# Command-Line Interface (CLI)

The `lighthouse` binary provides all necessary Ethereum consensus client functionality. It
has two primary sub-commands:

- `$ lighthouse beacon_node`: the largest and most fundamental component which connects to
	the p2p network, processes messages and tracks the head of the beacon
	chain.
- `$ lighthouse validator_client`: a lightweight but important component which loads a validators private
	key and signs messages using a `beacon_node` as a source-of-truth.

There are also some ancillary binaries like `lcli` and `account_manager`, but
these are primarily for testing.

> **Note:** documentation sometimes uses `$ lighthouse bn` and `$ lighthouse
> vc` instead of the long-form `beacon_node` and `validator_client`. These
> commands are valid on the CLI too.

## Installation

Typical users may install `lighthouse` to `CARGO_HOME` with `cargo install
--path lighthouse` from the root of the repository. See ["Configuring the
`PATH` environment variable"](https://www.rust-lang.org/tools/install) for more
information.

For developers, we recommend building Lighthouse using the `$ cargo build --release
--bin lighthouse` command and executing binaries from the
`<lighthouse-repository>/target/release` directory. This is more ergonomic when
modifying and rebuilding regularly.

## Documentation

Each binary supports the `--help` flag, this is the best source of
documentation.

```bash
$ lighthouse beacon_node --help
```

```bash
$ lighthouse validator_client --help
```

## Creating a new database/testnet

Lighthouse should run out-of-the box and connect to the current testnet
maintained by Sigma Prime.

However, for developers, testnets can be created by following the instructions
outlined in [testnets](./testnets.md). The steps listed here will create a
local database specified to a new testnet.

## Resuming from an existing database

Once a database/testnet has been created, it can be resumed by running `$ lighthouse bn`.
