# Summary

* [Introduction](./intro.md)
* [Installation](./installation.md)
    * [System Requirements](./system-requirements.md)
    * [Pre-Built Binaries](./installation-binaries.md)
    * [Docker](./docker.md)
    * [Build from Source](./installation-source.md)
    * [Raspberry Pi 4](./pi.md)
    * [Cross-Compiling](./cross-compiling.md)
    * [Homebrew](./homebrew.md)
    * [Update Priorities](./installation-priorities.md)
* [Run a Node](./run_a_node.md)
* [Become a Validator](./mainnet-validator.md)
    * [Become a Testnet Validator](./testnet-validator.md)
* [Key Management](./key-management.md)
    * [Create a wallet](./wallet-create.md)
    * [Create a validator](./validator-create.md)
    * [Key recovery](./key-recovery.md)
* [Validator Management](./validator-management.md)
    * [Importing from the Staking Launchpad](./validator-import-launchpad.md)
    * [Slashing Protection](./slashing-protection.md)
    * [Voluntary Exits](./voluntary-exit.md)
    * [Validator Monitoring](./validator-monitoring.md)
    * [Doppelganger Protection](./validator-doppelganger.md)
    * [Suggested Fee Recipient](./suggested-fee-recipient.md)
* [APIs](./api.md)
    * [Beacon Node API](./api-bn.md)
        * [/lighthouse](./api-lighthouse.md)
            * [Validator Inclusion APIs](./validator-inclusion.md)
    * [Validator Client API](./api-vc.md)
        * [Endpoints](./api-vc-endpoints.md)
        * [Authorization Header](./api-vc-auth-header.md)
        * [Signature Header](./api-vc-sig-header.md)
    * [Prometheus Metrics](./advanced_metrics.md)
* [Lighthouse UI (Siren)](./lighthouse-ui.md)
	* [Installation](./ui-installation.md)
	* [Configuration](./ui-configuration.md)
	* [Usage](./ui-usage.md)
	* [FAQs](./ui-faqs.md)
* [Advanced Usage](./advanced.md)
    * [Checkpoint Sync](./checkpoint-sync.md)
    * [Custom Data Directories](./advanced-datadir.md)
    * [Validator Graffiti](./graffiti.md)
    * [Remote Signing with Web3Signer](./validator-web3signer.md)
    * [Database Configuration](./advanced_database.md)
    * [Database Migrations](./database-migrations.md)
    * [Advanced Networking](./advanced_networking.md)
    * [Running a Slasher](./slasher.md)
    * [Redundancy](./redundancy.md)
    * [Pre-Releases](./advanced-pre-releases.md)
    * [Release Candidates](./advanced-release-candidates.md)
    * [MEV and Lighthouse](./builders.md)
    * [Merge Migration](./merge-migration.md)
    * [Late Block Re-orgs](./late-block-re-orgs.md)
* [Contributing](./contributing.md)
    * [Development Environment](./setup.md)
* [FAQs](./faq.md)
