library(package = "sensitivity", lib.loc = "/Users/Apple/Science/Rlibrary")
library(package = "plotrix", lib.loc= "/Users/Apple/Science/Rlibrary")
library(package = "rgl", lib.loc = "/Users/Apple/Science/Rlibrary")
.libPaths("/Users/Apple/Science/Rlibrary")

# Function definitions
new.fun <- function(X){
   	a <- runif(k)
   	b <- 1
	for (j in 1:length(a)) {
       	b <- b * (abs(4 * X[, j] - 2) + a[j])/(1 + a[j])
    }
   	b
}

genSampleComb <- function(yCol){
	return(disty[,yCol])
}

# browser()

# Data extraction
DATATYPE <- readline("Choose a file to process [1/2] \n
		  1 - ../data/onc2015280x2-A.txt \n
		      Genes down-regulated after ETC-159 treatment \n
		  2 - ../data/onc2015280x2-B.txt \n
		      Genes up-regulated after ETC-159 treatment \n
		  File number - ")
while(DATATYPE != "1" & DATATYPE != "2"){
	DATATYPE <- readline("Type the kind of data to be processed - ")
}
oncETC <- extractETCdata(DATATYPE)
y <- as.matrix(x = oncETC$logTwoFC, ncol = 1, byrow = FALSE)
rownames(y) <- oncETC$Genesymbol
factor.names <- oncETC$Genesymbol
dim.y <- dim(y)
no.genes <- dim.y[1]

# Regarding combinations
ANSWER <- readline("nCk - choosing k - ")
k = as.numeric(ANSWER)
cat("choosing ",k," out of the",no.genes," genes!\n---\n")
geneComb <- combn(no.genes,k)
no.geneComb <- dim(geneComb)[2]

# Generation of distributions
DISTRIBUTION <- readline("Should i generate distribution of data [y/n] - ")
if(DISTRIBUTION == "y"){
	gdfetppv <- function(n,yt){
		randyt <- c()
		lenyt <- length(yt)
		for(i in 1:lenyt){
			randyt <- cbind(randyt, jitter(rnorm(n, mean = yt[i], sd = 0.005),
				factor = 1))
		}
		yt <- rbind(yt, randyt)
		return(yt)
	}
}

# some initializations
# SA <- list(sensiFdiv.TV = list(), sensiFdiv.KL = list(),
	# sensiFdiv.Chi2 = list(), sensiFdiv.Hellinger = list(),
	# sensiHSIC.rbf = list(), sensiHSIC.linear = list(),
	# sensiHSIC.laplace = list(), SB.jansen = list(), SB.2002 = list(),
	# SB.2007 = list(), SB.martinez = list(), SBL = list())

sensiFdiv.TV <- list()
sensiFdiv.KL <- list()
sensiFdiv.Chi2 <- list()
sensiFdiv.Hellinger <- list()
sensiHSIC.rbf <- list()
sensiHSIC.linear <- list()
sensiHSIC.laplace <- list()
SB.jansen <- list()
SB.2002 <- list()
SB.2007 <- list()
SB.martinez <- list()
SBL <- list()

siNames <- c("Fdiv.TV", "Fdiv.KL", "Fdiv.Chi2", "Fdiv.Hellinger", "HSIC.rbf", "HSIC.linear", 				"HSIC.laplace", "SB.2002", "SB.2007", "SB.jansen", "SB.martinez", "SBL")
cat("Types of SA - ", siNames, "\n")
varName <- readline("Enter a type of SA - ")

n <- as.numeric(readline("Enter number of samples for distribution (odd numeric) - "))
# disty <- data.frame(gdfetppv(n,yt))
disty <- data.frame(gdfetppv(n,t(y)))
no.Samples <- dim(disty)[1]

# cat("generating for sample - ", itr, "\n")
sample.index <- sample(x = 1:no.Samples, size = no.Samples)
idx.fh <- sample.index[1:(no.Samples/2)]
idx.sh <- sample.index[((no.Samples/2)+1):no.Samples]

# Sample with replicates
x.S <- list()
x.Sfh <- list()
x.Ssh <- list()
cat("generating sample combinations - ")
distyN <- apply(X = geneComb, MARGIN = 2, FUN = genSampleComb)
# distyN can be replaced with x.S also

cat(rownames(y))
geneName <- readline("\nEnter name of gene to be evaluated - ")
cnt <- 0

for(i in 1:no.geneComb){
	if(geneName %in% names(distyN[[i]])){
		cnt <- cnt + 1
		x.S[[cnt]] <- distyN[[i]]
	}
}
no.slgeneComb <- cnt

# cat("dividing sample combinations into halves - ")
# genSampleComb.fh <- function(yCol){
	# return(disty[idx.fh,yCol])
# }
# x.Sfh <- apply(X = geneComb, MARGIN = 2, FUN = genSampleComb.fh)

# genSampleComb.sh <- function(yCol){
	# return(disty[idx.sh,yCol])
# }
# x.Ssh <- apply(X = geneComb, MARGIN = 2, FUN = genSampleComb.sh)

# cat("dividing sample combinations into halves - ")
# for(p in 1:(dim(geneComb)[2])){
# if((p%%1000) == 0){
	# cat(p," ")
# }else if((p%%10000) == 0){
        # cat(p,"\n===\n")
# }
# # x.S[[p]] <- disty[,geneComb[,p]]
# # x.S[[p]] <- distyN[[p]]
# # Split the data into two halves for processing via Sobol variants
# # x.Sfh[[p]] <- disty[idx.fh, geneComb[,p]]
# x.Sfh[[p]] <- x.S[[p]][idx.fh,]
# # x.Ssh[[p]] <- disty[idx.sh, geneComb[,p]]
# x.Ssh[[p]] <- x.S[[p]][idx.sh,]
# }

itr <- 1
if(length(grep("TV",varName))!= 0){
	FdivTV <- c()
	cat("computing estimate different indices ...\n")
	cat("Fdiv SA - TV\n")
	h <- lapply(x.S, sensiFdiv, model = new.fun, fdiv = "TV",
			nboot = 0, conf = 0.95)
	for(p in 1:no.slgeneComb){
		FdivTV <- cbind(FdivTV, h[[p]]$S$original)
	}
	sensiFdiv.TV[[itr]] <- FdivTV
	if(DATATYPE == "1" & itr == 1){
		filename <- paste("order-",k,"-",geneName,"-DR-A-ETC-T-fdiv-tv.Rdata",sep = "")
	}else if(DATATYPE == "2" & itr == 1){
		filename <- paste("order-",k,"-",geneName,"-UR-A-ETC-T-fdiv-tv.Rdata",sep = "")
	}	
}else if(length(grep("KL",varName))!= 0){
	FdivKL <- c()
	cat("computing estimate different indices ...\n")			
	cat("Fdiv SA - KL\n")
	h <- lapply(x.S, sensiFdiv, model = new.fun, fdiv = "KL",
		nboot = 0, conf = 0.95)
	for(p in 1:no.slgeneComb){
		FdivKL <- cbind(FdivKL, h[[p]]$S$original)
	}
	sensiFdiv.KL[[itr]] <- FdivKL
	if(DATATYPE == "1" & itr == 1){
		filename <- paste("order-",k,"-",geneName,"-DR-A-ETC-T-fdiv-kl.Rdata",sep = "")
	}else if(DATATYPE == "2" & itr == 1){
		filename <- paste("order-",k,"-",geneName,"-UR-A-ETC-T-fdiv-kl.Rdata",sep = "")
	}	
}else if(length(grep("Chi2",varName))!= 0){
	FdivChi2 <- c()
	cat("computing estimate different indices ...\n")			
	cat("Fdiv SA - Chi2\n")
	h <- lapply(x.S, sensiFdiv, model = new.fun, fdiv = "Chi2",
		nboot = 0, conf = 0.95)
	for(p in 1:no.slgeneComb){
		FdivChi2 <- cbind(FdivChi2, h[[p]]$S$original)
	}
	sensiFdiv.Chi2[[itr]] <- FdivChi2
	if(DATATYPE == "1" & itr == 1){
		filename <- paste("order-",k,"-",geneName,"-DR-A-ETC-T-fdiv-chi2.Rdata",sep = "")
	}else if(DATATYPE == "2" & itr == 1){
		filename <- paste("order-",k,"-",geneName,"-UR-A-ETC-T-fdiv-chi2.Rdata",sep = "")
	}	
}else if(length(grep("Hellinger",varName))!= 0){
	FdivHellinger <- c()
	cat("computing estimate different indices ...\n")			
	cat("Fdiv SA - Hellinger\n")	
	h <- lapply(x.S, sensiFdiv, model = new.fun, fdiv = "Hellinger",
		nboot = 0, conf = 0.95)
	for(p in 1:no.slgeneComb){
		FdivHellinger <- cbind(FdivHellinger, h[[p]]$S$original)
	}
	sensiFdiv.Hellinger[[itr]] <- FdivHellinger
	if(DATATYPE == "1" & itr == 1){
		filename <- paste("order-",k,"-",geneName,"-DR-A-ETC-T-fdiv-hellinger.Rdata",sep = "")
	}else if(DATATYPE == "2" & itr == 1){
		filename <- paste("order-",k,"-",geneName,"-UR-A-ETC-T-fdiv-hellinger.Rdata",sep = "")
	}	
}else if(length(grep("rbf",varName))!= 0){
	HSICrbf <- c()
	cat("computing estimate different indices ...\n")			
	cat("HSIC SA - rbf kernel\n")
	h <- lapply(x.S, sensiHSIC, model = new.fun, kernelX = "rbf", 									paramX = NA, kernelY = "rbf", paramY = NA, conf = 0.95)
	for(p in 1:no.slgeneComb){
		HSICrbf <- cbind(HSICrbf, h[[p]]$S$original)
	}
	sensiHSIC.rbf[[itr]] <- HSICrbf
	if(DATATYPE == "1" & itr == 1){
		filename <- paste("order-",k,"-",geneName,"-DR-A-ETC-T-hsic-rbf.Rdata",sep = "")
	}else if(DATATYPE == "2" & itr == 1){
		filename <- paste("order-",k,"-",geneName,"-UR-A-ETC-T-hsic-rbf.Rdata",sep = "")
	}	
}else if(length(grep("linear",varName))!= 0){
	HSIClinear <- c()
	cat("computing estimate different indices ...\n")			
	cat("HSIC SA - linear kernel\n")
	h <- lapply(x.S, sensiHSIC, model = new.fun, kernelX = "linear", 								paramX = NA, kernelY = "linear", paramY = NA, conf = 0.95)
	for(p in 1:no.slgeneComb){
		HSIClinear <- cbind(HSIClinear, h[[p]]$S$original)
	}
	sensiHSIC.linear[[itr]] <- HSIClinear
	if(DATATYPE == "2" & itr == 1){
		filename <- paste("order-",k,"-",geneName,"-DR-A-ETC-T-hsic-linear.Rdata",sep = "")
	}else if(DATATYPE == "1" & itr == 1){
		filename <- paste("order-",k,"-",geneName,"-UR-A-ETC-T-hsic-linear.Rdata",sep = "")
	}	
}else if(length(grep("laplace",varName))!= 0){
	HSIClaplace <- c()
	cat("computing estimate different indices ...\n")			
	cat("HSIC SA - laplace kernel\n")
	h <- lapply(x.S, sensiHSIC, model = new.fun, kernelX = "laplace", 								paramX = NA, kernelY = "laplace", paramY = NA, conf = 0.95)
	for(p in 1:no.slgeneComb){
		HSIClaplace <- cbind(HSIClaplace, h[[p]]$S$original)
	}
	sensiHSIC.laplace[[itr]] <- HSIClaplace
	if(DATATYPE == "1" & itr == 1){
		filename <- paste("order-",k,"-",geneName,"-DR-A-ETC-T-hsic-laplace.Rdata",sep = "")
	}else if(DATATYPE == "2" & itr == 1){
		filename <- paste("order-",k,"-",geneName,"-UR-A-ETC-T-hsic-laplace.Rdata",sep = "")
	}	
}else if(length(grep("jansen",varName))!= 0){
	SBLjansen <- c()
	cat("computing estimate different indices ...\n")			
	cat("Sobol Jansen SA\n")	
	for(p in 1:no.slgeneComb){
		h <- soboljansen(model = new.fun, X1 = t(x.Sfh[[p]]), X2 = t(x.Ssh[[p]]),
			conf = 0.95)
		SBLjansen <- cbind(SBLjansen, c(h$S$original, h$T$original))
	}
	SB.jansen[[itr]] <- SBLjansen
	if(DATATYPE == "1" & itr == 1){
		filename <- paste("order-",k,"-",geneName,"-DR-A-ETC-T-sb-jansen.Rdata",sep = "")
	}else if(DATATYPE == "2" & itr == 1){
		filename <- paste("order-",k,"-",geneName,"-UR-A-ETC-T-sb-jansen.Rdata",sep = "")
	}	
}else if(length(grep("2002",varName))!= 0){
	SBL2002 <- c()
	cat("computing estimate different indices ...\n")			
	cat("Sobol 2002 SA\n")	
	for(p in 1:no.slgeneComb){
		h <- sobol2002(model = new.fun, X1 = t(x.Sfh[[p]]),
			X2 = t(x.Ssh[[p]]), conf = 0.95)
		SBL2002 <- cbind(SBL2002, c(h$S$original, h$T$original))
	}
	SB.2002[[itr]] <- SBL2002
	if(DATATYPE == "1" & itr == 1){
		filename <- paste("order-",k,"-",geneName,"-DR-A-ETC-T-sb-2002.Rdata",sep = "")
	}else if(DATATYPE == "2" & itr == 1){
		filename <- paste("order-",k,"-",geneName,"-UR-A-ETC-T-sb-2002.Rdata",sep = "")
	}	
}else if(length(grep("2007",varName))!= 0){
	SBL2007 <- c()
	cat("computing estimate different indices ...\n")			
	cat("Sobol 2007 SA\n")	
	for(p in 1:no.slgeneComb){
		h <- sobol2007(model = new.fun, X1 = t(x.Sfh[[p]]),
			X2 = t(x.Ssh[[p]]), conf = 0.95)
		SBL2007 <- cbind(SBL2007, c(h$S$original, h$T$original))
	}
	SB.2007[[itr]] <- SBL2007
	if(DATATYPE == "1" & itr == 1){
		filename <- paste("order-",k,"-",geneName,"-DR-A-ETC-T-sb-2007.Rdata",sep = "")
	}else if(DATATYPE == "2" & itr == 1){
		filename <- paste("order-",k,"-",geneName,"-UR-A-ETC-T-sb-2007.Rdata",sep = "")
	}	
}else if(length(grep("martinez",varName))!= 0){
	SBLmartinez <- c()
	cat("computing estimate different indices ...\n")			
	cat("Sobol Martinez SA\n")	
	for(p in 1:no.slgeneComb){
		h <- sobolmartinez(model = new.fun, X1 = t(x.Sfh[[p]]),
			X2 = t(x.Ssh[[p]]), conf = 0.95)
		SBLmartinez <- cbind(SBLmartinez, c(h$S$original, h$T$original))	
	}
	SB.martinez[[itr]] <- SBLmartinez
	if(DATATYPE == "1" & itr == 1){
		filename <- paste("order-",k,"-",geneName,"-DR-A-ETC-T-sb-martinez.Rdata",sep = "")
	}else if(DATATYPE == "1" & itr == 1){
		filename <- paste("order-",k,"-",geneName,"-UR-A-ETC-T-sb-martinez.Rdata",sep = "")
	}	
}else if(length(grep("SBL",varName))!= 0){
	sbl <- c()
	cat("computing estimate different indices ...\n")			
	cat("SBL SA\n")	
	for(p in 1:no.slgeneComb){
		h <- sobol(model = new.fun, X1 = t(x.Sfh[[p]]), X2 = t(x.Ssh[[p]]),
			order = 1, conf = 0.95)
		sbl <- cbind(SBL, c(h$S$original, h$T$original))
	}
	SBL[[itr]] <- sbl
	if(DATATYPE == "1" & itr == 1){
		filename <- paste("order-",k,"-",geneName,"-DR-A-ETC-T-sbl.Rdata",sep = "")
	}else if(DATATYPE == "2" & itr == 1){
		filename <- paste("order-",k,"-",geneName,"-UR-A-ETC-T-sbl.Rdata",sep = "")
	}	
}

if(length(grep("TV",varName))!= 0){
	save(no.slgeneComb, x.S, sensiFdiv.TV, file = filename)
}else if(length(grep("KL",varName))!= 0){
	save(no.slgeneComb, x.S, sensiFdiv.KL, file = filename)
}else if(length(grep("Chi2",varName))!= 0){
	save(no.slgeneComb, x.S, sensiFdiv.Chi2, file = filename)
}else if(length(grep("Hellinger",varName))!= 0){
	save(no.slgeneComb, x.S, sensiFdiv.Hellinger, file = filename)
}else if(length(grep("rbf",varName))!= 0){
	save(no.slgeneComb, x.S, sensiHSIC.rbf, file = filename)
}else if(length(grep("linear",varName))!= 0){
	save(no.slgeneComb, x.S, sensiHSIC.linear, file = filename)
}else if(length(grep("laplace",varName))!= 0){
	save(no.slgeneComb, x.S, sensiHSIC.laplace, file = filename)
}else if(length(grep("jansen",varName))!= 0){
	save(no.slgeneComb, x.S, SB.jansen, file = filename)
}else if(length(grep("2002",varName))!= 0){
	save(no.slgeneComb, x.S, SB.2002, file = filename)
}else if(length(grep("2007",varName))!= 0){
	save(no.slgeneComb, x.S, SB.2007, file = filename)
}else if(length(grep("martinez",varName))!= 0){
	save(no.slgeneComb, x.S, SB.martinez, file = filename)
}else if(length(grep("SBL",varName))!= 0){
	save(no.slgeneComb, x.S, SBL, file = filename)
}

	# save(SA, file = filename)
	# ANSWER <- readline("Want to quit and see partial results [y/n] - ")
	# if(ANSWER == "y"){
		# browser()
	# }

# cat("end of loop for 20 iterations!\n---\n")
# ANSWER <- readline("Want to quit and see partial results [y/n] - ")
# if(ANSWER == "y"){
	# browser()
# }
# if(DOPLOT == "y"){
	# for(i in 1:(p-1)){
		# for(j in 1:length(SA)){
			# x <- SA[[j]][[i]]
			# if(length(grep("Fdiv",names(SA)[j])) != 0 |
			   # length(grep("HSIC",names(SA)[j])) != 0 |
			   # length(grep("SBL",names(SA)[j])) != 0){
				
				# # compute mean across factors
				# y.N <- as.matrix(rowMeans(x[,(1:(dim(x)[2]/2))]), ncol = 1)
				# # compute std across factors
				# y.Nsd <- as.matrix(apply(x[,(1:(dim(x)[2]/2))],1,sd), ncol = 1)
				# # compute confidence error across factors
				# y.Nerr <- 1.96*y.Nsd/sqrt(dim(x)[2]/2)
				# # compute lower and upper confidence limits
				# y.Nlow <- y.N - y.Nerr
				# y.Nhigh <- y.N + y.Nerr

				# # compute mean across factors
				# y.T <- as.matrix(rowMeans(x[,2*(1:(dim(x)[2]/2))]), ncol = 1)
				# # compute std across factors			
				# y.Tsd <- as.matrix(apply(x[,(1:2*(dim(x)[2]/2))],1,sd), ncol = 1)
				# # compute confidence error across factors			
				# y.Terr <- 1.96*y.Tsd/sqrt(dim(x)[2]/2)
				# # compute lower and upper confidence limits			
				# y.Tlow <- y.T - y.Terr
				# y.Thigh <- y.T + y.Terr
				
				# # plot bar graphs
				# # col=c("gold", "springgreen", "tomato", "blue"),
				# file.name <- paste(names(SA)[j],"-run-",i,"static.pdf",sep = "")
				# pdf(file=file.name, width=16, height=12)
			 	# mp <- barplot(t(cbind(y.N,y.T)), col=colour.code[1:2],
 								# ylim = c(min(y.Nlow,y.Tlow) - .01,max(y.Nhigh,y.Thigh)+ .01),
 							# beside = TRUE, names = rownames(y), border = NA, cex.axis = 1.5,
 								# cex.names = 1.5, pch=15, las = 2)
 						# arrows(mp, t(cbind(y.Nlow,y.Tlow)), mp, t(cbind(y.Nhigh,y.Thigh)),
 						# length = 0.07, angle = 90, code = 3, lty = 1)
				# # arrows(mp, low, mp, high, lenght = 0.07, angle = 90,
				# # code = 3, lty = 1)
				# if(length(grep("KL",names(SA)[j]))!=0){
					# legend("bottomright", c("Normal", "Tumor"), col=colour.code,
						# border=NA, pch=15)
				# }else{
					# legend("topright", c("Normal", "Tumor"), col=colour.code,
						# border=NA, pch=15)
				# }
				# dev.off()
			# }else if(length(grep("SB.",names(SA)[j])) != 0){
				
				# # generate indices for 1st order and total indices for
				# # normal & tumor cases i.e FN,TN,FT,TT
				# idx <- as.matrix(1:4,ncol=1)
				# k <- 1
				# while(k < dim(x)[2]/4){
					# k <- k + 1
					# idx <- cbind(idx, idx[,k-1] + 4)
				# }
				# y.FN <- as.matrix(rowMeans(x[,idx[1,]]), ncol = 1)
				# y.FNsd <- as.matrix(apply(x[,idx[1,]],1,sd), ncol = 1)
				# y.FNerr <- 1.96*y.FNsd/sqrt(length(dim(idx)[2]))
				# y.FNlow <- y.FN - y.FNerr
				# y.FNhigh <- y.FN + y.FNerr
				
				# y.TN <- as.matrix(rowMeans(x[,idx[2,]]), ncol = 1)
				# y.TNsd <- as.matrix(apply(x[,idx[2,]],1,sd), ncol = 1)
				# y.TNerr <- 1.96*y.TNsd/sqrt(length(dim(idx)[2]))
				# y.TNlow <- y.TN - y.TNerr
				# y.TNhigh <- y.TN + y.TNerr
				
				# y.FT <- as.matrix(rowMeans(x[,idx[3,]]), ncol = 1)
				# y.FTsd <- as.matrix(apply(x[,idx[3,]],1,sd), ncol = 1)
				# y.FTerr <- 1.96*y.FTsd/sqrt(length(dim(idx)[2]))
				# y.FTlow <- y.FT - y.FTerr
				# y.FThigh <- y.FT + y.FTerr
				
				# y.TT <- as.matrix(rowMeans(x[,idx[4,]]), ncol = 1)
				# y.TTsd <- as.matrix(apply(x[,idx[4,]],1,sd), ncol = 1)
				# y.TTerr <- 1.96*y.TTsd/sqrt(length(dim(idx)[2]))
				# y.TTlow <- y.TT - y.TTerr
				# y.TThigh <- y.TT + y.TTerr
				
				# # plot bar graphs
				# # col=c("gold", "springgreen", "tomato", "blue"),
				# file.name <- paste(names(SA)[j],"-FO-run-",i,"static.pdf",sep = "")
				# pdf(file=file.name, width=16, height=12)
			 	# mp <- barplot(t(cbind(y.FN,y.FT)), col=colour.code,
 								# ylim = c(min(y.FNlow,y.FTlow) - .01,max(y.FNhigh,y.FThigh)+ .01),
 								# beside = TRUE, names = rownames(y), border = NA, cex.axis = 1.5,
 							# cex.names = 1.5, pch=15, las = 2)
 					# arrows(mp, t(cbind(y.FNlow,y.FTlow)), mp, t(cbind(y.FNhigh,y.FThigh)),
 						# length = 0.07,angle = 90, code = 3, lty = 1)
				# # arrows(mp, low, mp, high, lenght = 0.07, angle = 90,
				# # code = 3, lty = 1)
				# legend("topright", c("Normal", "Tumor"), col=colour.code,
					# border=NA, pch=15)
				# dev.off()
				
				# file.name <- paste(names(SA)[j],"-TO-run-",i,"static.pdf",sep = "")
				# pdf(file=file.name, width=16, height=12)
	 			# mp <- barplot(t(cbind(y.TN,y.TT)), col=colour.code,
 					# ylim = c(min(y.TNlow,y.TTlow) - .01,max(y.TNhigh,y.TThigh)+ .01),
 								# beside = TRUE, names = rownames(y), border = NA, cex.axis = 1.5,
 								# cex.names = 1.5, pch=15, las = 2)
 						# arrows(mp, t(cbind(y.TNlow,y.TTlow)), mp, t(cbind(y.TNhigh,y.TThigh)),
 							# length = 0.07,angle = 90, code = 3, lty = 1)
				# # arrows(mp, low, mp, high, lenght = 0.07, angle = 90,
				# # code = 3, lty = 1)
				# legend("topright", c("Normal", "Tumor"), col=colour.code,
					# border=NA, pch=15)
				# dev.off()
			# }
		# }
		# while(readline("Continue [y/n] - ") == "y"){
			# break
		# }
	# }
# }
# # increment sample size
# noSamples <- noSamples + 4
# }
# }

# save.image("workspace-code.R")
if(is.na(match("plots-exp-1",dir()))){
	system(command = "mkdir plots-exp-1")
	system(command = "mv *.pdf plots-exp-1")	
}else{
	system(command = "mv *.pdf plots-exp-1")
}