itr <- as.numeric(readline("Type number of iterations - "))
source("extractETCdata.R")

siNames <- c("Fdiv.TV", "Fdiv.KL", "Fdiv.Chi2", "Fdiv.Hellinger", "HSIC.rbf", "HSIC.linear", 				"HSIC.laplace", "SB.2002", "SB.2007", "SB.jansen", "SB.martinez", "SBL")
cat("Types of SA - ", siNames, "\n")
varName <- readline("Enter a type of SA - ")

hmean <- c()
for(i in 1:itr){
	source("manuscript-2-1.r")
	if(i == 1){
		if(length(grep("TV",varName))!= 0){
			h <- sensiFdiv.TV[[1]]
			nocombs <- dim(h)[1]
		}else if(length(grep("KL",varName))!= 0){
			h <- sensiFdiv.KL[[1]]
			nocombs <- dim(h)[1]
		}else if(length(grep("Chi2",varName))!= 0){
			h <- sensiFdiv.Chi2[[1]]
			nocombs <- dim(h)[1]
		}else if(length(grep("Hellinger",varName))!= 0){
			h <- sensiFdiv.Hellinger[[1]]
			nocombs <- dim(h)[1]
		}else if(length(grep("rbf",varName))!= 0){
			h <- sensiHSIC.rbf[[1]]
			nocombs <- dim(h)[1]
		}else if(length(grep("linear",varName))!= 0){
			h <- sensiHSIC.linear[[1]]
			nocombs <- dim(h)[1]
		}else if(length(grep("laplace",varName))!= 0){
			h <- sensiHSIC.laplace[[1]]
			nocombs <- dim(h)[1]
		}else if(length(grep("jansen",varName))!= 0){
			h <- SB.jansen[[1]]
			nocombs <- dim(h)[1]
		}else if(length(grep("2002",varName))!= 0){
			h <- SB.2002[[1]]
			nocombs <- dim(h)[1]
		}else if(length(grep("2007",varName))!= 0){
			h <- SB.2007[[1]]
			nocombs <- dim(h)[1]
		}else if(length(grep("martinez",varName))!= 0){
			h <- SB.martinez[[1]]
			nocombs <- dim(h)[1]
		}else if(length(grep("SBL",varName))!= 0){
			h <- SBL[[1]]
			nocombs <- dim(h)[1]
		}
	}
	hmean <- rbind(hmean, h)
}
nrows <- dim(hmean)[1]
Hmean <- c()
for(i in 1:nocombs){
	combElm <- seq(from = i, to = nrows, by = nocombs)
	Hmean <- rbin(Hmean, apply(X = hmean[combElm,], MARGIN = 2, FUN = mean))
}

y <- Hmean
#y <- SAmean
data <- c()
for(i in 1:nocombs){
	z <- c()
	z <- cbind(z,i)
	for(j in 1:k){
		z <- cbind(z, paste(j,":",y[j,i],sep=""))
	}
	z <- cbind(z,"\n")
	data <- rbind(data,z)
}

trnfl <- paste("svr-trn-order-",k,".txt", sep = "")
tstfl <- paste("svr-tst-order-",k,".txt", sep = "")
mdlfl <- paste("svr-mdl-order-",k,".txt", sep = "")
predfl <- paste("svr-pred-order-",k,".txt", sep = "")

cat(t(data),file=trnfl)
cat(t(data),file=tstfl)

# svm rank learn on C value - 20
cmd <- paste("./../svm_rank/svm_rank_learn -c 20 -# 100 -n 9",trnfl,mdlfl,sep=" ")
system(command=cmd)