# library(ggplot2, lib.loc="../../../Rlibrary")
# library(plyr, lib.loc="../../../Rlibrary")
# library(reshape2, lib.loc="../../../Rlibrary")
# library(RColorBrewer, lib.loc="../../../Rlibrary")
# .libPaths("../../../Rlibrary")

cat("\nThis work is for Project -\n--- \n2nd and higher order Hilbert-Schmidt and Sobol sensitivity analysis for static and time series Wnt signaling measurements in colorectal cancer.\n--- \n")

DATATYPE <- readline("Choose a file to process [1/2] \n
		  1 - ../data/onc2015280x2-A.txt \n
		      Genes down-regulated after ETC-159 treatment \n
		  2 - ../data/onc2015280x2-B.txt \n
		      Genes up-regulated after ETC-159 treatment \n
		  File number - ")
while(DATATYPE != "1" & DATATYPE != "2"){
	DATATYPE <- readline("Type the kind of data to be processed - ")
}
oncETC <- extractETCdata(DATATYPE)
no.genes <- dim(oncETC)[1]
CHOOSE <- as.numeric(readline("pick a numeric for k in nCk - "))
k <- as.numeric(CHOOSE)
geneName <- readline("Please enter the name of the gene to be processed - ")
siNames <- c("Fdiv.TV", "Fdiv.KL", "Fdiv.Chi2", "Fdiv.Hellinger", "HSIC.rbf", "HSIC.linear", "HSIC.laplace", "SB.2002", "SB.2007", "SB.jansen", "SB.martinez", "SBL")
sa.name <- readline("Please enter the name of the proposed SA from above list - ")

browser()
# load original interactions of a particular gene
# if(DATATYPE == "1"){
	# filename <- paste("order-",k,"-",geneName,"-DR-A-ETC-T.Rdata",sep = "")
# }else{
	# filename <- paste("order-",k,"-",geneName,"-UR-A-ETC-T.Rdata",sep = "")
# }
# load(filename)

# load computed sensitivity indices for the above interactions.
if(length(grep(sa.name,"HSIC.rbf")) !=0){
	if(DATATYPE == "1"){
		filename <- paste("order-",k,"-",geneName,"-DR-A-ETC-T-hsic-rbf-mean.Rdata",sep = "")
	}else{
		filename <- paste("order-",k,"-",geneName,"-UR-A-ETC-T-hsic-rbf-mean.Rdata",sep = "")
	}
	load(filename)
	h <- sensiHSIC.rbf[[1]]
	# average scores will be more durable
}
# note - this is already done in the manuscript-2-1.R

# use this for single ranking
SA <- c()
for(p in 1:no.slgeneComb){
	SA <- cbind(SA, h[,p])
}

# Use this for averaged ranking
# SAmean <- c()
# for(p in 1:k){
	# r <- c()
	# for(itr in 1:2){
		# r <- rbind(h[[itr]][p,])	
	# }
	# SAmean <- rbind(SAmean, apply(X = r, MARGIN = 2, mean))
# }

y <- SA
#y <- SAmean
data <- c()
for(i in 1:no.slgeneComb){
	z <- c()
	z <- cbind(z,i)
	for(j in 1:k){
		z <- cbind(z, paste(j,":",y[j,i],sep=""))
	}
	z <- cbind(z,"\n")
	data <- rbind(data,z)
}

trnfl <- paste("svr-trn-order-",k,"-",geneName,".txt", sep = "")
tstfl <- paste("svr-tst-order-",k,"-",geneName,".txt", sep = "")
mdlfl <- paste("svr-mdl-order-",k,"-",geneName,".txt", sep = "")
predfl <- paste("svr-pred-order-",k,"-",geneName,".txt", sep = "")

cat(t(data),file=trnfl)
cat(t(data),file=tstfl)

# svm rank learn on C value - 20
cmd <- paste("./../svm_rank/svm_rank_learn -c 20 -# 100 -n 9",trnfl,mdlfl,sep=" ")
system(command=cmd)

# svm rank classify 
cmd <- paste("./../svm_rank/svm_rank_classify",tstfl,mdlfl,predfl,sep=" ")
system(command=cmd)

# read predictions of rankings
dataScore <- read.table(predfl)

# save it in appropriate file
if(DATATYPE == "1"){
	save(dataScore,file=paste("order-",k,"-SA-",sa.name,"-",geneName,"-rankingScore-DR.R",sep=""))
}else{
	save(dataScore,file=paste("order-",k,"-SA-",sa.name,"-",geneName,"-rankingScore-UR.R",sep=""))
}	
system(paste("rm svr*-*.txt",sep=""))

# sort the predicted scores
cat("sorting in ascending order - top is lowest in ranking")
dataScore <- sort(dataScore$V1,index.return=TRUE)
noCombs <- length(dataScore$ix)

# arrange the combinations by ranking
sortedGenecomb <- c()
for(i in 1:noCombs){
	idx <- dataScore$ix[i]
	z <- capture.output(cat(names(x.S[[idx]]),sep="-"))
	sortedGenecomb <- c(sortedGenecomb, z)
}
if(DATATYPE == "1"){
	write.table(sortedGenecomb,file=paste("order-",k,"-SA-",sa.name,"-",geneName,"-ranking-DR.txt",sep=""))
}else{
	write.table(sortedGenecomb,file=paste("order-",k,"-SA-",sa.name,"-",geneName,"-ranking-UR.txt",sep=""))
}