DATATYPE <- readline("Choose a file to process [1/2] \n
		  1 - ../data/onc2015280x2-A.txt \n
		      Genes down-regulated after ETC-159 treatment \n
		  2 - ../data/onc2015280x2-B.txt \n
		      Genes up-regulated after ETC-159 treatment \n
		  File number - ")
while(DATATYPE != "1" & DATATYPE != "2"){
	DATATYPE <- readline("Type the kind of data to be processed - ")
}

CHOOSE <- as.numeric(readline("pick a numeric for k in nCk - "))
k <- as.numeric(CHOOSE)

geneName <- readline("Please enter the name of the gene to be processed - ")
siNames <- c("Fdiv.TV", "Fdiv.KL", "Fdiv.Chi2", "Fdiv.Hellinger", "HSIC.rbf", "HSIC.linear", "HSIC.laplace", "SB.2002", "SB.2007", "SB.jansen", "SB.martinez", "SBL")
sa.name <- readline("Please enter the name of the proposed SA from above list - ")

if(length(grep(sa.name,"Fdiv.TV"))!= 0){
	if(DATATYPE == "1"){
		filename <- paste("order-",k,"-",geneName,"-DR-A-ETC-T-fdiv-tv-mean.Rdata",sep = "")
	}else{
		filename <- paste("order-",k,"-",geneName,"-UR-A-ETC-T-fdiv-tv-mean.Rdata",sep = "")
	}
	load(filename)
	h <- sensiFdiv.TV	
}else if(length(grep(sa.name,"Fdiv.KL"))!= 0){
	if(DATATYPE == "1"){
		filename <- paste("order-",k,"-",geneName,"-DR-A-ETC-T-fdiv-kl-mean.Rdata",sep = "")
	}else{
		filename <- paste("order-",k,"-",geneName,"-UR-A-ETC-T-fdiv-kl-mean.Rdata",sep = "")
	}
	load(filename)
	h <- sensiFdiv.KL	
}else if(length(grep(sa.name,"Fdiv.Chi2"))!= 0){
	if(DATATYPE == "1"){
		filename <- paste("order-",k,"-",geneName,"-DR-A-ETC-T-fdiv-chi2-mean.Rdata",sep = "")
	}else{
		filename <- paste("order-",k,"-",geneName,"-UR-A-ETC-T-fdiv-chi2-mean.Rdata",sep = "")
	}
	load(filename)
	h <- sensiFdiv.Chi2	
}else if(length(grep(sa.name,"Fdiv.Hellinger"))!= 0){
	if(DATATYPE == "1"){
		filename <- paste("order-",k,"-",geneName,"-DR-A-ETC-T-fdiv-hellinger-mean.Rdata",sep = "")
	}else{
		filename <- paste("order-",k,"-",geneName,"-UR-A-ETC-T-fdiv-hellinger-mean.Rdata",sep = "")
	}
	load(filename)
	h <- sensiFdiv.Hellinger
}else if(length(grep(sa.name,"HSIC.rbf")) !=0){
	if(DATATYPE == "1"){
		filename <- paste("order-",k,"-",geneName,"-DR-A-ETC-T-hsic-rbf-mean.Rdata",sep = "")
	}else{
		filename <- paste("order-",k,"-",geneName,"-UR-A-ETC-T-hsic-rbf-mean.Rdata",sep = "")
	}
	load(filename)
	h <- sensiHSIC.rbf
	# average scores will be more durable
}else if(length(grep(sa.name,"HSIC.linear"))!= 0){
	if(DATATYPE == "1"){
		filename <- paste("order-",k,"-",geneName,"-DR-A-ETC-T-hsic-linear-mean.Rdata",sep = "")
	}else{
		filename <- paste("order-",k,"-",geneName,"-UR-A-ETC-T-hsic-linear-mean.Rdata",sep = "")
	}
	load(filename)
	h <- sensiHSIC.linear	
}else if(length(grep(sa.name,"HSIC.laplace"))!= 0){
	if(DATATYPE == "1"){
		filename <- paste("order-",k,"-",geneName,"-DR-A-ETC-T-hsic-laplace-mean.Rdata",sep = "")
	}else{
		filename <- paste("order-",k,"-",geneName,"-UR-A-ETC-T-hsic-laplace-mean.Rdata",sep = "")
	}
	load(filename)
	h <- sensiHSIC.laplace	
}else if(length(grep(sa.name,"SB.2002"))!= 0){
	if(DATATYPE == "1"){
		filename <- paste("order-",k,"-",geneName,"-DR-A-ETC-T-sb-2002-mean.Rdata",sep = "")
	}else{
		filename <- paste("order-",k,"-",geneName,"-UR-A-ETC-T-sb-2002-mean.Rdata",sep = "")
	}
	load(filename)
	h <- SB.2002	
}else if(length(grep(sa.name,"SB.2007"))!= 0){
	if(DATATYPE == "1"){
		filename <- paste("order-",k,"-",geneName,"-DR-A-ETC-T-sb-2007-mean.Rdata",sep = "")
	}else{
		filename <- paste("order-",k,"-",geneName,"-UR-A-ETC-T-sb-2007-mean.Rdata",sep = "")
	}
	load(filename)
	h <- SB.2007	
}else if(length(grep(sa.name,"SB.jansen"))!= 0){
	if(DATATYPE == "1"){
		filename <- paste("order-",k,"-",geneName,"-DR-A-ETC-T-sb-jansen-mean.Rdata",sep = "")
	}else{
		filename <- paste("order-",k,"-",geneName,"-UR-A-ETC-T-sb-jansen-mean.Rdata",sep = "")
	}
	load(filename)
	h <- SB.jansen	
}else if(length(grep(sa.name,"SB.martinez"))!= 0){
	if(DATATYPE == "1"){
		filename <- paste("order-",k,"-",geneName,"-DR-A-ETC-T-sb-martinez-mean.Rdata",sep = "")
	}else{
		filename <- paste("order-",k,"-",geneName,"-UR-A-ETC-T-sb-martinez-mean.Rdata",sep = "")
	}
	load(filename)
	h <- SB.martinez
}else if(length(grep(sa.name,"SBL"))!= 0){
	if(DATATYPE == "1"){
		filename <- paste("order-",k,"-",geneName,"-DR-A-ETC-T-sbl-mean.Rdata",sep = "")
	}else{
		filename <- paste("order-",k,"-",geneName,"-UR-A-ETC-T-sbl-mean.Rdata",sep = "")
	}
	load(filename)
	h <- SBL
}

# Use this for averaged ranking
SAmean <- c()
for(p in 1:k){
	r <- c()
	for(itr in 1:2){
		r <- rbind(h[[itr]][p,])	
	}
	SAmean <- rbind(SAmean, apply(X = r, MARGIN = 2, mean))
}

# y <- SA
y <- SAmean
data <- c()
for(i in 1:no.slgeneComb){
	z <- c()
	z <- cbind(z,i)
	for(j in 1:k){
		z <- cbind(z, paste(j,":",y[j,i],sep=""))
	}
	z <- cbind(z,"\n")
	data <- rbind(data,z)
}

trnfl <- paste("svr-trn-order-",k,"-",geneName,".txt", sep = "")
tstfl <- paste("svr-tst-order-",k,"-",geneName,".txt", sep = "")
mdlfl <- paste("svr-mdl-order-",k,"-",geneName,".txt", sep = "")
predfl <- paste("svr-pred-order-",k,"-",geneName,".txt", sep = "")

cat(t(data),file=trnfl)
cat(t(data),file=tstfl)

# svm rank learn on C value - 20
cmd <- paste("svm_rank/svm_rank_learn -c 20 -# 100 -n 9",trnfl,mdlfl,sep=" ")
system(command=cmd)

# svm rank classify 
cmd <- paste("svm_rank/svm_rank_classify",tstfl,mdlfl,predfl,sep=" ")
system(command=cmd)

# read predictions of rankings
dataScore <- read.table(predfl)

# save it in appropriate file
if(DATATYPE == "1"){
	save(dataScore,file=paste("order-",k,"-SA-",sa.name,"-",geneName,"-rankingScore-mean-DR.R",sep=""))
}else{
	save(dataScore,file=paste("order-",k,"-SA-",sa.name,"-",geneName,"-rankingScore-mean-UR.R",sep=""))
}	
# system(paste("rm svr*-*.txt",sep=""))

# sort the predicted scores
cat("sorting in ascending order - top is lowest in ranking")
dataScore <- sort(dataScore$V1,index.return=TRUE)
noCombs <- length(dataScore$ix)

# arrange the combinations by ranking
sortedGenecomb <- c()
for(i in 1:noCombs){
	idx <- dataScore$ix[i]
	z <- capture.output(cat(names(x.S[[idx]]),sep="-"))
	sortedGenecomb <- c(sortedGenecomb, z)
}
if(DATATYPE == "1"){
	write.table(sortedGenecomb,file=paste("order-",k,"-SA-",sa.name,"-",geneName,"-ranking-mean-DR.txt",sep=""))
}else{
	write.table(sortedGenecomb,file=paste("order-",k,"-SA-",sa.name,"-",geneName,"-ranking-mean-UR.txt",sep=""))
}