! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! The Reaction Rates File
! 
! Generated by KPP-3.1.1 symbolic chemistry Kinetics PreProcessor
!       (https:/github.com/KineticPreProcessor/KPP
! KPP is distributed under GPL, the general public licence
!       (http://www.gnu.org/copyleft/gpl.html)
! (C) 1995-1997, V. Damian & A. Sandu, CGRER, Univ. Iowa
! (C) 1997-2022, A. Sandu, Michigan Tech, Virginia Tech
!     With important contributions from:
!        M. Damian,   Villanova University, Philadelphia, PA, USA
!        R. Sander,   Max-Planck Institute for Chemistry, Mainz, Germany
!        M. Long,     Renaissance Fiber, LLC, North Carolina, USA
!        H. Lin,      Harvard University, Cambridge, MA, USA
!        R. Yantosca, Harvard University, Cambridge, MA, USA
! 
! File                 : gckpp_Rates.F90
! Equation file        : gckpp.kpp
! Output root filename : gckpp
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



MODULE gckpp_Rates

  USE gckpp_Parameters
  USE gckpp_Global
  IMPLICIT NONE
  INTEGER, PARAMETER :: ASSOC = 1, DISSOC = 2

  PRIVATE :: ARR_abc_dp, ARR_abc_sp
  INTERFACE ARR_abc
     MODULE PROCEDURE ARR_abc_dp
     MODULE PROCEDURE ARR_abc_sp
  END INTERFACE ARR_abc

  PRIVATE :: ARR_ab_dp, ARR_ab_sp
  INTERFACE ARR_ab
     MODULE PROCEDURE ARR_ab_dp
     MODULE PROCEDURE ARR_ab_sp
  END INTERFACE ARR_ab

  PRIVATE :: ARR_ac_dp, ARR_ac_sp
  INTERFACE ARR_ac
     MODULE PROCEDURE ARR_ac_dp
     MODULE PROCEDURE ARR_ac_sp
  END INTERFACE ARR_ac

  PRIVATE :: EP2_dp, EP2_sp
  INTERFACE EP2
     MODULE PROCEDURE EP2_dp
     MODULE PROCEDURE EP2_sp
  END INTERFACE EP2

  PRIVATE :: EP3_dp, EP3_sp
  INTERFACE EP3
     MODULE PROCEDURE EP3_dp
     MODULE PROCEDURE EP3_sp
  END INTERFACE EP3

  PRIVATE :: FALL_dp, FALL_sp
  INTERFACE FALL
     MODULE PROCEDURE FALL_dp
     MODULE PROCEDURE FALL_sp
  END INTERFACE FALL

  PRIVATE :: k3rd_jpl_dp, k3rd_jpl_sp
  INTERFACE k3rd_jpl
     MODULE PROCEDURE k3rd_jpl_dp
     MODULE PROCEDURE k3rd_jpl_sp
  END INTERFACE k3rd_jpl

  PRIVATE :: k3rd_jpl_activation_dp, k3rd_jpl_activation_sp
  INTERFACE  k3rd_jpl_activation
     MODULE PROCEDURE  k3rd_jpl_activation_dp
     MODULE PROCEDURE  k3rd_jpl_activation_sp
  END INTERFACE  k3rd_jpl_activation

  PRIVATE :: k3rd_iupac_dp, k3rd_iupac_sp
  INTERFACE k3rd_iupac
     MODULE PROCEDURE k3rd_iupac_dp
     MODULE PROCEDURE k3rd_iupac_sp
  END INTERFACE k3rd_iupac

CONTAINS



! Begin Rate Law Functions from KPP_HOME/util/UserRateLaws

!~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!  User-defined Rate Law functions
!
!  NOTE: For computational efficiency, we have created duplicate rate law
!  routines here that take either all single precision or all double precision
!  arguments.  Explicit casts to DBLE are skipped in the functions that take
!  all double precision arguments (as this removes unneeded computations).
!
!  These functions are overloaded by INTERFACE statements, which are located
!  in file UserRateLawsInterfaces.f90.  The UserRateLawsInterfaces.f90 file
!  will be in-lined into the top of the gckpp_Rates module.
!~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  FUNCTION ARR_abc_dp( a0, b0, c0 ) RESULT( k )
    ! Arrhenius function, for nonzero a0, b0, c0 (dp args)
    REAL(dp), INTENT(IN) :: a0, b0, c0
    REAL(kind=dp) :: k
    k = a0 * EXP(-b0/TEMP) * (TEMP/300.0_dp)**C0
  END FUNCTION ARR_abc_dp

  FUNCTION ARR_abc_sp( a0, b0, c0 ) RESULT( k )
    ! Arrhenius function, for nonzero a0, b0, c0 (sp args)
    REAL(sp), INTENT(IN) :: a0, b0, c0
    REAL(kind=dp) :: k
    k = DBLE(a0) * EXP(-DBLE(b0)/TEMP) * (TEMP/300.0_dp)**DBLE(c0)
  END FUNCTION ARR_abc_sp

  !---------------------------------------------------------------------------

  FUNCTION ARR_ab_dp( a0, b0 ) RESULT( k )
    ! Arrhenius function, for nonzero a0, b0 (dp args)
    REAL(dp), INTENT(IN) :: a0, b0
    REAL(kind=dp) :: k
    k = a0 * EXP(-b0/TEMP)
  END FUNCTION ARR_ab_dp

  FUNCTION ARR_ab_sp( a0, b0 ) RESULT( k )
    ! Arrhenius function, for nonzero a0, b0 (sp args)
    REAL(sp), INTENT(IN) :: a0, b0
    REAL(kind=dp) :: k
    k = DBLE(a0) * EXP(-DBLE(b0)/TEMP)
  END FUNCTION ARR_ab_sp

  !---------------------------------------------------------------------------

  FUNCTION ARR_ac_dp( a0, c0 ) RESULT( k )
    ! Arrhenius function, for nonzero a0, c0 (dp args)
    REAL(dp), INTENT(IN) :: a0, c0
    REAL(kind=dp) :: k
    k = a0 * (TEMP/300.0_dp)**C0
  END FUNCTION ARR_ac_dp

  FUNCTION ARR_ac_sp( a0, c0 ) RESULT( k )
    ! Arrhenius function, for nonzero a0, c0 (sp args)
    REAL(sp), INTENT(IN) :: a0, c0
    REAL(kind=dp) :: k
    k = DBLE(a0) * (TEMP/300.0_dp)**DBLE(c0)
  END FUNCTION ARR_ac_sp

  !---------------------------------------------------------------------------

  FUNCTION EP2_dp( a0, c0, a2, c2, a3, c3 ) RESULT( k )
    ! EP2 function, for saprc99 and saprcnov (dp args)
    REAL(dp), INTENT(IN) :: a0, c0, a2, c2, a3, c3
    REAL(dp) :: k0, k2, k3
    REAL(kind=dp) :: k
    k0 = a0 * EXP(-c0/temp)
    k2 = a2 * EXP(-c2/temp)
    k3 = a3 * EXP(-c3/temp)
    k3 = k3 * CFACTOR * 1.0E6_dp
    k  = k0 + k3/(1.0_dp + k3/k2)
  END FUNCTION EP2_dp

  FUNCTION EP2_sp( a0, c0, a2, c2, a3, c3 ) RESULT( k )
    ! EP2 function, for saprc99 and saprcnov (sp args)
    REAL(sp), INTENT(IN) :: a0, c0, a2, c2, a3, c3
    REAL(dp) :: k0, k2, k3
    REAL(kind=dp) :: k
    k0 = DBLE(a0) * EXP(-DBLE(c0)/TEMP)
    k2 = DBLE(a2) * EXP(-DBLE(c2)/TEMP)
    k3 = DBLE(a3) * EXP(-DBLE(c3)/TEMP)
    k3 = k3 * CFACTOR * 1.0E6_dp
    k  = k0 + K3/(1.0_dp + k3/k2)
  END FUNCTION EP2_sp

  !---------------------------------------------------------------------------

  FUNCTION EP3_dp( a1, c1, a2, c2) RESULT( k )
    ! EP3 function, for saprc99 and saprcnov (dp args)
    REAL(dp), INTENT(IN) :: a1, c1, a2, c2
    REAL(dp) :: k1, k2
    REAL(kind=dp) :: k
    k1 = a1 * EXP(-c1/TEMP)
    k2 = a2 * EXP(-c2/TEMP)
    k  = k1 + k2*(1.0E6_dp * CFACTOR)
  END FUNCTION EP3_dp

  FUNCTION EP3_sp( a1, c1, a2, c2 ) RESULT( k )
    ! EP3 function, for saprc99 and saprcnov (sp args)
    REAL(sp), INTENT(IN) :: a1, c1, a2, c2
    REAL(dp) :: k1, k2
    REAL(kind=dp) :: k
    k1 = DBLE(a1) * EXP(-DBLE(c1)/TEMP)
    k2 = DBLE(a2) * EXP(-DBLE(c2)/TEMP)
    k  = k1 + k2*(1.0E6_dp * CFACTOR)
  END FUNCTION EP3_sp

  !---------------------------------------------------------------------------

  FUNCTION FALL_dp( a0, b0, c0, a1, b1, c1, cf ) RESULT( k )
    ! FALL function, for saprc99 and saprcnov (dp args)
    REAL(dp), INTENT(IN) :: a0, b0, c0, a1, b1, c1, cf
    REAL(dp) :: k0, k1
    REAL(kind=dp) :: k
    k0 = a0 * EXP(-b0/TEMP) * (TEMP/300.0_dp)**c0
    k1 = a1 * EXP(-b1/TEMP) * (TEMP/300.0_dp)**c1
    k0 = k0 * CFACTOR * 1.0E6_dp
    k1 = k0 / k1
    k  = (k0/(1.0_dp+k1)) * cf**(1.0_dp/(1.0_dp+(LOG10(k1))**2))
  END FUNCTION FALL_dp

  FUNCTION FALL_sp( a0, b0, c0, a1, b1, c1, cf ) RESULT( k )
    ! FALL function, for saprc99 and saprcnov (sp args)
    REAL(sp), INTENT(IN) :: a0, b0, c0, a1, b1, c1, cf
    REAL(dp) :: k0, k1
    REAL(kind=dp) :: k
    k0 = DBLE(A0) * EXP(-DBLE(B0)/TEMP)* (TEMP/300.0_dp)**DBLE(C0)
    k1 = DBLE(A1) * EXP(-DBLE(B1)/TEMP)* (TEMP/300.0_dp)**DBLE(C1)
    k0 = k0 * CFACTOR * 1.0E6_dp
    k1 = k0 / k1
    k  = (k0/(1.0_dp+k1)) * DBLE(cf)**(1.0_dp/(1.0_dp+(LOG10(k1))**2))
  END FUNCTION FALL_sp

  !---------------------------------------------------------------------------

  ! JPL (jpldataeval.jpl.nasa.gov) three-body reaction formula:
  
  REAL(dp) FUNCTION k3rd_jpl_dp(cair,k0_300K,n,kinf_300K,m,fc) ! dp args
    INTRINSIC LOG10
    REAL(dp), INTENT(IN) :: cair      ! air concentration [molecules/cm3]
    REAL(dp), INTENT(IN) :: k0_300K   ! low pressure limit at 300 K
    REAL(dp), INTENT(IN) :: n         ! exponent for low pressure limit
    REAL(dp), INTENT(IN) :: kinf_300K ! high pressure limit at 300 K
    REAL(dp), INTENT(IN) :: m         ! exponent for high pressure limit
    REAL(dp), INTENT(IN) :: fc        ! broadening factor (usually fc=0.6)
    REAL(dp) :: zt_help, k0_T, kinf_T, k_ratio
    zt_help  = 300._dp/temp
    k0_T     = k0_300K   * zt_help**(n) * cair ! k_0   at current T
    kinf_T   = kinf_300K * zt_help**(m)        ! k_inf at current T
    k_ratio  = k0_T/kinf_T
    k3rd_jpl_dp = k0_T/(1._dp+k_ratio)*fc**(1._dp/(1._dp+LOG10(k_ratio)**2))
  END FUNCTION k3rd_jpl_dp

  REAL(kind=dp) FUNCTION k3rd_jpl_sp(cair,k0_300K,n,kinf_300K,m,fc) ! sp args
    INTRINSIC LOG10
    REAL(sp), INTENT(IN) :: cair      ! air concentration [molecules/cm3]
    REAL(sp), INTENT(IN) :: k0_300K   ! low pressure limit at 300 K
    REAL(sp), INTENT(IN) :: n         ! exponent for low pressure limit
    REAL(sp), INTENT(IN) :: kinf_300K ! high pressure limit at 300 K
    REAL(sp), INTENT(IN) :: m         ! exponent for high pressure limit
    REAL(sp), INTENT(IN) :: fc        ! broadening factor (usually fc=0.6)
    REAL(sp) :: zt_help, k0_T, kinf_T, k_ratio
    zt_help  = 300._dp/temp
    k0_T     = k0_300K   * zt_help**(n) * cair ! k_0   at current T
    kinf_T   = kinf_300K * zt_help**(m)        ! k_inf at current T
    k_ratio  = k0_T/kinf_T
    k3rd_jpl_sp = k0_T/(1._dp+k_ratio)*fc**(1._dp/(1._dp+LOG10(k_ratio)**2))
  END FUNCTION k3rd_jpl_sp

  ! --------------------------------------------------------------------------

  ! JPL (jpldataeval.jpl.nasa.gov) termolecular chemical activation reaction:

  FUNCTION k3rd_jpl_activation_dp(cair,k0_298K,n,kinf_298K,m,A,B) ! dp args
    INTRINSIC :: LOG10
    REAL(dp), DIMENSION(2) :: k3rd_jpl_activation_dp
    REAL(dp), INTENT(IN) :: cair      ! air concentration [molecules/cm3]
    REAL(dp), INTENT(IN) :: k0_298K   ! low pressure limit at 300 K
    REAL(dp), INTENT(IN) :: n         ! exponent for low pressure limit
    REAL(dp), INTENT(IN) :: kinf_298K ! high pressure limit at 300 K
    REAL(dp), INTENT(IN) :: m         ! exponent for high pressure limit
    REAL(dp), INTENT(IN) :: A         ! for k_int
    REAL(dp), INTENT(IN) :: B         ! for k_int
    REAL(dp)             :: zt_help, k0_TM, kinf_T, k_ratio, k_f, k_int, k_fCA
    zt_help = 298./temp
    k0_TM   = k0_298K   * zt_help**n * cair ! k_0   at current T * M
    kinf_T  = kinf_298K * zt_help**m        ! k_inf at current T
    k_ratio = k0_TM/kinf_T
    k_f     = k0_TM/(1.+k_ratio)*0.6**(1./(1.+LOG10(k_ratio)**2))
    k_int   = A * exp(-B/temp)
    k_fCA   = k_int * (1. - k_f/kinf_T)
    k3rd_jpl_activation_dp(ASSOC)  = k_f
    k3rd_jpl_activation_dp(DISSOC) = k_fCA
  END FUNCTION k3rd_jpl_activation_dp

  FUNCTION k3rd_jpl_activation_sp(cair,k0_298K,n,kinf_298K,m,A,B) ! sp args
    INTRINSIC :: LOG10
    REAL(kind=dp), DIMENSION(2) :: k3rd_jpl_activation_sp
    REAL(sp), INTENT(IN) :: cair      ! air concentration [molecules/cm3]
    REAL(sp), INTENT(IN) :: k0_298K   ! low pressure limit at 300 K
    REAL(sp), INTENT(IN) :: n         ! exponent for low pressure limit
    REAL(sp), INTENT(IN) :: kinf_298K ! high pressure limit at 300 K
    REAL(sp), INTENT(IN) :: m         ! exponent for high pressure limit
    REAL(sp), INTENT(IN) :: A         ! for k_int
    REAL(sp), INTENT(IN) :: B         ! for k_int
    REAL(sp)             :: zt_help, k0_TM, kinf_T, k_ratio, k_f, k_int, k_fCA
    zt_help = 298./temp
    k0_TM   = k0_298K   * zt_help**n * cair ! k_0   at current T * M
    kinf_T  = kinf_298K * zt_help**m        ! k_inf at current T
    k_ratio = k0_TM/kinf_T
    k_f     = k0_TM/(1.+k_ratio)*0.6**(1./(1.+LOG10(k_ratio)**2))
    k_int   = A * exp(-B/temp)
    k_fCA   = k_int * (1. - k_f/kinf_T)
    k3rd_jpl_activation_sp(ASSOC)  = k_f
    k3rd_jpl_activation_sp(DISSOC) = k_fCA
  END FUNCTION k3rd_jpl_activation_sp

  ! --------------------------------------------------------------------------

  ! IUPAC (iupac.pole-ether.fr) three-body reaction formula:

  REAL(dp) FUNCTION k3rd_iupac_dp(cair,k0_300K,n,kinf_300K,m,fc) ! dp args
    INTRINSIC :: LOG10
    REAL(dp), INTENT(IN) :: cair      ! air concentration [molecules/cm3]
    REAL(dp), INTENT(IN) :: k0_300K   ! low pressure limit at 300 K
    REAL(dp), INTENT(IN) :: n         ! exponent for low pressure limit
    REAL(dp), INTENT(IN) :: kinf_300K ! high pressure limit at 300 K
    REAL(dp), INTENT(IN) :: m         ! exponent for high pressure limit
    REAL(dp), INTENT(IN) :: fc        ! broadening factor (e.g. 0.45 or 0.6...)
    REAL(dp)             :: nu        ! N
    REAL(dp)             :: zt_help, k0_T, kinf_T, k_ratio
    zt_help = 300._dp/temp
    k0_T    = k0_300K   * zt_help**(n) * cair ! k_0   at current T
    kinf_T  = kinf_300K * zt_help**(m)        ! k_inf at current T
    k_ratio = k0_T/kinf_T
    nu      = 0.75-1.27*LOG10(fc)
    k3rd_iupac_dp = k0_T/(1._dp+k_ratio)* &
      fc**(1._dp/(1._dp+(LOG10(k_ratio)/nu)**2))
  END FUNCTION k3rd_iupac_dp

  REAL(kind=dp) FUNCTION k3rd_iupac_sp(cair,k0_300K,n,kinf_300K,m,fc) ! sp args
    INTRINSIC :: LOG10
    REAL(sp), INTENT(IN) :: cair      ! air concentration [molecules/cm3]
    REAL(sp), INTENT(IN) :: k0_300K   ! low pressure limit at 300 K
    REAL(sp), INTENT(IN) :: n         ! exponent for low pressure limit
    REAL(sp), INTENT(IN) :: kinf_300K ! high pressure limit at 300 K
    REAL(sp), INTENT(IN) :: m         ! exponent for high pressure limit
    REAL(sp), INTENT(IN) :: fc        ! broadening factor (e.g. 0.45 or 0.6...)
    REAL(sp)             :: nu        ! N
    REAL(sp)             :: zt_help, k0_T, kinf_T, k_ratio
    zt_help = 300._dp/temp
    k0_T    = k0_300K   * zt_help**(n) * cair ! k_0   at current T
    kinf_T  = kinf_300K * zt_help**(m)        ! k_inf at current T
    k_ratio = k0_T/kinf_T
    nu      = 0.75-1.27*LOG10(fc)
    k3rd_iupac_sp = k0_T/(1._dp+k_ratio)* &
      fc**(1._dp/(1._dp+(LOG10(k_ratio)/nu)**2))
  END FUNCTION k3rd_iupac_sp

!~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!  End of User-defined Rate Law functions
!~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

! End Rate Law Functions from KPP_HOME/util/UserRateLaws


! Begin INLINED Rate Law Functions


  ! All rates are included in fullchem_RateLawFuncs.F90, which
  ! gets referenced directly from subroutine Update_Rconst.

! End INLINED Rate Law Functions

! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Update_SUN - update SUN light using TIME
!   Arguments :
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  SUBROUTINE Update_SUN()
    USE gckpp_Parameters
    USE gckpp_Global

    IMPLICIT NONE

    REAL(kind=dp) :: SunRise, SunSet
    REAL(kind=dp) :: Thour, Tlocal, Ttmp 
    ! PI - Value of pi
    REAL(kind=dp), PARAMETER :: PI = 3.14159265358979d0
    
    SunRise = 4.5_dp 
    SunSet  = 19.5_dp 
    Thour = TIME/3600.0_dp 
    Tlocal = Thour - (INT(Thour)/24)*24

    IF ((Tlocal>=SunRise).AND.(Tlocal<=SunSet)) THEN
       Ttmp = (2.0*Tlocal-SunRise-SunSet)/(SunSet-SunRise)
       IF (Ttmp.GT.0) THEN
          Ttmp =  Ttmp*Ttmp
       ELSE
          Ttmp = -Ttmp*Ttmp
       END IF
       SUN = ( 1.0_dp + COS(PI*Ttmp) )/2.0_dp 
    ELSE
       SUN = 0.0_dp 
    END IF

 END SUBROUTINE Update_SUN

! End of Update_SUN function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Update_RCONST - function to update rate constants
!   Arguments :
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE Update_RCONST ( )




! Begin INLINED RCONST


  ! Inline an include file containing rate law definitions, which
  ! will be inserted directly into subroutine Update_Rconst().
  ! This is necessary as a workaround for KPP not being able to
  ! include very large files ( > 200000 chars) directly.
  !  -- Bob Yantosca (11 Jun 2021)
  USE fullchem_RateLawFuncs

! End INLINED RCONST

  RCONST(1) = (K_MT(1))
  RCONST(2) = (K_MT(2))
  RCONST(3) = (K_MT(3))
  RCONST(4) = (K_MT(4))
  RCONST(5) = (K_MT(5))
  RCONST(6) = (K_MT(6))
  RCONST(7) = (K_CLD(1))
  RCONST(8) = (K_CLD(2))
  RCONST(9) = (K_CLD(3))
  RCONST(10) = (K_CLD(4))
  RCONST(11) = (K_CLD(5))
  RCONST(12) = (K_CLD(6))
  RCONST(13) = (GCARR_ac(3.00d-12,-1500.0d0))
  RCONST(14) = (GCARR_ac(1.70d-12,-940.0d0))
  RCONST(15) = (GCARR_ac(1.00d-14,-490.0d0))
  RCONST(16) = (GCARR_ac(1.20d-13,-2450.0d0))
  RCONST(17) = (GCARR_ac(2.90d-16,-1000.0d0))
  RCONST(18) = (1.80d-12)
  RCONST(19) = (GCJPLPR_aba(6.90d-31,1.0d+00,2.6d-11,0.6d0))
  RCONST(20) = (GCARR_ac(4.80d-11,250.0d0))
  RCONST(21) = (1.80d-12)
  RCONST(22) = (GCARR_ac(3.44d-12,260.0d0))
  RCONST(23) = (GC_HO2HO2_acac(3.00d-13,460.0d0,2.1d-33,920.0d0))
  RCONST(24) = (GCJPLPR_abab(6.9d-33,2.1d0,1.1d-12,-1.3d0,0.6d0)+GCJPLAC_ababac(6.9d-33,2.1d0,1.1d-12,-1.3d0,1.85d-13,&
                 &-6.5d1,0.6d0))
  RCONST(25) = (GCARR_ac(2.45d-12,-1775.0d0))
  RCONST(26) = (GC_RO2NO_B1_ac(2.80d-12,300.0d0))
  RCONST(27) = (GC_RO2NO_A1_ac(2.80d-12,300.0d0))
  RCONST(28) = (GCARR_ac(4.10d-13,750.0d0))
  RCONST(29) = (GC_TBRANCH_1_acac(9.50d-14,390.0d0,2.62d1,-1130.0d0))
  RCONST(30) = (GC_TBRANCH_1_acac(9.50d-14,390.0d0,4.0d-2,1130.0d0))
  RCONST(31) = (1.60d-10)
  RCONST(32) = (GCARR_ac(3.80d-12,200.0d0))
  RCONST(33) = (GCARR_ac(3.80d-12,200.0d0))
  RCONST(34) = (GCARR_ac(5.50d-12,125.0d0))
  RCONST(35) = (GCJPLPR_aba(1.80d-30,3.0d+00,2.8d-11,0.6d0))
  RCONST(36) = (GCJPLPR_abab(3.9d-31,7.2d0,1.5d-13,4.8d0,0.6d0)+GCJPLAC_ababac(3.9d-31,7.2d0,1.5d-13,4.8d0,3.7d-14,2.4d2,&
                 &0.6d0))
  RCONST(37) = (GCJPLPR_abab(7.00d-31,2.6d+00,3.60d-11,0.1d0,0.6d0))
  RCONST(38) = (GCARR_ac(3.00d-12,250.0d0))
  RCONST(39) = (GCJPLPR_abab(1.90d-31,3.4d+00,4.0d-12,0.3d0,0.6d0))
  RCONST(40) = (GCJPLPR_abcabc(9.05d-05,3.4d0,-10900.0d0,1.90d15,0.3d0,-10900.0d0,0.6d0))
  RCONST(41) = (GCARR_ac(4.50d-13,610.0d0))
  RCONST(42) = (3.50d-12)
  RCONST(43) = (GCARR_ac(1.70d-11,125.0d0))
  RCONST(44) = (2.00d-11)
  RCONST(45) = (GCJPLPR_abab(2.40d-30,3.0d+00,1.6d-12,-0.1d0,0.6d0))
  RCONST(46) = (GCJPLPR_abcabc(4.14d-04,3.0d0,-10840.0d0,2.76d14,-0.1d0,-10840.0d0,0.6d0))
  RCONST(47) = (4.00d-13)
  RCONST(48) = (GCARR_ac(2.90d-12,-345.0d0))
  RCONST(49) = (GCARR_ac(4.35d-14,-1335.0d0))
  RCONST(50) = (5.80d-16)
  RCONST(51) = (GCARR_ac(4.63d-12,350.0d0))
  RCONST(52) = (GCARR_ac(1.40d-12,-1900.0d0))
  RCONST(53) = (GCJPLPR_abab(7.30d-29,4.1d+00,9.5d-12,1.6d0,0.6d0))
  RCONST(54) = (GCJPLEQ_acabab(9.00d-29,14000.0d0,7.3d-29,4.1d0,9.5d-12,1.6d0,0.6d0))
  RCONST(55) = (3.00d-14)
  RCONST(56) = (GCARR_ac(8.10d-12,270.0d0))
  RCONST(57) = (GCARR_ac(7.66d-12,-1020.0d0))
  RCONST(58) = (GC_RO2NO_B2_aca(2.60d-12,365.0d0,2.0d0))
  RCONST(59) = (GC_RO2NO_A2_aca(2.60d-12,365.0d0,2.0d0))
  RCONST(60) = (GCARR_ac(2.60d-12,365.0d0))
  RCONST(61) = (GCARR_abc(8.54d-13,1.54d0,-19.0d0))
  RCONST(62) = (GCARR_abc(1.97d-12,1.23d0,-675.0d0))
  RCONST(63) = (GC_RO2NO_B2_aca(2.90d-12,350.0d0,3.0d0))
  RCONST(64) = (GC_RO2NO_A2_aca(2.90d-12,350.0d0,3.0d0))
  RCONST(65) = (GCARR_ac(2.70d-12,350.0d0))
  RCONST(66) = (GCARR_ac(2.00d-11,-359.0d0))
  RCONST(67) = (6.0d-17)
  RCONST(68) = (GC_RO2NO_B2_aca(2.70d-12,350.0d0,7.0d0))
  RCONST(69) = (GC_RO2NO_A2_aca(2.70d-12,350.0d0,7.0d0))
  RCONST(70) = (3.0d-12)
  RCONST(71) = (1.00d-11)
  RCONST(72) = (4.00d-12)
  RCONST(73) = (GCARR_ac(4.20d-12,180.0d0))
  RCONST(74) = (GCARR_ac(7.40d-13,700.0d0))
  RCONST(75) = (GCARR_ac(1.48d-11,448.0d0))
  RCONST(76) = (1.03d-13)
  RCONST(77) = (GCARR_ac(1.34d-14,-2283.0d0))
  RCONST(78) = (GCARR_ac(2.70d-12,360.0d0))
  RCONST(79) = (GCARR_ac(1.82d-13,1300d0))
  RCONST(80) = (3.59d-11)
  RCONST(81) = (2.00d-11)
  RCONST(82) = (GCARR_ac(2.70d-12,360.0d0))
  RCONST(83) = (GCARR_ac(1.51d-13,1300.0d0))
  RCONST(84) = (GCARR_ac(5.2d-13,980.0d0))
  RCONST(85) = (GCARR_ac(7.5d-12,290.0d0))
  RCONST(86) = (GCJPLPR_abab(9.70d-29,5.6d+00,9.3d-12,1.5d0,0.6d0))
  RCONST(87) = (GCJPLEQ_acabab(9.30d-29,14000.0d0,9.7d-29,5.6d0,9.3d-12,1.5d0,0.6d0))
  RCONST(88) = (1.47d-11)
  RCONST(89) = (GCARR_ac(9.10d-12,-405.0d0))
  RCONST(90) = (GC_RO2NO_B2_aca(2.70d-12,350.0d0,4.5d0))
  RCONST(91) = (GC_RO2NO_A2_aca(2.70d-12,350.0d0,4.5d0))
  RCONST(92) = (GCARR_ac(2.70d-12,350.0d0))
  RCONST(93) = (GC_RO2NO_B2_aca(2.70d-12,350.0d0,4.5d0))
  RCONST(94) = (GC_RO2NO_A2_aca(2.70d-12,350.0d0,4.5d0))
  RCONST(95) = (GCARR_ac(2.70d-12,350.0d0))
  RCONST(96) = (GCARR_ac(2.90d-12,300.0d0))
  RCONST(97) = (GCARR_ac(2.70d-12,350.0d0))
  RCONST(98) = (GC_RO2NO_B2_aca(2.70d-12,360.0d0,3.0d0))
  RCONST(99) = (GC_RO2NO_A2_aca(2.70d-12,360.0d0,3.0d0))
  RCONST(100) = (GCARR_ac(2.70d-12,350.0d0))
  RCONST(101) = (GCARR_ac(2.80d-12,-3280.0d0))
  RCONST(102) = (1.60d-12)
  RCONST(103) = (1.60d-12)
  RCONST(104) = (GCARR_ac(3.15d-14,920.0d0))
  RCONST(105) = (GCARR_ac(6.00d-12,410.0d0))
  RCONST(106) = (GCJPLPR_abab(9.00d-28,8.9d0,7.7d-12,0.2d0,0.6d0))
  RCONST(107) = (GCJPLEQ_acabab(9.00d-29,14000.0d0,9.00d-28,8.9d0,7.7d-12,0.2d0,0.6d0))
  RCONST(108) = (1.27d-12)
  RCONST(109) = (GCARR_ac(6.70d-12,340.0d0))
  RCONST(110) = (6.50d-15)
  RCONST(111) = (1.33d-13+3.82d-11*exp(-2000.0d0/TEMP))
  RCONST(112) = (5.92d-13)
  RCONST(113) = (5.92d-13)
  RCONST(114) = (GCARR_ac(7.40d-13,700.0d0))
  RCONST(115) = (GCARR_ac(7.40d-13,700.0d0))
  RCONST(116) = (GCARR_ac(7.40d-13,700.0d0))
  RCONST(117) = (GCARR_ac(7.40d-13,700.0d0))
  RCONST(118) = (GCARR_ac(8.60d-13,700.0d0))
  RCONST(119) = (GC_RO2HO2_aca(2.91d-13,1300.0d0,4.0d0))
  RCONST(120) = (GC_RO2HO2_aca(2.91d-13,1300.0d0,3.0d0))
  RCONST(121) = (GC_RO2HO2_aca(2.91d-13,1300.0d0,3.0d0))
  RCONST(122) = (GCARR_ac(1.50d-12,-90.0d0))
  RCONST(123) = (GCARR_ac(2.70d-12,350.0d0))
  RCONST(124) = (GCJPLPR_abab(9.70d-29,5.6d+00,9.3d-12,1.5d0,0.6d0))
  RCONST(125) = (GCJPLEQ_acabab(9.30d-29,14000.0d0,9.7d-29,5.6d0,9.3d-12,1.5d0,0.6d0))
! RCONST(126) = constant rate coefficient
  RCONST(127) = (GCARR_ac(7.50d-12,290.0d0))
  RCONST(128) = (GCARR_ac(5.20d-13,980.0d0))
  RCONST(129) = (3.00d-13)
  RCONST(130) = (3.00d-13)
  RCONST(131) = (8.00d-16)
  RCONST(132) = (8.37d-14)
  RCONST(133) = (8.37d-14)
  RCONST(134) = (8.37d-14)
  RCONST(135) = (8.37d-14)
  RCONST(136) = (GCARR_ac(7.50d-13,500.0d0))
  RCONST(137) = (8.37d-14)
  RCONST(138) = (8.37d-14)
  RCONST(139) = (8.37d-14)
  RCONST(140) = (3.35d-12)
  RCONST(141) = (GCARR_ac(4.40d-12,70.0d0))
  RCONST(142) = (6.80d-14)
  RCONST(143) = (6.80d-14)
  RCONST(144) = (GCARR_ac(7.50d-13,700.0d0))
  RCONST(145) = (GCARR_ac(7.50d-13,700.0d0))
  RCONST(146) = (GC_RO2HO2_aca(2.91d-13,1300.0d0,3.0d0))
  RCONST(147) = (GC_RO2HO2_aca(2.91d-13,1300.0d0,3.0d0))
  RCONST(148) = (GCARR_ac(4.30d-13,1040.0d0))
  RCONST(149) = (GCJPLPR_abab(4.60d-27,4.0d0,2.6d-11,1.3d0,0.5d0))
  RCONST(150) = (GCARR_ac(6.50d-15,-1900.0d0))
  RCONST(151) = (GC_GLYCOH_A_a(8.00d-12))
  RCONST(152) = (GC_GLYCOH_B_a(8.00d-12))
  RCONST(153) = (1.0d-11)
  RCONST(154) = (GCARR_ac(1.44d-12,-1862.0d0))
  RCONST(155) = (GCJPLPR_abab(9.70d-29,5.6d+00,9.3d-12,1.5d0,0.6d0))
  RCONST(156) = (GCJPLEQ_acabab(9.30d-29,14000.0d0,9.7d-29,5.6d0,9.3d-12,1.5d0,0.6d0))
  RCONST(157) = (GCARR_ac(7.5d-12,290d0))
  RCONST(158) = (GCARR_ac(5.2d-13,980d0))
  RCONST(159) = (4.0d-12)
  RCONST(160) = (1.12d-12)
  RCONST(161) = (2.73d-12)
  RCONST(162) = (GCARR_ac(4.59d-13,-1156.0d0))
  RCONST(163) = (GCARR_ac(3.10d-12,340.0d0))
  RCONST(164) = (GCARR_ac(1.90d-12,575.0d0))
  RCONST(165) = (GC_GLYXNO3_ac(1.40d-12,-1860.0d0))
  RCONST(166) = (GCARR_ac(3.36d-12,-1860.0d0))
  RCONST(167) = (GC_HACOH_A_ac(2.00d-12,320.0d0))
  RCONST(168) = (GC_HACOH_B_ac(2.00d-12,320.0d0))
  RCONST(169) = (GCARR_ac(8.78d-12,200.0d0))
  RCONST(170) = (GCARR_ac(5.18d-12,200.0d0))
  RCONST(171) = (GCARR_ac(5.18d-12,200.0d0))
  RCONST(172) = (GCARR_ac(8.78d-12,200.0d0))
  RCONST(173) = (GCARR_ac(8.78d-12,200.0d0))
  RCONST(174) = (GCARR_ac(8.78d-12,200.0d0))
  RCONST(175) = (GCARR_ac(6.13d-13,200.0d0))
  RCONST(176) = (GCARR_ac(8.78d-12,200.0d0))
  RCONST(177) = (GCARR_ac(4.82d-11,-400.0d0))
  RCONST(178) = (3.00d-14)
  RCONST(179) = (1.40d-18)
  RCONST(180) = (GCARR_ac(2.90d-12,500.0d0))
  RCONST(181) = (GCARR_ac(2.00d-12,500.0d0))
  RCONST(182) = (GCARR_ac(1.87d-12,500.0d0))
  RCONST(183) = (GCARR_ac(1.87d-12,500.0d0))
  RCONST(184) = (GCARR_ac(1.87d-12,500.0d0))
  RCONST(185) = (GCARR_ac(1.87d-12,500.0d0))
  RCONST(186) = (GCARR_ac(1.87d-12,500.0d0))
  RCONST(187) = (GCARR_ac(1.87d-12,500.0d0))
  RCONST(188) = (GCARR_ac(1.87d-12,500.0d0))
  RCONST(189) = (GCARR_ac(1.87d-12,500.0d0))
  RCONST(190) = (GCARR_ac(1.87d-12,500.0d0))
  RCONST(191) = (GCARR_ac(1.87d-12,500.0d0))
  RCONST(192) = (GCARR_ac(1.87d-12,500.0d0))
  RCONST(193) = (GCARR_ac(1.87d-12,500.0d0))
  RCONST(194) = (GCARR_ac(2.50d-12,500.0d0))
  RCONST(195) = (GCARR_ac(1.87d-12,500.0d0))
  RCONST(196) = (GCARR_ac(8.50d-13,-2450.0d0))
  RCONST(197) = (GCJPLPR_abab(1.00d-30,4.8d+00,7.2d-12,2.1d0,0.6d0))
  RCONST(198) = (GCJPLPR_abcabc(1.05d-02,4.8d+00,-11234.0d0,7.58d16,2.1d0,-11234.0d0,0.6d0))
  RCONST(199) = (GCARR_ac(1.20d-11,-280.0d0))
  RCONST(200) = (GC_DMSOH_acac(8.20d-39,5376.0d0,1.05d-5,3644.0d0))
  RCONST(201) = (GCARR_ac(1.90d-13,530.0d0))
  RCONST(202) = (GCJPLPR_abab(2.90d-31,4.1d+00,1.7d-12,-0.2d0,0.6d0))
  RCONST(203) = (GCARR_ac(1.60d-11,-780.0d0))
  RCONST(204) = (GCARR_ac(4.50d-12,460.0d0))
  RCONST(205) = (GCARR_ac(4.80d-12,-310.0d0))
  RCONST(206) = (GCARR_ac(5.50d-12,200.0d0))
  RCONST(207) = (GCARR_ac(2.40d-12,40.0d0))
  RCONST(208) = (GCARR_ac(2.80d-14,860.0d0))
  RCONST(209) = (GCARR_ac(8.80d-12,260.0d0))
  RCONST(210) = (4.90d-11)
  RCONST(211) = (GCARR_ac(2.10d-11,240.0d0))
  RCONST(212) = (GCARR_ac(1.20d-10,-430.0d0))
  RCONST(213) = (GCARR_ac(5.80d-12,-1500.0d0))
  RCONST(214) = (GCARR_ac(1.70d-11,250.0d0))
  RCONST(215) = (1.60d-11)
  RCONST(216) = (GCARR_ac(1.70d-11,-800.0d0))
  RCONST(217) = (GCARR_ac(1.80d-11,-460.0d0))
  RCONST(218) = (GCARR_ac(1.66d-10,-7000.0d0))
  RCONST(219) = (GCARR_ac(2.36d-10,-6411.0d0))
  RCONST(220) = (GCARR_ac(8.77d-11,-4330.0d0))
  RCONST(221) = (GCJPLPR_aba(4.20d-31,2.4d0,2.7d-11,0.6d0))
  RCONST(222) = (GCJPLPR_abab(5.40d-31,3.1d0,6.5d-12,2.9d0,0.6d0))
  RCONST(223) = (GCARR_ac(9.00d-13,-360.0d0))
  RCONST(224) = (GCARR_ac(2.00d-12,-840.0d0))
  RCONST(225) = (GCARR_ac(1.42d-12,-1150.0d0))
  RCONST(226) = (GCARR_ac(1.63d-10,60.0d0))
  RCONST(227) = (GCARR_ac(2.15d-11,110.0d0))
  RCONST(228) = (GCARR_ac(3.30d-11,55.0d0))
  RCONST(229) = (1.20d-10)
  RCONST(230) = (GCARR_ac(1.19d-10,20.0d0))
  RCONST(231) = (1.75d-10)
  RCONST(232) = (GCARR_ab(6.00d-34,2.4d0)*NUMDEN)
  RCONST(233) = (GCARR_ac(8.00d-12,-2060.0d0))
  RCONST(234) = (GCARR_ac(2.80d-12,-1800.0d0))
  RCONST(235) = (GCARR_ac(1.80d-11,180.0d0))
  RCONST(236) = (GCARR_ac(3.00d-11,200.0d0))
  RCONST(237) = (2.40d-10)
  RCONST(238) = (GCARR_ac(2.10d-11,-2200.0d0))
  RCONST(239) = (GCARR_ac(7.20d-14,-1070.0d0))
  RCONST(240) = (GCJPLAC_ababac(3.4d-31,1.6d0,2.3d-11,0.2d0,5.3d-12,2.0d2,0.6d0))
  RCONST(241) = (1.30d-11)
  RCONST(242) = (GCJPLPR_aba(9.00d-32,1.5d+00,3.0d-11,0.6d0))
  RCONST(243) = (GCJPLPR_abab(3.4d-31,1.6d0,2.3d-11,0.2d0,0.6d0))
  RCONST(244) = (GCARR_ac(1.40d-12,-2000.0d0))
  RCONST(245) = (GCJPLPR_abab(5.30d-32,1.8d+00,9.5d-11,-0.4d0,0.6d0))
  RCONST(246) = (GCARR_ac(1.40d-10,-470.0d0))
  RCONST(247) = (8.05d-11)
  RCONST(248) = (GCARR_ac(3.30d-12,-3150.0d0))
  RCONST(249) = (GCARR_ac(2.10d-11,100.0d0))
  RCONST(250) = (GCARR_ac(5.80d-12,220.0d0))
  RCONST(251) = (GCARR_ac(1.90d-11,230.0d0))
  RCONST(252) = (GCARR_ac(3.40d-11,-1600.0d0))
  RCONST(253) = (1.50d-10)
  RCONST(254) = (1.50d-10)
  RCONST(255) = (2.70d-10)
  RCONST(256) = (3.30d-10)
  RCONST(257) = (2.60d-10)
  RCONST(258) = (1.80d-10)
  RCONST(259) = (2.70d-10)
  RCONST(260) = (6.60d-10)
  RCONST(261) = (1.02d-10)
  RCONST(262) = (2.30d-10)
  RCONST(263) = (1.40d-10)
  RCONST(264) = (1.50d-10)
  RCONST(265) = (1.00d-10)
  RCONST(266) = (2.60d-10)
  RCONST(267) = (2.00d-10)
  RCONST(268) = (2.00d-10)
  RCONST(269) = (2.32d-10)
  RCONST(270) = (GCARR_ac(1.30d-10,25.0d0))
  RCONST(271) = (GCARR_ac(5.40d-11,30.0d0))
  RCONST(272) = (GCARR_ac(1.60d-10,0.0d0))
  RCONST(273) = (GCARR_ac(2.60d-12,-1100.0d0))
  RCONST(274) = (GCARR_ac(1.80d-11,-600.0d0))
  RCONST(275) = (GCARR_ac(7.40d-12,270.0d0))
  RCONST(276) = (GCARR_ac(6.00d-13,230.0d0))
  RCONST(277) = (GCARR_ac(1.40d-12,600.0d0))
  RCONST(278) = (GCARR_ac(6.00d-13,670.0d0))
  RCONST(279) = (GCARR_ac(1.80d-12,-250.0d0))
  RCONST(280) = (GCARR_ac(3.00d-12,-500.0d0))
  RCONST(281) = (GCARR_ac(2.40d-12,-1250.0d0))
  RCONST(282) = (GCARR_ac(1.20d-12,-330.0d0))
  RCONST(283) = (GCARR_ac(1.96d-12,-1200.0d0))
  RCONST(284) = (GCARR_ac(1.92d-12,-880.0d0))
  RCONST(285) = (GCARR_ac(2.20d-12,-920.0d0))
  RCONST(286) = (GCARR_ac(1.64d-12,-1520.0d0))
  RCONST(287) = (GCARR_ac(9.20d-13,-1560.0d0))
  RCONST(288) = (GCARR_ac(1.25d-12,-1600.0d0))
  RCONST(289) = (GCARR_ac(1.30d-12,-1770.0d0))
  RCONST(290) = (GCARR_ac(7.40d-13,-900.0d0))
  RCONST(291) = (GCARR_ac(7.10d-12,-1270.0d0))
  RCONST(292) = (GCARR_ac(8.10d-11,-30.0d0))
  RCONST(293) = (GCARR_ac(2.30d-11,-200.0d0))
  RCONST(294) = (GCARR_ac(3.05d-11,-2270.0d0))
  RCONST(295) = (GCARR_ac(1.10d-11,-980.0d0))
  RCONST(296) = (GCARR_ac(1.40d-11,270.0d0))
  RCONST(297) = (GCARR_ac(3.60d-11,-375.0d0))
  RCONST(298) = (GCARR_ac(2.80d-11,85.0d0))
  RCONST(299) = (GCARR_ac(2.60d-12,290.0d0))
  RCONST(300) = (GCARR_ac(6.40d-12,290.0d0))
  RCONST(301) = (GCJPLPR_abab(1.80d-31,3.4d+00,1.50d-11,1.9d0,0.6d0))
  RCONST(302) = (GCARR_ac(1.00d-12,-1590.0d0))
  RCONST(303) = (GCARR_ac(3.00d-11,-2450.0d0))
  RCONST(304) = (GCARR_ac(3.50d-13,-1370.0d0))
  RCONST(305) = (GCJPLPR_aba(2.20d-33,3.1d+00,1.8d-10,0.6d0))
  RCONST(306) = (GCJPLEQ_acabab(6.60d-25,2502.0d0,2.20d-33,3.1d+00,1.8d-10,0.0d0,0.6d0))
  RCONST(307) = (GCJPLPR_abab(1.90d-32,3.6d+00,3.7d-12,1.6d0,0.6d0))
  RCONST(308) = (GCJPLEQ_acabab(2.16d-27,8537.0d0,1.90d-32,3.6d+00,3.7d-12,1.6d0,0.6d0))
  RCONST(309) = (2.42d-10)
  RCONST(310) = (GCARR_ac(9.50d-13,550.0d0))
  RCONST(311) = (GCARR_ac(2.30d-12,260.0d0))
  RCONST(312) = (GCARR_ac(4.10d-13,290.0d0))
  RCONST(313) = (GCARR_ac(3.60d-12,-840.0d0))
  RCONST(314) = (GCARR_ac(6.50d-12,135.0d0))
  RCONST(315) = (GCARR_ac(2.03d-11,-1110.0d0))
  RCONST(316) = (GCARR_ac(7.40d-12,-910.0d0))
  RCONST(317) = (GCARR_ac(3.30d-12,-990.0d0))
  RCONST(318) = (2.00d-13)
  RCONST(319) = (1.60d-10)
  RCONST(320) = (5.7d-11)
  RCONST(321) = (GCARR_ac(7.2d-11,-70.0d0))
  RCONST(322) = (7.4d-11)
  RCONST(323) = (7.4d-11)
  RCONST(324) = (5.5d-11)
  RCONST(325) = (9.6d-11)
  RCONST(326) = (2.8d-14)
  RCONST(327) = (GCARR_ac(6.54d-11,60.0d0))
  RCONST(328) = (GCARR_ac(8.12d-11,-90.0d0))
  RCONST(329) = (GCARR_ac(1.63d-11,-610.0d0))
  RCONST(330) = (GCARR_ac(7.60d-11,500.0d0))
  RCONST(331) = (2.05d-10)
  RCONST(332) = (GCJPLPR_aa(4.00d-28,2.8d-10,0.6d0))
  RCONST(333) = (3.60d-12)
  RCONST(334) = (GCJPLPR_aba(1.80d-32,1.0d0,1.70d-11,0.6d0))
  RCONST(335) = (GCARR_ac(8.40d-11,-2620.0d0))
  RCONST(336) = (GCJPLPR_aba(3.00d-31,1.0d0,6.6d-11,0.6d0))
  RCONST(337) = (GCARR_ac(9.94d+17,-11859.0d0))
  RCONST(338) = (GCARR_ac(2.90d-11,-2600.0d0))
  RCONST(339) = (1.50d-12)
  RCONST(340) = (GCJPLPR_abab(7.50d-31,3.5d0,7.6d-12,1.5d0,0.6d0))
  RCONST(341) = (GCARR_ac(2.10d+15,-13670.0d0))
  RCONST(342) = (GCARR_ac(9.10d-11,-146.0d0))
  RCONST(343) = (1.20d-11)
  RCONST(344) = (GCARR_ac(5.50d-12,760.0d0))
  RCONST(345) = (1.00d-10)
  RCONST(346) = (1.50d-10)
  RCONST(347) = (3.80d-02)
  RCONST(348) = (GCARR_ac(1.10d-12,542.0d0))
  RCONST(349) = (GCARR_ac(4.82d-12,280.0d0))
  RCONST(350) = (GCARR_ac(2.00d-11,-830.0d0))
  RCONST(351) = (GCARR_ac(1.50d-11,-1090.0d0))
  RCONST(352) = (1.80d-10)
  RCONST(353) = (3.00d-11)
  RCONST(354) = (5.00d-12)
  RCONST(355) = (GCARR_ac(1.30d-11,570.0d0))
  RCONST(356) = (GCARR_ac(8.60d-12,230.0d0))
  RCONST(357) = (GCARR_ac(1.50d-11,500.0d0))
  RCONST(358) = (GCARR_ac(2.51d+14,-9770.0d0))
  RCONST(359) = (GCARR_ac(2.90d-12,-1100.0d0))
  RCONST(360) = (2.40d-12)
  RCONST(361) = (6.70d-13)
  RCONST(362) = (1.20d-15)
  RCONST(363) = (1.00d-14)
  RCONST(364) = (4.25d-12)
  RCONST(365) = (2.80d-16)
  RCONST(366) = (GCARR_ac(2.88d-35,1391.0d0))
  RCONST(367) = (1.40d-12)
  RCONST(368) = (3.80d-11)
  RCONST(369) = (1.20d-15)
  RCONST(370) = (1.00d-14)
  RCONST(371) = (4.25d-12)
  RCONST(372) = (2.65d-11)
  RCONST(373) = (6.00d-18)
  RCONST(374) = (1.00d-17)
  RCONST(375) = (GCARR_ac(8.33d-13,490.0d0))
  RCONST(376) = (GCARR_ac(8.33d-13,490.0d0))
  RCONST(377) = (1.22d-11)
  RCONST(378) = (GCARR_ac(4.20d-11,401.0d0))
  RCONST(379) = (GCARR_ac(2.95d-15,-783.0d0))
  RCONST(380) = (GCARR_ac(1.21d-11,440.0d0))
  RCONST(381) = (GCARR_ac(2.7d-15,-520.0d0))
  RCONST(382) = (GCARR_ac(1.34d-11,410.0d0))
  RCONST(383) = (GCARR_ac(8.22d-16,-640.0d0))
  RCONST(384) = (GCARR_ac(2.66d-13,1300.0d0))
  RCONST(385) = (GCARR_ac(2.7d-12,360.0d0))
  RCONST(386) = (2.3d-12)
  RCONST(387) = (1.83d-11)
  RCONST(388) = (5.50d-12)
  RCONST(389) = (2.0d-14)
  RCONST(390) = (GCARR_ac(5.2d-12,600.0d0))
  RCONST(391) = (GCARR_ac(2.66d-13,1300.0d0))
  RCONST(392) = (GCARR_ac(2.7d-12,360.0d0))
  RCONST(393) = (GCJPLPR_abab(9.70d-29,5.6d+00,9.3d-12,1.5d0,0.6d0))
  RCONST(394) = (GCJPLEQ_acabab(9.30d-29,14000.0d0,9.7d-29,5.6d0,9.3d-12,1.5d0,0.6d0))
  RCONST(395) = (2.3d-12)
  RCONST(396) = (9.73d-12)
  RCONST(397) = (6.65d-12)
  RCONST(398) = (GCARR_ac(2.66d-13,1300.0d0))
  RCONST(399) = (GCARR_ac(2.7d-12,360.0d0))
  RCONST(400) = (2.3d-12)
  RCONST(401) = (GCARR_ac(3.75d-13,500.0d0))
  RCONST(402) = (2.6d-11)
  RCONST(403) = (2.88d-12)
  RCONST(404) = (GCARR_ac(2.66d-13,1300.0d0))
  RCONST(405) = (GCARR_ac(2.7d-12,360.0d0))
  RCONST(406) = (2.3d-12)
  RCONST(407) = (4.7d-12)
  RCONST(408) = (1.33d-11)
  RCONST(409) = (1.55d-11)
  RCONST(410) = (GCARR_ac(2.66d-13,1300.0d0))
  RCONST(411) = (GCARR_ac(4.32d-13,360.0d0))
  RCONST(412) = (GCARR_ac(2.27d-12,360.0d0))
  RCONST(413) = (GCARR_ac(3.75d-13,500.0d0))
  RCONST(414) = (2.3d-12)
  RCONST(415) = (8.59d-11)
  RCONST(416) = (3.24d-12)
  RCONST(417) = (GCARR_ac(2.66d-13,1300.0d0))
  RCONST(418) = (GCARR_ac(2.7d-12,360.0d0))
  RCONST(419) = (2.3d-12)
  RCONST(420) = (1.1d-10)
  RCONST(421) = (8.3d-18)
  RCONST(422) = (2.6d-13)
  RCONST(423) = (9.97d-11)
  RCONST(424) = (1.5d-16)
  RCONST(425) = (9.4d-12)
  RCONST(426) = (1.1d-10)
  RCONST(427) = (8.3d-18)
  RCONST(428) = (2.6d-13)
  RCONST(429) = (GCARR_ac(2.7d-12,360.0d0))
  RCONST(430) = (GCARR_ac(2.66d-13,1300.0d0))
  RCONST(431) = (2.3d-12)
  RCONST(432) = (GCARR_ac(3.75d-13,500.0d0))
  RCONST(433) = (3.6d-11)
  RCONST(434) = (GCARR_ac(1.22d-11,-1862.0d0))
  RCONST(435) = (6.3d-12)
  RCONST(436) = (GCARR_ac(2.66d-13,1300.0d0))
  RCONST(437) = (GCARR_ac(2.7d-12,360.0d0))
  RCONST(438) = (GCJPLPR_abab(9.70d-29,5.6d+00,9.3d-12,1.5d0,0.6d0))
  RCONST(439) = (GCJPLEQ_acabab(9.30d-29,14000.0d0,9.7d-29,5.6d0,9.3d-12,1.5d0,0.6d0))
  RCONST(440) = (2.3d-12)
  RCONST(441) = (9.73d-12)
  RCONST(442) = (6.65d-12)
  RCONST(443) = (GCARR_ac(2.66d-13,1300.0d0))
  RCONST(444) = (GCARR_ac(6.75d-13,360.0d0))
  RCONST(445) = (GCARR_ac(2.03d-12,360.0d0))
  RCONST(446) = (2.3d-12)
  RCONST(447) = (GCARR_ac(6.05d-12,440.0d0))
  RCONST(448) = (GCARR_ac(1.35d-15,-520.0d0))
  RCONST(449) = (GCARR_ac(1.06d-12,490.0d0))
  RCONST(450) = (GCARR_ac(6.05d-12,440.0d0))
  RCONST(451) = (GCARR_ac(1.35d-15,-520.0d0))
  RCONST(452) = (GCARR_ac(1.06d-12,490.0d0))
  RCONST(453) = (GCARR_ac(6.05d-12,440.0d0))
  RCONST(454) = (GCARR_ac(1.35d-15,-520.0d0))
  RCONST(455) = (GCARR_ac(1.06d-12,490.0d0))
  RCONST(456) = (GCARR_ac(3.75d-13,500.0d0))
  RCONST(457) = (GCARR_ac(1.87d-12,500.0d0))
  RCONST(458) = (GCARR_ac(3.75d-13,500.0d0))
  RCONST(459) = (GCARR_ac(1.87d-12,500.0d0))
  RCONST(460) = (GCARR_ac(3.75d-13,500.0d0))
  RCONST(461) = (GCARR_ac(1.87d-12,500.0d0))
  RCONST(462) = (GCARR_ac(3.75d-13,500.0d0))
  RCONST(463) = (GCARR_ac(1.87d-12,500.0d0))
  RCONST(464) = (GCARR_ac(1.87d-12,500.0d0))
  RCONST(465) = (GCARR_ac(3.75d-14,500.0d0))
  RCONST(466) = (GCARR_ac(1.87d-12,500.0d0))
  RCONST(467) = (GCARR_ac(3.75d-14,500.0d0))
  RCONST(468) = (4.00d-12)
  RCONST(469) = (4.00d-12)
  RCONST(470) = (GCARR_ac(1.66d-13,1300.0d0))
  RCONST(471) = (GCARR_ac(1.66d-13,1300.0d0))
  RCONST(472) = (GCARR_ac(1.60d-13,708.0d0))
  RCONST(473) = (GCARR_ac(9.68d-14,708.0d0))
  RCONST(474) = (GCARR_ac(8.85d-13,765.0d0))
  RCONST(475) = (GCARR_ac(5.37d-13,765.0d0))
  RCONST(476) = (1.20d-12)
  RCONST(477) = (1.20d-12)
  RCONST(478) = (GCARR_ac(7.00d-14,1000.0d0))
  RCONST(479) = (GCARR_ac(4.25d-14,1000.0d0))
  RCONST(480) = (GCARR_ac(2.96d-14,1000.0d0))
  RCONST(481) = (4.80d-12)
  RCONST(482) = (7.29d-11)
  RCONST(483) = (1.67d-16)
  RCONST(484) = (GCARR_ac(3.15d-13,-448.0d0))
  RCONST(485) = (GCARR_ac(3.15d-13,-448.0d0))
  RCONST(486) = (2.78d-04)
  RCONST(487) = (2.78d-04)
  RCONST(488) = (GCJPLPR_abab(3.9d-31,7.2d0,1.5d-13,4.8d0,0.6d0)+GCJPLAC_ababac(3.9d-31,7.2d0,1.5d-13,4.8d0,3.7d-14,&
                  &2.4d2,0.6d0))
  RCONST(489) = (GCARR_ac(8.00d-13,-1000.0d0))
  RCONST(490) = (GCARR_ac(1.00d-12,-490.0d0))
  RCONST(491) = (GCARR_ac(1.20d-12,-320.0d0))
  RCONST(492) = (7.10d-13)
  RCONST(493) = (GCARR_ac(1.10d-14,-2000.0d0))
  RCONST(494) = (GC_ISO1(1.7d-11,3.90d2,9.33d-2,5.05d15,-1.22d4,1.79d14,-8.830d3))
  RCONST(495) = (GC_ISO1(1.0d-11,3.90d2,2.26d-1,2.22d9,-7.160d3,1.75d14,-9.054d3))
  RCONST(496) = (GC_ISO2(1.7d-11,3.90d2,9.33d-2,5.05d15,-1.22d4,1.79d14,-8.830d3))
  RCONST(497) = (GC_ISO2(1.0d-11,3.90d2,2.26d-1,2.22d9,-7.160d3,1.75d14,-9.054d3))
  RCONST(498) = (ARRPLUS_abde(2.12d-13,-1300d0,1.1644d0,-7.0485d-4))
  RCONST(499) = (ARRPLUS_abde(2.12d-13,-1300d0,-0.1644d0,7.0485d-4))
  RCONST(500) = (ARRPLUS_abde(2.12d-13,-1300d0,1.2038d0,-9.0435d-4))
  RCONST(501) = (ARRPLUS_abde(2.12d-13,-1300d0,-0.2038d0,9.0435d-4))
  RCONST(502) = (ARRPLUS_abde(1.04d11,9.746d3,1.1644d0,-7.0485d-4))
  RCONST(503) = (TUNPLUS_abcde(5.05d15,-1.22d4,1.0d8,-0.0128d0,5.1242d-5))
  RCONST(504) = (ARRPLUS_abde(1.88d11,9.752d3,1.2038d0,-9.0435d-4))
  RCONST(505) = (TUNPLUS_abcde(2.22d9,-7.160d3,1.0d8,-0.0306d0,1.1346d-4))
  RCONST(506) = (ARRPLUS_ade(6.92d-14,1.1644d0,-7.0485d-4))
  RCONST(507) = (ARRPLUS_ade(5.74d-12,1.2038d0,-9.0435d-4))
  RCONST(508) = (ARRPLUS_ade(1.54d-12,2.3682d0,-1.6092d-3))
  RCONST(509) = (ARRPLUS_ade(2.49d-12,-0.1644d0,7.0485d-4))
  RCONST(510) = (ARRPLUS_ade(3.94d-12,-0.2038d0,9.0435d-4))
  RCONST(511) = (ARRPLUS_ade(1.54d-12,-0.3682d0,1.6092d-3))
  RCONST(512) = (ARRPLUS_ade(2.0d-12,1.1644d0,-7.0485d-4))
  RCONST(513) = (ARRPLUS_ade(2.0d-12,-0.1644d0,7.0485d-4))
  RCONST(514) = (ARRPLUS_ade(2.0d-12,1.2038d0,-9.0435d-4))
  RCONST(515) = (ARRPLUS_ade(2.0d-12,-0.2038d0,9.0435d-4))
  RCONST(516) = (GC_NIT(2.7d-12,3.50d2,1.19d0,6.0d0,1.1644d0,7.05d-4))
  RCONST(517) = (GC_ALK(2.7d-12,3.50d2,1.19d0,6.0d0,1.1644d0,7.05d-4))
  RCONST(518) = (GC_NIT(2.7d-12,3.50d2,1.421d0,6.0d0,-0.1644d0,-7.05d-4))
  RCONST(519) = (GC_ALK(2.7d-12,3.50d2,1.421d0,6.0d0,-0.1644d0,-7.05d-4))
  RCONST(520) = (GC_NIT(2.7d-12,3.50d2,1.297d0,6.0d0,1.2038d0,9.04d-4))
  RCONST(521) = (GC_ALK(2.7d-12,3.50d2,1.297d0,6.0d0,1.2038d0,9.04d-4))
  RCONST(522) = (GC_NIT(2.7d-12,3.50d2,1.421d0,6.0d0,-0.2038d0,-9.04d-4))
  RCONST(523) = (GC_ALK(2.7d-12,3.50d2,1.421d0,6.0d0,-0.2038d0,-9.04d-4))
  RCONST(524) = (GCARR_ac(1.17d-11,450.0d0))
  RCONST(525) = (GCARR_ac(1.17d-11,450.0d0))
  RCONST(526) = (GCARR_ac(2.20d-11,390.0d0))
  RCONST(527) = (GCARR_ac(3.50d-11,390.0d0))
  RCONST(528) = (GCARR_ac(4.64d-12,650.0d0))
  RCONST(529) = (GCARR_ac(9.85d-12,410.0d0))
  RCONST(530) = (GCARR_ac(3.00d-12,650.0d0))
  RCONST(531) = (GCARR_ac(2.47d-12,390.0d0))
  RCONST(532) = (GC_EPO_a(1.62d-11,3.90d2,4.77d-21))
  RCONST(533) = (GCARR_ac(4.35d-12,390.0d0))
  RCONST(534) = (GC_EPO_a(2.85d-11,390.0d0,4.77d-21))
  RCONST(535) = (GCARR_ac(6.10d-12,200.0d0))
  RCONST(536) = (GCARR_ac(4.10d-12,200.0d0))
  RCONST(537) = (GCARR_ac(3.53d-11,390.0d0))
  RCONST(538) = (GCARR_ac(3.53d-11,390.0d0))
  RCONST(539) = (GCARR_ac(1.59d+13,-10000.0d0))
  RCONST(540) = (GC_ALK(2.7d-12,3.50d2,2.1d0,9.0d0,1.0d0,0.0d0))
  RCONST(541) = (GC_NIT(2.7d-12,3.50d2,2.1d0,9.0d0,1.0d0,0.0d0))
  RCONST(542) = (GCARR_ac(2.47d-13,1300.0d0))
  RCONST(543) = (GCARR_ac(2.91d+13,-10000.0d0))
  RCONST(544) = (GC_ALK(2.7d-12,3.50d2,2.315d0,9.0d0,1.0d0,0.0d0))
  RCONST(545) = (GC_NIT(2.7d-12,3.50d2,2.315d0,9.0d0,1.0d0,0.0d0))
  RCONST(546) = (GCARR_ac(2.47d-13,1300.0d0))
  RCONST(547) = (GCARR_ac(1.875d+13,-10000.0d0))
  RCONST(548) = (GC_ALK(2.7d-12,3.50d2,3.079d0,9.0d0,1.0d0,0.0d0))
  RCONST(549) = (GC_NIT(2.7d-12,3.50d2,3.079d0,9.0d0,1.0d0,0.0d0))
  RCONST(550) = (GCARR_ac(2.47d-13,1300.0d0))
  RCONST(551) = (GCARR_ac(3.22d-11,-400.0d0))
  RCONST(552) = (GCARR_ac(1.05d-11,-400.0d0))
  RCONST(553) = (GC_EPO_a(5.82d-11,-4.00d2,1.14d-20))
  RCONST(554) = (GCARR_ac(8.25d-12,-400.0d0))
  RCONST(555) = (GC_EPO_a(3.75d-11,-4.00d2,8.91d-21))
  RCONST(556) = (GCARR_ac(1.875d+13,-10000.0d0))
  RCONST(557) = (GCARR_ac(1.0d+7,-5000.0d0))
  RCONST(558) = (GCARR_ac(2.38d-13,1300.0d0))
  RCONST(559) = (GC_ALK(2.7d-12,3.50d2,13.098d0,8.0d0,1.0d0,0.0d0))
  RCONST(560) = (GC_NIT(2.7d-12,3.50d2,13.098d0,8.0d0,1.0d0,0.0d0))
  RCONST(561) = (GCARR_ac(1.875d+13,-10000.0d0))
  RCONST(562) = (GCARR_ac(1.0d+7,-5000.0d0))
  RCONST(563) = (GC_ALK(2.7d-12,3.50d2,16.463d0,8.0d0,1.0d0,0.0d0))
  RCONST(564) = (GC_NIT(2.7d-12,3.50d2,16.463d0,8.0d0,1.0d0,0.0d0))
  RCONST(565) = (GCARR_ac(2.38d-13,1300.0d0))
  RCONST(566) = (GCARR_ac(2.38d-13,1300.0d0))
  RCONST(567) = (GC_NIT(2.7d-12,3.50d2,13.098d0,8.0d0,1.0d0,0.0d0))
  RCONST(568) = (GC_ALK(2.7d-12,3.50d2,13.098d0,8.0d0,1.0d0,0.0d0))
  RCONST(569) = (GCARR_ac(1.875d+13,-10000.0d0))
  RCONST(570) = (GCARR_ac(2.70d-12,350.0d0))
  RCONST(571) = (GCARR_ac(2.38d-13,1300.0d0))
  RCONST(572) = (GCARR_ac(2.70d-12,350.0d0))
  RCONST(573) = (GCARR_ac(2.38d-13,1300.0d0))
  RCONST(574) = (GCARR_ac(7.14d-12,390.0d0))
  RCONST(575) = (GC_EPO_a(6.30d-12,390.0d0,1.62d-19))
  RCONST(576) = (GCARR_ac(1.02d-11,390.0d0))
  RCONST(577) = (GC_EPO_a(1.05d-11,390.0d0,2.49d-19))
  RCONST(578) = (GC_EPO_a(1.55d-11,390.0d0,2.715d-19))
  RCONST(579) = (GCARR_ac(2.04d-11,390.0d0))
  RCONST(580) = (GC_EPO_a(9.52d-12,390.0d0,2.715d-19))
  RCONST(581) = (GCARR_ac(2.95d-11,390.0d0))
  RCONST(582) = (GCARR_ac(7.5d-12,20.0d0))
  RCONST(583) = (GCARR_ac(7.5d-12,20.0d0))
  RCONST(584) = (GCARR_ac(1.875d+13,-10000.0d0))
  RCONST(585) = (GCARR_ac(2.60d-13,1300.0d0))
  RCONST(586) = (GC_ALK(2.7d-12,350.0d0,6.32d0,11.0d0,1.0d0,0.0d0))
  RCONST(587) = (GC_NIT(2.7d-12,350.0d0,6.32d0,11.0d0,1.0d0,0.0d0))
  RCONST(588) = (GCARR_ac(1.875d+13,-10000.0d0))
  RCONST(589) = (GCARR_ac(2.60d-13,1300.0d0))
  RCONST(590) = (GC_ALK(2.7d-12,350.0d0,7.941d0,11.0d0,1.0d0,0.0d0))
  RCONST(591) = (GC_NIT(2.7d-12,350.0d0,7.941d0,11.0d0,1.0d0,0.0d0))
  RCONST(592) = (GCARR_ac(1.256d+13,-10000.0d0))
  RCONST(593) = (GCARR_ac(5.092d+12,-10000.0d0))
  RCONST(594) = (GCARR_ac(2.60d-13,1300.0d0))
  RCONST(595) = (GC_ALK(2.7d-12,350.0d0,4.712d0,11.0d0,1.0d0,0.0d0))
  RCONST(596) = (GC_NIT(2.7d-12,350.0d0,4.712d0,11.0d0,1.0d0,0.0d0))
  RCONST(597) = (GCARR_ac(2.60d-13,1300.0d0))
  RCONST(598) = (GC_ALK(2.7d-12,350.0d0,2.258d0,11.0d0,1.0d0,0.0d0))
  RCONST(599) = (GC_NIT(2.7d-12,350.0d0,2.258d0,11.0d0,1.0d0,0.0d0))
  RCONST(600) = (GCARR_ac(2.60d-13,1300.0d0))
  RCONST(601) = (GC_ALK(2.7d-12,350.0d0,1.851d0,11.0d0,1.0d0,0.0d0))
  RCONST(602) = (GC_NIT(2.7d-12,350.0d0,1.851d0,11.0d0,1.0d0,0.0d0))
  RCONST(603) = (GCARR_ac(2.95d-12,-450.0d0))
  RCONST(604) = (GCARR_ac(2.47d-13,1300.0d0))
  RCONST(605) = (GCARR_ac(2.47d-13,1300.0d0))
  RCONST(606) = (1.61d-12)
  RCONST(607) = (2.56d-12)
  RCONST(608) = (3.71d-12)
  RCONST(609) = (1.18d-12)
  RCONST(610) = (2.80d-13)
  RCONST(611) = (1.92d-12)
  RCONST(612) = (7.71d-12)
  RCONST(613) = (2.3d-12)
  RCONST(614) = (2.3d-12)
  RCONST(615) = (GC_ALK(2.7d-12,350.0d0,12.915d0,9.0d0,1.0d0,0.0d0))
  RCONST(616) = (GC_NIT(2.7d-12,350.0d0,12.915d0,9.0d0,1.0d0,0.0d0))
  RCONST(617) = (GC_ALK(2.7d-12,350.0d0,1.412d0,9.0d0,1.0d0,0.0d0))
  RCONST(618) = (GC_NIT(2.7d-12,350.0d0,1.412d0,9.0d0,1.0d0,0.0d0))
  RCONST(619) = (GCARR_ac(2.50d-14,-300.0d0))
  RCONST(620) = (GCARR_ac(1.00d+20,-10000.0d0))
  RCONST(621) = (GCARR_ac(5.88d-12,390.0d0))
  RCONST(622) = (GCARR_ac(1.61d-11,390.0d0))
  RCONST(623) = (GC_EPO_a(4.471d-12,390.0d0,2.28d-20))
  RCONST(624) = (GC_EPO_a(8.77d-12,390.0d0,2.185d-20))
  RCONST(625) = (GC_EPO_a(1.493d-11,390.0d0,2.715d-19))
  RCONST(626) = (GCARR_ac(2.278d-12,200.0d0))
  RCONST(627) = (GCARR_ac(3.40d-12,200.0d0))
  RCONST(628) = (GCARR_ac(7.50d-12,20.0d0))
  RCONST(629) = (GCARR_ac(6.55d+12,-10000.0d0))
  RCONST(630) = (GCARR_ac(8.72d+12,-10000.0d0))
  RCONST(631) = (GCARR_ac(2.64d-13,1300.0d0))
  RCONST(632) = (GCARR_ac(2.64d-13,1300.0d0))
  RCONST(633) = (GC_ALK(2.7d-12,350.0d0,6.092d0,12.0d0,1.0d0,0.0d0))
  RCONST(634) = (GC_NIT(2.7d-12,350.0d0,6.092d0,12.0d0,1.0d0,0.0d0))
  RCONST(635) = (GC_ALK(2.7d-12,350.0d0,4.383d0,12.0d0,1.0d0,0.0d0))
  RCONST(636) = (GC_NIT(2.7d-12,350.0d0,4.383d0,12.0d0,1.0d0,0.0d0))
  RCONST(637) = (GC_EPO_a(2.97d-12,390.0d0,2.715d-19))
  RCONST(638) = (GCARR_ac(9.35d-12,390.0d0))
  RCONST(639) = (GCARR_ac(2.70d-12,350.0d0))
  RCONST(640) = (GCARR_ac(2.54d-13,1300.0d0))
  RCONST(641) = (GCARR_ac(1.00d-11,0.0d0))
  RCONST(642) = (GCARR_ac(2.70d-12,350.0d0))
  RCONST(643) = (GCARR_ac(2.71d-13,1300.0d0))
  RCONST(644) = (GCARR_ac(2.60d-12,610.0d0))
  RCONST(645) = (GCARR_ac(8.50d-16,-1520.0d0))
  RCONST(646) = (GCARR_ac(4.40d-12,380.0d0))
  RCONST(647) = (GCARR_ac(2.70d-12,470.0d0))
  RCONST(648) = (GCARR_ac(1.50d-15,-2110.0d0))
  RCONST(649) = (GCARR_ac(1.80d-13,-1190.0d0))
  RCONST(650) = (GCARR_ac(1.24d-12,380.0d0))
  RCONST(651) = (5.77d-11)
  RCONST(652) = (GCARR_ac(2.70d-12,470.0d0))
  RCONST(653) = (GCARR_ac(1.39d-11,380.0d0))
  RCONST(654) = (GCARR_ac(2.70d-12,470.0d0))
  RCONST(655) = (GCARR_ac(2.70d-12,350.0d0))
  RCONST(656) = (GCARR_ac(1.93d-13,1300.0d0))
  RCONST(657) = (9.00d-12)
  RCONST(658) = (GCARR_ac(2.70d-12,350.0d0))
  RCONST(659) = (GCARR_ac(1.93d-13,1300.0d0))
  RCONST(660) = (9.00d-12)
  RCONST(661) = (GCARR_ac(3.71d-12,983.0d0))
  RCONST(662) = (GCARR_ac(5.00d-12,470.0d0))
  RCONST(663) = (GCARR_ac(8.70d-12,70.0d0))
  RCONST(664) = (GCARR_ac(5.00d-12,470.0d0))
  RCONST(665) = (GCARR_ac(2.00d-12,70.0d0))
  RCONST(666) = (GCARR_ac(2.4d-11,70.0d0))
  RCONST(667) = (GCARR_ac(2.12d-13,1300.0d0))
  RCONST(668) = (GC_ALK(2.7d-12,350.0d0,4.573d0,6.0d0,1.0d0,0.0d0))
  RCONST(669) = (GC_NIT(2.7d-12,350.0d0,4.573d0,6.0d0,1.0d0,0.0d0))
  RCONST(670) = (GCARR_ac(2.12d-13,1300.0d0))
  RCONST(671) = (GCARR_ac(3.14d-12,580.0d0))
  RCONST(672) = (1.66d-11)
  RCONST(673) = (GCARR_ac(2.90d+7,-5297.0d0))
  RCONST(674) = (GC_ALK(2.7d-12,350.0d0,2.985d0,6.0d0,1.0d0,0.0d0))
  RCONST(675) = (GC_NIT(2.7d-12,350.0d0,2.985d0,6.0d0,1.0d0,0.0d0))
  RCONST(676) = (GCARR_ac(8.7d-12,290.0d0))
  RCONST(677) = (GC_PAN_acac(2.591d-28,-6.87d0,1.125d-11,-1.105d0,0.3d0))
  RCONST(678) = (GCARR_ac(3.14d-12,580.0d0))
  RCONST(679) = (GCARR_ac(7.50d-12,290.0d0))
  RCONST(680) = (GC_PAN_acac(2.591d-28,-6.87d0,1.125d-11,-1.105d0,0.3d0))
  RCONST(681) = (4.00d-12)
  RCONST(682) = (GCARR_ac(2.9d-12,500.0d0))
  RCONST(683) = (GCARR_ac(1.58d+16,-13500.0d0))
  RCONST(684) = (2.90d-11)
  RCONST(685) = (4.33d-12)
  RCONST(686) = (1.00d-11)
  RCONST(687) = (2.25d-11)
  RCONST(688) = (3.00d-12)
  RCONST(689) = (3.00d-12)
  RCONST(690) = (1.00d-11)
  RCONST(691) = (3.00d-12)
  RCONST(692) = (GCARR_ac(1.40d-12,-1860.0d0))
  RCONST(693) = (8.00d-13)
  RCONST(694) = (GCARR_ac(1.30d-12,500.0d0))
  RCONST(695) = (GCARR_ac(3.14d-12,580.0d0))
  RCONST(696) = (GCARR_ac(1.55d-12,340.0d0))
  RCONST(697) = (2.91d-11)
  RCONST(698) = (GCARR_ac(1.56d-11,117.0d0))
  RCONST(699) = (GCARR_ac(1.40d-12,700.0d0))
  RCONST(700) = (GCARR_ac(2.60d-12,350.0d0))
  RCONST(701) = (1.20d-12)
  RCONST(702) = (5.8d-11)
  RCONST(703) = (1.5d-12)
  RCONST(704) = (1.7d-17)
  RCONST(705) = (7.0d-12)
  RCONST(706) = (1.2d-16)
  RCONST(707) = (3.92d-11)
  RCONST(708) = (1.4d-15)
  RCONST(709) = (GCARR_ac(2.7d-12,360.0d0))
  RCONST(710) = (GCARR_ac(1.5d-13,1310.0d0))
  RCONST(711) = (7.16d-11)
  RCONST(712) = (GCARR_ac(1.20d-14,-2630.0d0))
  RCONST(713) = (GCJPLPR_abab(1.10d-28,3.5d+00,8.4d-12,1.75d0,0.5d0))
  RCONST(714) = (GCJPLPR_abab(5.50d-30,0.0d0,8.3d-13,-2.0d0,0.5d0))
  RCONST(715) = (GCARR_ac(1.53d-13,1300.0d0))
  RCONST(716) = (GCARR_ac(2.7d-12,360.0d0))
  RCONST(717) = (2.3d-12)
  RCONST(718) = (6.00d-13)
  RCONST(719) = (GCARR_ac(9.5d+13,-5988.0d0))
  RCONST(720) = (GCARR_ac(2.5d-14,-300.0d0))
  RCONST(721) = (8.40d-13)
  RCONST(722) = (GCARR_ac(1.90d-12,190.0d0))
  RCONST(723) = (1.38d-11)
  RCONST(724) = (GCARR_ac(2.3d-12,-193.0d0))
  RCONST(725) = (GCARR_ac(1.8d-12,340.0d0))
  RCONST(726) = (1.7d-11)
  RCONST(727) = (2.91d-13*EXP(1300.0d0/TEMP)*0.82d0)
  RCONST(728) = (GCARR_ac(2.60d-12,365.0d0))
  RCONST(729) = (2.30d-12)
  RCONST(730) = (GCARR_ac(1.70d-14,220.0d0))
  RCONST(731) = (GCARR_ac(4.20d-14,220.0d0))
  RCONST(732) = (6.9d-11)
  RCONST(733) = (GCARR_abc(2.7d-12,0.0d0,360.0d0))
  RCONST(734) = (GCARR_abc(2.05d-13,0.0d0,1300.0d0))
! RCONST(735) = constant rate coefficient
  RCONST(736) = (GCARR_abc(7.50d-12,0.0d0,290.0d0))
  RCONST(737) = (GCARR_abc(5.20d-13,0.0d0,980.0d0))
  RCONST(738) = (GC_PAN_acac(3.28d-28,-6.87d0,1.125d-11,-1.105d0,0.3d0))
  RCONST(739) = (GC_PAN_abab(1.10d-5,-10100.0d0,1.90d+17,-14100.0d0,0.3d0)*0.67d0)
  RCONST(740) = (1.0d-14)
  RCONST(741) = (GCARR_ac(4.70d-13,1220.0d0))
  RCONST(742) = (3.8d-12)
  RCONST(743) = (4.7d-11)
  RCONST(744) = (1.4d-11)
  RCONST(745) = (2.0d-11)
  RCONST(746) = (9.2d-18)
  RCONST(747) = (9.9d-11)
  RCONST(748) = (GCARR_ac(5.90d-12,225.0d0))
  RCONST(749) = (2.4d-15)
  RCONST(750) = (GCARR_ac(1.10d-11,340.0d0))
  RCONST(751) = (GCARR_ac(7.50d-12,290.0d0))
  RCONST(752) = (GC_PAN_acac(3.28d-28,-6.87d0,1.125d-11,-1.105d0,0.3d0))
  RCONST(753) = (4.66d-12)
  RCONST(754) = (GC_PAN_abab(1.10d-5,-10100.0d0,1.90d+17,-14100.0d0,0.3d0)*0.67d0)
  RCONST(755) = (1.06d-12)
  RCONST(756) = (7.00d-12)
  RCONST(757) = (GCARR_ac(2.670d-12,365.0d0))
  RCONST(758) = (2.30d-12)
  RCONST(759) = (GCARR_ac(2.24d-13,1300.0d0))
  RCONST(760) = (3.60d-12)
  RCONST(761) = (2.86d-13)
  RCONST(762) = (2.08d-12)
  RCONST(763) = (3.47d-12)
  RCONST(764) = (2.60d-12)
  RCONST(765) = (GCARR_ac(2.670d-13,365.0d0))
  RCONST(766) = (GCARR_ac(2.670d-12,365.0d0))
  RCONST(767) = (5.0d-11)
  RCONST(768) = (8.0d-16)
  RCONST(769) = (1.5d-3)
  RCONST(770) = (5.0d-11)
  RCONST(771) = (8.0d-16)
  RCONST(772) = (1.5d-3)
  RCONST(773) = (GCARR_ac(1.40d-12,700.0d0))
  RCONST(774) = (GCARR_ac(2.60d-12,350.0d0))
  RCONST(775) = (GCARR_ac(1.40d-12,700.0d0))
  RCONST(776) = (GCARR_ac(2.60d-12,350.0d0))
  RCONST(777) = (GCARR_ac(1.40d-12,700.0d0))
  RCONST(778) = (GCARR_ac(2.60d-12,350.0d0))
  RCONST(779) = (1.20d-12)
  RCONST(780) = (GCARR_ac(1.32d-11,334.0d0))
  RCONST(781) = (HO2uptk1stOrd(State_Het))
  RCONST(782) = (NO2uptk1stOrdAndCloud(State_Het))
  RCONST(783) = (NO3uptk1stOrdAndCloud(State_Het))
  RCONST(784) = (NO3hypsisClonSALA(State_Het))
  RCONST(785) = (NO3hypsisClonSALC(State_Het))
  RCONST(786) = (N2O5uptkByH2O(State_Het))
  RCONST(787) = (N2O5uptkByStratHCl(State_Het))
  RCONST(788) = (N2O5uptkByCloud(State_Het))
  RCONST(789) = (N2O5uptkBySALACl(State_Het))
  RCONST(790) = (N2O5uptkBySALCCl(State_Het))
  RCONST(791) = (OHuptkBySALACl(State_Het))
  RCONST(792) = (OHuptkBySALCCl(State_Het))
  RCONST(793) = (BrNO3uptkByH2O(State_Het))
  RCONST(794) = (BrNO3uptkByHCl(State_Het))
  RCONST(795) = (ClNO3uptkByH2O(State_Het))
  RCONST(796) = (ClNO3uptkByHCl(State_Het))
  RCONST(797) = (ClNO3uptkByHBr(State_Het))
  RCONST(798) = (ClNO3uptkByBrSALA(State_Het))
  RCONST(799) = (ClNO3uptkByBrSALC(State_Het))
  RCONST(800) = (ClNO3uptkBySALACL(State_Het))
  RCONST(801) = (ClNO3uptkBySALCCL(State_Het))
  RCONST(802) = (ClNO2uptkBySALACL(State_Het))
  RCONST(803) = (ClNO2uptkBySALCCL(State_Het))
  RCONST(804) = (ClNO2uptkByHCl(State_Het))
  RCONST(805) = (ClNO2uptkByBrSALA(State_Het))
  RCONST(806) = (ClNO2uptkByBrSALC(State_Het))
  RCONST(807) = (ClNO2uptkByHBr(State_Het))
  RCONST(808) = (HOClUptkByHCl(State_Het))
  RCONST(809) = (HOClUptkByHBr(State_Het))
  RCONST(810) = (HOClUptkBySALACL(State_Het))
  RCONST(811) = (HOClUptkBySALCCL(State_Het))
  RCONST(812) = (HOClUptkByHSO3m(State_Het)+HOClUptkBySO3mm(State_Het)+SRHOCl)
  RCONST(813) = (HOBrUptkByHBr(State_Het))
  RCONST(814) = (HOBrUptkByHCl(State_Het))
  RCONST(815) = (HOBrUptkBySALACL(State_Het))
  RCONST(816) = (HOBrUptkBySALCCL(State_Het))
  RCONST(817) = (HOBrUptkByBrSALA(State_Het))
  RCONST(818) = (HOBrUptkByBrSALC(State_Het))
  RCONST(819) = (HOBrUptkByHSO3m(State_Het)+HOBrUptkBySO3mm(State_Het)+SRHOBr)
  RCONST(820) = (O3uptkByHBr(State_Het))
  RCONST(821) = (O3uptkByBrSALA(State_Het))
  RCONST(822) = (O3uptkByBrSALC(State_Het))
  RCONST(823) = (HBrUptkBySALA(State_Het))
  RCONST(824) = (HBrUptkBySALC(State_Het))
  RCONST(825) = (IuptkBySulf1stOrd(SR_MW(ind_HI),0.10_dp,State_Het))
  RCONST(826) = (IuptkBySALA1stOrd(SR_MW(ind_HI),0.10_dp,State_Het))
  RCONST(827) = (IuptkBySALC1stOrd(SR_MW(ind_HI),0.10_dp,State_Het))
  RCONST(828) = (IuptkByAlkSALA1stOrd(SR_MW(ind_HOI),0.01_dp,State_Het))
  RCONST(829) = (IuptkByAlkSALC1stOrd(SR_MW(ind_HOI),0.01_dp,State_Het))
  RCONST(830) = (IuptkBySulf1stOrd(SR_MW(ind_I2O2),0.02_dp,State_Het))
  RCONST(831) = (IuptkBySALA1stOrd(SR_MW(ind_I2O2),0.02_dp,State_Het))
  RCONST(832) = (IuptkBySALC1stOrd(SR_MW(ind_I2O2),0.02_dp,State_Het))
  RCONST(833) = (IuptkBySulf1stOrd(SR_MW(ind_I2O3),0.02_dp,State_Het))
  RCONST(834) = (IuptkBySALA1stOrd(SR_MW(ind_I2O3),0.02_dp,State_Het))
  RCONST(835) = (IuptkBySALC1stOrd(SR_MW(ind_I2O3),0.02_dp,State_Het))
  RCONST(836) = (IuptkBySulf1stOrd(SR_MW(ind_I2O4),0.02_dp,State_Het))
  RCONST(837) = (IuptkBySALA1stOrd(SR_MW(ind_I2O4),0.02_dp,State_Het))
  RCONST(838) = (IuptkBySALC1stOrd(SR_MW(ind_I2O4),0.02_dp,State_Het))
  RCONST(839) = (IuptkByAlkSALA1stOrd(SR_MW(ind_IONO),0.02_dp,State_Het))
  RCONST(840) = (IuptkByAlkSALC1stOrd(SR_MW(ind_IONO),0.02_dp,State_Het))
  RCONST(841) = (IuptkByAlkSALA1stOrd(SR_MW(ind_IONO2),0.01_dp,State_Het))
  RCONST(842) = (IuptkByAlkSALC1stOrd(SR_MW(ind_IONO2),0.01_dp,State_Het))
  RCONST(843) = (IONO2uptkByH2O(State_Het))
  RCONST(844) = (IbrkdnByAcidBrSALA(SR_MW(ind_IONO),C(ind_IONO),0.02_dp,State_Het))
  RCONST(845) = (IbrkdnByAcidBrSALC(SR_MW(ind_IONO),C(ind_IONO),0.02_dp,State_Het))
  RCONST(846) = (IbrkdnByAcidSALACl(SR_MW(ind_IONO),C(ind_IONO),0.02_dp,State_Het))
  RCONST(847) = (IbrkdnByAcidSALCCl(SR_MW(ind_IONO),C(ind_IONO),0.02_dp,State_Het))
  RCONST(848) = (IbrkdnByAcidBrSALA(SR_MW(ind_IONO2),C(ind_IONO2),0.01_dp,State_Het))
  RCONST(849) = (IbrkdnByAcidBrSALC(SR_MW(ind_IONO2),C(ind_IONO2),0.01_dp,State_Het))
  RCONST(850) = (IbrkdnByAcidSALACl(SR_MW(ind_IONO2),C(ind_IONO2),0.01_dp,State_Het))
  RCONST(851) = (IbrkdnByAcidSALCCl(SR_MW(ind_IONO2),C(ind_IONO2),0.01_dp,State_Het))
  RCONST(852) = (IbrkdnByAcidBrSALA(SR_MW(ind_HOI),C(ind_HOI),0.01_dp,State_Het))
  RCONST(853) = (IbrkdnByAcidBrSALC(SR_MW(ind_HOI),C(ind_HOI),0.01_dp,State_Het))
  RCONST(854) = (IbrkdnByAcidSALACl(SR_MW(ind_HOI),C(ind_HOI),0.01_dp,State_Het))
  RCONST(855) = (IbrkdnByAcidSALCCl(SR_MW(ind_HOI),C(ind_HOI),0.01_dp,State_Het))
  RCONST(856) = (GLYXuptk1stOrd(SR_MW(ind_GLYX),State_Het))
  RCONST(857) = (MGLYuptk1stOrd(SR_MW(ind_MGLY),State_Het))
  RCONST(858) = (IEPOXuptk1stOrd(SR_MW(ind_IEPOXA),.FALSE.,State_Het))
  RCONST(859) = (IEPOXuptk1stOrd(SR_MW(ind_IEPOXB),.FALSE.,State_Het))
  RCONST(860) = (IEPOXuptk1stOrd(SR_MW(ind_IEPOXD),.FALSE.,State_Het))
  RCONST(861) = (VOCuptk1stOrd(SR_MW(ind_LVOC),1.0_dp,State_Het))
  RCONST(862) = (VOCuptk1stOrd(SR_MW(ind_MVKN),5.0E-3_dp,State_Het))
  RCONST(863) = (VOCuptk1stOrd(SR_MW(ind_R4N2),5.0E-3_dp,State_Het))
  RCONST(864) = (VOCuptk1stOrd(SR_MW(ind_MONITS),1.0E-2_dp,State_Het))
  RCONST(865) = (VOCuptk1stOrd(SR_MW(ind_MONITU),1.0E-2_dp,State_Het))
  RCONST(866) = (VOCuptk1stOrd(SR_MW(ind_HONIT),1.0E-2_dp,State_Het))
  RCONST(867) = (MGLYuptk1stOrd(SR_MW(ind_PYAC),State_Het))
  RCONST(868) = (IEPOXuptk1stOrd(SR_MW(ind_HMML),.TRUE.,State_Het))
  RCONST(869) = (VOCuptk1stOrd(SR_MW(ind_IHN1),5.0E-3_dp,State_Het))
  RCONST(870) = (VOCuptk1stOrd(SR_MW(ind_IHN2),5.0E-2_dp,State_Het))
  RCONST(871) = (VOCuptk1stOrd(SR_MW(ind_IHN3),5.0E-3_dp,State_Het))
  RCONST(872) = (VOCuptk1stOrd(SR_MW(ind_IHN4),5.0E-3_dp,State_Het))
  RCONST(873) = (IEPOXuptk1stOrd(SR_MW(ind_ICHE),.FALSE.,State_Het))
  RCONST(874) = (VOCuptk1stOrd(SR_MW(ind_INPD),5.0E-3_dp,State_Het))
  RCONST(875) = (VOCuptk1stOrd(SR_MW(ind_INPB),5.0E-3_dp,State_Het))
  RCONST(876) = (VOCuptk1stOrd(SR_MW(ind_IDN),5.0E-3_dp,State_Het))
  RCONST(877) = (VOCuptk1stOrd(SR_MW(ind_ITCN),5.0E-3_dp,State_Het))
  RCONST(878) = (VOCuptk1stOrd(SR_MW(ind_ITHN),5.0E-3_dp,State_Het))
  RCONST(879) = (VOCuptk1stOrd(SR_MW(ind_MCRHNB),5.0E-3_dp,State_Het))
  RCONST(880) = (VOCuptk1stOrd(SR_MW(ind_MCRHN),5.0E-3_dp,State_Het))
  RCONST(881) = (VOCuptk1stOrd(SR_MW(ind_NPHEN),1.0E-2_dp,State_Het))
  RCONST(882) = (PHOTOL(2))
  RCONST(883) = (PHOTOL(3))
  RCONST(884) = (PHOTOL(1))
  RCONST(885) = (PHOTOL(11))
  RCONST(886) = (PHOTOL(9))
  RCONST(887) = (PHOTOL(10))
  RCONST(888) = (PHOTOL(7))
  RCONST(889) = (PHOTOL(8))
  RCONST(890) = (PHOTOL(16))
  RCONST(891) = (PHOTOL(15))
  RCONST(892) = (PHOTOL(17))
  RCONST(893) = (PHOTOL(18))
  RCONST(894) = (PHOTOL(12))
  RCONST(895) = (PHOTOL(13))
  RCONST(896) = (PHOTOL(14))
  RCONST(897) = (PHOTOL(61))
  RCONST(898) = (PHOTOL(62))
  RCONST(899) = (PHOTOL(59))
  RCONST(900) = (PHOTOL(59))
  RCONST(901) = (PHOTOL(66))
  RCONST(902) = (PHOTOL(70))
  RCONST(903) = (PHOTOL(70))
  RCONST(904) = (PHOTOL(76))
  RCONST(905) = (PHOTOL(77))
  RCONST(906) = (PHOTOL(69))
  RCONST(907) = (PHOTOL(68))
  RCONST(908) = (PHOTOL(72))
  RCONST(909) = (PHOTOL(73))
  RCONST(910) = (PHOTOL(74))
  RCONST(911) = (PHOTOL(71))
  RCONST(912) = (PHOTOL(63))
  RCONST(913) = (PHOTOL(64))
  RCONST(914) = (PHOTOL(65))
  RCONST(915) = (PHOTOL(66))
  RCONST(916) = (PHOTOL(75))
  RCONST(917) = (PHOTOL(79))
  RCONST(918) = (PHOTOL(80))
  RCONST(919) = (PHOTOL(81))
  RCONST(920) = (PHOTOL(82))
  RCONST(921) = (PHOTOL(83))
  RCONST(922) = (PHOTOL(83))
  RCONST(923) = (PHOTOL(83))
  RCONST(924) = (PHOTOL(84))
  RCONST(925) = (PHOTOL(85))
  RCONST(926) = (PHOTOL(98))
  RCONST(927) = (PHOTOL(98))
  RCONST(928) = (PHOTOL(98))
  RCONST(929) = (PHOTOL(98))
  RCONST(930) = (PHOTOL(99))
  RCONST(931) = (PHOTOL(23))
  RCONST(932) = (PHOTOL(28))
  RCONST(933) = (PHOTOL(32))
  RCONST(934) = (PHOTOL(29))
  RCONST(935) = (PHOTOL(30))
  RCONST(936) = (PHOTOL(31))
  RCONST(937) = (PHOTOL(56))
  RCONST(938) = (PHOTOL(55))
  RCONST(939) = (PHOTOL(50))
  RCONST(940) = (PHOTOL(43))
  RCONST(941) = (PHOTOL(45))
  RCONST(942) = (PHOTOL(33))
  RCONST(943) = (PHOTOL(22))
  RCONST(944) = (PHOTOL(27))
  RCONST(945) = (PHOTOL(25))
  RCONST(946) = (PHOTOL(26))
  RCONST(947) = (PHOTOL(21))
  RCONST(948) = (PHOTOL(19))
  RCONST(949) = (PHOTOL(20))
  RCONST(950) = (PHOTOL(24))
  RCONST(951) = (PHOTOL(44))
  RCONST(952) = (PHOTOL(42))
  RCONST(953) = (PHOTOL(37))
  RCONST(954) = (PHOTOL(38))
  RCONST(955) = (PHOTOL(39))
  RCONST(956) = (PHOTOL(40))
  RCONST(957) = (PHOTOL(41))
  RCONST(958) = (PHOTOL(47))
  RCONST(959) = (PHOTOL(48))
  RCONST(960) = (PHOTOL(49))
  RCONST(961) = (PHOTOL(46))
  RCONST(962) = (PHOTOL(53))
  RCONST(963) = (PHOTOL(51))
  RCONST(964) = (PHOTOL(54))
  RCONST(965) = (PHOTOL(101))
  RCONST(966) = (PHOTOL(114))
  RCONST(967) = (PHOTOL(115))
  RCONST(968) = (PHOTOL(116))
  RCONST(969) = (PHOTOL(117))
  RCONST(970) = (PHOTOL(118))
  RCONST(971) = (PHOTOL(119))
  RCONST(972) = (PHOTOL(120))
  RCONST(973) = (PHOTOL(121))
  RCONST(974) = (PHOTOL(122))
  RCONST(975) = (PHOTOL(123))
  RCONST(976) = (PHOTOL(124))
  RCONST(977) = (PHOTOL(125))
  RCONST(978) = (PHOTOL(126))
  RCONST(979) = (PHOTOL(127))
  RCONST(980) = (PHOTOL(128))
  RCONST(981) = (PHOTOL(129))
  RCONST(982) = (PHOTOL(103))
  RCONST(983) = (PHOTOL(104))
  RCONST(984) = (PHOTOL(97))
  RCONST(985) = (PHOTOL(36))
  RCONST(986) = (PHOTOL(34))
  RCONST(987) = (PHOTOL(100))
  RCONST(988) = (PHOTOL(6))
  RCONST(989) = (PHOTOL(105))
  RCONST(990) = (PHOTOL(107))
  RCONST(991) = (PHOTOL(111))
  RCONST(992) = (PHOTOL(112))
  RCONST(993) = (PHOTOL(113))
  RCONST(994) = (PHOTOL(130))
  RCONST(995) = (PHOTOL(131))
  RCONST(996) = (PHOTOL(132))
  RCONST(997) = (PHOTOL(133))
  RCONST(998) = (PHOTOL(134))
  RCONST(999) = (PHOTOL(135))
  RCONST(1000) = (PHOTOL(136))
  RCONST(1001) = (PHOTOL(137))
  RCONST(1002) = (PHOTOL(86))
  RCONST(1003) = (PHOTOL(87))
  RCONST(1004) = (PHOTOL(88))
  RCONST(1005) = (PHOTOL(89))
  RCONST(1006) = (PHOTOL(90))
  RCONST(1007) = (PHOTOL(91))
  RCONST(1008) = (PHOTOL(92))
  RCONST(1009) = (PHOTOL(93))
  RCONST(1010) = (PHOTOL(94))
  RCONST(1011) = (PHOTOL(95))
  RCONST(1012) = (PHOTOL(96))
  RCONST(1013) = (PHOTOL(108))
  RCONST(1014) = (PHOTOL(109))
  RCONST(1015) = (PHOTOL(110))
  RCONST(1016) = (PHOTOL(138))
  RCONST(1017) = (PHOTOL(139))
  RCONST(1018) = (PHOTOL(140))
  RCONST(1019) = (PHOTOL(141))
  RCONST(1020) = (PHOTOL(142))
  RCONST(1021) = (PHOTOL(143))
  RCONST(1022) = (PHOTOL(144))
  RCONST(1023) = (PHOTOL(145))
  RCONST(1024) = (PHOTOL(146))
  RCONST(1025) = (PHOTOL(147))
  RCONST(1026) = (PHOTOL(148))
  RCONST(1027) = (PHOTOL(149))
  RCONST(1028) = (PHOTOL(150))
  RCONST(1029) = (PHOTOL(151))
  RCONST(1030) = (PHOTOL(152))
  RCONST(1031) = (PHOTOL(106))
  RCONST(1032) = (PHOTOL(78))
  RCONST(1033) = (PHOTOL(153))
  RCONST(1034) = (PHOTOL(154))
  RCONST(1035) = (PHOTOL(155))
  RCONST(1036) = (PHOTOL(156))
  RCONST(1037) = (PHOTOL(157))
  RCONST(1038) = (PHOTOL(158))
  RCONST(1039) = (PHOTOL(159))
  RCONST(1040) = (PHOTOL(160))
  RCONST(1041) = (PHOTOL(161))
  RCONST(1042) = (PHOTOL(162))
  RCONST(1043) = (PHOTOL(163))
  RCONST(1044) = (PHOTOL(164))
  RCONST(1045) = (PHOTOL(165))
  RCONST(1046) = (PHOTOL(166))
  RCONST(1047) = (PHOTOL(167))
  RCONST(1048) = (PHOTOL(168))
  RCONST(1049) = (PHOTOL(169))
  RCONST(1050) = (PHOTOL(170))
  RCONST(1051) = (PHOTOL(171))
  RCONST(1052) = (PHOTOL(172))
  RCONST(1053) = (PHOTOL(173))
  RCONST(1054) = (PHOTOL(174))
  RCONST(1055) = (PHOTOL(175))
  RCONST(1056) = (PHOTOL(176))
  RCONST(1057) = (PHOTOL(105))
  RCONST(1058) = (PHOTOL(177))
      
END SUBROUTINE Update_RCONST

! End of Update_RCONST function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Update_PHOTO - function to update photolytical rate constants
!   Arguments :
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE Update_PHOTO ( )



! Begin INLINED RCONST


  ! Inline an include file containing rate law definitions, which
  ! will be inserted directly into subroutine Update_Rconst().
  ! This is necessary as a workaround for KPP not being able to
  ! include very large files ( > 200000 chars) directly.
  !  -- Bob Yantosca (11 Jun 2021)
  USE fullchem_RateLawFuncs

! End INLINED RCONST

  RCONST(882) = (PHOTOL(2))
  RCONST(883) = (PHOTOL(3))
  RCONST(884) = (PHOTOL(1))
  RCONST(885) = (PHOTOL(11))
  RCONST(886) = (PHOTOL(9))
  RCONST(887) = (PHOTOL(10))
  RCONST(888) = (PHOTOL(7))
  RCONST(889) = (PHOTOL(8))
  RCONST(890) = (PHOTOL(16))
  RCONST(891) = (PHOTOL(15))
  RCONST(892) = (PHOTOL(17))
  RCONST(893) = (PHOTOL(18))
  RCONST(894) = (PHOTOL(12))
  RCONST(895) = (PHOTOL(13))
  RCONST(896) = (PHOTOL(14))
  RCONST(897) = (PHOTOL(61))
  RCONST(898) = (PHOTOL(62))
  RCONST(899) = (PHOTOL(59))
  RCONST(900) = (PHOTOL(59))
  RCONST(901) = (PHOTOL(66))
  RCONST(902) = (PHOTOL(70))
  RCONST(903) = (PHOTOL(70))
  RCONST(904) = (PHOTOL(76))
  RCONST(905) = (PHOTOL(77))
  RCONST(906) = (PHOTOL(69))
  RCONST(907) = (PHOTOL(68))
  RCONST(908) = (PHOTOL(72))
  RCONST(909) = (PHOTOL(73))
  RCONST(910) = (PHOTOL(74))
  RCONST(911) = (PHOTOL(71))
  RCONST(912) = (PHOTOL(63))
  RCONST(913) = (PHOTOL(64))
  RCONST(914) = (PHOTOL(65))
  RCONST(915) = (PHOTOL(66))
  RCONST(916) = (PHOTOL(75))
  RCONST(917) = (PHOTOL(79))
  RCONST(918) = (PHOTOL(80))
  RCONST(919) = (PHOTOL(81))
  RCONST(920) = (PHOTOL(82))
  RCONST(921) = (PHOTOL(83))
  RCONST(922) = (PHOTOL(83))
  RCONST(923) = (PHOTOL(83))
  RCONST(924) = (PHOTOL(84))
  RCONST(925) = (PHOTOL(85))
  RCONST(926) = (PHOTOL(98))
  RCONST(927) = (PHOTOL(98))
  RCONST(928) = (PHOTOL(98))
  RCONST(929) = (PHOTOL(98))
  RCONST(930) = (PHOTOL(99))
  RCONST(931) = (PHOTOL(23))
  RCONST(932) = (PHOTOL(28))
  RCONST(933) = (PHOTOL(32))
  RCONST(934) = (PHOTOL(29))
  RCONST(935) = (PHOTOL(30))
  RCONST(936) = (PHOTOL(31))
  RCONST(937) = (PHOTOL(56))
  RCONST(938) = (PHOTOL(55))
  RCONST(939) = (PHOTOL(50))
  RCONST(940) = (PHOTOL(43))
  RCONST(941) = (PHOTOL(45))
  RCONST(942) = (PHOTOL(33))
  RCONST(943) = (PHOTOL(22))
  RCONST(944) = (PHOTOL(27))
  RCONST(945) = (PHOTOL(25))
  RCONST(946) = (PHOTOL(26))
  RCONST(947) = (PHOTOL(21))
  RCONST(948) = (PHOTOL(19))
  RCONST(949) = (PHOTOL(20))
  RCONST(950) = (PHOTOL(24))
  RCONST(951) = (PHOTOL(44))
  RCONST(952) = (PHOTOL(42))
  RCONST(953) = (PHOTOL(37))
  RCONST(954) = (PHOTOL(38))
  RCONST(955) = (PHOTOL(39))
  RCONST(956) = (PHOTOL(40))
  RCONST(957) = (PHOTOL(41))
  RCONST(958) = (PHOTOL(47))
  RCONST(959) = (PHOTOL(48))
  RCONST(960) = (PHOTOL(49))
  RCONST(961) = (PHOTOL(46))
  RCONST(962) = (PHOTOL(53))
  RCONST(963) = (PHOTOL(51))
  RCONST(964) = (PHOTOL(54))
  RCONST(965) = (PHOTOL(101))
  RCONST(966) = (PHOTOL(114))
  RCONST(967) = (PHOTOL(115))
  RCONST(968) = (PHOTOL(116))
  RCONST(969) = (PHOTOL(117))
  RCONST(970) = (PHOTOL(118))
  RCONST(971) = (PHOTOL(119))
  RCONST(972) = (PHOTOL(120))
  RCONST(973) = (PHOTOL(121))
  RCONST(974) = (PHOTOL(122))
  RCONST(975) = (PHOTOL(123))
  RCONST(976) = (PHOTOL(124))
  RCONST(977) = (PHOTOL(125))
  RCONST(978) = (PHOTOL(126))
  RCONST(979) = (PHOTOL(127))
  RCONST(980) = (PHOTOL(128))
  RCONST(981) = (PHOTOL(129))
  RCONST(982) = (PHOTOL(103))
  RCONST(983) = (PHOTOL(104))
  RCONST(984) = (PHOTOL(97))
  RCONST(985) = (PHOTOL(36))
  RCONST(986) = (PHOTOL(34))
  RCONST(987) = (PHOTOL(100))
  RCONST(988) = (PHOTOL(6))
  RCONST(989) = (PHOTOL(105))
  RCONST(990) = (PHOTOL(107))
  RCONST(991) = (PHOTOL(111))
  RCONST(992) = (PHOTOL(112))
  RCONST(993) = (PHOTOL(113))
  RCONST(994) = (PHOTOL(130))
  RCONST(995) = (PHOTOL(131))
  RCONST(996) = (PHOTOL(132))
  RCONST(997) = (PHOTOL(133))
  RCONST(998) = (PHOTOL(134))
  RCONST(999) = (PHOTOL(135))
  RCONST(1000) = (PHOTOL(136))
  RCONST(1001) = (PHOTOL(137))
  RCONST(1002) = (PHOTOL(86))
  RCONST(1003) = (PHOTOL(87))
  RCONST(1004) = (PHOTOL(88))
  RCONST(1005) = (PHOTOL(89))
  RCONST(1006) = (PHOTOL(90))
  RCONST(1007) = (PHOTOL(91))
  RCONST(1008) = (PHOTOL(92))
  RCONST(1009) = (PHOTOL(93))
  RCONST(1010) = (PHOTOL(94))
  RCONST(1011) = (PHOTOL(95))
  RCONST(1012) = (PHOTOL(96))
  RCONST(1013) = (PHOTOL(108))
  RCONST(1014) = (PHOTOL(109))
  RCONST(1015) = (PHOTOL(110))
  RCONST(1016) = (PHOTOL(138))
  RCONST(1017) = (PHOTOL(139))
  RCONST(1018) = (PHOTOL(140))
  RCONST(1019) = (PHOTOL(141))
  RCONST(1020) = (PHOTOL(142))
  RCONST(1021) = (PHOTOL(143))
  RCONST(1022) = (PHOTOL(144))
  RCONST(1023) = (PHOTOL(145))
  RCONST(1024) = (PHOTOL(146))
  RCONST(1025) = (PHOTOL(147))
  RCONST(1026) = (PHOTOL(148))
  RCONST(1027) = (PHOTOL(149))
  RCONST(1028) = (PHOTOL(150))
  RCONST(1029) = (PHOTOL(151))
  RCONST(1030) = (PHOTOL(152))
  RCONST(1031) = (PHOTOL(106))
  RCONST(1032) = (PHOTOL(78))
  RCONST(1033) = (PHOTOL(153))
  RCONST(1034) = (PHOTOL(154))
  RCONST(1035) = (PHOTOL(155))
  RCONST(1036) = (PHOTOL(156))
  RCONST(1037) = (PHOTOL(157))
  RCONST(1038) = (PHOTOL(158))
  RCONST(1039) = (PHOTOL(159))
  RCONST(1040) = (PHOTOL(160))
  RCONST(1041) = (PHOTOL(161))
  RCONST(1042) = (PHOTOL(162))
  RCONST(1043) = (PHOTOL(163))
  RCONST(1044) = (PHOTOL(164))
  RCONST(1045) = (PHOTOL(165))
  RCONST(1046) = (PHOTOL(166))
  RCONST(1047) = (PHOTOL(167))
  RCONST(1048) = (PHOTOL(168))
  RCONST(1049) = (PHOTOL(169))
  RCONST(1050) = (PHOTOL(170))
  RCONST(1051) = (PHOTOL(171))
  RCONST(1052) = (PHOTOL(172))
  RCONST(1053) = (PHOTOL(173))
  RCONST(1054) = (PHOTOL(174))
  RCONST(1055) = (PHOTOL(175))
  RCONST(1056) = (PHOTOL(176))
  RCONST(1057) = (PHOTOL(105))
  RCONST(1058) = (PHOTOL(177))
      
END SUBROUTINE Update_PHOTO

! End of Update_PHOTO function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



END MODULE gckpp_Rates

