# KPP/fullchem -- folder for the default GEOS-Chem mechanism

This folder contains the files that define the full-chemistry
mechanism (NOx-Ox-VOCs-Br-Cl-I) for GEOS-Chem.

## User-modifiable configuration files

  1. **fullchem.kpp**: Master KPP specification file.

  2. **fullchem.eqn**: KPP equation file, contains reaction definitoins.

  3. **fullchem_HetStateFuncs.F90**: This module contains functions
     that initialize the HetChem state object.

  4. **fullchem_SulfurChemFuncs.F90**: This module contains routines
     that compute rates for SO2 reactions in cloud.

  5. **fullchem_RateLawFuncs.F90**: This module contains functions
	 that compute rates for heterogenous chemistry reactions.  This is
	 the so-called "rate law library" for the fullchem mechanism.

  6. **rateLawUtilFuncs.F90**: This module contains several utility
     functions for heterogeneous chemistry reactions.

  7, **commonIncludeVars.H**: Global variables that are used for all
      KPP mechanisms.  These will be inlined into the KPP-generated
      **gckpp_Global.F90** file.

The following files link to the KPP/stubs folder.  These include stub
subroutines that are used by other chemical mechanisms.  The stubs are
needed in order to avoid compilation errors.

  1. **stub_aciduptake_DustChemFuncs.F90** Stub routines corresponding
     to the KPP/aciduptake/aciduptake_DustChemFuncs.F90 module,

  2. **stub_Hg_HetStateFuncs.F90**: Stub routines corresponding
     to the KPP/Hg/Hg_HetStateFuncs.F90 module.

## Files generated by KPP

With the exception of the symbolic link **gckpp.kpp**, and the map
file **gckpp.map**, all files starting with the prefix **gckpp_** are
generated by KPP.  These contain the specifications of the chemical
mechanism in efficient source code.

For more information, please see:

  1. KPP documentation at: https://kpp.readthedocs.io

  2. [Guide to Using KPP with GEOS-Chem](https://geos-chem.readthedocs.io/en/latest/geos-chem-shared-docs/supplemental-guides/using-kpp-with-gc.html)
