! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Parameter Module File
! 
! Generated by KPP-3.1.1 symbolic chemistry Kinetics PreProcessor
!       (https:/github.com/KineticPreProcessor/KPP
! KPP is distributed under GPL, the general public licence
!       (http://www.gnu.org/copyleft/gpl.html)
! (C) 1995-1997, V. Damian & A. Sandu, CGRER, Univ. Iowa
! (C) 1997-2022, A. Sandu, Michigan Tech, Virginia Tech
!     With important contributions from:
!        M. Damian,   Villanova University, Philadelphia, PA, USA
!        R. Sander,   Max-Planck Institute for Chemistry, Mainz, Germany
!        M. Long,     Renaissance Fiber, LLC, North Carolina, USA
!        H. Lin,      Harvard University, Cambridge, MA, USA
!        R. Yantosca, Harvard University, Cambridge, MA, USA
! 
! File                 : gckpp_Parameters.F90
! Equation file        : gckpp.kpp
! Output root filename : gckpp
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



MODULE gckpp_Parameters

  USE gckpp_Precision
  PUBLIC
  SAVE


! NSPEC - Number of chemical species
  INTEGER, PARAMETER :: NSPEC = 14 
! NVAR - Number of Variable species
  INTEGER, PARAMETER :: NVAR = 10 
! NFAM - Number of Prod/Loss Families
  INTEGER, PARAMETER :: NFAM = 3 
! NVARACT - Number of Active species
  INTEGER, PARAMETER :: NVARACT = 2 
! NFIX - Number of Fixed species
  INTEGER, PARAMETER :: NFIX = 4 
! NREACT - Number of reactions
  INTEGER, PARAMETER :: NREACT = 7 
! NVARST - Starting of variables in conc. vect.
  INTEGER, PARAMETER :: NVARST = 1 
! NFIXST - Starting of fixed in conc. vect.
  INTEGER, PARAMETER :: NFIXST = 11 
! NONZERO - Number of nonzero entries in Jacobian
  INTEGER, PARAMETER :: NONZERO = 1 
! LU_NONZERO - Number of nonzero entries in LU factoriz. of Jacobian
  INTEGER, PARAMETER :: LU_NONZERO = 1 
! CNVAR - (NVAR+1) Number of elements in compressed row format
  INTEGER, PARAMETER :: CNVAR = 11 
! NLOOKAT - Number of species to look at
  INTEGER, PARAMETER :: NLOOKAT = 0 
! NMONITOR - Number of species to monitor
  INTEGER, PARAMETER :: NMONITOR = 0 
! NMASS - Number of atoms to check mass balance
  INTEGER, PARAMETER :: NMASS = 1 

! Index declaration for variable species in C and VAR
!   VAR(ind_spc) = C(ind_spc)

  INTEGER, PARAMETER :: ind_CH4 = 1 
  INTEGER, PARAMETER :: ind_CO = 2 
  INTEGER, PARAMETER :: ind_CO2 = 3 
  INTEGER, PARAMETER :: ind_COfromCH4 = 4 
  INTEGER, PARAMETER :: ind_COfromNMVOC = 5 
  INTEGER, PARAMETER :: ind_CO2fromOH = 6 
  INTEGER, PARAMETER :: ind_Dummy = 7 
  INTEGER, PARAMETER :: ind_PCO = 8 
  INTEGER, PARAMETER :: ind_LCO = 9 
  INTEGER, PARAMETER :: ind_LCH4 = 10 

! Index declaration for fixed species in C
!   C(ind_spc)

  INTEGER, PARAMETER :: ind_FixedOH = 11 
  INTEGER, PARAMETER :: ind_FixedCl = 12 
  INTEGER, PARAMETER :: ind_DummyCH4 = 13 
  INTEGER, PARAMETER :: ind_DummyNMVOC = 14 

! Index declaration for fixed species in FIX
!    FIX(indf_spc) = C(ind_spc) = C(NVAR+indf_spc)

  INTEGER, PARAMETER :: indf_FixedOH = 1 
  INTEGER, PARAMETER :: indf_FixedCl = 2 
  INTEGER, PARAMETER :: indf_DummyCH4 = 3 
  INTEGER, PARAMETER :: indf_DummyNMVOC = 4 

END MODULE gckpp_Parameters

