! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! The ODE Function of Chemical Model File
! 
! Generated by KPP-3.1.1 symbolic chemistry Kinetics PreProcessor
!       (https:/github.com/KineticPreProcessor/KPP
! KPP is distributed under GPL, the general public licence
!       (http://www.gnu.org/copyleft/gpl.html)
! (C) 1995-1997, V. Damian & A. Sandu, CGRER, Univ. Iowa
! (C) 1997-2022, A. Sandu, Michigan Tech, Virginia Tech
!     With important contributions from:
!        M. Damian,   Villanova University, Philadelphia, PA, USA
!        R. Sander,   Max-Planck Institute for Chemistry, Mainz, Germany
!        M. Long,     Renaissance Fiber, LLC, North Carolina, USA
!        H. Lin,      Harvard University, Cambridge, MA, USA
!        R. Yantosca, Harvard University, Cambridge, MA, USA
! 
! File                 : gckpp_Function.F90
! Equation file        : gckpp.kpp
! Output root filename : gckpp
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



MODULE gckpp_Function

  USE gckpp_Parameters
  IMPLICIT NONE

! A - Rate for each equation
  REAL(kind=dp) :: A(NREACT)
  !$OMP THREADPRIVATE(  A )

CONTAINS


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Fun - time derivatives of variables - Aggregate form
!   Arguments :
!      V         - Concentrations of variable species (local)
!      F         - Concentrations of fixed species (local)
!      RCT       - Rate constants (local)
!      Vdot      - Time derivative of variable species concentrations
!      Aout      - Optional argument to return equation rate constants
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE Fun ( V, F, RCT, Vdot, Aout )

! V - Concentrations of variable species (local)
  REAL(kind=dp) :: V(NVAR)
! F - Concentrations of fixed species (local)
  REAL(kind=dp) :: F(NFIX)
! RCT - Rate constants (local)
  REAL(kind=dp) :: RCT(NREACT)
! Vdot - Time derivative of variable species concentrations
  REAL(kind=dp) :: Vdot(NVAR)
! Aout - Optional argument to return equation rate constants
  REAL(kind=dp), OPTIONAL :: Aout(NREACT)


! Computation of equation rates
  A(1) = RCT(1)*V(1)*F(1)
  A(2) = RCT(2)*V(1)*F(2)
  A(3) = RCT(3)*V(2)*F(1)
  A(4) = RCT(4)*F(4)
  A(5) = RCT(5)*V(1)
  A(6) = RCT(6)*F(3)
  A(7) = RCT(7)*V(2)

  !### Use Aout to return equation rates
  IF ( PRESENT( Aout ) ) Aout = A

! Aggregate function
  Vdot(1) = -A(1)-A(2)-A(5)
  Vdot(2) = A(1)-A(3)+A(4)+A(6)-A(7)
  Vdot(3) = A(3)+A(7)
  Vdot(4) = A(1)
  Vdot(5) = A(4)
  Vdot(6) = A(3)+A(7)
  Vdot(7) = A(2)+A(5)
  Vdot(8) = A(1)+A(4)+A(6)
  Vdot(9) = A(3)+A(7)
  Vdot(10) = A(1)+A(2)+A(5)
      
END SUBROUTINE Fun

! End of Fun function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Fun_SPLIT - time derivatives of variables - Split form
!   Arguments :
!      V         - Concentrations of variable species (local)
!      F         - Concentrations of fixed species (local)
!      RCT       - Rate constants (local)
!      Vdot      - Time derivative of variable species concentrations
!      P_VAR     - Production term
!      D_VAR     - Destruction term
!      Aout      - Optional argument to return equation rate constants
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE Fun_SPLIT ( V, F, RCT, Vdot, P_VAR, D_VAR, Aout )

! V - Concentrations of variable species (local)
  REAL(kind=dp) :: V(NVAR)
! F - Concentrations of fixed species (local)
  REAL(kind=dp) :: F(NFIX)
! RCT - Rate constants (local)
  REAL(kind=dp) :: RCT(NREACT)
! Vdot - Time derivative of variable species concentrations
  REAL(kind=dp) :: Vdot(NVAR)
! P_VAR - Production term
  REAL(kind=dp) :: P_VAR(NVAR)
! D_VAR - Destruction term
  REAL(kind=dp) :: D_VAR(NVAR)
! Aout - Optional argument to return equation rate constants
  REAL(kind=dp), OPTIONAL :: Aout(NREACT)


! Computation of equation rates
  A(1) = RCT(1)*V(1)*F(1)
  A(2) = RCT(2)*V(1)*F(2)
  A(3) = RCT(3)*V(2)*F(1)
  A(4) = RCT(4)*F(4)
  A(5) = RCT(5)*V(1)
  A(6) = RCT(6)*F(3)
  A(7) = RCT(7)*V(2)

  !### Use Aout to return equation rates
  IF ( PRESENT( Aout ) ) Aout = A

! Production function
  P_VAR(1) = 0
  P_VAR(2) = A(1)+A(4)+A(6)
  P_VAR(3) = A(3)+A(7)
  P_VAR(4) = A(1)
  P_VAR(5) = A(4)
  P_VAR(6) = A(3)+A(7)
  P_VAR(7) = A(2)+A(5)
  P_VAR(8) = A(1)+A(4)+A(6)
  P_VAR(9) = A(3)+A(7)
  P_VAR(10) = A(1)+A(2)+A(5)

! Destruction function
  D_VAR(1) = RCT(1)*F(1)+RCT(2)*F(2)+RCT(5)
  D_VAR(2) = RCT(3)*F(1)+RCT(7)
  D_VAR(3) = 0
  D_VAR(4) = 0
  D_VAR(5) = 0
  D_VAR(6) = 0
  D_VAR(7) = 0
  D_VAR(8) = 0
  D_VAR(9) = 0
  D_VAR(10) = 0

  Vdot = P_VAR - D_VAR*V
      
END SUBROUTINE Fun_SPLIT

! End of Fun_SPLIT function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! CalcStoichNum - calculate stoichiometric numbers
!   Arguments :
!      StoichNum - Stoichiometric numbers
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE CalcStoichNum ( StoichNum )

! StoichNum - Stoichiometric numbers
  REAL(kind=dp) :: StoichNum(NVAR,NREACT)

  StoichNum(:,:) = 0.
  StoichNum(1,1) = -1
  StoichNum(1,2) = -1
  StoichNum(1,5) = -1
  StoichNum(2,1) = 1
  StoichNum(2,3) = -1
  StoichNum(2,4) = 1
  StoichNum(2,6) = 1
  StoichNum(2,7) = -1
  StoichNum(3,3) = 1
  StoichNum(3,7) = 1
  StoichNum(4,1) = 1
  StoichNum(5,4) = 1
  StoichNum(6,3) = 1
  StoichNum(6,7) = 1
  StoichNum(7,2) = 1
  StoichNum(7,5) = 1
  StoichNum(8,1) = 1
  StoichNum(8,4) = 1
  StoichNum(8,6) = 1
  StoichNum(9,3) = 1
  StoichNum(9,7) = 1
  StoichNum(10,1) = 1
  StoichNum(10,2) = 1
  StoichNum(10,5) = 1
      
END SUBROUTINE CalcStoichNum

! End of CalcStoichNum function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



END MODULE gckpp_Function

