! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! The Reaction Rates File
! 
! Generated by KPP-3.0.0 symbolic chemistry Kinetics PreProcessor
!       (https:/github.com/KineticPreProcessor/KPP
! KPP is distributed under GPL, the general public licence
!       (http://www.gnu.org/copyleft/gpl.html)
! (C) 1995-1997, V. Damian & A. Sandu, CGRER, Univ. Iowa
! (C) 1997-2022, A. Sandu, Michigan Tech, Virginia Tech
!     With important contributions from:
!        M. Damian,   Villanova University, Philadelphia, PA, USA
!        R. Sander,   Max-Planck Institute for Chemistry, Mainz, Germany
!        M. Long,     Renaissance Fiber, LLC, North Carolina, USA
!        H. Lin,      Harvard University, Cambridge, MA, USA
!        R. Yantosca, Harvard University, Cambridge, MA, USA
! 
! File                 : gckpp_Rates.F90
! Equation file        : gckpp.kpp
! Output root filename : gckpp
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



MODULE gckpp_Rates

  USE gckpp_Parameters
  USE gckpp_Global
  IMPLICIT NONE
  INTEGER, PARAMETER :: ASSOC = 1, DISSOC = 2

  PRIVATE :: ARR_abc_dp, ARR_abc_sp
  INTERFACE ARR_abc
     MODULE PROCEDURE ARR_abc_dp
     MODULE PROCEDURE ARR_abc_sp
  END INTERFACE ARR_abc

  PRIVATE :: ARR_ab_dp, ARR_ab_sp
  INTERFACE ARR_ab
     MODULE PROCEDURE ARR_ab_dp
     MODULE PROCEDURE ARR_ab_sp
  END INTERFACE ARR_ab

  PRIVATE :: ARR_ac_dp, ARR_ac_sp
  INTERFACE ARR_ac
     MODULE PROCEDURE ARR_ac_dp
     MODULE PROCEDURE ARR_ac_sp
  END INTERFACE ARR_ac

  PRIVATE :: EP2_dp, EP2_sp
  INTERFACE EP2
     MODULE PROCEDURE EP2_dp
     MODULE PROCEDURE EP2_sp
  END INTERFACE EP2

  PRIVATE :: EP3_dp, EP3_sp
  INTERFACE EP3
     MODULE PROCEDURE EP3_dp
     MODULE PROCEDURE EP3_sp
  END INTERFACE EP3

  PRIVATE :: FALL_dp, FALL_sp
  INTERFACE FALL
     MODULE PROCEDURE FALL_dp
     MODULE PROCEDURE FALL_sp
  END INTERFACE FALL

  PRIVATE :: k3rd_jpl_dp, k3rd_jpl_sp
  INTERFACE k3rd_jpl
     MODULE PROCEDURE k3rd_jpl_dp
     MODULE PROCEDURE k3rd_jpl_sp
  END INTERFACE k3rd_jpl

  PRIVATE :: k3rd_jpl_activation_dp, k3rd_jpl_activation_sp
  INTERFACE  k3rd_jpl_activation
     MODULE PROCEDURE  k3rd_jpl_activation_dp
     MODULE PROCEDURE  k3rd_jpl_activation_sp
  END INTERFACE  k3rd_jpl_activation

  PRIVATE :: k3rd_iupac_dp, k3rd_iupac_sp
  INTERFACE k3rd_iupac
     MODULE PROCEDURE k3rd_iupac_dp
     MODULE PROCEDURE k3rd_iupac_sp
  END INTERFACE k3rd_iupac

CONTAINS



! Begin Rate Law Functions from KPP_HOME/util/UserRateLaws

!~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!  User-defined Rate Law functions
!
!  NOTE: For computational efficiency, we have created duplicate rate law
!  routines here that take either all single precision or all double precision
!  arguments.  Explicit casts to DBLE are skipped in the functions that take
!  all double precision arguments (as this removes unneeded computations).
!
!  These functions are overloaded by INTERFACE statements, which are located
!  in file UserRateLawsInterfaces.f90.  The UserRateLawsInterfaces.f90 file
!  will be in-lined into the top of the gckpp_Rates module.
!~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  FUNCTION ARR_abc_dp( a0, b0, c0 ) RESULT( k )
    ! Arrhenius function, for nonzero a0, b0, c0 (dp args)
    REAL(dp), INTENT(IN) :: a0, b0, c0
    REAL(kind=dp) :: k
    k = a0 * EXP(-b0/TEMP) * (TEMP/300.0_dp)**C0
  END FUNCTION ARR_abc_dp

  FUNCTION ARR_abc_sp( a0, b0, c0 ) RESULT( k )
    ! Arrhenius function, for nonzero a0, b0, c0 (sp args)
    REAL(sp), INTENT(IN) :: a0, b0, c0
    REAL(kind=dp) :: k
    k = DBLE(a0) * EXP(-DBLE(b0)/TEMP) * (TEMP/300.0_dp)**DBLE(c0)
  END FUNCTION ARR_abc_sp

  !---------------------------------------------------------------------------

  FUNCTION ARR_ab_dp( a0, b0 ) RESULT( k )
    ! Arrhenius function, for nonzero a0, b0 (dp args)
    REAL(dp), INTENT(IN) :: a0, b0
    REAL(kind=dp) :: k
    k = a0 * EXP(-b0/TEMP)
  END FUNCTION ARR_ab_dp

  FUNCTION ARR_ab_sp( a0, b0 ) RESULT( k )
    ! Arrhenius function, for nonzero a0, b0 (sp args)
    REAL(sp), INTENT(IN) :: a0, b0
    REAL(kind=dp) :: k
    k = DBLE(a0) * EXP(-DBLE(b0)/TEMP)
  END FUNCTION ARR_ab_sp

  !---------------------------------------------------------------------------

  FUNCTION ARR_ac_dp( a0, c0 ) RESULT( k )
    ! Arrhenius function, for nonzero a0, c0 (dp args)
    REAL(dp), INTENT(IN) :: a0, c0
    REAL(kind=dp) :: k
    k = a0 * (TEMP/300.0_dp)**C0
  END FUNCTION ARR_ac_dp

  FUNCTION ARR_ac_sp( a0, c0 ) RESULT( k )
    ! Arrhenius function, for nonzero a0, c0 (sp args)
    REAL(sp), INTENT(IN) :: a0, c0
    REAL(kind=dp) :: k
    k = DBLE(a0) * (TEMP/300.0_dp)**DBLE(c0)
  END FUNCTION ARR_ac_sp

  !---------------------------------------------------------------------------

  FUNCTION EP2_dp( a0, c0, a2, c2, a3, c3 ) RESULT( k )
    ! EP2 function, for saprc99 and saprcnov (dp args)
    REAL(dp), INTENT(IN) :: a0, c0, a2, c2, a3, c3
    REAL(dp) :: k0, k2, k3
    REAL(kind=dp) :: k
    k0 = a0 * EXP(-c0/temp)
    k2 = a2 * EXP(-c2/temp)
    k3 = a3 * EXP(-c3/temp)
    k3 = k3 * CFACTOR * 1.0E6_dp
    k  = k0 + k3/(1.0_dp + k3/k2)
  END FUNCTION EP2_dp

  FUNCTION EP2_sp( a0, c0, a2, c2, a3, c3 ) RESULT( k )
    ! EP2 function, for saprc99 and saprcnov (sp args)
    REAL(sp), INTENT(IN) :: a0, c0, a2, c2, a3, c3
    REAL(dp) :: k0, k2, k3
    REAL(kind=dp) :: k
    k0 = DBLE(a0) * EXP(-DBLE(c0)/TEMP)
    k2 = DBLE(a2) * EXP(-DBLE(c2)/TEMP)
    k3 = DBLE(a3) * EXP(-DBLE(c3)/TEMP)
    k3 = k3 * CFACTOR * 1.0E6_dp
    k  = k0 + K3/(1.0_dp + k3/k2)
  END FUNCTION EP2_sp

  !---------------------------------------------------------------------------

  FUNCTION EP3_dp( a1, c1, a2, c2) RESULT( k )
    ! EP3 function, for saprc99 and saprcnov (dp args)
    REAL(dp), INTENT(IN) :: a1, c1, a2, c2
    REAL(dp) :: k1, k2
    REAL(kind=dp) :: k
    k1 = a1 * EXP(-c1/TEMP)
    k2 = a2 * EXP(-c2/TEMP)
    k  = k1 + k2*(1.0E6_dp * CFACTOR)
  END FUNCTION EP3_dp

  FUNCTION EP3_sp( a1, c1, a2, c2 ) RESULT( k )
    ! EP3 function, for saprc99 and saprcnov (sp args)
    REAL(sp), INTENT(IN) :: a1, c1, a2, c2
    REAL(dp) :: k1, k2
    REAL(kind=dp) :: k
    k1 = DBLE(a1) * EXP(-DBLE(c1)/TEMP)
    k2 = DBLE(a2) * EXP(-DBLE(c2)/TEMP)
    k  = k1 + k2*(1.0E6_dp * CFACTOR)
  END FUNCTION EP3_sp

  !---------------------------------------------------------------------------

  FUNCTION FALL_dp( a0, b0, c0, a1, b1, c1, cf ) RESULT( k )
    ! FALL function, for saprc99 and saprcnov (dp args)
    REAL(dp), INTENT(IN) :: a0, b0, c0, a1, b1, c1, cf
    REAL(dp) :: k0, k1
    REAL(kind=dp) :: k
    k0 = a0 * EXP(-b0/TEMP) * (TEMP/300.0_dp)**c0
    k1 = a1 * EXP(-b1/TEMP) * (TEMP/300.0_dp)**c1
    k0 = k0 * CFACTOR * 1.0E6_dp
    k1 = k0 / k1
    k  = (k0/(1.0_dp+k1)) * cf**(1.0_dp/(1.0_dp+(LOG10(k1))**2))
  END FUNCTION FALL_dp

  FUNCTION FALL_sp( a0, b0, c0, a1, b1, c1, cf ) RESULT( k )
    ! FALL function, for saprc99 and saprcnov (sp args)
    REAL(sp), INTENT(IN) :: a0, b0, c0, a1, b1, c1, cf
    REAL(dp) :: k0, k1
    REAL(kind=dp) :: k
    k0 = DBLE(A0) * EXP(-DBLE(B0)/TEMP)* (TEMP/300.0_dp)**DBLE(C0)
    k1 = DBLE(A1) * EXP(-DBLE(B1)/TEMP)* (TEMP/300.0_dp)**DBLE(C1)
    k0 = k0 * CFACTOR * 1.0E6_dp
    k1 = k0 / k1
    k  = (k0/(1.0_dp+k1)) * DBLE(cf)**(1.0_dp/(1.0_dp+(LOG10(k1))**2))
  END FUNCTION FALL_sp

  !---------------------------------------------------------------------------

  ! JPL (jpldataeval.jpl.nasa.gov) three-body reaction formula:
  
  REAL(dp) FUNCTION k3rd_jpl_dp(cair,k0_300K,n,kinf_300K,m,fc) ! dp args
    INTRINSIC LOG10
    REAL(dp), INTENT(IN) :: cair      ! air concentration [molecules/cm3]
    REAL(dp), INTENT(IN) :: k0_300K   ! low pressure limit at 300 K
    REAL(dp), INTENT(IN) :: n         ! exponent for low pressure limit
    REAL(dp), INTENT(IN) :: kinf_300K ! high pressure limit at 300 K
    REAL(dp), INTENT(IN) :: m         ! exponent for high pressure limit
    REAL(dp), INTENT(IN) :: fc        ! broadening factor (usually fc=0.6)
    REAL(dp) :: zt_help, k0_T, kinf_T, k_ratio
    zt_help  = 300._dp/temp
    k0_T     = k0_300K   * zt_help**(n) * cair ! k_0   at current T
    kinf_T   = kinf_300K * zt_help**(m)        ! k_inf at current T
    k_ratio  = k0_T/kinf_T
    k3rd_jpl_dp = k0_T/(1._dp+k_ratio)*fc**(1._dp/(1._dp+LOG10(k_ratio)**2))
  END FUNCTION k3rd_jpl_dp

  REAL(kind=dp) FUNCTION k3rd_jpl_sp(cair,k0_300K,n,kinf_300K,m,fc) ! sp args
    INTRINSIC LOG10
    REAL(sp), INTENT(IN) :: cair      ! air concentration [molecules/cm3]
    REAL(sp), INTENT(IN) :: k0_300K   ! low pressure limit at 300 K
    REAL(sp), INTENT(IN) :: n         ! exponent for low pressure limit
    REAL(sp), INTENT(IN) :: kinf_300K ! high pressure limit at 300 K
    REAL(sp), INTENT(IN) :: m         ! exponent for high pressure limit
    REAL(sp), INTENT(IN) :: fc        ! broadening factor (usually fc=0.6)
    REAL(sp) :: zt_help, k0_T, kinf_T, k_ratio
    zt_help  = 300._dp/temp
    k0_T     = k0_300K   * zt_help**(n) * cair ! k_0   at current T
    kinf_T   = kinf_300K * zt_help**(m)        ! k_inf at current T
    k_ratio  = k0_T/kinf_T
    k3rd_jpl_sp = k0_T/(1._dp+k_ratio)*fc**(1._dp/(1._dp+LOG10(k_ratio)**2))
  END FUNCTION k3rd_jpl_sp

  ! --------------------------------------------------------------------------

  ! JPL (jpldataeval.jpl.nasa.gov) termolecular chemical activation reaction:

  FUNCTION k3rd_jpl_activation_dp(cair,k0_298K,n,kinf_298K,m,A,B) ! dp args
    INTRINSIC :: LOG10
    REAL(dp), DIMENSION(2) :: k3rd_jpl_activation_dp
    REAL(dp), INTENT(IN) :: cair      ! air concentration [molecules/cm3]
    REAL(dp), INTENT(IN) :: k0_298K   ! low pressure limit at 300 K
    REAL(dp), INTENT(IN) :: n         ! exponent for low pressure limit
    REAL(dp), INTENT(IN) :: kinf_298K ! high pressure limit at 300 K
    REAL(dp), INTENT(IN) :: m         ! exponent for high pressure limit
    REAL(dp), INTENT(IN) :: A         ! for k_int
    REAL(dp), INTENT(IN) :: B         ! for k_int
    REAL(dp)             :: zt_help, k0_TM, kinf_T, k_ratio, k_f, k_int, k_fCA
    zt_help = 298./temp
    k0_TM   = k0_298K   * zt_help**n * cair ! k_0   at current T * M
    kinf_T  = kinf_298K * zt_help**m        ! k_inf at current T
    k_ratio = k0_TM/kinf_T
    k_f     = k0_TM/(1.+k_ratio)*0.6**(1./(1.+LOG10(k_ratio)**2))
    k_int   = A * exp(-B/temp)
    k_fCA   = k_int * (1. - k_f/kinf_T)
    k3rd_jpl_activation_dp(ASSOC)  = k_f
    k3rd_jpl_activation_dp(DISSOC) = k_fCA
  END FUNCTION k3rd_jpl_activation_dp

  FUNCTION k3rd_jpl_activation_sp(cair,k0_298K,n,kinf_298K,m,A,B) ! sp args
    INTRINSIC :: LOG10
    REAL(kind=dp), DIMENSION(2) :: k3rd_jpl_activation_sp
    REAL(sp), INTENT(IN) :: cair      ! air concentration [molecules/cm3]
    REAL(sp), INTENT(IN) :: k0_298K   ! low pressure limit at 300 K
    REAL(sp), INTENT(IN) :: n         ! exponent for low pressure limit
    REAL(sp), INTENT(IN) :: kinf_298K ! high pressure limit at 300 K
    REAL(sp), INTENT(IN) :: m         ! exponent for high pressure limit
    REAL(sp), INTENT(IN) :: A         ! for k_int
    REAL(sp), INTENT(IN) :: B         ! for k_int
    REAL(sp)             :: zt_help, k0_TM, kinf_T, k_ratio, k_f, k_int, k_fCA
    zt_help = 298./temp
    k0_TM   = k0_298K   * zt_help**n * cair ! k_0   at current T * M
    kinf_T  = kinf_298K * zt_help**m        ! k_inf at current T
    k_ratio = k0_TM/kinf_T
    k_f     = k0_TM/(1.+k_ratio)*0.6**(1./(1.+LOG10(k_ratio)**2))
    k_int   = A * exp(-B/temp)
    k_fCA   = k_int * (1. - k_f/kinf_T)
    k3rd_jpl_activation_sp(ASSOC)  = k_f
    k3rd_jpl_activation_sp(DISSOC) = k_fCA
  END FUNCTION k3rd_jpl_activation_sp

  ! --------------------------------------------------------------------------

  ! IUPAC (iupac.pole-ether.fr) three-body reaction formula:

  REAL(dp) FUNCTION k3rd_iupac_dp(cair,k0_300K,n,kinf_300K,m,fc) ! dp args
    INTRINSIC :: LOG10
    REAL(dp), INTENT(IN) :: cair      ! air concentration [molecules/cm3]
    REAL(dp), INTENT(IN) :: k0_300K   ! low pressure limit at 300 K
    REAL(dp), INTENT(IN) :: n         ! exponent for low pressure limit
    REAL(dp), INTENT(IN) :: kinf_300K ! high pressure limit at 300 K
    REAL(dp), INTENT(IN) :: m         ! exponent for high pressure limit
    REAL(dp), INTENT(IN) :: fc        ! broadening factor (e.g. 0.45 or 0.6...)
    REAL(dp)             :: nu        ! N
    REAL(dp)             :: zt_help, k0_T, kinf_T, k_ratio
    zt_help = 300._dp/temp
    k0_T    = k0_300K   * zt_help**(n) * cair ! k_0   at current T
    kinf_T  = kinf_300K * zt_help**(m)        ! k_inf at current T
    k_ratio = k0_T/kinf_T
    nu      = 0.75-1.27*LOG10(fc)
    k3rd_iupac_dp = k0_T/(1._dp+k_ratio)* &
      fc**(1._dp/(1._dp+(LOG10(k_ratio)/nu)**2))
  END FUNCTION k3rd_iupac_dp

  REAL(kind=dp) FUNCTION k3rd_iupac_sp(cair,k0_300K,n,kinf_300K,m,fc) ! sp args
    INTRINSIC :: LOG10
    REAL(sp), INTENT(IN) :: cair      ! air concentration [molecules/cm3]
    REAL(sp), INTENT(IN) :: k0_300K   ! low pressure limit at 300 K
    REAL(sp), INTENT(IN) :: n         ! exponent for low pressure limit
    REAL(sp), INTENT(IN) :: kinf_300K ! high pressure limit at 300 K
    REAL(sp), INTENT(IN) :: m         ! exponent for high pressure limit
    REAL(sp), INTENT(IN) :: fc        ! broadening factor (e.g. 0.45 or 0.6...)
    REAL(sp)             :: nu        ! N
    REAL(sp)             :: zt_help, k0_T, kinf_T, k_ratio
    zt_help = 300._dp/temp
    k0_T    = k0_300K   * zt_help**(n) * cair ! k_0   at current T
    kinf_T  = kinf_300K * zt_help**(m)        ! k_inf at current T
    k_ratio = k0_T/kinf_T
    nu      = 0.75-1.27*LOG10(fc)
    k3rd_iupac_sp = k0_T/(1._dp+k_ratio)* &
      fc**(1._dp/(1._dp+(LOG10(k_ratio)/nu)**2))
  END FUNCTION k3rd_iupac_sp

!~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
!  End of User-defined Rate Law functions
!~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

! End Rate Law Functions from KPP_HOME/util/UserRateLaws


! Begin INLINED Rate Law Functions


  ! All rates are included in Hg_RateLawFuncs.F90, which
  ! gets referenced directly from subroutine Update_Rconst.

! End INLINED Rate Law Functions

! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Update_SUN - update SUN light using TIME
!   Arguments :
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  SUBROUTINE Update_SUN()
    USE gckpp_Parameters
    USE gckpp_Global

    IMPLICIT NONE

    REAL(kind=dp) :: SunRise, SunSet
    REAL(kind=dp) :: Thour, Tlocal, Ttmp 
    ! PI - Value of pi
    REAL(kind=dp), PARAMETER :: PI = 3.14159265358979d0
    
    SunRise = 4.5_dp 
    SunSet  = 19.5_dp 
    Thour = TIME/3600.0_dp 
    Tlocal = Thour - (INT(Thour)/24)*24

    IF ((Tlocal>=SunRise).AND.(Tlocal<=SunSet)) THEN
       Ttmp = (2.0*Tlocal-SunRise-SunSet)/(SunSet-SunRise)
       IF (Ttmp.GT.0) THEN
          Ttmp =  Ttmp*Ttmp
       ELSE
          Ttmp = -Ttmp*Ttmp
       END IF
       SUN = ( 1.0_dp + COS(PI*Ttmp) )/2.0_dp 
    ELSE
       SUN = 0.0_dp 
    END IF

 END SUBROUTINE Update_SUN

! End of Update_SUN function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Update_RCONST - function to update rate constants
!   Arguments :
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE Update_RCONST ( )




! Begin INLINED RCONST


  ! Inline an include file containing rate law definitions, which
  ! will be inserted directly into subroutine Update_Rconst().
  ! This is necessary as a workaround for KPP not being able to
  ! include very large files ( > 200000 chars) directly.
  !  -- Bob Yantosca (09 Dec 2021)
  USE Hg_RateLawFuncs

! End INLINED RCONST

  RCONST(1) = (GCARR_ab(1.46d-32,1.86d0)*NUMDEN)
  RCONST(2) = (GCARR_abc(1.6d-9,1.86d0,-7801.0d0)*NUMDEN)
  RCONST(3) = (3.9d-11)
  RCONST(4) = (3.0d-12)
  RCONST(5) = (GCJPLPR_abab(4.3d-30,5.9d0,1.2d-10,1.90d0,0.6d0))
  RCONST(6) = (GCJPLPR_abab(4.3d-30,5.9d0,6.9d-11,2.40d0,0.6d0))
  RCONST(7) = (GCJPLPR_abab(4.3d-30,5.9d0,6.9d-11,2.40d0,0.6d0))
  RCONST(8) = (GCJPLPR_abab(4.3d-30,5.9d0,6.9d-11,2.40d0,0.6d0))
  RCONST(9) = (GCJPLPR_abab(4.3d-30,5.9d0,6.9d-11,2.40d0,0.6d0))
  RCONST(10) = (3.0d-11)
  RCONST(11) = (GCARR_ac(4.1d-12,-856.0d0))
  RCONST(12) = (GCARR_ac(6.0d-11,-550.0d0))
  RCONST(13) = (3.0d-11)
  RCONST(14) = (GCARR_ac(2.25d-33,680.0d0)*NUMDEN)
  RCONST(15) = (3.9d-11)
  RCONST(16) = (3.0d-12)
  RCONST(17) = (GCJPLPR_abab(4.3d-30,5.9d0,1.2d-10,1.90d0,0.6d0))
  RCONST(18) = (GCJPLPR_abab(4.3d-30,5.9d0,6.9d-11,2.40d0,0.6d0))
  RCONST(19) = (GCJPLPR_abab(4.3d-30,5.9d0,6.9d-11,2.40d0,0.6d0))
  RCONST(20) = (GCJPLPR_abab(4.3d-30,5.9d0,6.9d-11,2.40d0,0.6d0))
  RCONST(21) = (3.0d-11)
  RCONST(22) = (3.0d-11)
  RCONST(23) = (3.0d-11)
  RCONST(24) = (GCARR_ac(4.1d-12,-856.0d0))
  RCONST(25) = (GCARR_ac(6.0d-11,-550.0d0))
  RCONST(26) = (GCARR_ac(3.34d-33,43.0d0)*NUMDEN)
  RCONST(27) = (GCARR_ac(1.22d-9,-5720.0d0)*NUMDEN)
  RCONST(28) = (GCJPLPR_abab(4.1d-30,5.9d0,1.2E-10,1.90d0,0.6d0))
  RCONST(29) = (GCJPLPR_abab(4.1d-30,5.9d0,6.9d-11,2.40d0,0.6d0))
  RCONST(30) = (GCJPLPR_abab(4.1d-30,5.9d0,6.9d-11,2.40d0,0.6d0))
  RCONST(31) = (GCJPLPR_abab(4.1d-30,5.9d0,6.9d-11,2.40d0,0.6d0))
  RCONST(32) = (GCJPLPR_abab(4.1d-30,5.9d0,6.9d-11,2.40d0,0.6d0))
  RCONST(33) = (GCJPLPR_abab(4.1d-30,5.9d0,6.9d-11,2.40d0,0.6d0))
  RCONST(34) = (3.0d-11)
  RCONST(35) = (GCARR_ac(4.1d-12,-856.0d0))
  RCONST(36) = (GCARR_ac(6.0d-11,-550.0d0))
  RCONST(37) = (Het_HgIIP_Org(State_Het,0.1d0,SR_MW(ind_HgBrNO2)))
  RCONST(38) = (Het_HgIIP_Org(State_Het,0.1d0,SR_MW(ind_HgBrHO2)))
  RCONST(39) = (Het_HgIIP_Org(State_Het,0.1d0,SR_MW(ind_HgBrOH)))
  RCONST(40) = (Het_HgIIP_Org(State_Het,0.1d0,SR_MW(ind_HgBrBrO)))
  RCONST(41) = (Het_HgIIP_Org(State_Het,0.1d0,SR_MW(ind_HgBrClO)))
  RCONST(42) = (Het_HgIIP_Org(State_Het,0.1d0,SR_MW(ind_HgBr2)))
  RCONST(43) = (Het_HgIIP_Org(State_Het,0.1d0,SR_MW(ind_HgClNO2)))
  RCONST(44) = (Het_HgIIP_Org(State_Het,0.1d0,SR_MW(ind_HgClHO2)))
  RCONST(45) = (Het_HgIIP_Org(State_Het,0.1d0,SR_MW(ind_HgClOH)))
  RCONST(46) = (Het_HgIIP_Org(State_Het,0.1d0,SR_MW(ind_HgClBrO)))
  RCONST(47) = (Het_HgIIP_Org(State_Het,0.1d0,SR_MW(ind_HgClClO)))
  RCONST(48) = (Het_HgIIP_Org(State_Het,0.1d0,SR_MW(ind_HgClBr)))
  RCONST(49) = (Het_HgIIP_Org(State_Het,0.1d0,SR_MW(ind_HgCl2)))
  RCONST(50) = (Het_HgIIP_Org(State_Het,0.1d0,SR_MW(ind_HgOHNO2)))
  RCONST(51) = (Het_HgIIP_Org(State_Het,0.1d0,SR_MW(ind_HgOHHO2)))
  RCONST(52) = (Het_HgIIP_Org(State_Het,0.1d0,SR_MW(ind_HgOHOH)))
  RCONST(53) = (Het_HgIIP_Org(State_Het,0.1d0,SR_MW(ind_HgOHBrO)))
  RCONST(54) = (Het_HgIIP_Org(State_Het,0.1d0,SR_MW(ind_HgOHClO)))
  RCONST(55) = (Het_HgIIP_Inorg(State_Het,0.1d0,SR_MW(ind_HgBrNO2)))
  RCONST(56) = (Het_HgIIP_Inorg(State_Het,0.1d0,SR_MW(ind_HgBrHO2)))
  RCONST(57) = (Het_HgIIP_Inorg(State_Het,0.1d0,SR_MW(ind_HgBrOH)))
  RCONST(58) = (Het_HgIIP_Inorg(State_Het,0.1d0,SR_MW(ind_HgBrBrO)))
  RCONST(59) = (Het_HgIIP_Inorg(State_Het,0.1d0,SR_MW(ind_HgBrClO)))
  RCONST(60) = (Het_HgIIP_Inorg(State_Het,0.1d0,SR_MW(ind_HgBr2)))
  RCONST(61) = (Het_HgIIP_Inorg(State_Het,0.1d0,SR_MW(ind_HgClNO2)))
  RCONST(62) = (Het_HgIIP_Inorg(State_Het,0.1d0,SR_MW(ind_HgClHO2)))
  RCONST(63) = (Het_HgIIP_Inorg(State_Het,0.1d0,SR_MW(ind_HgClOH)))
  RCONST(64) = (Het_HgIIP_Inorg(State_Het,0.1d0,SR_MW(ind_HgClBrO)))
  RCONST(65) = (Het_HgIIP_Inorg(State_Het,0.1d0,SR_MW(ind_HgClClO)))
  RCONST(66) = (Het_HgIIP_Inorg(State_Het,0.1d0,SR_MW(ind_HgClBr)))
  RCONST(67) = (Het_HgIIP_Inorg(State_Het,0.1d0,SR_MW(ind_HgOHNO2)))
  RCONST(68) = (Het_HgIIP_Inorg(State_Het,0.1d0,SR_MW(ind_HgOHHO2)))
  RCONST(69) = (Het_HgIIP_Inorg(State_Het,0.1d0,SR_MW(ind_HgOHOH)))
  RCONST(70) = (Het_HgIIP_Inorg(State_Het,0.1d0,SR_MW(ind_HgOHBrO)))
  RCONST(71) = (Het_HgIIP_Inorg(State_Het,0.1d0,SR_MW(ind_HgOHClO)))
  RCONST(72) = (PHOTOL(25))
  RCONST(73) = (PHOTOL(26))
  RCONST(74) = (PHOTOL(27))
  RCONST(75) = (PHOTOL(4))
  RCONST(76) = (PHOTOL(7))
  RCONST(77) = (PHOTOL(8))
  RCONST(78) = (PHOTOL(9))
  RCONST(79) = (PHOTOL(10))
  RCONST(80) = (PHOTOL(11))
  RCONST(81) = (PHOTOL(12))
  RCONST(82) = (PHOTOL(14))
  RCONST(83) = (PHOTOL(15))
  RCONST(84) = (PHOTOL(16))
  RCONST(85) = (PHOTOL(17))
  RCONST(86) = (PHOTOL(18))
  RCONST(87) = (PHOTOL(19))
  RCONST(88) = (PHOTOL(6))
  RCONST(89) = (PHOTOL(20))
  RCONST(90) = (PHOTOL(21))
  RCONST(91) = (PHOTOL(5))
  RCONST(92) = (PHOTOL(23))
  RCONST(93) = (PHOTOL(24))
  RCONST(94) = (PHOTOL(13))
      
END SUBROUTINE Update_RCONST

! End of Update_RCONST function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Update_PHOTO - function to update photolytical rate constants
!   Arguments :
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUBROUTINE Update_PHOTO ( )



! Begin INLINED RCONST


  ! Inline an include file containing rate law definitions, which
  ! will be inserted directly into subroutine Update_Rconst().
  ! This is necessary as a workaround for KPP not being able to
  ! include very large files ( > 200000 chars) directly.
  !  -- Bob Yantosca (09 Dec 2021)
  USE Hg_RateLawFuncs

! End INLINED RCONST

  RCONST(72) = (PHOTOL(25))
  RCONST(73) = (PHOTOL(26))
  RCONST(74) = (PHOTOL(27))
  RCONST(75) = (PHOTOL(4))
  RCONST(76) = (PHOTOL(7))
  RCONST(77) = (PHOTOL(8))
  RCONST(78) = (PHOTOL(9))
  RCONST(79) = (PHOTOL(10))
  RCONST(80) = (PHOTOL(11))
  RCONST(81) = (PHOTOL(12))
  RCONST(82) = (PHOTOL(14))
  RCONST(83) = (PHOTOL(15))
  RCONST(84) = (PHOTOL(16))
  RCONST(85) = (PHOTOL(17))
  RCONST(86) = (PHOTOL(18))
  RCONST(87) = (PHOTOL(19))
  RCONST(88) = (PHOTOL(6))
  RCONST(89) = (PHOTOL(20))
  RCONST(90) = (PHOTOL(21))
  RCONST(91) = (PHOTOL(5))
  RCONST(92) = (PHOTOL(23))
  RCONST(93) = (PHOTOL(24))
  RCONST(94) = (PHOTOL(13))
      
END SUBROUTINE Update_PHOTO

! End of Update_PHOTO function
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



END MODULE gckpp_Rates

