! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Parameter Module File
! 
! Generated by KPP-3.0.0 symbolic chemistry Kinetics PreProcessor
!       (https:/github.com/KineticPreProcessor/KPP
! KPP is distributed under GPL, the general public licence
!       (http://www.gnu.org/copyleft/gpl.html)
! (C) 1995-1997, V. Damian & A. Sandu, CGRER, Univ. Iowa
! (C) 1997-2022, A. Sandu, Michigan Tech, Virginia Tech
!     With important contributions from:
!        M. Damian,   Villanova University, Philadelphia, PA, USA
!        R. Sander,   Max-Planck Institute for Chemistry, Mainz, Germany
!        M. Long,     Renaissance Fiber, LLC, North Carolina, USA
!        H. Lin,      Harvard University, Cambridge, MA, USA
!        R. Yantosca, Harvard University, Cambridge, MA, USA
! 
! File                 : gckpp_Parameters.F90
! Equation file        : gckpp.kpp
! Output root filename : gckpp
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



MODULE gckpp_Parameters

  USE gckpp_Precision
  PUBLIC
  SAVE


! NSPEC - Number of chemical species
  INTEGER, PARAMETER :: NSPEC = 43 
! NVAR - Number of Variable species
  INTEGER, PARAMETER :: NVAR = 32 
! NFAM - Number of Prod/Loss Families
  INTEGER, PARAMETER :: NFAM = 5 
! NVARACT - Number of Active species
  INTEGER, PARAMETER :: NVARACT = 26 
! NFIX - Number of Fixed species
  INTEGER, PARAMETER :: NFIX = 11 
! NREACT - Number of reactions
  INTEGER, PARAMETER :: NREACT = 94 
! NVARST - Starting of variables in conc. vect.
  INTEGER, PARAMETER :: NVARST = 1 
! NFIXST - Starting of fixed in conc. vect.
  INTEGER, PARAMETER :: NFIXST = 33 
! NONZERO - Number of nonzero entries in Jacobian
  INTEGER, PARAMETER :: NONZERO = 155 
! LU_NONZERO - Number of nonzero entries in LU factoriz. of Jacobian
  INTEGER, PARAMETER :: LU_NONZERO = 161 
! CNVAR - (NVAR+1) Number of elements in compressed row format
  INTEGER, PARAMETER :: CNVAR = 33 
! NLOOKAT - Number of species to look at
  INTEGER, PARAMETER :: NLOOKAT = 0 
! NMONITOR - Number of species to monitor
  INTEGER, PARAMETER :: NMONITOR = 0 
! NMASS - Number of atoms to check mass balance
  INTEGER, PARAMETER :: NMASS = 1 

! Index declaration for variable species in C and VAR
!   VAR(ind_spc) = C(ind_spc)

  INTEGER, PARAMETER :: ind_HgCl2 = 1 
  INTEGER, PARAMETER :: ind_Hg2ClP = 2 
  INTEGER, PARAMETER :: ind_PHg2 = 3 
  INTEGER, PARAMETER :: ind_PHg0 = 4 
  INTEGER, PARAMETER :: ind_PHg2Br = 5 
  INTEGER, PARAMETER :: ind_PHg2OH = 6 
  INTEGER, PARAMETER :: ind_PHg2Cl = 7 
  INTEGER, PARAMETER :: ind_HgClClO = 8 
  INTEGER, PARAMETER :: ind_HgClBrO = 9 
  INTEGER, PARAMETER :: ind_HgClBr = 10 
  INTEGER, PARAMETER :: ind_HgOHClO = 11 
  INTEGER, PARAMETER :: ind_HgOHBrO = 12 
  INTEGER, PARAMETER :: ind_HgBrClO = 13 
  INTEGER, PARAMETER :: ind_HgBrBrO = 14 
  INTEGER, PARAMETER :: ind_HgOHNO2 = 15 
  INTEGER, PARAMETER :: ind_HgBrNO2 = 16 
  INTEGER, PARAMETER :: ind_HgClNO2 = 17 
  INTEGER, PARAMETER :: ind_HgBr2 = 18 
  INTEGER, PARAMETER :: ind_HgOHO = 19 
  INTEGER, PARAMETER :: ind_HgOHOH = 20 
  INTEGER, PARAMETER :: ind_HgOHHO2 = 21 
  INTEGER, PARAMETER :: ind_HgBrO = 22 
  INTEGER, PARAMETER :: ind_HgBrHO2 = 23 
  INTEGER, PARAMETER :: ind_HgClO = 24 
  INTEGER, PARAMETER :: ind_HgClHO2 = 25 
  INTEGER, PARAMETER :: ind_HgClOH = 26 
  INTEGER, PARAMETER :: ind_HgCl = 27 
  INTEGER, PARAMETER :: ind_Hg2ORGP = 28 
  INTEGER, PARAMETER :: ind_HgOH = 29 
  INTEGER, PARAMETER :: ind_Hg0 = 30 
  INTEGER, PARAMETER :: ind_HgBrOH = 31 
  INTEGER, PARAMETER :: ind_HgBr = 32 

! Index declaration for fixed species in C
!   C(ind_spc)

  INTEGER, PARAMETER :: ind_Br = 33 
  INTEGER, PARAMETER :: ind_Cl = 34 
  INTEGER, PARAMETER :: ind_OH = 35 
  INTEGER, PARAMETER :: ind_NO2 = 36 
  INTEGER, PARAMETER :: ind_NO = 37 
  INTEGER, PARAMETER :: ind_O3 = 38 
  INTEGER, PARAMETER :: ind_HO2 = 39 
  INTEGER, PARAMETER :: ind_BrO = 40 
  INTEGER, PARAMETER :: ind_ClO = 41 
  INTEGER, PARAMETER :: ind_CO = 42 
  INTEGER, PARAMETER :: ind_CH4 = 43 

! Index declaration for fixed species in FIX
!    FIX(indf_spc) = C(ind_spc) = C(NVAR+indf_spc)

  INTEGER, PARAMETER :: indf_Br = 1 
  INTEGER, PARAMETER :: indf_Cl = 2 
  INTEGER, PARAMETER :: indf_OH = 3 
  INTEGER, PARAMETER :: indf_NO2 = 4 
  INTEGER, PARAMETER :: indf_NO = 5 
  INTEGER, PARAMETER :: indf_O3 = 6 
  INTEGER, PARAMETER :: indf_HO2 = 7 
  INTEGER, PARAMETER :: indf_BrO = 8 
  INTEGER, PARAMETER :: indf_ClO = 9 
  INTEGER, PARAMETER :: indf_CO = 10 
  INTEGER, PARAMETER :: indf_CH4 = 11 

END MODULE gckpp_Parameters

