! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! 
! Global Data Module File
! 
! Generated by KPP-3.0.0 symbolic chemistry Kinetics PreProcessor
!       (https:/github.com/KineticPreProcessor/KPP
! KPP is distributed under GPL, the general public licence
!       (http://www.gnu.org/copyleft/gpl.html)
! (C) 1995-1997, V. Damian & A. Sandu, CGRER, Univ. Iowa
! (C) 1997-2022, A. Sandu, Michigan Tech, Virginia Tech
!     With important contributions from:
!        M. Damian,   Villanova University, Philadelphia, PA, USA
!        R. Sander,   Max-Planck Institute for Chemistry, Mainz, Germany
!        M. Long,     Renaissance Fiber, LLC, North Carolina, USA
!        H. Lin,      Harvard University, Cambridge, MA, USA
!        R. Yantosca, Harvard University, Cambridge, MA, USA
! 
! File                 : gckpp_Global.F90
! Equation file        : gckpp.kpp
! Output root filename : gckpp
! 
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



MODULE gckpp_Global

  USE gckpp_Parameters, ONLY: dp, NSPEC, NVAR, NFIX, NREACT, LU_NONZERO
  PUBLIC
  SAVE


! Declaration of global variables

! ~~~ If you are using KPP within an OpenMP parallel environment,
! ~~~ then these variables must be declared THREADPRIVATE.  This means
! ~~~ that the compiler will make a private copy of these variables
! ~~~ (in stack memory) for each execution thread.  At the end of
! ~~~ the OpenMP parallel loop, these variables will be finalized,
! ~~~ and their memory deallocated.
! ~~~
! ~~~ NOTE: Because the OpenMP commands all begin with a comment
! ~~~ character, they will be ignored unless the code is compiled
! ~~~ with OpenMP parallelization turned on.

! C - Concentration of all species
  REAL(kind=dp), TARGET :: C(NSPEC)
  !$OMP THREADPRIVATE( C )
! VAR - Concentrations of variable species (global)
  REAL(kind=dp), POINTER :: VAR(:)
  !$OMP THREADPRIVATE( VAR )
! FIX - Concentrations of fixed species (global)
  REAL(kind=dp), POINTER :: FIX(:)
  !$OMP THREADPRIVATE( FIX )
! RCONST - Rate constants (global)
  REAL(kind=dp) :: RCONST(NREACT)
  !$OMP THREADPRIVATE( RCONST )
! TIME - Current integration time
  REAL(kind=dp) :: TIME
  !$OMP THREADPRIVATE( TIME )
! SUN - Sunlight intensity between [0,1]
  REAL(kind=dp) :: SUN
  !$OMP THREADPRIVATE( SUN )
! TEMP - Temperature
  REAL(kind=dp) :: TEMP
  !$OMP THREADPRIVATE( TEMP )

! ~~~ If you are using KPP within an OpenMP parallel environment,
! ~~~ these variables DO NOT need to be declared THREADPRIVATE.

! TSTART - Integration start time
  REAL(kind=dp) :: TSTART
! TEND - Integration end time
  REAL(kind=dp) :: TEND
! DT - Integration step
  REAL(kind=dp) :: DT
! ATOL - Absolute tolerance
  REAL(kind=dp) :: ATOL(NVAR)
! RTOL - Relative tolerance
  REAL(kind=dp) :: RTOL(NVAR)
! STEPMIN - Lower bound for integration step
  REAL(kind=dp) :: STEPMIN
! STEPMAX - Upper bound for integration step
  REAL(kind=dp) :: STEPMAX
! CFACTOR - Conversion factor for concentration units
  REAL(kind=dp) :: CFACTOR

! INLINED global variable declarations

! Inline common variables into gckpp_Global.F90
#include "commonIncludeVars.H"

! INLINED global variable declarations


END MODULE gckpp_Global

