# KPP/Hg -- folder for the GEOS-Chem mercury chemistry mechanism

This folder contains the files that define the mercury chemistry
mechanism for GEOS-Chem.

## User-modifiable configuration files

  1. **Hg.kpp**: Master KPP specification file.

  2. **Hg.eqn**: KPP equation file, contains reaction definitoins.

  3. **Hg_HetStateFuncs.F90**: This module contains functions
     that initialize the HetChem state object.

  5. **Hg_RateLawFuncs.F90**: This module contains functions
	 that compute rates for heterogenous chemistry reactions.  This is
	 the so-called "rate law library" for the fullchem mechanism.

  6. **rateLawUtilFuncs.F90**: This module contains several utility
     functions for heterogeneous chemistry reactions.  (Symbolic link
     to ../fullchem/rateLawUtilfuncs.

   7, **commonIncludeVars.H**: Global variables that are used for all
      KPP mechanisms.  These will be inlined into the KPP-generated
      **gckpp_Global.F90** file.

The following files link to the KPP/stubs folder.  These include stub
subroutines that are used by other chemical mechanisms.  The stubs are
needed in order to avoid compilation errors.

  1. **stub_aciduptake_DustChemFuncs.F90** Stub routines corresponding
     to the KPP/aciduptake/aciduptake_DustChemFuncs.F90 module,

  2. **stub_fullchem_HetStateFuncs.F90**: Stub routines corresponding
     to the KPP/fullchem/Hg_HetStateFuncs.F90 module.

  3. **stub_fullchem_SulfurChemFuncs.F90**: Stub routines corresponding
	 to the KPP/fullchem/fullchem_SulfurChemFuncs.F90 module.

### Files generated by KPP

With the exception of the symbolic link **gckpp.kpp**, and the map
file **gckpp.map**, all files starting with the prefix **gckpp_** are
generated by KPP.  These contain the specifications of the chemical
mechanism in efficient source code.

FFor more information, please see:

  1. KPP documentation at: https://kpp.readthedocs.io

  2. [Guide to Using KPP with GEOS-Chem](https://geos-chem.readthedocs.io/en/latest/geos-chem-shared-docs/supplemental-guides/using-kpp-with-gc.html)
