// reads the output of gfs.c

#include "input.h"

int main()
{
  init_grid (N);
  scalar a[];
  vector u[];
  
  FILE * fp = fopen ("gfsi.gfs", "r"); // this is generated by gfs.c
  input_gfs (fp);
  fclose (fp);

  output_cells (stdout);

  double k = 2.*pi;
  foreach() {
    assert (fabs(a[] - sin(k*x)*cos(k*y)) < 1e-12);
    assert (fabs(u.x[] - sin(k*x)*cos(k*y)) < 1e-12);
    assert (fabs(u.y[] - sin(k*x)*cos(k*y)) < 1e-12);
  }

  system ("gfsview-batch2D gfsi.gfs < /dev/null");
}
