BEGIN {
    RS = ";";
    FS = ",";
    types[0] = "pstring";
    types[1] = "pint";
    types[2] = "punsigned";
    types[3] = "pbool";
    types[4] = "pfloat";
    types[5] = "pdouble";
    types[6] = "pdouble";
    types[7] = "pcolormap";

    format[0] = "%s";  zero[0] = "\"\"";
    format[1] = "%d";  zero[1] = "0";
    format[2] = "%d";  zero[2] = "0";
    format[3] = "%d";  zero[3] = "0";
    format[4] = "%f";  zero[4] = "0.";
    format[5] = "%lf"; zero[5] = "0.";
    format[6] = "%lf"; zero[6] = "0.";
    format[7] = "%f";  zero[7] = "0.";

    ORS = ""
    
    print "// Automatically generated by params.awk\n"
    print "// Automatically generated by params.awk\n" > "draw_json.h"
#    print "#include \"parse.h\""
}

function print1(f, args)
{
    gsub("[\"]", "\\\"", f)
    print "  i = snprintf (s, len, \"" f "\"" >> "draw_json.h"
    if (args != "")
	print ", " args  >> "draw_json.h";
    print ");\n" >> "draw_json.h"
    print "  s += i, len -= i, len1 += i;\n" >> "draw_json.h"
}

function gettype(c)
{
    if (c[2] == "*") {
	if (c[1] == "char")
	    return 0;
    }
    else if (c[1] == "int")
	return 1;
    else if (c[1] == "unsigned")
	return 2;
    else if (c[1] == "bool")
	return 3;
    else if (c[1] == "float")
	return 4;
    else if (c[1] == "double")
	return 5;
    else if (c[1] == "coord")
	return 6;
    else if (c[1] == "colormap")
	return 7;
    return -1;
}
    
/\([^)]*\)[\t\n ]*{/ {
    if (match($0, /([a-zA-Z_]+)[\t\n ]+([a-zA-Z_]+)[\t\n ]+([a-zA-Z_0-9]+)[\t\n ]*\(([^)]*)\)[\t\n ]*{/, a) &&
	a[1] == "static")
	;
    else if (match($0, /([a-zA-Z_]+)[\t\n ]+([a-zA-Z_0-9]+)[\t\n ]*\(([^)]*)\)[\t\n ]*{/, a) &&
	     a[1] != "else" && a[3] != "" && !match(a[3], /struct[ \t]+/) &&
            (a[1] == "void" || a[1] == "bool")) {
	rettype = a[1];
	name = a[2];
	params = a[3];
	print "else if (!strcmp (s, \"" name "\")) {\n"
	print "int _" name "_json (char * s, int len) {\n" >> "draw_json.h"
        print "  int i, len1 = 0;\n" >> "draw_json.h"
	print1("  \"" name "\" : {", "");
        nc = "\\n"
	n = split (params, b, ",[ \t\n]");
	for (i = 1; i <= n; i++) {
	    gsub(/^[ \t\n]+/, "", b[i]);
	    gsub(/[ \t\n]+$/, "", b[i])
	    print "  " b[i];
	    if (!match(b[i], /=/)) {
		split (b[i], c, "[ \n\t]+");
		type = gettype(c);
		if (type == 0)
		    print " = NULL";
		else if (type > 0)
		    print " = " zero[type];
	    }
	    print ";\n";
	}
	print "  Params params[] = {\n"
	for (i = 1; i <= n; i++) {
	    nf = split (b[i], c, "[ \n\t]+");
	    type = gettype(c);
	    pos = c[2] == "*" ? 3 : 2;
	    param[i] = c[pos];
	    gsub ("\\[.*\\]", "", param[i])
	    if (type >= 0) {
		d = "";
		for (j = pos; j <= nf && c[j] != "="; j++)
		    d = d c[j];
		split (d, e, ",|;");
		for (j in e) {
		    if (e[j] != "" && e[j] != "expr" && substr (e[j],1,1) != "/") {
			if (gsub ("[\\[\\]]", " ", e[j])) {
			    split (e[j], f, " ");
			    print "    {\"" f[1] "\", " types[type] ", " f[1] ", " f[2] "},\n";
			    tname = f[1] == "fc" || f[1] == "lc" ? "color" : types[type];
			    s = nc "    \"" f[1] "\": { \"type\": \"" tname \
				"\", \"cardinality\": " f[2] ", \"value\": [" format[type];
			    for (k = 1; k < f[2]; k++)
				s = s "," format[type];
			    s = s "] }";
			    s1 = zero[type]; # f[1] "[0]";
			    for (k = 1; k < f[2]; k++)
				s1 = s1 ", " zero[type]; # f[1] "[" k "]";
			    print1(s, s1);
			}
			else if (type == 6) {
			    print "    {\"" e[j] "\", " types[type] ", &" e[j] ", 3},\n";
			    print1(nc "    \"" e[j] "\": { \"type\": \"" types[type] \
				   "\", \"cardinality\": 3, \"value\": [%lf,%lf,%lf] }",
				   zero[type] ", " zero[type] ", " zero[type]);
				   # e[j] ".x, " e[j] ".y, " e[j] ".z");
			}
			else {
			    print "    {\"" e[j] "\", " types[type] ", &" e[j] "},\n";
			    if (type != 7) # colormap: fixme: does nothing for the moment
				print1(nc "    \"" e[j] "\": { \"type\": \"" types[type] \
				       "\", \"cardinality\": 1, \"value\": \"" format[type] "\" }", zero[type]); # e[j]);
			}
			nc = ",\\n";
		    }
                    
                }
	    }
	}
	print "    {NULL}\n  };\n"
	print "  if (!parse_params (params))\n"
        print "    return false;\n"
	printf "  ";
	if (rettype == "bool")
	    printf "if (!";
	printf name " (";
	for (i = 1; i <= n; i++) {
	    printf param[i];
	    if (i < n)
		printf (",");
	}
	if (rettype == "bool") {
	    print "))\n"
	    print "    return false;\n"
	}
        else
          print ");\n"
        print "}\n"
	print1("\\n  }");
        print "  return len1;\n" >> "draw_json.h"
        print "}\n" >> "draw_json.h"
    }
}
