
#line 3 "lex.yy.c"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 6
#define YY_FLEX_SUBMINOR_VERSION 4
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#ifndef SIZE_MAX
#define SIZE_MAX               (~(size_t)0)
#endif

#endif /* ! C99 */

#endif /* ! FLEXINT_H */

/* begin standard C++ headers. */

/* TODO: this is always defined, so inline it */
#define yyconst const

#if defined(__GNUC__) && __GNUC__ >= 3
#define yynoreturn __attribute__((__noreturn__))
#else
#define yynoreturn
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an
 *   integer in range [0..255] for use as an array index.
 */
#define YY_SC_TO_UI(c) ((YY_CHAR) (c))

/* An opaque pointer. */
#ifndef YY_TYPEDEF_YY_SCANNER_T
#define YY_TYPEDEF_YY_SCANNER_T
typedef void* yyscan_t;
#endif

/* For convenience, these vars (plus the bison vars far below)
   are macros in the reentrant scanner. */
#define yyin yyg->yyin_r
#define yyout yyg->yyout_r
#define yyextra yyg->yyextra_r
#define yyleng yyg->yyleng_r
#define yytext yyg->yytext_r
#define yylineno (YY_CURRENT_BUFFER_LVALUE->yy_bs_lineno)
#define yycolumn (YY_CURRENT_BUFFER_LVALUE->yy_bs_column)
#define yy_flex_debug yyg->yy_flex_debug_r

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN yyg->yy_start = 1 + 2 *
/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START ((yyg->yy_start - 1) / 2)
#define YYSTATE YY_START
/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)
/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE yyrestart( yyin , yyscanner )
#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k.
 * Moreover, YY_BUF_SIZE is 2*YY_READ_BUF_SIZE in the general case.
 * Ditto for the __ia64__ case accordingly.
 */
#define YY_BUF_SIZE 32768
#else
#define YY_BUF_SIZE 16384
#endif /* __ia64__ */
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t yy_size_t;
#endif

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2
    
    #define YY_LESS_LINENO(n)
    #define YY_LINENO_REWIND_TO(ptr)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = yyg->yy_hold_char; \
		YY_RESTORE_YY_MORE_OFFSET \
		yyg->yy_c_buf_p = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )
#define unput(c) yyunput( c, yyg->yytext_ptr , yyscanner )

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	int yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */

	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via yyrestart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( yyg->yy_buffer_stack \
                          ? yyg->yy_buffer_stack[yyg->yy_buffer_stack_top] \
                          : NULL)
/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE yyg->yy_buffer_stack[yyg->yy_buffer_stack_top]

static void yyrestart ( FILE *input_file , yyscan_t yyscanner );

static YY_BUFFER_STATE yy_create_buffer ( FILE *file, int size , yyscan_t yyscanner );
static void yy_delete_buffer ( YY_BUFFER_STATE b , yyscan_t yyscanner );
static void yy_flush_buffer ( YY_BUFFER_STATE b , yyscan_t yyscanner );

static void yypop_buffer_state ( yyscan_t yyscanner );

static void yyensure_buffer_stack ( yyscan_t yyscanner );
static void yy_load_buffer_state ( yyscan_t yyscanner );
static void yy_init_buffer ( YY_BUFFER_STATE b, FILE *file , yyscan_t yyscanner );
#define YY_FLUSH_BUFFER yy_flush_buffer( YY_CURRENT_BUFFER , yyscanner)





static void *yyalloc ( yy_size_t , yyscan_t yyscanner );
static void *yyrealloc ( void *, yy_size_t , yyscan_t yyscanner );
static void yyfree ( void * , yyscan_t yyscanner );

#define yy_new_buffer yy_create_buffer
#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        yyensure_buffer_stack (yyscanner); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer( yyin, YY_BUF_SIZE , yyscanner); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}
#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        yyensure_buffer_stack (yyscanner); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer( yyin, YY_BUF_SIZE , yyscanner); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}
#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* Begin user sect3 */

#define yywrap(yyscanner) (/*CONSTCOND*/1)
#define YY_SKIP_YYWRAP
typedef flex_uint8_t YY_CHAR;

typedef int yy_state_type;

#define yytext_ptr yytext_r

static yy_state_type yy_get_previous_state ( yyscan_t yyscanner );
static yy_state_type yy_try_NUL_trans ( yy_state_type current_state  , yyscan_t yyscanner);
static int yy_get_next_buffer ( yyscan_t yyscanner );
static void yynoreturn yy_fatal_error ( const char* msg , yyscan_t yyscanner );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	yyg->yytext_ptr = yy_bp; \
	yyleng = (int) (yy_cp - yy_bp); \
	yyg->yy_hold_char = *yy_cp; \
	*yy_cp = '\0'; \
	yyg->yy_c_buf_p = yy_cp;
#define YY_NUM_RULES 25
#define YY_END_OF_BUFFER 26
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static const flex_int16_t yy_acclist[108] =
    {   0,
       26,   22,   25,   23,   25,   22,   25,   22,   25,   22,
       25,   22,   25,   22,   25,   19,   21,   22,   25,   22,
       25,   22,   25,   19,   21,   22,   25,   19,   21,   22,
       25,   19,   21,   22,   25,   12,   22,   25,   13,   22,
       25,   22,   25,   22,   25,    3,   22,   25,    1,   24,
       20,    9,   19,   21,   17,   19,   21,   19,   21,   19,
       21,   19,   21,    3,    3,   10,   19,   21,   19,   21,
       19,   21,   19,   21,   19,   21,   19,   21,   19,   21,
       19,   21,   19,   21,   19,   21,   19,   21,   19,   21,
        2,   18,   19,   21,   19,   21,    5,   16,   19,   21,

       11,   15,    8,   14,    7,    6,    4
    } ;

static const flex_int16_t yy_accept[173] =
    {   0,
        1,    1,    1,    2,    4,    6,    8,   10,   12,   14,
       16,   20,   22,   24,   28,   32,   36,   39,   42,   44,
       46,   49,   49,   50,   50,   51,   51,   51,   51,   51,
       52,   52,   52,   53,   55,   56,   56,   56,   56,   56,
       56,   58,   60,   62,   64,   64,   64,   65,   65,   65,
       66,   66,   66,   66,   66,   66,   67,   67,   67,   67,
       67,   67,   67,   69,   71,   73,   75,   75,   75,   75,
       75,   75,   75,   75,   75,   75,   75,   75,   77,   79,
       81,   83,   83,   83,   83,   83,   83,   83,   83,   83,
       83,   83,   83,   85,   87,   89,   91,   91,   92,   92,

       92,   92,   92,   92,   92,   92,   95,   97,   97,   97,
       97,   98,   98,   98,   98,   98,  101,  101,  101,  101,
      101,  101,  101,  101,  101,  101,  101,  101,  101,  101,
      101,  101,  101,  101,  101,  101,  101,  101,  101,  102,
      102,  103,  103,  103,  103,  103,  104,  104,  104,  105,
      105,  105,  105,  105,  106,  106,  106,  107,  107,  107,
      107,  107,  107,  107,  107,  107,  107,  107,  107,  107,
      108,  108
    } ;

static const YY_CHAR yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        4,    5,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    6,    1,    7,    8,    1,    1,    9,   10,   11,
        1,   12,    1,    1,   13,   14,   15,   16,   16,   16,
       17,   16,   16,   16,   16,   18,   19,    1,   20,   21,
       22,   23,   24,   25,   18,   18,   26,   18,   18,   18,
       27,   27,   27,   27,   27,   27,   27,   27,   27,   27,
       27,   27,   27,   27,   27,   27,   27,   27,   27,   27,
        1,   28,    1,    1,   27,    1,   29,   30,   31,   32,

       33,   34,   35,   36,   37,   27,   27,   38,   39,   40,
       41,   42,   43,   44,   45,   46,   47,   48,   27,   49,
       50,   27,   51,    1,   52,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static const YY_CHAR yy_meta[53] =
    {   0,
        1,    2,    3,    2,    2,    2,    4,    1,    1,    5,
        2,    1,    6,    1,    6,    7,    7,    8,    8,    2,
        1,    1,    1,    5,    1,    8,    9,    5,    7,    7,
        8,    8,    8,    7,    9,    9,    9,    9,    9,   10,
        9,    9,    9,   10,    9,   10,    9,   10,   10,    9,
        1,    1
    } ;

static const flex_int16_t yy_base[184] =
    {   0,
        0,   51,  389,  390,  390,  384,   47,   47,    0,  375,
       58,   43,  378,   89,   34,   35,  390,  390,   71,   79,
       80,  381,  390,   76,  390,   54,  367,  336,  372,  390,
      119,  129,  390,  350,  390,  349,  373,  337,  338,   99,
       58,   57,   68,  345,  135,  105,   96,  111,  335,  112,
      341,  137,    0,  354,  331,  390,  330,  334,  337,  333,
      113,  327,  107,   95,   75,  115,  335,  331,  140,  162,
      344,  317,  330,  317,  327,  353,  327,   98,  121,  127,
      132,  319,  149,  157,    0,    0,  336,  322,  321,  347,
      307,  313,  139,  140,  141,  145,  303,  390,  340,    0,

      325,  313,  315,  301,  297,  312,  166,  310,  333,  326,
      390,  317,  300,  306,  304,  304,  301,  316,  296,  324,
      301,  307,  295,  180,  308,  317,    0,  280,  310,  196,
      197,  287,  255,  281,  227,    0,  199,  259,  390,  218,
      390,  241,  249,  248,  247,  237,  193,  213,  390,  212,
      200,  172,  172,  209,  195,  173,  390,  166,  168,  180,
      177,  183,  167,  155,  144,  169,  136,  159,   33,  390,
      390,  221,  231,  241,  250,  257,  261,  269,  274,  284,
      294,  304,  314
    } ;

static const flex_int16_t yy_def[184] =
    {   0,
      171,    1,  171,  171,  171,  172,  173,  171,  174,  171,
      175,  171,  171,  175,   14,   14,  171,  171,  171,  171,
      171,  172,  171,  173,  171,  176,  171,  171,  171,  171,
      171,  171,  171,   14,  171,  171,  171,  171,  171,  171,
       14,   14,   14,   14,  171,  171,  171,  171,  171,  171,
      171,  173,  177,  171,  171,  171,  171,  171,  171,  171,
      171,  171,   14,   14,   14,   14,  171,  171,  173,  173,
      171,  171,  171,  171,  171,  171,  171,   14,   14,   14,
       14,  171,  171,  173,   70,  178,  171,  171,  171,  171,
      171,  171,   14,   14,   14,   14,  171,  171,  171,  179,

      171,  171,  171,  171,  171,   14,   14,  171,  171,  179,
      171,  171,  171,  171,  171,   14,  171,  171,  171,  171,
      171,  171,  171,  171,  171,  171,  180,  171,  171,  171,
      171,  171,  171,  180,  171,  181,  171,  182,  171,  171,
      171,  171,  181,  183,  182,  182,  171,  171,  171,  183,
      183,  171,  171,  183,  171,  171,  171,  171,  171,  171,
      171,  171,  171,  171,  171,  171,  171,  171,  171,  171,
        0,  171,  171,  171,  171,  171,  171,  171,  171,  171,
      171,  171,  171
    } ;

static const flex_int16_t yy_nxt[443] =
    {   0,
        4,    4,    5,    6,    4,    4,    7,    4,    8,    9,
        4,    4,    4,    4,   10,   11,   11,   11,   11,    4,
       12,    4,   13,    4,    4,   11,   11,    4,   11,   11,
       11,   11,   11,   11,   11,   11,   11,   11,   11,   11,
       11,   11,   11,   11,   14,   15,   11,   16,   11,   11,
       17,   18,   19,   25,   27,  170,   19,   36,   20,   31,
       32,   32,   32,   31,   34,   34,   42,   44,   33,   52,
       52,   37,   45,   38,   26,   21,   45,   35,   46,   39,
       48,   50,   25,   43,   48,   50,   63,   34,   34,   28,
       31,   32,   32,   32,   31,   47,   64,   50,   34,   33,

       61,   50,   53,   26,   61,   34,   48,   80,   35,   65,
       48,   51,   48,   50,   61,   49,   48,   50,   61,   41,
       31,   32,   32,   32,   31,   34,   93,   51,   34,   33,
       32,   32,   32,   32,   32,   62,   45,   34,   35,   79,
       45,   49,   46,   25,   78,   34,   25,   49,   35,   62,
       98,   34,   69,   69,   98,   84,   84,   34,   95,   47,
       81,   94,   34,   25,   26,  169,  168,   26,   25,   34,
       34,   34,   96,  107,  167,   34,  166,   85,   85,   85,
       85,  131,  106,  106,   26,  131,  165,   85,  106,   26,
       85,   85,   85,   85,   85,   85,   34,  137,  131,  116,

      137,  137,  131,  138,  137,  144,  151,  164,  163,  162,
      161,  160,  159,  158,  157,  151,  156,  155,  151,  153,
      154,   22,   22,   22,   22,   22,   22,   22,   22,   22,
       22,   24,   24,  152,   24,   24,   24,   24,   24,   24,
       24,   29,   29,  146,   29,   29,   29,   29,   29,   29,
       29,   34,   34,  146,  151,  149,   34,   34,   34,   34,
       24,   24,  148,   24,  147,  146,   24,   70,   70,   99,
       99,  142,   99,   99,   99,   99,   99,   99,   99,  110,
      110,  110,  110,  110,  134,  134,  134,  141,  134,  134,
      134,  134,  134,  134,  143,  143,  143,  140,  143,  143,

      143,  143,  143,  143,  145,  145,  139,  145,  145,  145,
      145,  145,  145,  145,  150,  150,  136,  150,  150,  150,
      150,  150,  150,  150,  135,  133,  132,  130,  129,  128,
      127,  126,  125,  124,   34,  123,  122,  121,  120,  119,
      118,  117,   34,  115,  114,  113,  112,  111,  109,  108,
      105,  104,  103,  102,  101,  100,   97,   92,   91,   90,
       89,   88,   87,   86,   83,   82,   77,   76,   75,   74,
       73,   72,   71,   68,   67,   66,   60,   59,   58,   57,
       34,   56,   55,   54,   23,   40,   30,   23,  171,    3,
      171,  171,  171,  171,  171,  171,  171,  171,  171,  171,

      171,  171,  171,  171,  171,  171,  171,  171,  171,  171,
      171,  171,  171,  171,  171,  171,  171,  171,  171,  171,
      171,  171,  171,  171,  171,  171,  171,  171,  171,  171,
      171,  171,  171,  171,  171,  171,  171,  171,  171,  171,
      171,  171
    } ;

static const flex_int16_t yy_chk[443] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    2,    7,    8,  169,    2,   12,    2,   11,
       11,   11,   11,   11,   15,   16,   15,   16,   11,   26,
       26,   12,   19,   12,    7,    2,   19,   11,   19,   12,
       20,   21,   24,   15,   20,   21,   41,   42,   41,    8,
       14,   14,   14,   14,   14,   19,   42,   47,   43,   14,

       40,   47,   26,   24,   40,   65,   46,   65,   14,   43,
       46,   21,   48,   50,   61,   20,   48,   50,   61,   14,
       31,   31,   31,   31,   31,   64,   78,   47,   78,   31,
       32,   32,   32,   32,   32,   40,   45,   63,   31,   64,
       45,   46,   45,   52,   63,   66,   69,   48,   32,   61,
       83,   79,   52,   52,   83,   69,   69,   80,   80,   45,
       66,   79,   81,   84,   52,  168,  167,   69,   70,   93,
       94,   95,   81,   95,  166,   96,  165,   70,   70,   70,
       70,  124,   93,   94,   84,  124,  164,   70,   96,   70,
       70,   70,   70,   70,   70,   70,  107,  130,  131,  107,

      137,  130,  131,  131,  137,  137,  151,  163,  162,  161,
      160,  159,  158,  156,  155,  154,  153,  152,  150,  148,
      151,  172,  172,  172,  172,  172,  172,  172,  172,  172,
      172,  173,  173,  147,  173,  173,  173,  173,  173,  173,
      173,  174,  174,  146,  174,  174,  174,  174,  174,  174,
      174,  175,  175,  145,  144,  143,  175,  175,  175,  175,
      176,  176,  142,  176,  140,  138,  176,  177,  177,  178,
      178,  135,  178,  178,  178,  178,  178,  178,  178,  179,
      179,  179,  179,  179,  180,  180,  180,  134,  180,  180,
      180,  180,  180,  180,  181,  181,  181,  133,  181,  181,

      181,  181,  181,  181,  182,  182,  132,  182,  182,  182,
      182,  182,  182,  182,  183,  183,  129,  183,  183,  183,
      183,  183,  183,  183,  128,  126,  125,  123,  122,  121,
      120,  119,  118,  117,  116,  115,  114,  113,  112,  110,
      109,  108,  106,  105,  104,  103,  102,  101,   99,   97,
       92,   91,   90,   89,   88,   87,   82,   77,   76,   75,
       74,   73,   72,   71,   68,   67,   62,   60,   59,   58,
       57,   55,   54,   51,   49,   44,   39,   38,   37,   36,
       34,   29,   28,   27,   22,   13,   10,    6,    3,  171,
      171,  171,  171,  171,  171,  171,  171,  171,  171,  171,

      171,  171,  171,  171,  171,  171,  171,  171,  171,  171,
      171,  171,  171,  171,  171,  171,  171,  171,  171,  171,
      171,  171,  171,  171,  171,  171,  171,  171,  171,  171,
      171,  171,  171,  171,  171,  171,  171,  171,  171,  171,
      171,  171
    } ;

#define REJECT \
{ \
*yy_cp = yyg->yy_hold_char; /* undo effects of setting up yytext */ \
yy_cp = yyg->yy_full_match; /* restore poss. backed-over text */ \
++yyg->yy_lp; \
goto find_rule; \
}

#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
#line 1 "codeblock.lex"
#line 3 "codeblock.lex"
  #include <stdlib.h>
   
  #undef YY_BUF_SIZE
  #define YY_BUF_SIZE 262144

  typedef struct {
    char id[80], file[512], line[80];
  } Tag;

  struct MyScanner {
    char * page;
    Tag * decl, * call, * incl;
    int ndecl, ncall, nincl;
    int i, intypedef, intypedefscope, scope;
    int incode;
  };

  typedef struct { char * s, * sub; } Subst;

  #define lookup_decl(x) lookup_tag(x, yyextra->decl, yyextra->ndecl);
  #define lookup_call(x) lookup_tag(x, yyextra->call, yyextra->ncall);
  static Tag * lookup_tag (const char * id, Tag * tags, int ntags) {
    int i;
    for (i = 0; i < ntags; i++)
      if (!strcmp (id, tags[i].id))
	return &tags[i];
    return NULL;
  }

  #define output_c(c) putchar(c)
  #define echo() output_s(yytext)
  #define output_s(s) fputs(s, stdout)

  static char * baseurl = "", * ext = NULL, * basilisk_url = NULL;

  char * url (char * s, char * baseurl)
  {
    static char s1[256];
    if (s[0] == '/') {
      // assert (strlen(baseurl) + strlen(s) + 1) < 256;
      char * root = getenv ("DOCUMENT_ROOT");
      if (root && s[strlen(root)] == '/' && !strncmp (root, s, strlen(root)))
	s += strlen(root);
      strcat (strcpy (s1, baseurl), s);
    }
    else
      strcpy (s1, s);
    if (ext) {
      char page[strlen(s1) + strlen (".page") + 1];
      strcpy (page, s1);
      char * anchor = strchr (page, '#');
      if (anchor)
	*anchor = '\0';
      strcat (page, ".page");
      // fprintf (stderr, "testing '%s'\n", page);
      FILE * fp = fopen (page, "r");
      if (fp) {
	if (anchor) {
	  strcpy (page, s1);
	  *strchr (s1, '#') = '\0';
	  strcat (s1, ".html");
	  strcat (s1, anchor);
	}
	else
	  strcat (s1, ".html");
	fclose (fp);
      }
    }
    return s1;
  }

# define INCODE() (yyextra->incode)
  
  static int check_tag (char * text, struct MyScanner * scan) {
    Tag * t = lookup_tag (text, scan->call, scan->ncall);
    if (t) {
      // link to another page
      output_s ("<a href=");
      if (!strcmp(t->file, "stdlib")) {
	output_s ("http://man7.org/linux/man-pages/man3/");
	output_s (text);
	output_s (".3.html");
      }
      else if (!strcmp(t->file, "basilisk")) {
	output_s (url ("/Basilisk%20C", basilisk_url));
	output_c ('#');
	output_s (t->line);
      }
      else {
	output_s (url (t->file, basilisk_url));
	output_c ('#');
	char s1[256];
	if (t->file[0] == '/')
	  strcat (strcpy (s1, baseurl), t->file);
	else
	  strcpy (s1, t->file);
	output_s (t->line);
      }
      output_s (">");
      output_s (text);
      output_s ("</a" ">");
    }
    return (t != NULL);
  }

  static char * append_c (char * tmp, int c) {
    int len = strlen(tmp);
    tmp = realloc (tmp, len + 2);
    tmp[len] = c; tmp[len+1] = '\0';
    return tmp;
  }

  static char * append_s (char * tmp, char * s) {
    while (*s)
      tmp = append_c (tmp, *s++);
    return tmp;
  }

  #define nonspace(s) { while (strchr(" \t\v\n\f", *s)) s++; }
  #define space(s) { while (!strchr(" \t\v\n\f", *s)) s++; }
  static void comment(yyscan_t scanner);
#line 720 "lex.yy.c"
#line 721 "lex.yy.c"

#define INITIAL 0

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#define YY_EXTRA_TYPE struct MyScanner *

/* Holds the entire state of the reentrant scanner. */
struct yyguts_t
    {

    /* User-defined. Not touched by flex. */
    YY_EXTRA_TYPE yyextra_r;

    /* The rest are the same as the globals declared in the non-reentrant scanner. */
    FILE *yyin_r, *yyout_r;
    size_t yy_buffer_stack_top; /**< index of top of stack. */
    size_t yy_buffer_stack_max; /**< capacity of stack. */
    YY_BUFFER_STATE * yy_buffer_stack; /**< Stack as an array. */
    char yy_hold_char;
    int yy_n_chars;
    int yyleng_r;
    char *yy_c_buf_p;
    int yy_init;
    int yy_start;
    int yy_did_buffer_switch_on_eof;
    int yy_start_stack_ptr;
    int yy_start_stack_depth;
    int *yy_start_stack;
    yy_state_type yy_last_accepting_state;
    char* yy_last_accepting_cpos;

    int yylineno_r;
    int yy_flex_debug_r;

    yy_state_type *yy_state_buf;
    yy_state_type *yy_state_ptr;
    char *yy_full_match;
    int yy_lp;

    /* These are only needed for trailing context rules,
     * but there's no conditional variable for that yet. */
    int yy_looking_for_trail_begin;
    int yy_full_lp;
    int *yy_full_state;

    char *yytext_r;
    int yy_more_flag;
    int yy_more_len;

    }; /* end struct yyguts_t */

static int yy_init_globals ( yyscan_t yyscanner );



static int yylex_init_extra ( YY_EXTRA_TYPE user_defined, yyscan_t* scanner);

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

static int yylex_destroy ( yyscan_t yyscanner );



static void yyset_debug ( int debug_flag , yyscan_t yyscanner );

static YY_EXTRA_TYPE yyget_extra ( yyscan_t yyscanner );

static void yyset_extra ( YY_EXTRA_TYPE user_defined , yyscan_t yyscanner );



static void yyset_in  ( FILE * _in_str , yyscan_t yyscanner );



static void yyset_out  ( FILE * _out_str , yyscan_t yyscanner );













/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int yywrap ( yyscan_t yyscanner );
#else
extern int yywrap ( yyscan_t yyscanner );
#endif
#endif

#ifndef YY_NO_UNPUT
    
    static void yyunput ( int c, char *buf_ptr  , yyscan_t yyscanner);
    
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy ( char *, const char *, int , yyscan_t yyscanner);
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen ( const char * , yyscan_t yyscanner);
#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
static int yyinput ( yyscan_t yyscanner );
#else
static int input ( yyscan_t yyscanner );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k */
#define YY_READ_BUF_SIZE 16384
#else
#define YY_READ_BUF_SIZE 8192
#endif /* __ia64__ */
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO do { if (fwrite( yytext, (size_t) yyleng, 1, yyout )) {} } while (0)
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		int n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = (int) fread(buf, 1, (yy_size_t) max_size, yyin)) == 0 && ferror(yyin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(yyin); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg , yyscanner)
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

static int yylex (yyscan_t yyscanner);

#define YY_DECL int yylex (yyscan_t yyscanner)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK /*LINTED*/break;
#endif

#define YY_RULE_SETUP \
	if ( yyleng > 0 ) \
		YY_CURRENT_BUFFER_LVALUE->yy_at_bol = \
				(yytext[yyleng - 1] == '\n'); \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	yy_state_type yy_current_state;
	char *yy_cp, *yy_bp;
	int yy_act;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	if ( !yyg->yy_init )
		{
		yyg->yy_init = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

        /* Create the reject buffer large enough to save one state per allowed character. */
        if ( ! yyg->yy_state_buf )
            yyg->yy_state_buf = (yy_state_type *)yyalloc(YY_STATE_BUF_SIZE  , yyscanner);
            if ( ! yyg->yy_state_buf )
                YY_FATAL_ERROR( "out of dynamic memory in yylex()" );

		if ( ! yyg->yy_start )
			yyg->yy_start = 1;	/* first start state */

		if ( ! yyin )
			yyin = stdin;

		if ( ! yyout )
			yyout = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			yyensure_buffer_stack (yyscanner);
			YY_CURRENT_BUFFER_LVALUE =
				yy_create_buffer( yyin, YY_BUF_SIZE , yyscanner);
		}

		yy_load_buffer_state( yyscanner );
		}

	{
#line 132 "codeblock.lex"


#line 1002 "lex.yy.c"

	while ( /*CONSTCOND*/1 )		/* loops until end-of-file is reached */
		{
		yy_cp = yyg->yy_c_buf_p;

		/* Support of yytext. */
		*yy_cp = yyg->yy_hold_char;

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = yyg->yy_start;
		yy_current_state += YY_AT_BOL();

		yyg->yy_state_ptr = yyg->yy_state_buf;
		*yyg->yy_state_ptr++ = yy_current_state;

yy_match:
		do
			{
			YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)] ;
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 172 )
					yy_c = yy_meta[yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
			*yyg->yy_state_ptr++ = yy_current_state;
			++yy_cp;
			}
		while ( yy_base[yy_current_state] != 390 );

yy_find_action:
		yy_current_state = *--yyg->yy_state_ptr;
		yyg->yy_lp = yy_accept[yy_current_state];

find_rule: /* we branch to this label when backing up */

		for ( ; ; ) /* until we find what rule we matched */
			{
			if ( yyg->yy_lp && yyg->yy_lp < yy_accept[yy_current_state + 1] )
				{
				yy_act = yy_acclist[yyg->yy_lp];
					{
					yyg->yy_full_match = yy_cp;
					break;
					}
				}
			--yy_cp;
			yy_current_state = *--yyg->yy_state_ptr;
			yyg->yy_lp = yy_accept[yy_current_state];
			}

		YY_DO_BEFORE_ACTION;

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
case 1:
/* rule 1 can match eol */
YY_RULE_SETUP
#line 134 "codeblock.lex"
{
  // code line numbers
  output_s ("<span id=");
  char * s = yytext;
  while (*s) {
    if (strchr ("0123456789", *s))
      output_c (*s);
    s++;
  }
  output_s ("></span>");
}
	YY_BREAK
case 2:
YY_RULE_SETUP
#line 146 "codeblock.lex"
{
  yyextra->incode = 0; echo();
}
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 150 "codeblock.lex"
{
  yyextra->incode = 1; echo();
}
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 154 "codeblock.lex"
{
  yyextra->incode = 1; echo();
}
	YY_BREAK
case 5:
YY_RULE_SETUP
#line 158 "codeblock.lex"
{
  yyextra->incode = 0; echo();
}
	YY_BREAK
case 6:
#line 163 "codeblock.lex"
case 7:
#line 164 "codeblock.lex"
case 8:
YY_RULE_SETUP
#line 164 "codeblock.lex"
{
  if (!INCODE())
    REJECT;
  // add HTML links in include headers
  char c = '"', * s = strchr(yytext, c);
  if (!s)
    c = ';', s = strchr(yytext, c);
  *s++ = '\0';
  char c1 = '"', * s1 = strchr(s, c1);
  if (!s1)
    c1 = '&', s1 = strchr(s, c1);
  *s1++ = '\0';
  // look for header in tags
  char * header = NULL;
  int i = 0;
  for (i = 0; i < yyextra->nincl && !header; i++)
    if (strstr(yyextra->incl[i].id, s))
      header = yyextra->incl[i].id;
  echo();
  output_c (c);
  if (header) {
    output_s ("<a href=");
    output_s (url (header, basilisk_url));
    output_s (">");
  }
  output_s (s);
  if (header)
    output_s ("</a" ">");
  else
    fprintf (stderr, 
	     "codeblock: warning: %s: tag for \"%s\" not found\n",
	     yyextra->page, s);
  output_c (c1);
  output_s (s1);
}
	YY_BREAK
case 9:
YY_RULE_SETUP
#line 200 "codeblock.lex"
{
  if (!INCODE() || yyextra->scope > 0)
    REJECT;
  // keyword  anchor (function definition)
  // this regexp needs to match that in src/include.lex (for tags)
  char * s = strdup(yytext), * s1 = s;
  while (!strchr(" \t\v\n\f(", *s1)) s1++;
  int c = *s1;
  *s1++ = '\0';
  char * tmp = malloc (sizeof(char)); *tmp = '\0';
  int p = 0, para = 1, c1;
  while (para > p && (c1 = input(yyscanner)) > 0) {
    if (c1 == '\v') {
      // line number
      tmp = append_s (tmp, "<span id=");
      while ((c1 = input(yyscanner)) > 0 && c1 != '\v')
	if (strchr ("0123456789", c1))
	  tmp = append_c (tmp, c1);
      tmp = append_s (tmp, "></span>");
    }
    else {
      tmp = append_c (tmp, c1);
      if (c1 == '(') para++;
      else if (c1 == ')') para--;
    }
  }
  if (c1 != ')') {
    output_s (s);
  }
  else {
    while ((c1 = input(yyscanner)) > 0) {
      if (c1 == '\v') {
	// line number
	tmp = append_s (tmp, "<span id=");
	while ((c1 = input(yyscanner)) > 0 && c1 != '\v')
	  if (strchr ("0123456789", c1))
	    tmp = append_c (tmp, c1);
	tmp = append_s (tmp, "></span>");
      }
      else {
	tmp = append_c (tmp, c1);
	if (c1 == '{' || c1 == ';')
	  break;
	if (!strchr(" \t\v\n\f", c1))
	  break;
      }
    }
    if (c1 != '{') {
      output_s (s);
    }
    else {
      yyextra->scope++;
      Tag * t = lookup_decl (s);
      if (t == NULL || !strstr (yyextra->page, t->file)) {
	if (t != NULL)
	  fprintf (stderr, "file: %s page: %s\n", t->file, yyextra->page);
#if 1
	fprintf (stderr, 
		 "codeblock: warning: %s: tag for '%s' not found\n",
		 yyextra->page, s);
#endif
	output_s (s);
      }
      else
	printf ("<a id=%s>%s</a>", t->id, s);
    }
  }
  output_c (c);
  output_s (s1);
  output_s (tmp);
  free (tmp);
  free (s);
}
	YY_BREAK
case 10:
YY_RULE_SETUP
#line 274 "codeblock.lex"
{
  echo(); // quoted character
}
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 278 "codeblock.lex"
{
  echo(); // quoted character in HTML
}
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 282 "codeblock.lex"
{
  echo();
  yyextra->scope++;
}
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 287 "codeblock.lex"
{
  echo();
  yyextra->scope--;
  if (yyextra->scope < 0) {
    fprintf (stderr, "warning: %s: error: mismatched '}'\n", yyextra->page);
    yyextra->scope = 0;
  }
}
	YY_BREAK
case 14:
/* rule 14 can match eol */
#line 297 "codeblock.lex"
case 15:
/* rule 15 can match eol */
YY_RULE_SETUP
#line 297 "codeblock.lex"
{
  // URL
  yytext[strlen(yytext) - 1] = '\0';
  char * u = strchr (yytext, '"');
  *u = '\0';
  output_s (yytext);
  output_c ('"');
  output_s (url (u + 1, baseurl));
  output_c ('"');
}
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 308 "codeblock.lex"
{
  if (!INCODE())
    REJECT;
  echo();
  yyextra->intypedef = 1; yyextra->intypedefscope = yyextra->scope;
}
	YY_BREAK
case 17:
/* rule 17 can match eol */
YY_RULE_SETUP
#line 315 "codeblock.lex"
{
  if (!INCODE())
    REJECT;
  // keyword  anchor (typedef)
  // this regexp needs to match that in src/include.lex (for tags)
  if (yyextra->intypedef && yyextra->intypedefscope == yyextra->scope) {
    char * s = yytext; space(s); *s-- = '\0';
    if (*s == ';')
      *s = '\0';
    yyextra->intypedef = 0;
    s = yytext;
    Tag * t = lookup_decl (s);
    if (t == NULL || !strstr (yyextra->page, t->file)) {
      if (t != NULL)
	fprintf (stderr, "file: %s page: %s\n", t->file, yyextra->page);
      fprintf (stderr, 
	       "codeblock: warning: %s: tag for '%s' not found\n",
	       yyextra->page, s);
      output_s (s);
    }
    else
      printf ("<a id=%s>%s</a>", t->id, s);
    output_c (';');
  }
  else
    REJECT;  
}
	YY_BREAK
case 18:
YY_RULE_SETUP
#line 343 "codeblock.lex"
{
  output_s ("<span class=\"dt\">");
  echo();
  output_s ("</span>");
}
	YY_BREAK
case 19:
YY_RULE_SETUP
#line 349 "codeblock.lex"
{
  if (!INCODE())
    REJECT;
  // keyword links
  if (!check_tag (yytext, yyextra))
    REJECT;
}
	YY_BREAK
case 20:
YY_RULE_SETUP
#line 357 "codeblock.lex"
{
  if (!INCODE())
    REJECT;
  echo();
  comment(yyscanner);
}
	YY_BREAK
case 21:
YY_RULE_SETUP
#line 364 "codeblock.lex"
echo();
	YY_BREAK
case 22:
YY_RULE_SETUP
#line 365 "codeblock.lex"
echo();
	YY_BREAK
case 23:
/* rule 23 can match eol */
YY_RULE_SETUP
#line 366 "codeblock.lex"
echo();
	YY_BREAK
case 24:
YY_RULE_SETUP
#line 367 "codeblock.lex"
{ echo(); /* STRING_LITERAL */ }
	YY_BREAK
case 25:
YY_RULE_SETUP
#line 369 "codeblock.lex"
ECHO;
	YY_BREAK
#line 1379 "lex.yy.c"
			case YY_STATE_EOF(INITIAL):
				yyterminate();

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - yyg->yytext_ptr) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = yyg->yy_hold_char;
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * yylex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			yyg->yy_n_chars = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = yyin;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( yyg->yy_c_buf_p <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			yyg->yy_c_buf_p = yyg->yytext_ptr + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state( yyscanner );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state , yyscanner);

			yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++yyg->yy_c_buf_p;
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = yyg->yy_c_buf_p;
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer( yyscanner ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				yyg->yy_did_buffer_switch_on_eof = 0;

				if ( yywrap( yyscanner ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					yyg->yy_c_buf_p = yyg->yytext_ptr + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! yyg->yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				yyg->yy_c_buf_p =
					yyg->yytext_ptr + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state( yyscanner );

				yy_cp = yyg->yy_c_buf_p;
				yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				yyg->yy_c_buf_p =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars];

				yy_current_state = yy_get_previous_state( yyscanner );

				yy_cp = yyg->yy_c_buf_p;
				yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
	} /* end of user's declarations */
} /* end of yylex */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int yy_get_next_buffer (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	char *source = yyg->yytext_ptr;
	int number_to_move, i;
	int ret_val;

	if ( yyg->yy_c_buf_p > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( yyg->yy_c_buf_p - yyg->yytext_ptr - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) (yyg->yy_c_buf_p - yyg->yytext_ptr - 1);

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars = 0;

	else
		{
			int num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			YY_FATAL_ERROR(
"input buffer overflow, can't enlarge buffer because scanner uses REJECT" );

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			yyg->yy_n_chars, num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars;
		}

	if ( yyg->yy_n_chars == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			yyrestart( yyin  , yyscanner);
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if ((yyg->yy_n_chars + number_to_move) > YY_CURRENT_BUFFER_LVALUE->yy_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		int new_size = yyg->yy_n_chars + number_to_move + (yyg->yy_n_chars >> 1);
		YY_CURRENT_BUFFER_LVALUE->yy_ch_buf = (char *) yyrealloc(
			(void *) YY_CURRENT_BUFFER_LVALUE->yy_ch_buf, (yy_size_t) new_size , yyscanner );
		if ( ! YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in yy_get_next_buffer()" );
		/* "- 2" to take care of EOB's */
		YY_CURRENT_BUFFER_LVALUE->yy_buf_size = (int) (new_size - 2);
	}

	yyg->yy_n_chars += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars + 1] = YY_END_OF_BUFFER_CHAR;

	yyg->yytext_ptr = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    static yy_state_type yy_get_previous_state (yyscan_t yyscanner)
{
	yy_state_type yy_current_state;
	char *yy_cp;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	yy_current_state = yyg->yy_start;
	yy_current_state += YY_AT_BOL();

	yyg->yy_state_ptr = yyg->yy_state_buf;
	*yyg->yy_state_ptr++ = yy_current_state;

	for ( yy_cp = yyg->yytext_ptr + YY_MORE_ADJ; yy_cp < yyg->yy_c_buf_p; ++yy_cp )
		{
		YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 172 )
				yy_c = yy_meta[yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
		*yyg->yy_state_ptr++ = yy_current_state;
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state , yyscan_t yyscanner)
{
	int yy_is_jam;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner; /* This var may be unused depending upon options. */

	YY_CHAR yy_c = 1;
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 172 )
			yy_c = yy_meta[yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
	yy_is_jam = (yy_current_state == 171);
	if ( ! yy_is_jam )
		*yyg->yy_state_ptr++ = yy_current_state;

	(void)yyg;
	return yy_is_jam ? 0 : yy_current_state;
}

#ifndef YY_NO_UNPUT

    static void yyunput (int c, char * yy_bp , yyscan_t yyscanner)
{
	char *yy_cp;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

    yy_cp = yyg->yy_c_buf_p;

	/* undo effects of setting up yytext */
	*yy_cp = yyg->yy_hold_char;

	if ( yy_cp < YY_CURRENT_BUFFER_LVALUE->yy_ch_buf + 2 )
		{ /* need to shift things up to make room */
		/* +2 for EOB chars. */
		int number_to_move = yyg->yy_n_chars + 2;
		char *dest = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[
					YY_CURRENT_BUFFER_LVALUE->yy_buf_size + 2];
		char *source =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move];

		while ( source > YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			*--dest = *--source;

		yy_cp += (int) (dest - source);
		yy_bp += (int) (dest - source);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars =
			yyg->yy_n_chars = (int) YY_CURRENT_BUFFER_LVALUE->yy_buf_size;

		if ( yy_cp < YY_CURRENT_BUFFER_LVALUE->yy_ch_buf + 2 )
			YY_FATAL_ERROR( "flex scanner push-back overflow" );
		}

	*--yy_cp = (char) c;

	yyg->yytext_ptr = yy_bp;
	yyg->yy_hold_char = *yy_cp;
	yyg->yy_c_buf_p = yy_cp;
}

#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (yyscan_t yyscanner)
#else
    static int input  (yyscan_t yyscanner)
#endif

{
	int c;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	*yyg->yy_c_buf_p = yyg->yy_hold_char;

	if ( *yyg->yy_c_buf_p == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( yyg->yy_c_buf_p < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars] )
			/* This was really a NUL. */
			*yyg->yy_c_buf_p = '\0';

		else
			{ /* need more input */
			int offset = (int) (yyg->yy_c_buf_p - yyg->yytext_ptr);
			++yyg->yy_c_buf_p;

			switch ( yy_get_next_buffer( yyscanner ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					yyrestart( yyin , yyscanner);

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( yywrap( yyscanner ) )
						return 0;

					if ( ! yyg->yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput(yyscanner);
#else
					return input(yyscanner);
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					yyg->yy_c_buf_p = yyg->yytext_ptr + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) yyg->yy_c_buf_p;	/* cast for 8-bit char's */
	*yyg->yy_c_buf_p = '\0';	/* preserve yytext */
	yyg->yy_hold_char = *++yyg->yy_c_buf_p;

	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = (c == '\n');

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * @param yyscanner The scanner object.
 * @note This function does not reset the start condition to @c INITIAL .
 */
static void yyrestart  (FILE * input_file , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	if ( ! YY_CURRENT_BUFFER ){
        yyensure_buffer_stack (yyscanner);
		YY_CURRENT_BUFFER_LVALUE =
            yy_create_buffer( yyin, YY_BUF_SIZE , yyscanner);
	}

	yy_init_buffer( YY_CURRENT_BUFFER, input_file , yyscanner);
	yy_load_buffer_state( yyscanner );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * @param yyscanner The scanner object.
 */
































static void yy_load_buffer_state  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	yyg->yy_n_chars = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	yyg->yytext_ptr = yyg->yy_c_buf_p = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	yyin = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	yyg->yy_hold_char = *yyg->yy_c_buf_p;
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * @param yyscanner The scanner object.
 * @return the allocated buffer state.
 */
static YY_BUFFER_STATE yy_create_buffer  (FILE * file, int  size , yyscan_t yyscanner)
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) yyalloc( sizeof( struct yy_buffer_state ) , yyscanner );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) yyalloc( (yy_size_t) (b->yy_buf_size + 2) , yyscanner );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_is_our_buffer = 1;

	yy_init_buffer( b, file , yyscanner);

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with yy_create_buffer()
 * @param yyscanner The scanner object.
 */
static void yy_delete_buffer (YY_BUFFER_STATE  b , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		yyfree( (void *) b->yy_ch_buf , yyscanner );

	yyfree( (void *) b , yyscanner );
}

/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a yyrestart() or at EOF.
 */
    static void yy_init_buffer  (YY_BUFFER_STATE  b, FILE * file , yyscan_t yyscanner)

{
	int oerrno = errno;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	yy_flush_buffer( b , yyscanner);

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then yy_init_buffer was _probably_
     * called from yyrestart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

        b->yy_is_interactive = file ? (isatty( fileno(file) ) > 0) : 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * @param yyscanner The scanner object.
 */
static void yy_flush_buffer (YY_BUFFER_STATE  b , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		yy_load_buffer_state( yyscanner );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  @param yyscanner The scanner object.
 */



























/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  @param yyscanner The scanner object.
 */
static void yypop_buffer_state (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	if (!YY_CURRENT_BUFFER)
		return;

	yy_delete_buffer(YY_CURRENT_BUFFER , yyscanner);
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if (yyg->yy_buffer_stack_top > 0)
		--yyg->yy_buffer_stack_top;

	if (YY_CURRENT_BUFFER) {
		yy_load_buffer_state( yyscanner );
		yyg->yy_did_buffer_switch_on_eof = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void yyensure_buffer_stack (yyscan_t yyscanner)
{
	yy_size_t num_to_alloc;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	if (!yyg->yy_buffer_stack) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
      num_to_alloc = 1; /* After all that talk, this was set to 1 anyways... */
		yyg->yy_buffer_stack = (struct yy_buffer_state**)yyalloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								, yyscanner);
		if ( ! yyg->yy_buffer_stack )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		memset(yyg->yy_buffer_stack, 0, num_to_alloc * sizeof(struct yy_buffer_state*));

		yyg->yy_buffer_stack_max = num_to_alloc;
		yyg->yy_buffer_stack_top = 0;
		return;
	}

	if (yyg->yy_buffer_stack_top >= (yyg->yy_buffer_stack_max) - 1){

		/* Increase the buffer to prepare for a possible push. */
		yy_size_t grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = yyg->yy_buffer_stack_max + grow_size;
		yyg->yy_buffer_stack = (struct yy_buffer_state**)yyrealloc
								(yyg->yy_buffer_stack,
								num_to_alloc * sizeof(struct yy_buffer_state*)
								, yyscanner);
		if ( ! yyg->yy_buffer_stack )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset(yyg->yy_buffer_stack + yyg->yy_buffer_stack_max, 0, grow_size * sizeof(struct yy_buffer_state*));
		yyg->yy_buffer_stack_max = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object.
 */





























/** Setup the input buffer state to scan a string. The next call to yylex() will
 * scan from a @e copy of @a str.
 * @param yystr a NUL-terminated string to scan
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       yy_scan_bytes() instead.
 */






/** Setup the input buffer state to scan the given bytes. The next call to yylex() will
 * scan from a @e copy of @a bytes.
 * @param yybytes the byte buffer to scan
 * @param _yybytes_len the number of bytes in the buffer pointed to by @a bytes.
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object.
 */






























#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void yynoreturn yy_fatal_error (const char* msg , yyscan_t yyscanner)
{
	struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	(void)yyg;
	fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		yytext[yyleng] = yyg->yy_hold_char; \
		yyg->yy_c_buf_p = yytext + yyless_macro_arg; \
		yyg->yy_hold_char = *yyg->yy_c_buf_p; \
		*yyg->yy_c_buf_p = '\0'; \
		yyleng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the user-defined data for this scanner.
 * @param yyscanner The scanner object.
 */
static YY_EXTRA_TYPE yyget_extra  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyextra;
}

/** Get the current line number.
 * @param yyscanner The scanner object.
 */










/** Get the current column number.
 * @param yyscanner The scanner object.
 */










/** Get the input stream.
 * @param yyscanner The scanner object.
 */






/** Get the output stream.
 * @param yyscanner The scanner object.
 */






/** Get the length of the current token.
 * @param yyscanner The scanner object.
 */






/** Get the current token.
 * @param yyscanner The scanner object.
 */







/** Set the user-defined data. This data is never touched by the scanner.
 * @param user_defined The data to be associated with this scanner.
 * @param yyscanner The scanner object.
 */
static void yyset_extra (YY_EXTRA_TYPE  user_defined , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yyextra = user_defined ;
}

/** Set the current line number.
 * @param _line_number line number
 * @param yyscanner The scanner object.
 */











/** Set the current column.
 * @param _column_no column number
 * @param yyscanner The scanner object.
 */











/** Set the input stream. This does not discard the current
 * input buffer.
 * @param _in_str A readable stream.
 * @param yyscanner The scanner object.
 * @see yy_switch_to_buffer
 */
static void yyset_in (FILE *  _in_str , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yyin = _in_str ;
}

static void yyset_out (FILE *  _out_str , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yyout = _out_str ;
}







static void yyset_debug (int  _bdebug , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yy_flex_debug = _bdebug ;
}

/* Accessor methods for yylval and yylloc */

/* User-visible API */

/* yylex_init is special because it creates the scanner itself, so it is
 * the ONLY reentrant function that doesn't take the scanner as the last argument.
 * That's why we explicitly handle the declaration, instead of using our macros.
 */




















/* yylex_init_extra has the same functionality as yylex_init, but follows the
 * convention of taking the scanner as the last argument. Note however, that
 * this is a *pointer* to a scanner, as it will be allocated by this call (and
 * is the reason, too, why this function also must handle its own declaration).
 * The user defined value in the first argument will be available to yyalloc in
 * the yyextra field.
 */
static int yylex_init_extra( YY_EXTRA_TYPE yy_user_defined, yyscan_t* ptr_yy_globals )
{
    struct yyguts_t dummy_yyguts;

    yyset_extra (yy_user_defined, &dummy_yyguts);

    if (ptr_yy_globals == NULL){
        errno = EINVAL;
        return 1;
    }

    *ptr_yy_globals = (yyscan_t) yyalloc ( sizeof( struct yyguts_t ), &dummy_yyguts );

    if (*ptr_yy_globals == NULL){
        errno = ENOMEM;
        return 1;
    }

    /* By setting to 0xAA, we expose bugs in
    yy_init_globals. Leave at 0x00 for releases. */
    memset(*ptr_yy_globals,0x00,sizeof(struct yyguts_t));

    yyset_extra (yy_user_defined, *ptr_yy_globals);

    return yy_init_globals ( *ptr_yy_globals );
}

static int yy_init_globals (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from yylex_destroy(), so don't allocate here.
     */

    yyg->yy_buffer_stack = NULL;
    yyg->yy_buffer_stack_top = 0;
    yyg->yy_buffer_stack_max = 0;
    yyg->yy_c_buf_p = NULL;
    yyg->yy_init = 0;
    yyg->yy_start = 0;

    yyg->yy_start_stack_ptr = 0;
    yyg->yy_start_stack_depth = 0;
    yyg->yy_start_stack =  NULL;

    yyg->yy_state_buf = 0;
    yyg->yy_state_ptr = 0;
    yyg->yy_full_match = 0;
    yyg->yy_lp = 0;

/* Defined in main.c */
#ifdef YY_STDINIT
    yyin = stdin;
    yyout = stdout;
#else
    yyin = NULL;
    yyout = NULL;
#endif

    /* For future reference: Set errno on error, since we are called by
     * yylex_init()
     */
    return 0;
}

/* yylex_destroy is for both reentrant and non-reentrant scanners. */
static int yylex_destroy  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		yy_delete_buffer( YY_CURRENT_BUFFER , yyscanner );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		yypop_buffer_state(yyscanner);
	}

	/* Destroy the stack itself. */
	yyfree(yyg->yy_buffer_stack , yyscanner);
	yyg->yy_buffer_stack = NULL;

    /* Destroy the start condition stack. */
        yyfree( yyg->yy_start_stack , yyscanner );
        yyg->yy_start_stack = NULL;

    yyfree ( yyg->yy_state_buf , yyscanner);
    yyg->yy_state_buf  = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * yylex() is called, initialization will occur. */
    yy_init_globals( yyscanner);

    /* Destroy the main struct (reentrant only). */
    yyfree ( yyscanner , yyscanner );
    yyscanner = NULL;
    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, const char * s2, int n , yyscan_t yyscanner)
{
	struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	(void)yyg;

	int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (const char * s , yyscan_t yyscanner)
{
	int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

static void *yyalloc (yy_size_t  size , yyscan_t yyscanner)
{
	struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	(void)yyg;
	return malloc(size);
}

static void *yyrealloc  (void * ptr, yy_size_t  size , yyscan_t yyscanner)
{
	struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	(void)yyg;

	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return realloc(ptr, size);
}

static void yyfree (void * ptr , yyscan_t yyscanner)
{
	struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	(void)yyg;
	free( (char *) ptr );	/* see yyrealloc() for (char *) cast */
}

#define YYTABLES_NAME "yytables"

#line 369 "codeblock.lex"


static void comment(yyscan_t scanner)
{
  int c;
  while ((c = input(scanner)) > 0) {
    if (c == '*') {
      output_c (c);
      while ((c = input(scanner)) == '*')
	output_c (c);
      output_c (c);
      if (c == '/')
	return;
      if (c == 0)
	break;
    }
    else if (c == '\v') {
      // line number
      output_s ("<span id=");
      while ((c = input(scanner)) && strchr ("0123456789", c))
	output_c (c);
      output_s ("></span>");
    }
    else
      output_c (c);
  }
  fprintf (stderr, "codeblock: warning: %s: unterminated comment\n", 
	   yyget_extra(scanner)->page);
}

static void read_tagfile (struct MyScanner * scan)
{
  char files[2][200] = {"", ""};
  char * s = getenv ("BASILISK");
  if (s)
    strcpy (files[0], s);
  strcat (files[0], "/external.tags");
  strcpy (files[1], scan->page);
  strcat (files[1], ".tags");
  int i;
  for (i = 0; i < 2; i++) {
    char * s = files[i];
    FILE * fp = fopen (s, "r");
    if (fp == NULL)
      perror (s);
    else {
      Tag t;
      char type[10];
      while (fscanf (fp, "%s %s %s %s", type, t.id, t.file, t.line) == 4) {
	if (!strcmp (type, "decl")) {
	  scan->ndecl++;
	  scan->decl = realloc (scan->decl, scan->ndecl*sizeof(Tag));
	  scan->decl[scan->ndecl-1] = t;
	}
	else if (!strcmp (type, "call")) {
	  scan->ncall++;
	  scan->call = realloc (scan->call, scan->ncall*sizeof(Tag));
	  scan->call[scan->ncall-1] = t;
	}
	else if (!strcmp (type, "incl")) {
	  scan->nincl++;
	  scan->incl = realloc (scan->incl, scan->nincl*sizeof(Tag));
	  scan->incl[scan->nincl-1] = t;
	}
      }
      fclose (fp);
    }
  }
}

void codeblock (char * page)
{
  yyscan_t scanner;
  struct MyScanner sdata = {};
  sdata.i = sdata.scope = sdata.intypedef = 0;
  sdata.page = page;
  sdata.incode = 0;
  read_tagfile (&sdata);

  yylex_init_extra (&sdata, &scanner);
  yyset_in (stdin, scanner);
  yyset_out (stdout, scanner);
  yyset_debug (2, scanner);
  yylex (scanner);
  yylex_destroy (scanner);
  free (sdata.decl);
  free (sdata.call);
  free (sdata.incl);
}

static void usage () {
  fprintf (stderr,
	   "usage: codeblock BASEURL FILE.[ch] [EXT] < FILE.[ch].html\n");
  exit (1);
}

int main (int argc, char * argv[])
{
  if (argc < 3)
    usage();
  char * name = argv[2];

  baseurl = argv[1];
  if (argc >= 4)
    ext = argv[3];
  basilisk_url = getenv ("HTTP_BASILISK_URL");
  if (basilisk_url == NULL)
    basilisk_url = baseurl;
  
  codeblock (name);
  return 0;
}

