#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <assert.h>

int read_identifier (char * buf)
{
  int c;
  while ((c = getchar()) != EOF && strchr (" \n\t", c));
  if (c == '%')
    return c;
  if (c == '{')
    while ((c = getchar()) != EOF && c != '}');
  if (c == '/') {
    c = getchar();
    if (c == '*')
      while (((c = getchar()) != EOF && c != '*') ||
	     ((c = getchar()) != EOF && c != '/'));
    else {
      assert (c == '/');
      while ((c = getchar()) != EOF && c != '\n');
    }
  }
  if (c == '\'') {
    *buf++ = c;
    c = getchar();
    *buf++ = c;
    c = getchar();
    *buf++ = c;
    assert (c == '\'');
    c = getchar();
  }
  else
    while (c != EOF && (c == '_' ||
			(c >= 'a' && c <= 'z') ||
			(c >= 'A' && c <= 'Z'))) {
      *buf++ = c;
      c = getchar();
    }
  *buf = '\0';
  return c;
}

int main()
{
  printf ("/* Automatically generated by grammar.c */\n");
  int c;
  while ((c = getchar()) != EOF)
    if (c == '%') {
      c = getchar();
      if (c == '%')
	break;
    }
  do {
    char parent[100], child[100];
    c = read_identifier (parent);
    if (c == '%')
      break;
    if (parent[0] != '\0' && strcmp (parent, "type_not_specified")) {
      printf ("if (n->sym == sym_%s)\n"
	      "  return (", parent);
      int m = 0;
      do {	
	int n = 0;
	if (m > 0)
	  printf (" ||\n          ");
	printf ("(");
	do {
	  c = read_identifier (child);
	  if (child[0] != '\0' && strcmp (child, "type_not_specified")) {
	    if (n > 0)
	      printf (" &&\n           ");
	    printf ("n->child[%d] && n->child[%d]->sym == %s%s%s",
		    n, n, child[0] == '\'' ? "token_symbol(" : "sym_",
		    child, child[0] == '\'' ? ")" : "");
	    n++;
	  }
	} while (c != '|' && c != ';');
	printf (" && !n->child[%d]", n);
	printf (")");
	m++;
      } while (c != ';');
      printf (");\n");
    }
  } while (c != EOF);
}
