import os
import tempfile
import unittest
import logging

import shutil

import pytest

import tests.res.fluka.generated.generate_input as gen
from pymchelper.flair import Input

logger = logging.getLogger(__name__)


@pytest.mark.smoke
class TestFlukaGenerate(unittest.TestCase):

    def test_create(self):
        working_dir = tempfile.mkdtemp()  # make temp working dir for converter output files
        logger.info("Creating directory {:s}".format(working_dir))

        generated_file_path = os.path.join(working_dir, "generated.inp")
        generated_file_object = gen.generate_fluka_file(generated_file_path)

        logger.info("Expecting file {:s} to be generated by pymchelper".format(generated_file_path))
        self.assertTrue(os.path.exists(generated_file_path))
        self.assertIsNotNone(generated_file_object)

        parsed_file_object = Input.Input()
        parsed_file_object.read(generated_file_path)

        parsed_file_path = os.path.join(working_dir, "parsed.inp")
        parsed_file_object.write(parsed_file_path)

        logger.info("Checking number of regions")
        self.assertEqual(len(generated_file_object.regionProperties()), len(parsed_file_object.regionProperties()))

        logger.info("Checking number of USRBINs")
        self.assertEqual(len(generated_file_object["USRBIN"]), len(parsed_file_object["USRBIN"]))

        logger.info("Checking number of cards")
        self.assertEqual(len(generated_file_object.allcards()), len(parsed_file_object.allcards()))

        logger.info("Removing directory {:s}".format(working_dir))
        shutil.rmtree(working_dir)


if __name__ == '__main__':
    unittest.main()
