## Description #############################################################################
#
# Precompilation.
#
############################################################################################

import PrecompileTools

PrecompileTools.@compile_workload begin
    # == Parsing and Reading ===============================================================

    tle = tle"""
    AMAZONIA 1
    1 47699U 21015A   23083.68657856 -.00000044  10000-8  43000-4 0  9990
    2 47699  98.4304 162.1097 0001247 136.2017 223.9283 14.40814394108652
    """

    tles = tles"""
    AMAZONIA 1
    1 47699U 21015A   23083.68657856 -.00000044  10000-8  43000-4 0  9990
    2 47699  98.4304 162.1097 0001247 136.2017 223.9283 14.40814394108652
    CBERS 4A
    1 44883U 19093E   23084.50188177  .00004132  00000+0  53225-3 0  9992
    2 44883  97.8666 164.4776 0001781  94.0485 266.0964 14.81596492176403
    """

    l1 = "1 47699U 21015A   23083.68657856 -.00000044  10000-8  43000-4 0  9990"
    l2 = "2 47699  98.4304 162.1097 0001247 136.2017 223.9283 14.40814394108652"
    tle = read_tle(l1, l2; name = "AMAZONIA 1")

    # == Conversion ========================================================================

    convert(String, tle)
    tle_epoch(tle)

    # == Show ==============================================================================

    show(IOBuffer(), tle)
    show(IOBuffer(), MIME("text/plain"), tle)
end
