# -*- coding: utf-8 -*-
"""
Created on Thu Dec  5 11:13:22 2024

@author: surma37p
"""

from scipy.constants import pi
from scipy.fft import fft, fftfreq
import numpy as np
import matplotlib.pyplot as plt
import matplotlib as mpl
from matplotlib.patches import Circle
from matplotlib.ticker import (MultipleLocator, AutoMinorLocator)
from matplotlib import ticker as mticker
from matplotlib.widgets import Slider
plt.rcParams["font.family"] = "Times New Roman"
plt.rcParams["font.size"] = 12
plt.rcParams['xtick.major.size']=4
plt.rcParams['xtick.major.width']=1
plt.rcParams['ytick.major.size']=4
plt.rcParams['ytick.major.width']=1
plt.rcParams['xtick.minor.size']=2
plt.rcParams['xtick.minor.width']=1
plt.rcParams['ytick.minor.size']=2
plt.rcParams['ytick.minor.width']=1  
plt.rcParams['xtick.direction']="in"
plt.rcParams['ytick.direction']="in"

plt.close('all')

R = 2.23e-3
# Number of sample points
N  = 629
# sample spacing
T = 1/N

initfreq = 136
finalfreq = 187
step=0.1

freq_range = np.arange(initfreq,finalfreq+step,step)
Nfreq=len(freq_range)
phi = np.linspace(0,2*pi, N)

x = np.linspace(0.0, N*T, N, endpoint=False)
xf = fftfreq(N, T)[:N//2]

yffted=np.zeros((N,Nfreq),dtype=np.complex128)

overlap=[]

for i in np.arange(Nfreq):
    print(freq_range[i])
    yimag = np.genfromtxt("RealAndImagEz_at300umOptMode_136to187GHz_instepsof0p1GHz_3DFullSimulation_1p007timesneno.txt", skip_header=8)[:,2*i+1]
    yreal = np.genfromtxt("RealAndImagEz_at300umOptMode_136to187GHz_instepsof0p1GHz_3DFullSimulation_1p007timesneno.txt", skip_header=8)[:,2*i+2]
    
    zimag = np.genfromtxt("RealAndImagEz_inWaveguide_136to187GHz_instepsof0p1GHz_3DFullSimulation_1p007timesneno.txt", skip_header=8)[0,2*i+2]
    zreal = np.genfromtxt("RealAndImagEz_inWaveguide_136to187GHz_instepsof0p1GHz_3DFullSimulation_1p007timesneno.txt", skip_header=8)[0,2*i+1]
    
    ycomplex = (yreal+1j*yimag)/abs(zreal+1j*zimag)#*P_THz_input
    yffted[:,i]=fft(ycomplex)
    yffted[0:N//2,i]=abs(yffted[0:N//2,i])

#%%
def plot_2Ddata(data, ax, colormap='bwr', title=" "):
    Xmin = -3.5
    Xmax = 3.5
    Ymin = -3.5
    Ymax = 3.5

    X = np.arange(Xmin, Xmax+0.01, 0.01)
    Y = np.arange(Ymin, Ymax+0.01, 0.01)
    x,y = np.meshgrid(X,Y)
    
    ax.tick_params(bottom=True, top=True, left=True, right=True)
    ax.tick_params(axis='both', which='both', top=True)
    ax.tick_params(axis='both', which='both', right=True)
    ax.xaxis.set_minor_locator(AutoMinorLocator())
    ax.yaxis.set_minor_locator(AutoMinorLocator()) 
    ax.set_title(title)
    coupling_dist = 0.05
    res_radius = 2.23 
    wg_thickness=0.33
    wg_pos_x = res_radius + coupling_dist
    res_centre_x = 0 
    res_centre_y = 0

    ax.pcolormesh(x, y, data, cmap = colormap, vmin=-3e4, vmax=3e4)#, vmin=0, vmax=1e9)
    ax.vlines(x = wg_pos_x, ymin = Ymin, ymax = Ymax, color='k')
    ax.vlines(x = wg_pos_x + wg_thickness, ymin = Ymin, ymax = Ymax, color='k')
    ax.vlines(x = Xmin, ymin = Ymin, ymax = Ymax, color='k')
    ax.vlines(x = Xmax, ymin = Ymin, ymax = Ymax, color='k')
    circle = Circle((res_centre_x, res_centre_y), res_radius, facecolor='none', edgecolor='k')
    ax.add_patch(circle)
    # ax.axis("off")
    ax.set_xlim([Xmin,Xmax])
    ax.set_ylim([Ymin,Ymax])
    

fig, axs = plt.subplots(1,2)
data = np.genfromtxt('RealEz_atZ0_2Dcutforcolour_m3p5to3p5XY_165p8GHz_3DFullSimulation.txt', skip_header=14)
plot_2Ddata(data, axs[1],"RdGy")
data = np.genfromtxt('RealEz_atZ0_2Dcutforcolour_m3p5to3p5XY_173p7GHz_3DFullSimulation.txt', skip_header=14)
images=plot_2Ddata(data, axs[0],"RdGy")

axs[0].set_xlabel('X (mm)')
axs[1].set_xlabel('X (mm)')
axs[0].set_ylabel('Y (mm)')
axs[1].set_ylabel('Y (mm)')
plt.tight_layout()

fig, axs = plt.subplots(1,2)
# Find the file at 165.8 GHz:
i=np.argmin(np.abs(freq_range - 162.1))
yreal = np.genfromtxt("RealAndImagEz_atOptMode_136to187GHz_instepsof0p1GHz_3DFullSimulation_1p007timesneno.txt", skip_header=8)[:,2*i+2]
phisim= np.genfromtxt("RealAndImagEz_atOptMode_136to187GHz_instepsof0p1GHz_3DFullSimulation_1p007timesneno.txt", skip_header=8)[:,0]
j=np.argmin(abs(phisim-pi/2))
yapp = np.append(yreal[j:],yreal[:j])
axs[0].plot(phisim[::-1], yapp/2.18e4, label='resonant', linestyle='-',color='C6') #
axs[1].stem(xf[0:26], yffted[0:26,i]/88.7, label='resonant', linefmt='C6',basefmt='white')
i=np.argmin(np.abs(freq_range - 169))
yreal = np.genfromtxt("RealAndImagEz_atOptMode_136to187GHz_instepsof0p1GHz_3DFullSimulation_1p007timesneno.txt", skip_header=8)[:,2*i+2]
phisim= np.genfromtxt("RealAndImagEz_atOptMode_136to187GHz_instepsof0p1GHz_3DFullSimulation_1p007timesneno.txt", skip_header=8)[:,0]
j=np.argmin(abs(phisim-pi/2))
yapp = np.append(yreal[j:],yreal[:j])
axs[0].plot(phisim[::-1], yapp/2.18e4, label='offresonant', linestyle='--',color='C2') #
axs[1].stem(xf[0:26], yffted[0:26,i]/88.7, label='off-resonant', linefmt='C2--',basefmt='white')

axs[0].set_xlim([0,2*pi])
axs[0].set_xticks([0,pi/2,pi,3*pi/2,2*pi])
axs[0].set_ylim([-1.05,1.05])
axs[1].set_ylim([0,1.05])
axs[1].set_xlim([0,25])
axs[0].tick_params(bottom=True, top=True, left=True, right=True)
axs[0].tick_params(axis='both', which='both', top=True)
axs[0].tick_params(axis='both', which='both', right=True)
axs[0].xaxis.set_minor_locator(AutoMinorLocator())
axs[0].yaxis.set_minor_locator(AutoMinorLocator()) 
axs[1].tick_params(bottom=True, top=True, left=True, right=True)
axs[1].tick_params(axis='both', which='both', top=True)
axs[1].tick_params(axis='both', which='both', right=True)
axs[1].xaxis.set_minor_locator(AutoMinorLocator())
axs[1].yaxis.set_minor_locator(AutoMinorLocator()) 
axs[0].set_xlabel(r'Azimuthal angle ($\phi$)')
axs[0].set_ylabel(r'Ez ($\rho_0$, 0, $\phi$)')
axs[1].set_ylabel(r"$\epsilon$z ($\rho_0$, 0, $\Delta m$)")
axs[1].set_xlabel(r"$\Delta$ m")
plt.tight_layout()

#%%  
stretch=1
# From the eigenfrequency simulations in COMSOL put into a txt file
m=np.genfromtxt("2DAxisSymm_1p007increase_neno.txt",delimiter="; ", skip_header=1)[:,0]
eigenf=np.genfromtxt("2DAxisSymm_1p007increase_neno.txt",delimiter="; ", skip_header=1)[:,1]
delta_m_range = np.arange(14, 20)
FSR=9.8046#797#

fig, ax = plt.subplots(1,2, gridspec_kw={'width_ratios': [2,1]})
axbig=ax[0]
ticks_range=np.linspace(0,1.1e-3,5)

simFSRs = [9.8046]#35]#9.79,10.0]
C = ['red','k', 'grey']
linesim = [":","-","--"]

# fig, axbig = plt.subplots()
images=axbig.pcolormesh(xf[0:26],freq_range*stretch*1e-3,abs(yffted[0:26]).T, cmap = "Blues",vmin=0,vmax=95)
axbig.plot(m, eigenf*1e-3, label=r"$\Omega_{new_eigen}/2\pi$", marker='>',markersize=4, linestyle='-',color='C6')
axbig.plot(delta_m_range, FSR*delta_m_range*stretch*1e-3, label=r"$\Delta m \times \delta\omega_{opt}/2\pi$", marker='o',markersize=3, linestyle=':',color=C[0])
axbig.hlines(169*stretch*1e-3, 0, 25, label="off", linestyle='--',color='#18a52bff')
# axbig.hlines(156.9*stretch*1e-3, 0, 25, label="off", linestyle='--',color='C4')
axbig.hlines(162.1*stretch*1e-3, 0, 25, label="eigen", linestyle='--',color='C6')

axbig.tick_params(bottom=True, top=True, left=True, right=True)
axbig.tick_params(axis='both', which='both', top=True)
axbig.tick_params(axis='both', which='both', right=True)
axbig.xaxis.set_minor_locator(AutoMinorLocator())
axbig.yaxis.set_minor_locator(AutoMinorLocator())

axbig.set_xlabel(r"$\Delta$ m")
axbig.set_ylabel("Frequency (THz)")
axbig.set_xticks(np.arange(0,26,5))
axbig.set_xlim([0,25])
axbig.set_ylim([0.136,0.187])

ne=2.137
r33=29e-12 #m/V
omega_opt = 2*pi*191.8346e12
lw_opt = 1.4e6
gamma_opt = lw_opt*pi/2

f_pump = 191.8346e12 #[Hz] measured with Wavemeter
Q_opt = 1.4e8 #[] approx.
P_pump_input = 8.6e-3 #[W] measured using Thorlabs power meter
P_pump_refl_dB = -3.26 #[dBm] measured on Wavemeter
#optical coupling efficiency
K_opt = 0.5 

def power_conversion_rate_per_W_incoupled_pump_power(f_THz,f_pump,P_up_dB,P_THz_input,P_pump_input,P_pump_refl_dB,K_THz,K_opt): 
    #THz attentuation introduced by components in beam path: through PTFE lens and UHMWPE lens and through the entrance of the Si waveguide; 
    #absorption losses are neglibible in all <0.1 /cm
    t_THz = (1-(3.416-1)**2/(3.416+1)**2) * (1-(1.52-1)**2/(1.52+1)**2)**2 * 1-(1.4-1)**2/(1.4+1)**2
    P_THz = t_THz*P_THz_input 
    # print(P_THz)
    #attenuation introduced by reflection at the uncoated prism plane 
    t_opt = 1-(2.3878-1)**2/(2.3878+1)**2 #for diamond
    #pump light actually coupled into the WGMR
    P_pump = K_opt*t_opt*P_pump_input   #[W]
    P_up = 1e-3*10**(P_up_dB/10)*10/9   #[W] same but correcting for the 90% port being used
    print("Upconverted peak:"+str(round(P_up*1e9,2))+" nW.")
    return P_up/P_THz/P_pump

def photon_conversion_rate_per_W_incoupled_pump_power_normpowconv(f_THz,f_pump,pow_conv_eff):
    return f_THz/(f_pump+f_THz) * pow_conv_eff

dmrange = np.arange(14,20,1)
# P_THz_input_e = np.array([144e-6 *0.08, 130e-6 *0.11, 81e-6*0.02, 88e-6*0.02, 67e-6*0.16, 49e-6*0.11])
P_THz_input_e = np.array([144e-6*0.09, 130e-6*0.12, 81e-6*0.03, 88e-6*0.01, 67e-6*0.17, 49e-6*0.09])#*0.0968


### PEAKS IS ARRANGED WITH DIFFERENT ROWS AT DIFFERENT FSRS: 
### 9.797 FIRST ROW, 9.8035 SECOND, 9.805 THIRD ROW, 9.8045 FOURTH 9.8135 FOURTH. 
### AND DIFFERENT COLUMNS GOING DM FROM 14 TO 19
# peaks_SFG = [[-61.4, -58.3, -50.0, -55.9, -61.9, -58.1],
#              [-60.6, -53.4, -47.0, -56.0, -59.3, -63.2],
#              [-64.9, -60.1, -50.2, -55.7, -63.1, -53.0],
#              [-66.7, -60.0, -48.5, -56.3, -64.4, -60.5],
#              [-67.2, -58.1, -53.8, -58.6, -64.6, -68.5]]
# peaks_DFG = [[-61.2, -56.9, -48.9, -55.0, -60.2, -57.6],
#              [-60.8, -55.1, -48.0, -53.9, -60.8, -61.9],
#              [-60.5, -57.7, -47.6, -56.8, -62.3, -54.2],
#              [-68.6, -58.7, -48.1, -59.5, -64.5, -63.6],
#              [-67.2, -61.9, -52.6, -59.4, -64.0, -67.8]]
# peaks_SFG = [[-60.6, -53.4, -47.0, -56.0, -59.3, -63.2]]
# peaks_DFG = [[-60.5, -57.7, -47.6, -56.8, -62.3, -54.2]]
FSRs = [9.8046e9, 9.8046e9]# 9.797e9, 9.8035e9, 9.805e9, 9.8045e9, 9.8135e9]
peaks_9p8046 = [[-64.9, -60.1, -50.2, -55.7, -63.1, -53], 
                [-60.5, -57.7, -47.6, -56.8, -62.3, -54.2]]
# FSRs = [9.797e9, 9.8035e9, 9.8046e9,9.805e9, 9.8135e9]#9.8046e9,9.8046e9]# 
cmap = mpl.colormaps['Blues_r']
# Ce = cmap(np.linspace(0, 0.6, len(FSRs)))
# Le = ['-.','--','-','-.','--']
Me = [3,3,5,3,3]
labels=['9.797 GHz','9.8035 GHz','9.8046 GHz','9.805 GHz', '9.8135 GHz']
Ce = ['#005c8a','#00aaffff']
pow_conv_eff=np.zeros_like(peaks_9p8046)
phot_conv_rate=np.zeros_like(pow_conv_eff)

for i, FSRi in enumerate(FSRs):
    print(FSRi*1e-9)
    for j, m in enumerate(dmrange):
        pow_conv_eff[i][j]=power_conversion_rate_per_W_incoupled_pump_power(m*FSRi, f_pump, peaks_9p8046[i][j], P_THz_input_e[j], P_pump_input, P_pump_refl_dB, K_opt)
        # pow_conv_eff[i][j]=power_conversion_rate_per_W_incoupled_pump_power(m*FSRi, f_pump, peaks_DFG[i][j], P_THz_input_e[j], P_pump_input, P_pump_refl_dB, K_THz, K_opt)
        phot_conv_rate[i][j] = photon_conversion_rate_per_W_incoupled_pump_power_normpowconv(m*FSRi, f_pump, pow_conv_eff[i][j])
    ax[1].semilogy(dmrange*FSRi*1e-12, phot_conv_rate[i]*1e3,'d', markersize=Me[i], linestyle='-', color=Ce[i])#,label=labels[i]) #x1e6 per mW  
    print(phot_conv_rate[i][:]*1e3)
'''
Ce = ['#005c8a','#00aaffff']
FSRs = [9.8046e9, 9.8046e9]
peaks_9p8046 = [[-64.9, -60.1, -50.2, -55.7, -63.1, -53], 
                [-60.5, -57.7, -47.6, -56.8, -62.3, -54.2]]

pow_conv_eff=np.zeros_like(peaks_9p8046)
phot_conv_rate=np.zeros_like(pow_conv_eff)

for i, FSRi in enumerate(FSRs):
    print(FSRi*1e-9)
    for j, m in enumerate(dmrange):
        pow_conv_eff[i][j]=power_conversion_rate_per_W_incoupled_pump_power(m*FSRi, f_pump, peaks_9p8046[i][j], P_THz_input_e[j], P_pump_input, P_pump_refl_dB, K_THz, K_opt)
        # pow_conv_eff[i][j]=power_conversion_rate_per_W_incoupled_pump_power(m*FSRi, f_pump, peaks_DFG[i][j], P_THz_input_e[j], P_pump_input, P_pump_refl_dB, K_THz, K_opt)
        phot_conv_rate[i][j] = photon_conversion_rate_per_W_incoupled_pump_power_normpowconv(m*FSRi, f_pump, pow_conv_eff[i][j])
    ax[1].semilogy(dmrange*FSRi*1e-12, phot_conv_rate[i]*1e3,'-d',markersize=5, color=Ce[i])#,label=labels[i]) #x1e6 per mW  
    print(phot_conv_rate[i][:]*1e3)
'''
dmrange = np.arange(14,20,1)
ax2 = ax[1].twinx()
for j, FSRj in enumerate(simFSRs):
    g_NLcouplingrate=[]
    upconvfreq=[]
    for i in np.arange(len(freq_range)):
        for m in dmrange:
            if i==np.argmin(np.abs(freq_range*stretch - round(m*FSRj,1))):
                g_NLcouplingrate.append(abs(yffted[m,i]*ne**2*r33*omega_opt/4/pi))
                upconvfreq.append(freq_range[i]*stretch)

    # this is from Strekalov et al Sensors 2022, 22, 804 and to put it into the same form as the eta in our 2024 manuscript divide by THz power
    eta_per_pump = np.array(g_NLcouplingrate)**2/4/gamma_opt**2 * FSRj#/P_THz_input #per W
    ax2.semilogy(np.array(upconvfreq)*1e-3, eta_per_pump/np.max(eta_per_pump), ":o",markersize=3, color='r') #x1e6 per mW

ax2.set_ylabel(r"$\eta_{sim}$ (arb. units)")
ax[1].set_xlabel("Frequency (THz)")
ax[1].set_xlim([0.135,0.188])
ax[1].set_xlabel("Frequency (THz)")
ax[1].set_ylabel(r"$\eta_{expt} (\times 10^{-6} /mW)$")
ax[1].tick_params(bottom=True, top=True, left=True)
ax[1].tick_params(axis='both', which='both', top=True)
# ax[1].tick_params(axis='both', which='both', right=True)
ax[1].xaxis.set_minor_locator(AutoMinorLocator())
ax[1].yaxis.set_minor_locator(mticker.LogLocator(numticks=5, subs="auto"))
ax2.tick_params(bottom=True, top=True, right=True)
ax2.tick_params(axis='both', which='both', top=True)
# ax2.tick_params(axis='both', which='both', right=True)
ax2.xaxis.set_minor_locator(AutoMinorLocator())
ax2.yaxis.set_minor_locator(mticker.LogLocator(numticks=5, subs="auto"))
plt.tight_layout()