# -*- coding: utf-8 -*-
"""
Created on Tue Oct  3 17:31:56 2023

@author: mika
"""
import matplotlib.pyplot as plt
import numpy as np
from matplotlib.ticker import (AutoMinorLocator)
plt.rcParams.update({'font.size': 12})

def extract_data(filename):
    data = np.genfromtxt(filename,delimiter="	",skip_header=14)
    freq = data[:,0]
    power = data[:,1]
    return freq,power

def tellme(s):
    print(s)
    plt.title(s)

fig, axs = plt.subplots(1, 1) 
axs.set_ylabel("Power (dBm)")
axs.set_xlabel("Frequency (THz)")
axs.tick_params(bottom=True, top=True, left=True, right=True)
axs.tick_params(axis='both', which='both', top=True)
axs.tick_params(axis='both', which='both', right=True)
axs.xaxis.set_minor_locator(AutoMinorLocator())
axs.yaxis.set_minor_locator(AutoMinorLocator())
axs.tick_params(which='both',direction='in')
axs.tick_params(axis='both', which='major', length=7, width=1.05, colors='k')
axs.tick_params(axis='both', which='minor', length=3.5, width=1, colors='k')

file = ["opticalmode9p8046GHz_all_23p84degC_9p3Vcoupled_prop.txt"]#"mode9p7973GHz_50percoupl_6p3V.txt"]
fsr=9.8046e-3
plt.vlines([-19*fsr,-18*fsr,-17*fsr,-16*fsr,-15*fsr,-14*fsr,
            19*fsr,18*fsr,17*fsr,16*fsr,15*fsr,14*fsr,0],
           -68,-38, color='0.6',linestyles='--',linewidth=0.7)
for i in np.arange(len(file)):
    f,p=extract_data(file[i])
    plt.plot(f-191.8346, p,linewidth=0.8)
plt.axis([-0.2,0.2,-83,-38])
plt.tight_layout()
plt.draw()
plt.show()