# Data

| Name               | Description                           |
|--------------------|---------------------------------------|
| `orthonormal_basis`           | Basis templates used for template generation, with further details in [notebook 1](https://github.com/XENONnT/light_wimp_data_release/tree/master/notebooks). This is not used in any results published in the [paper](https://arxiv.org/abs/2409.17868).   |
| `ac`           | Templates for accidental coincidence backgrounds.   |
| `b8`           | Templates for solar $^8\mathrm{B}$ $\mathrm{CE}\nu\mathrm{NS}$ backgrounds.     |
| `er`           | Templates for electronic recoil backgrounds.     |
| `rg`           | Templates for Radiogenic neutron backgrounds.     |
| `signal`           | Theoretical recoil energy spectrums and XENONnT's YBe-calibrated low-energy nuclear recoil yield models. |
| `wimp_si` | Templates for WIMPs of spin-independent interaction. |
| `wimp_si_n_1` | Templates for Momentum Dependent Dark Matter with $n=1$. |
| `wimp_si_n_2` | Templates for Momentum Dependent Dark Matter with $n=2$. |
| `wimp_si_n_m2` | Templates for Momentum Dependent Dark Matter with $n=-2$, which can also be interpreted as self-interacting dark matter with a light mediator. |
| `mirror_dm`           | Templates for Mirror Dark Matter (dark oxygen).     |
| `real_data.pkl` | All real-data events unblinded in the search region of interest after all selections. |
| `statistical_model_base.yaml` | A template of [alea](https://github.com/XENONnT/alea) statistical model config, which is modified to generate new configs in statistical inference described in [notebook 2](https://github.com/XENONnT/light_wimp_data_release/tree/master/notebooks), as part of the recasting. This is not used in any results published in the [paper](https://arxiv.org/abs/2409.17868). |



