from mikatools import *
from tqdm import tqdm
from selenium import webdriver
import time
from glob import glob
from selenium.webdriver.common.by import By
from selenium.webdriver.common.keys import Keys
import urllib.parse
import os.path


def initiate_crawling_sequence():
	options = webdriver.ChromeOptions() 
	options.add_argument("user-data-dir=/Users/mikahama/Library/Application Support/Google/Chrome/")
	browser = webdriver.Chrome(options=options)
	url = "https://twitch.tv"
	browser.get(url)
	print("Now, navigate to the stream you want to start recording. After you have done that and the video is playing, give a prefix for the chat file. E.g. smallant_mario")
	file_prefix = input("File prefix: ")
	print("Let's go!")
	print("Chat will be written in the file as the video plays... It might take some time before the file buffer is actually written.")
	print("At any rate, once you are done with the video, close your browser and kill this script with ctrl+C. The loop will ensure the file stream is closed properly :-)")
	chat_box = browser.find_element(by=By.CLASS_NAME, value="video-chat__message-list-wrapper")
	message_log = set([])

	w = open_write(file_prefix + "_chat_log.txt")
	
	try:
		while True:
			try:
				messages = [x.text for x in chat_box.find_elements(by=By.CLASS_NAME, value="vod-message") if x.text not in message_log]
			except:
				w.flush()
			message_log.update(set(messages))
			for line in messages:
				line = line.strip().replace("\r", "").replace("\n", " ")
				w.write(line + "\n")
			time.sleep(1)
	except:
		w.close()


initiate_crawling_sequence()
