* Load "ProPA_coded sample_anon.csv" dataset 
import delimited "[file path]/ProPA_coded sample_anon.csv", encoding(ISO-8859-1)

* Generate the outcome variable
gen accountunavailable=0
replace accountunavailable =1 if accountavailable==0

* Generate a binary variable on whether an observation is authoritarian (authoritarian=1) or not (authoritarian=0)
gen authoritarian=0
replace authoritarian=1 if proregimepropaganda==1 | antidissidentdisinformation==1 | antidissidentdoxing==1 | antidissidentviolence==1

* Generate a variable representing an observation's associated sampling weight
gen pw=80.6085 //sampling weight for a Cambodian post = 161217/2000 = 80.6085
replace pw=8.536 if myanmar==1 //sampling weight for a Myanmar post = 17072/2000 = 8.536
replace pw=26.982 if thai==1 //sampling weight for a Thai post = 53964/2000 = 26.982

* Generate a categorical variable representing an observation's associated country case: Cambodia = "kh", Myanmar = "mm", Thailand = "th"
gen case = "kh" 
replace case = "mm" if myanmar==1
replace case = "th" if thai==1

* Run the mixed-effects logistic regression  
melogit accountunavailable myanmar antidissidentdoxing antidissidentviolence antidissidentdisinformation antiethnicreligiousminority [pweight=pw] if authoritarian==1 || case:

* Assess whether the model is correctly specified, i.e. when p-value for "_hat" is below 0.05 and p-value for "_hatsq" is above 0.05
linktest
