CREATE DATABASE giles;

USE giles;

CREATE TABLE UserConnection (userId varchar(255) not null,
    providerId varchar(255) not null,
    providerUserId varchar(255),
    rank int not null,
    displayName varchar(255),
    profileUrl varchar(512),
    imageUrl varchar(512),
    accessToken text not null,
    secret varchar(512),
    refreshToken varchar(512),
    expireTime bigint,
    primary key (userId, providerId, providerUserId));
 
create unique index UserConnectionRank on UserConnection(userId, providerId, rank);

CREATE USER 'giles'@'localhost' IDENTIFIED BY 'GilesPassword';
GRANT ALL ON giles.* TO 'giles'@'localhost';