# Guidelines for Pull Requests

If you haven't yet read our code review guidelines, please do so, You can find them [here](https://diging.atlassian.net/wiki/spaces/DIGING/pages/2256076801/Code+Review+Guidelines).

Please confirm the following by adding an x for each item (turn `[ ]` into `[x]`).

- [ ] I have removed all code style changes that are not necessary (e.g. changing blanks across the whole file that don’t need to be changed, adding empty lines in parts other than your own code)
- [ ] I am not making any changes to files that don’t have any effect (e.g. imports added that don’t need to be added)
- [ ] I do not have any sysout statements in my code or commented out code that isn’t needed anymore
- [ ] I am not reformatting any files in the wrong format or without cause. 
- [ ] I am not changing file encoding or line endings to something else than UTF-8, LF
- [ ] My pull request does not show an insane amount of files being changed although my ticket only requires a few files being changed
- [ ] I have added Javadoc/documentation where appropriate
- [ ] I have added test cases where appropriate
- [ ] I have explained any part of my code/implementation decisions that is not be self-explanatory

## Please provide a brief description of your ticket 
(you can copy the ticket if it hasn't changed) 

...Put description here...
  
## Anything else the reviewer needs to know?

... describe here; e.g. is there another pull request this pull request depends on? If so, link it here. ...
