*** |  (C) 2006-2024 Potsdam Institute for Climate Impact Research (PIK)
*** |  authors, and contributors see CITATION.cff file. This file is part
*** |  of REMIND and licensed under AGPL-3.0-or-later. Under Section 7 of
*** |  AGPL-3.0, you are granted additional permissions described in the
*** |  REMIND License Exception, version 1.0 (see LICENSE file).
*** |  Contact: remind@pik-potsdam.de
*** SOF ./modules/29_CES_parameters/calibrate/output.gms
p29_CESderivative(t,regi_dyn29(regi),cesOut2cesIn(out,in))$( vm_cesIO.l(t,regi,in) gt 0 )
  =
    pm_cesdata(t,regi,in,"xi")
  * pm_cesdata(t,regi,in,"eff")
  * vm_effGr.l(t,regi,in)

  * (vm_cesIO.l(t,regi,out)
     )
 ** (1 - pm_cesdata(t,regi,out,"rho"))

  * ( pm_cesdata(t,regi,in,"eff")
    * vm_effGr.l(t,regi,in)
    * (vm_cesIO.l(t,regi,in)
       )
    )
 ** (pm_cesdata(t,regi,out,"rho") - 1);
;

*** Propagate price down the CES tree
loop ((cesLevel2cesIO(counter,in),cesOut2cesIn(in,in2),cesOut2cesIn2(in2,in3)),
  p29_CESderivative(t,regi_dyn29(regi),"inco",in3)
  = p29_CESderivative(t,regi,"inco",in2)
  * p29_CESderivative(t,regi,in2,in3);
);

*** Prices of intermediate production factors are all 1
***p29_CESderivative(t,regi_dyn29(regi),in,ipf_29(in2))$( p29_CESderivative(t,regi,in,in2) ) = 1;

*** Transfer prices
pm_cesdata(t,regi_dyn29(regi),in,"price")
  = p29_CESderivative(t,regi,"inco",in);

  
put file_CES_calibration;


loop ((t,regi_dyn29(regi),in)$(   ppf_29(in) 
                               OR ppf_beyondcalib_29(in)
                               OR sameas(in,"inco")),
  file_CES_calibration_integers
  put "%c_expname%", sm_CES_calibration_iteration, t.tl, regi.tl;
  file_CES_calibration_floats
  put "efficiency", in.tl;
  put (pm_cesdata("2005",regi,in,"eff") * vm_effGr.l(t,regi,in)) /;

  file_CES_calibration_integers
  put "%c_expname%", sm_CES_calibration_iteration, t.tl, regi.tl;
  file_CES_calibration_floats
  put "efficiency growth", in.tl, vm_effGr.l(t,regi,in) /;

  file_CES_calibration_integers
  put "%c_expname%", sm_CES_calibration_iteration, t.tl, regi.tl, "xi";
  file_CES_calibration_floats
  put in.tl, pm_cesdata(t,regi,in,"xi") /;
);

loop ((t,regi_dyn29(regi),in)$( (   ppf_29(in) 
                                    OR ppf_beyondcalib_29(in)
                                    OR sameas(in,"inco"))     ),
  file_CES_calibration_integers
  put "%c_expname%", sm_CES_calibration_iteration, t.tl, regi.tl;
  file_CES_calibration_floats
  put "quantity", in.tl, vm_cesIO.l(t,regi,in) /;

  file_CES_calibration_integers
  put "%c_expname%", sm_CES_calibration_iteration, t.tl, regi.tl, "price";
  file_CES_calibration_floats
  put in.tl, pm_cesdata(t,regi,in,"price") /;

  file_CES_calibration_integers
  put "%c_expname%", sm_CES_calibration_iteration, t.tl, regi.tl;
  file_CES_calibration_floats
  put "total efficiency", in.tl;
  put sum(cesOut2cesIn(out,in),
        pm_cesdata(t,regi,in,"xi")
     ** (1 / pm_cesdata(t,regi,out,"rho"))
      * ( pm_cesdata("2005",regi,in,"eff")
        * vm_effGr.l(t,regi,in)
        )
      ) /;
);

loop ((ttot,regi_dyn29(regi),te_29_report),
  file_CES_calibration_integers
  put "%c_expname%", sm_CES_calibration_iteration, ttot.tl, regi.tl;
  file_CES_calibration_floats
  put "vm_deltaCap", te_29_report.tl;
  put sum(rlf,vm_deltaCap.L(ttot,regi,te_29_report,rlf)) /;
);

loop ((t,regi_dyn29(regi),in),
  if (vm_cesIO.lo(t,regi,in) ne 0,
    file_CES_calibration_integers
    put "%c_expname%", sm_CES_calibration_iteration, t.tl, regi.tl;
    file_CES_calibration_floats
    put "lower bound", in.tl, vm_cesIO.lo(t,regi,in) /;
  );

  if (vm_cesIO.up(t,regi,in) ne INF,
    file_CES_calibration_integers
    put "%c_expname%", sm_CES_calibration_iteration, t.tl, regi.tl;
    file_CES_calibration_floats
    put "upper bound", in.tl, vm_cesIO.up(t,regi,in) /;
  );
);

putclose file_CES_calibration;

*** EOF ./modules/29_CES_parameters/calibrate/output.gms
