/*
  Copyright (C) 2011 - 2023 by the authors of the ASPECT code.

  This file is part of ASPECT.

  ASPECT is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, or (at your option)
  any later version.

  ASPECT is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with ASPECT; see the file LICENSE.  If not see
  <http://www.gnu.org/licenses/>.
*/


#include <aspect/postprocess/visualization/error_indicator.h>


namespace aspect
{
  namespace Postprocess
  {
    namespace VisualizationPostprocessors
    {
      template <int dim>
      ErrorIndicator<dim>::
      ErrorIndicator ()
        :
        CellDataVectorCreator<dim>("")
      {}



      template <int dim>
      std::pair<std::string, std::unique_ptr<Vector<float>>>
      ErrorIndicator<dim>::execute() const
      {
        std::pair<std::string, std::unique_ptr<Vector<float>>>
        return_value ("error_indicator",
                      std::make_unique<Vector<float>>(this->get_triangulation().n_active_cells()));
        this->get_refinement_criteria(*return_value.second);

        return return_value;
      }
    }
  }
}


// explicit instantiations
namespace aspect
{
  namespace Postprocess
  {
    namespace VisualizationPostprocessors
    {
      ASPECT_REGISTER_VISUALIZATION_POSTPROCESSOR(ErrorIndicator,
                                                  "error indicator",
                                                  "A visualization output object that generates output "
                                                  "showing the estimated error or other mesh refinement "
                                                  "indicator as a spatially variable function with one "
                                                  "value per cell."
                                                  "\n\n"
                                                  "Physical units: None. (Strictly speaking, errors have "
                                                  "physical units of course, but because error "
                                                  "\\textit{indicators} can be computed from different "
                                                  "solution components and other input, we consider "
                                                  "error indicators unitless.)")

    }
  }
}
