/*
  Copyright (C) 2011 - 2017 by the authors of the ASPECT code.

  This file is part of ASPECT.

  ASPECT is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, or (at your option)
  any later version.

  ASPECT is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with ASPECT; see the file LICENSE.  If not see
  <http://www.gnu.org/licenses/>.
*/


#include <aspect/geometry_model/initial_topography_model/zero_topography.h>


namespace aspect
{
  namespace InitialTopographyModel
  {
    template <int dim>
    double
    ZeroTopography<dim>::
    value (const Point<dim-1> &/*p*/) const
    {
      // return a zero value regardless of position
      return 0.0;
    }

    template <int dim>
    double
    ZeroTopography<dim>::
    max_topography () const
    {
      return 0;
    }
  }
}

// explicit instantiations
namespace aspect
{
  namespace InitialTopographyModel
  {
    ASPECT_REGISTER_INITIAL_TOPOGRAPHY_MODEL(ZeroTopography,
                                             "zero topography",
                                             "Implementation of a model in which the initial topography "
                                             "is zero. ")
  }
}
