# The Geodynamic World Builder (GWB)

Welcome to the manual of the Geodynamic World Builder (GWB). The GWB is a stand-alone library which allows for the **easy** creation of **complex** initial conditions for geodynamic models, such as [ASPECT](https://aspect.geodynamics.org) {cite:p}`Kronbichler_Heister_etal_2012,Heister_Dannberg_etal_2017,aspect-doi-v2.3.0,aspectmanual`, [ELEFANT](https://cedricthieulot.net/elefant.html) {cite:p}`Thieulot_2017` or SEPRAN {cite:p}`Berg_Segal_etal_2015`.

This manual will guide you **step-by-step** to everything you need to know to **use**, or **develop** for the GWB.

![Cascadia_real7_Jps2_v5_view1_highres_v1](https://user-images.githubusercontent.com/7631629/123048354-992dc680-d3fe-11eb-8e91-6fac6125f7de.png)


```{toctree}
:caption: Introduction
:maxdepth: 4
:hidden:
introduction/what_is_the_gwb
introduction/gwb_philosophy
introduction/how_to_use_this_manual
introduction/bibliography
```


```{toctree}
:caption: User manual
:maxdepth: 4
:hidden:

user_manual/introduction/index
user_manual/installation/index
user_manual/how_to_use_the_applications/index
user_manual/concepts/index
user_manual/basic_starter_tutorial/index
user_manual/cookbooks/index
user_manual/parameter_documentation/index
```


```{toctree}
:caption: API manual
:maxdepth: 4
:hidden:

api_manual/api_design
api_manual/available_apis
api_manual/API_FFI/index
```


```{toctree}
:caption: Developer manual
:maxdepth: 4
:hidden:

developer_manual/start_devel_and_contrib/index
developer_manual/contributing_to_the_documentation/index
developer_manual/contributing_to_the_code/index
developer_manual/developing_for_the_GWB/index

```

```{toctree}
:caption: Parameter listings
:maxdepth: 4
:hidden:

GWB_parameter_listings/world_builder_file/index.md
GWB_parameter_listings/visualization_grid_file/index.md
```

```{toctree}
:caption: Project Links
:maxdepth: 4
:hidden:

   GitHub <https://github.com/GeodynamicWorldBuilder/WorldBuilder/>
   Doxygen <https://codedocs.xyz/GeodynamicWorldBuilder/WorldBuilder/index.html>
   Chat <https://app.element.io/%23/room/%23gwb:matrix.org>
```

