# Time dependent annulus benchmark

[This folder](https://github.com/geodynamics/aspect/tree/main/benchmarks/time_dependent_annulus)
contains input files for the time dependent annular flow benchmark from Section 5 of
{cite:t}`gassmoller:etal:2019`.

It features a spherical annulus with a circular flow and a
time-independent analytical, but a time-dependent numerical solution,
which allows to quantify how errors in the advection equation
influence the accuracy of the Stokes equation. In this example
the benchmark uses particles to carry density, but it can be
used for other advection methods as well.

The complete input file can be found in `time_dependent_annulus.prm`.
All other input files are generated by the 'run_all_models' script
to run cases with different finite elements and numbers of particles
per cell. All models can be started by

```
  bash run_all_models
```

to run a model with a specific set of setting you can modify the loops
inside of this script to only generate models you are interested in.

The bash script `get_statistics` can extract the relevant statistics
(velocity error, pressure error, density error)
of one or several model runs and copy it to the screen output and a
separate file (annulus.txt)
It takes one or several paths to a number of statistics
files as input parameters, for example:

```
bash get_statistics Q2_Pfalse_refinement3_5
```

(assuming Q2_Pfalse_refinement3_5 is an output directory of the model runs).
