set terminal png size 1500,1000 enhanced font 'Verdana,14'
set output 'figure_t.png'
set yrange [1e-14:1]
set xrange [0:60]
set format y '%g'
set logscale y
set multiplot title "With a minimum linear tolerance of 1e-8, a stress exponent of 3 and pressure boundary conditions" font 'Verdana, 20'
set size 0.51,0.49
set origin 0,0.48
unset key
set title "Without stabilization of the velocity block and without the RSM"
plot \
'results/b1SNL_BTt_NS_ST1e-20_UFSfalse_NSP-SPD_NSA-none_C0_g4_ag0_AEWfalse_UDSfalse_SF9e-1_NLT1e-14_ABT1e-2_LT1e-5_mLT1e-8_I150_P150_EW1_theta1_LS0_RSMfalse_AV-1_phi0_vel0_BV1e19_n3/plot.dat' u 9:10 w l lw 2 lc rgb 'green' t 'Defect correction Picard', \
'results/b1SNL_BTt_NS_ST1e-20_UFSfalse_NSP-SPD_NSA-none_C0_g4_ag0_AEWfalse_UDSfalse_SF9e-1_NLT1e-14_ABT1e-2_LT1e-5_mLT1e-8_I150_P5_EW1_theta1_LS0_RSMfalse_AV-1_phi0_vel0_BV1e19_n3/plot.dat' u 9:10 w l dt 1 lw 2 lc rgb 'blue' t 'Newton solver with 5 Picard and without line search', \
'results/b1SNL_BTt_NS_ST1e-20_UFSfalse_NSP-SPD_NSA-none_C0_g4_ag0_AEWfalse_UDSfalse_SF9e-1_NLT1e-14_ABT1e-2_LT1e-5_mLT1e-8_I150_P5_EW1_theta1_LS100_RSMfalse_AV-1_phi0_vel0_BV1e19_n3/plot.dat' u 9:10 w p dt 3 lw 2 lc rgb 'blue' pt 7 t 'Newton solver with 5 Picard and line search', \
'results/b1SNL_BTt_NS_ST1e-20_UFSfalse_NSP-SPD_NSA-none_C0_g4_ag0_AEWfalse_UDSfalse_SF9e-1_NLT1e-14_ABT1e-2_LT1e-5_mLT1e-8_I150_P10_EW1_theta1_LS0_RSMfalse_AV-1_phi0_vel0_BV1e19_n3/plot.dat' u 9:10 w l dt 1 lw 2 lc rgb 'orange' t 'Newton solver with 10 Picard and without line search', \
'results/b1SNL_BTt_NS_ST1e-20_UFSfalse_NSP-SPD_NSA-none_C0_g4_ag0_AEWfalse_UDSfalse_SF9e-1_NLT1e-14_ABT1e-2_LT1e-5_mLT1e-8_I150_P10_EW1_theta1_LS100_RSMfalse_AV-1_phi0_vel0_BV1e19_n3/plot.dat' u 9:10 w p dt 3 lw 2 lc rgb 'orange' pt 7 ps 1 t 'Newton solver with 10 Picard and with line search', \
'results/b1SNL_BTt_NS_ST1e-20_UFSfalse_NSP-SPD_NSA-none_C0_g4_ag0_AEWfalse_UDSfalse_SF9e-1_NLT1e-14_ABT1e-2_LT1e-5_mLT1e-8_I150_P15_EW1_theta1_LS0_RSMfalse_AV-1_phi0_vel0_BV1e19_n3/plot.dat' u 9:10 w l dt 1 lw 2 lc rgb 'red' t 'Newton solver with 15 Picard and without line search', \
'results/b1SNL_BTt_NS_ST1e-20_UFSfalse_NSP-SPD_NSA-none_C0_g4_ag0_AEWfalse_UDSfalse_SF9e-1_NLT1e-14_ABT1e-2_LT1e-5_mLT1e-8_I150_P15_EW1_theta1_LS100_RSMfalse_AV-1_phi0_vel0_BV1e19_n3/plot.dat' u 9:10 w p dt 3 lw 2 lc rgb 'red' pt 7 ps 1 t 'Newton solver with 15 Picard and with line search', \
'<tail -n 1 results/b1SNL_BTt_NS_ST1e-20_UFSfalse_NSP-SPD_NSA-none_C0_g4_ag0_AEWfalse_UDSfalse_SF9e-1_NLT1e-14_ABT1e-2_LT1e-5_mLT1e-8_I150_P150_EW1_theta1_LS0_RSMfalse_AV-1_phi0_vel0_BV1e19_n3/plot.dat' u 9:10 w p lw 2 lc rgb 'green' pt 5 t 'Defect correction Picard', \
'<tail -n 1 results/b1SNL_BTt_NS_ST1e-20_UFSfalse_NSP-SPD_NSA-none_C0_g4_ag0_AEWfalse_UDSfalse_SF9e-1_NLT1e-14_ABT1e-2_LT1e-5_mLT1e-8_I150_P5_EW1_theta1_LS0_RSMfalse_AV-1_phi0_vel0_BV1e19_n3/plot.dat' u 9:10 w p dt 1 lw 2 lc rgb 'blue' pt 5 t 'Newton solver with 5 Picard and without line search', \
'<tail -n 1 results/b1SNL_BTt_NS_ST1e-20_UFSfalse_NSP-SPD_NSA-none_C0_g4_ag0_AEWfalse_UDSfalse_SF9e-1_NLT1e-14_ABT1e-2_LT1e-5_mLT1e-8_I150_P5_EW1_theta1_LS100_RSMfalse_AV-1_phi0_vel0_BV1e19_n3/plot.dat' u 9:10 w p dt 3 lw 2 lc rgb 'blue' pt 5 t 'Newton solver with 5 Picard and line search', \
'<tail -n 1 results/b1SNL_BTt_NS_ST1e-20_UFSfalse_NSP-SPD_NSA-none_C0_g4_ag0_AEWfalse_UDSfalse_SF9e-1_NLT1e-14_ABT1e-2_LT1e-5_mLT1e-8_I150_P10_EW1_theta1_LS0_RSMfalse_AV-1_phi0_vel0_BV1e19_n3/plot.dat' u 9:10 w p dt 1 lw 2 lc rgb 'orange' pt 5 t 'Newton solver with 10 Picard and without line search', \
'<tail -n 1 results/b1SNL_BTt_NS_ST1e-20_UFSfalse_NSP-SPD_NSA-none_C0_g4_ag0_AEWfalse_UDSfalse_SF9e-1_NLT1e-14_ABT1e-2_LT1e-5_mLT1e-8_I150_P10_EW1_theta1_LS100_RSMfalse_AV-1_phi0_vel0_BV1e19_n3/plot.dat' u 9:10 w p dt 3 lw 2 lc rgb 'orange' pt 5 ps 1 t 'Newton solver with 10 Picard and with line search', \
'<tail -n 1 results/b1SNL_BTt_NS_ST1e-20_UFSfalse_NSP-SPD_NSA-none_C0_g4_ag0_AEWfalse_UDSfalse_SF9e-1_NLT1e-14_ABT1e-2_LT1e-5_mLT1e-8_I150_P15_EW1_theta1_LS0_RSMfalse_AV-1_phi0_vel0_BV1e19_n3/plot.dat' u 9:10 w p dt 1 lw 2 lc rgb 'red' pt 5 t 'Newton solver with 15 Picard and without line search', \
'<tail -n 1 results/b1SNL_BTt_NS_ST1e-20_UFSfalse_NSP-SPD_NSA-none_C0_g4_ag0_AEWfalse_UDSfalse_SF9e-1_NLT1e-14_ABT1e-2_LT1e-5_mLT1e-8_I150_P15_EW1_theta1_LS100_RSMfalse_AV-1_phi0_vel0_BV1e19_n3/plot.dat' u 9:10 w p dt 3 lw 2 lc rgb 'red' pt 5 ps 1 t 'Newton solver with 15 Picard and with line search'
set origin 0.49,0.48
set key left bottom reverse Left font 'Verdana, 11'
set title "With stabilization of the velocity block and without the RSM"
plot \
'results/b1SNL_BTt_NS_ST1e-20_UFSfalse_NSP-SPD_NSA-SPD_C0_g4_ag0_AEWfalse_UDSfalse_SF9e-1_NLT1e-14_ABT1e-2_LT1e-5_mLT1e-8_I150_P150_EW1_theta1_LS0_RSMfalse_AV-1_phi0_vel0_BV1e19_n3/plot.dat' u 9:10 w l lw 2 lc rgb 'green' t 'Defect correction Picard', \
'results/b1SNL_BTt_NS_ST1e-20_UFSfalse_NSP-SPD_NSA-SPD_C0_g4_ag0_AEWfalse_UDSfalse_SF9e-1_NLT1e-14_ABT1e-2_LT1e-5_mLT1e-8_I150_P5_EW1_theta1_LS0_RSMfalse_AV-1_phi0_vel0_BV1e19_n3/plot.dat' u 9:10 w l dt 1 lw 2 lc rgb 'blue' t 'Newton solver with 5 Picard and without line search', \
'results/b1SNL_BTt_NS_ST1e-20_UFSfalse_NSP-SPD_NSA-SPD_C0_g4_ag0_AEWfalse_UDSfalse_SF9e-1_NLT1e-14_ABT1e-2_LT1e-5_mLT1e-8_I150_P5_EW1_theta1_LS100_RSMfalse_AV-1_phi0_vel0_BV1e19_n3/plot.dat' u 9:10 w p dt 3 lw 2 lc rgb 'blue' pt 7 t 'Newton solver with 5 Picard and line search', \
'results/b1SNL_BTt_NS_ST1e-20_UFSfalse_NSP-SPD_NSA-SPD_C0_g4_ag0_AEWfalse_UDSfalse_SF9e-1_NLT1e-14_ABT1e-2_LT1e-5_mLT1e-8_I150_P10_EW1_theta1_LS0_RSMfalse_AV-1_phi0_vel0_BV1e19_n3/plot.dat' u 9:10 w l dt 1 lw 2 lc rgb 'orange' t 'Newton solver with 10 Picard and without line search', \
'results/b1SNL_BTt_NS_ST1e-20_UFSfalse_NSP-SPD_NSA-SPD_C0_g4_ag0_AEWfalse_UDSfalse_SF9e-1_NLT1e-14_ABT1e-2_LT1e-5_mLT1e-8_I150_P10_EW1_theta1_LS100_RSMfalse_AV-1_phi0_vel0_BV1e19_n3/plot.dat' u 9:10 w p dt 3 lw 2 lc rgb 'orange' pt 7 ps 1 t 'Newton solver with 10 Picard and with line search', \
'results/b1SNL_BTt_NS_ST1e-20_UFSfalse_NSP-SPD_NSA-SPD_C0_g4_ag0_AEWfalse_UDSfalse_SF9e-1_NLT1e-14_ABT1e-2_LT1e-5_mLT1e-8_I150_P15_EW1_theta1_LS0_RSMfalse_AV-1_phi0_vel0_BV1e19_n3/plot.dat' u 9:10 w l dt 1 lw 2 lc rgb 'red' t 'Newton solver with 15 Picard and without line search', \
'results/b1SNL_BTt_NS_ST1e-20_UFSfalse_NSP-SPD_NSA-SPD_C0_g4_ag0_AEWfalse_UDSfalse_SF9e-1_NLT1e-14_ABT1e-2_LT1e-5_mLT1e-8_I150_P15_EW1_theta1_LS100_RSMfalse_AV-1_phi0_vel0_BV1e19_n3/plot.dat' u 9:10 w p dt 3 lw 2 lc rgb 'red' pt 7 ps 1 t 'Newton solver with 15 Picard and with line search', \
'<tail -n 1 results/b1SNL_BTt_NS_ST1e-20_UFSfalse_NSP-SPD_NSA-SPD_C0_g4_ag0_AEWfalse_UDSfalse_SF9e-1_NLT1e-14_ABT1e-2_LT1e-5_mLT1e-8_I150_P150_EW1_theta1_LS0_RSMfalse_AV-1_phi0_vel0_BV1e19_n3/plot.dat' u 9:10 w p lw 2 lc rgb 'green' pt 5 t '', \
'<tail -n 1 results/b1SNL_BTt_NS_ST1e-20_UFSfalse_NSP-SPD_NSA-SPD_C0_g4_ag0_AEWfalse_UDSfalse_SF9e-1_NLT1e-14_ABT1e-2_LT1e-5_mLT1e-8_I150_P5_EW1_theta1_LS0_RSMfalse_AV-1_phi0_vel0_BV1e19_n3/plot.dat' u 9:10 w p dt 1 lw 2 lc rgb 'blue' pt 5 t '', \
'<tail -n 1 results/b1SNL_BTt_NS_ST1e-20_UFSfalse_NSP-SPD_NSA-SPD_C0_g4_ag0_AEWfalse_UDSfalse_SF9e-1_NLT1e-14_ABT1e-2_LT1e-5_mLT1e-8_I150_P5_EW1_theta1_LS100_RSMfalse_AV-1_phi0_vel0_BV1e19_n3/plot.dat' u 9:10 w p dt 3 lw 2 lc rgb 'blue' pt 5 t '', \
'<tail -n 1 results/b1SNL_BTt_NS_ST1e-20_UFSfalse_NSP-SPD_NSA-SPD_C0_g4_ag0_AEWfalse_UDSfalse_SF9e-1_NLT1e-14_ABT1e-2_LT1e-5_mLT1e-8_I150_P10_EW1_theta1_LS0_RSMfalse_AV-1_phi0_vel0_BV1e19_n3/plot.dat' u 9:10 w p dt 1 lw 2 lc rgb 'orange' pt 5 t '', \
'<tail -n 1 results/b1SNL_BTt_NS_ST1e-20_UFSfalse_NSP-SPD_NSA-SPD_C0_g4_ag0_AEWfalse_UDSfalse_SF9e-1_NLT1e-14_ABT1e-2_LT1e-5_mLT1e-8_I150_P10_EW1_theta1_LS100_RSMfalse_AV-1_phi0_vel0_BV1e19_n3/plot.dat' u 9:10 w p dt 3 lw 2 lc rgb 'orange' pt 5 ps 1 t '', \
'<tail -n 1 results/b1SNL_BTt_NS_ST1e-20_UFSfalse_NSP-SPD_NSA-SPD_C0_g4_ag0_AEWfalse_UDSfalse_SF9e-1_NLT1e-14_ABT1e-2_LT1e-5_mLT1e-8_I150_P15_EW1_theta1_LS0_RSMfalse_AV-1_phi0_vel0_BV1e19_n3/plot.dat' u 9:10 w p dt 1 lw 2 lc rgb 'red' pt 5 t '', \
'<tail -n 1 results/b1SNL_BTt_NS_ST1e-20_UFSfalse_NSP-SPD_NSA-SPD_C0_g4_ag0_AEWfalse_UDSfalse_SF9e-1_NLT1e-14_ABT1e-2_LT1e-5_mLT1e-8_I150_P15_EW1_theta1_LS100_RSMfalse_AV-1_phi0_vel0_BV1e19_n3/plot.dat' u 9:10 w p dt 3 lw 2 lc rgb 'red' pt 5 ps 1 t ''
unset key
set origin 0,0
set title "Without stabilization of the velocity block and with the RSM"
plot \
'results/b1SNL_BTt_NS_ST1e-20_UFSfalse_NSP-SPD_NSA-none_C0_g4_ag0_AEWfalse_UDSfalse_SF9e-1_NLT1e-14_ABT1e-2_LT1e-5_mLT1e-8_I150_P150_EW1_theta1_LS0_RSMtrue_AV-1_phi0_vel0_BV1e19_n3/plot.dat' u 9:10 w l lw 2 lc rgb 'green' t 'Defect correction Picard', \
'results/b1SNL_BTt_NS_ST1e-20_UFSfalse_NSP-SPD_NSA-none_C0_g4_ag0_AEWfalse_UDSfalse_SF9e-1_NLT1e-14_ABT1e-2_LT1e-5_mLT1e-8_I150_P5_EW1_theta1_LS0_RSMtrue_AV-1_phi0_vel0_BV1e19_n3/plot.dat' u 9:10 w l dt 1 lw 2 lc rgb 'blue' t 'Newton solver with 5 Picard and without line search', \
'results/b1SNL_BTt_NS_ST1e-20_UFSfalse_NSP-SPD_NSA-none_C0_g4_ag0_AEWfalse_UDSfalse_SF9e-1_NLT1e-14_ABT1e-2_LT1e-5_mLT1e-8_I150_P5_EW1_theta1_LS100_RSMtrue_AV-1_phi0_vel0_BV1e19_n3/plot.dat' u 9:10 w p dt 3 lw 2 lc rgb 'blue' pt 7 t 'Newton solver with 5 Picard and line search', \
'results/b1SNL_BTt_NS_ST1e-20_UFSfalse_NSP-SPD_NSA-none_C0_g4_ag0_AEWfalse_UDSfalse_SF9e-1_NLT1e-14_ABT1e-2_LT1e-5_mLT1e-8_I150_P10_EW1_theta1_LS0_RSMtrue_AV-1_phi0_vel0_BV1e19_n3/plot.dat' u 9:10 w l dt 1 lw 2 lc rgb 'orange' t 'Newton solver with 10 Picard and without line search', \
'results/b1SNL_BTt_NS_ST1e-20_UFSfalse_NSP-SPD_NSA-none_C0_g4_ag0_AEWfalse_UDSfalse_SF9e-1_NLT1e-14_ABT1e-2_LT1e-5_mLT1e-8_I150_P10_EW1_theta1_LS100_RSMtrue_AV-1_phi0_vel0_BV1e19_n3/plot.dat' u 9:10 w p dt 3 lw 2 lc rgb 'orange' pt 7 ps 1 t 'Newton solver with 10 Picard and with line search', \
'results/b1SNL_BTt_NS_ST1e-20_UFSfalse_NSP-SPD_NSA-none_C0_g4_ag0_AEWfalse_UDSfalse_SF9e-1_NLT1e-14_ABT1e-2_LT1e-5_mLT1e-8_I150_P15_EW1_theta1_LS0_RSMtrue_AV-1_phi0_vel0_BV1e19_n3/plot.dat' u 9:10 w l dt 1 lw 2 lc rgb 'red' t 'Newton solver with 15 Picard and without line search', \
'results/b1SNL_BTt_NS_ST1e-20_UFSfalse_NSP-SPD_NSA-none_C0_g4_ag0_AEWfalse_UDSfalse_SF9e-1_NLT1e-14_ABT1e-2_LT1e-5_mLT1e-8_I150_P15_EW1_theta1_LS100_RSMtrue_AV-1_phi0_vel0_BV1e19_n3/plot.dat' u 9:10 w p dt 3 lw 2 lc rgb 'red' pt 7 ps 1 t 'Newton solver with 15 Picard and with line search', \
'<tail -n 1 results/b1SNL_BTt_NS_ST1e-20_UFSfalse_NSP-SPD_NSA-none_C0_g4_ag0_AEWfalse_UDSfalse_SF9e-1_NLT1e-14_ABT1e-2_LT1e-5_mLT1e-8_I150_P150_EW1_theta1_LS0_RSMtrue_AV-1_phi0_vel0_BV1e19_n3/plot.dat' u 9:10 w p lw 2 lc rgb 'green' pt 5 t 'Defect correction Picard', \
'<tail -n 1 results/b1SNL_BTt_NS_ST1e-20_UFSfalse_NSP-SPD_NSA-none_C0_g4_ag0_AEWfalse_UDSfalse_SF9e-1_NLT1e-14_ABT1e-2_LT1e-5_mLT1e-8_I150_P5_EW1_theta1_LS0_RSMtrue_AV-1_phi0_vel0_BV1e19_n3/plot.dat' u 9:10 w p dt 1 lw 2 lc rgb 'blue' pt 5 t 'Newton solver with 5 Picard and without line search', \
'<tail -n 1 results/b1SNL_BTt_NS_ST1e-20_UFSfalse_NSP-SPD_NSA-none_C0_g4_ag0_AEWfalse_UDSfalse_SF9e-1_NLT1e-14_ABT1e-2_LT1e-5_mLT1e-8_I150_P5_EW1_theta1_LS100_RSMtrue_AV-1_phi0_vel0_BV1e19_n3/plot.dat' u 9:10 w p dt 3 lw 2 lc rgb 'blue' pt 5 t 'Newton solver with 5 Picard and line search', \
'<tail -n 1 results/b1SNL_BTt_NS_ST1e-20_UFSfalse_NSP-SPD_NSA-none_C0_g4_ag0_AEWfalse_UDSfalse_SF9e-1_NLT1e-14_ABT1e-2_LT1e-5_mLT1e-8_I150_P10_EW1_theta1_LS0_RSMtrue_AV-1_phi0_vel0_BV1e19_n3/plot.dat' u 9:10 w p dt 1 lw 2 lc rgb 'orange' pt 5 t 'Newton solver with 10 Picard and without line search', \
'<tail -n 1 results/b1SNL_BTt_NS_ST1e-20_UFSfalse_NSP-SPD_NSA-none_C0_g4_ag0_AEWfalse_UDSfalse_SF9e-1_NLT1e-14_ABT1e-2_LT1e-5_mLT1e-8_I150_P10_EW1_theta1_LS100_RSMtrue_AV-1_phi0_vel0_BV1e19_n3/plot.dat' u 9:10 w p dt 3 lw 2 lc rgb 'orange' pt 5 ps 1 t 'Newton solver with 10 Picard and with line search', \
'<tail -n 1 results/b1SNL_BTt_NS_ST1e-20_UFSfalse_NSP-SPD_NSA-none_C0_g4_ag0_AEWfalse_UDSfalse_SF9e-1_NLT1e-14_ABT1e-2_LT1e-5_mLT1e-8_I150_P15_EW1_theta1_LS0_RSMtrue_AV-1_phi0_vel0_BV1e19_n3/plot.dat' u 9:10 w p dt 1 lw 2 lc rgb 'red' pt 5 t 'Newton solver with 15 Picard and without line search', \
'<tail -n 1 results/b1SNL_BTt_NS_ST1e-20_UFSfalse_NSP-SPD_NSA-none_C0_g4_ag0_AEWfalse_UDSfalse_SF9e-1_NLT1e-14_ABT1e-2_LT1e-5_mLT1e-8_I150_P15_EW1_theta1_LS100_RSMtrue_AV-1_phi0_vel0_BV1e19_n3/plot.dat' u 9:10 w p dt 3 lw 2 lc rgb 'red' pt 5 ps 1 t 'Newton solver with 15 Picard and with line search'
set origin 0.49,0
set title "With stabilization of the velocity block and with the RSM"
plot \
'results/b1SNL_BTt_NS_ST1e-20_UFSfalse_NSP-SPD_NSA-SPD_C0_g4_ag0_AEWfalse_UDSfalse_SF9e-1_NLT1e-14_ABT1e-2_LT1e-5_mLT1e-8_I150_P150_EW1_theta1_LS0_RSMtrue_AV-1_phi0_vel0_BV1e19_n3/plot.dat' u 9:10 w l lw 2 lc rgb 'green' t 'Defect correction Picard', \
'results/b1SNL_BTt_NS_ST1e-20_UFSfalse_NSP-SPD_NSA-SPD_C0_g4_ag0_AEWfalse_UDSfalse_SF9e-1_NLT1e-14_ABT1e-2_LT1e-5_mLT1e-8_I150_P5_EW1_theta1_LS0_RSMtrue_AV-1_phi0_vel0_BV1e19_n3/plot.dat' u 9:10 w l dt 1 lw 2 lc rgb 'blue' t 'Newton solver with 5 Picard and without line search', \
'results/b1SNL_BTt_NS_ST1e-20_UFSfalse_NSP-SPD_NSA-SPD_C0_g4_ag0_AEWfalse_UDSfalse_SF9e-1_NLT1e-14_ABT1e-2_LT1e-5_mLT1e-8_I150_P5_EW1_theta1_LS100_RSMtrue_AV-1_phi0_vel0_BV1e19_n3/plot.dat' u 9:10 w p dt 3 lw 2 lc rgb 'blue' pt 7 t 'Newton solver with 5 Picard and line search', \
'results/b1SNL_BTt_NS_ST1e-20_UFSfalse_NSP-SPD_NSA-SPD_C0_g4_ag0_AEWfalse_UDSfalse_SF9e-1_NLT1e-14_ABT1e-2_LT1e-5_mLT1e-8_I150_P10_EW1_theta1_LS0_RSMtrue_AV-1_phi0_vel0_BV1e19_n3/plot.dat' u 9:10 w l dt 1 lw 2 lc rgb 'orange' t 'Newton solver with 10 Picard and without line search', \
'results/b1SNL_BTt_NS_ST1e-20_UFSfalse_NSP-SPD_NSA-SPD_C0_g4_ag0_AEWfalse_UDSfalse_SF9e-1_NLT1e-14_ABT1e-2_LT1e-5_mLT1e-8_I150_P10_EW1_theta1_LS100_RSMtrue_AV-1_phi0_vel0_BV1e19_n3/plot.dat' u 9:10 w p dt 3 lw 2 lc rgb 'orange' pt 7 ps 1 t 'Newton solver with 10 Picard and with line search', \
'results/b1SNL_BTt_NS_ST1e-20_UFSfalse_NSP-SPD_NSA-SPD_C0_g4_ag0_AEWfalse_UDSfalse_SF9e-1_NLT1e-14_ABT1e-2_LT1e-5_mLT1e-8_I150_P15_EW1_theta1_LS0_RSMtrue_AV-1_phi0_vel0_BV1e19_n3/plot.dat' u 9:10 w l dt 1 lw 2 lc rgb 'red' t 'Newton solver with 15 Picard and without line search', \
'results/b1SNL_BTt_NS_ST1e-20_UFSfalse_NSP-SPD_NSA-SPD_C0_g4_ag0_AEWfalse_UDSfalse_SF9e-1_NLT1e-14_ABT1e-2_LT1e-5_mLT1e-8_I150_P15_EW1_theta1_LS100_RSMtrue_AV-1_phi0_vel0_BV1e19_n3/plot.dat' u 9:10 w p dt 3 lw 2 lc rgb 'red' pt 7 ps 1 t 'Newton solver with 15 Picard and with line search', \
'<tail -n 1 results/b1SNL_BTt_NS_ST1e-20_UFSfalse_NSP-SPD_NSA-SPD_C0_g4_ag0_AEWfalse_UDSfalse_SF9e-1_NLT1e-14_ABT1e-2_LT1e-5_mLT1e-8_I150_P150_EW1_theta1_LS0_RSMtrue_AV-1_phi0_vel0_BV1e19_n3/plot.dat' u 9:10 w p lw 2 lc rgb 'green' pt 5 t 'Defect correction Picard', \
'<tail -n 1 results/b1SNL_BTt_NS_ST1e-20_UFSfalse_NSP-SPD_NSA-SPD_C0_g4_ag0_AEWfalse_UDSfalse_SF9e-1_NLT1e-14_ABT1e-2_LT1e-5_mLT1e-8_I150_P5_EW1_theta1_LS0_RSMtrue_AV-1_phi0_vel0_BV1e19_n3/plot.dat' u 9:10 w p dt 1 lw 2 lc rgb 'blue' pt 5 t 'Newton solver with 5 Picard and without line search', \
'<tail -n 1 results/b1SNL_BTt_NS_ST1e-20_UFSfalse_NSP-SPD_NSA-SPD_C0_g4_ag0_AEWfalse_UDSfalse_SF9e-1_NLT1e-14_ABT1e-2_LT1e-5_mLT1e-8_I150_P5_EW1_theta1_LS100_RSMtrue_AV-1_phi0_vel0_BV1e19_n3/plot.dat' u 9:10 w p dt 3 lw 2 lc rgb 'blue' pt 5 t 'Newton solver with 5 Picard and line search', \
'<tail -n 1 results/b1SNL_BTt_NS_ST1e-20_UFSfalse_NSP-SPD_NSA-SPD_C0_g4_ag0_AEWfalse_UDSfalse_SF9e-1_NLT1e-14_ABT1e-2_LT1e-5_mLT1e-8_I150_P10_EW1_theta1_LS0_RSMtrue_AV-1_phi0_vel0_BV1e19_n3/plot.dat' u 9:10 w p dt 1 lw 2 lc rgb 'orange' pt 5 t 'Newton solver with 10 Picard and without line search', \
'<tail -n 1 results/b1SNL_BTt_NS_ST1e-20_UFSfalse_NSP-SPD_NSA-SPD_C0_g4_ag0_AEWfalse_UDSfalse_SF9e-1_NLT1e-14_ABT1e-2_LT1e-5_mLT1e-8_I150_P10_EW1_theta1_LS100_RSMtrue_AV-1_phi0_vel0_BV1e19_n3/plot.dat' u 9:10 w p dt 3 lw 2 lc rgb 'orange' pt 5 ps 1 t 'Newton solver with 10 Picard and with line search', \
'<tail -n 1 results/b1SNL_BTt_NS_ST1e-20_UFSfalse_NSP-SPD_NSA-SPD_C0_g4_ag0_AEWfalse_UDSfalse_SF9e-1_NLT1e-14_ABT1e-2_LT1e-5_mLT1e-8_I150_P15_EW1_theta1_LS0_RSMtrue_AV-1_phi0_vel0_BV1e19_n3/plot.dat' u 9:10 w p dt 1 lw 2 lc rgb 'red' pt 5 t 'Newton solver with 15 Picard and without line search', \
'<tail -n 1 results/b1SNL_BTt_NS_ST1e-20_UFSfalse_NSP-SPD_NSA-SPD_C0_g4_ag0_AEWfalse_UDSfalse_SF9e-1_NLT1e-14_ABT1e-2_LT1e-5_mLT1e-8_I150_P15_EW1_theta1_LS100_RSMtrue_AV-1_phi0_vel0_BV1e19_n3/plot.dat' u 9:10 w p dt 3 lw 2 lc rgb 'red' pt 5 ps 1 t 'Newton solver with 15 Picard and with line search'
