# Gravity field generated by mantle density variations

*This section was contributed by C. Thieulot and L. Jeanniot.*

The gravity postprocessor has been benchmarked in
{ref}`sec:benchmarks:thin-shell-gravity` and
{ref}`sec:benchmarks:thick-shell-gravity`. We use it here in an Earth-like
context: the tomography model S40RTS {cite}`ritsema:etal:2011` is used and scaled
so as to provide temperature anomalies, which themselves incorporated in the
Simple material model yield a density distribution for the entire Earth mantle
minus the lithosphere, i.e.
$R_\text{inner} \leq r \leq R_\text{outer}$ with
$R_\text{inner}=3480~\text{ km}$ and
$R_\text{outer}=6251~\text{ km}$. The use of the S20RTS/S40RTS
tomography model and its parameterization is detailed in
{ref}`sec:cookbooks-S20RTS`.

We set the global refinement to 3 so that the mesh counts
$12\times 16^3=49,152$ cells. This means that the radial resolution is
$(R_\text{outer}-R_\text{inner})/16\simeq  173~\text{ km}$ while
the lateral resolution is
$(4\pi R_\text{outer}^2/(12\times 16^2))^{1/2} \simeq 400~\text{ km}$ at
the surface and
$(4\pi R_\text{inner}^2/(12\times 16^2))^{1/2} \simeq 220~\text{ km}$ at
the CMB. The mesh and the density field are shown in {numref}`fig:grav_mantle1` and {numref}`fig:grav_mantle3`.
The temperature anomaly ranges from approximately $-342~\text{ k}$ to
approximately $+331~\text{ k}$ and geodynamical features such as the
mid-oceanic ridge or the Afar region are visible in the form of positive
temperature anomalies, indicating that mantle material is present in these
areas. Note that these values are not necessarily meaningful since we here
assume that density variations are 100% due to temperature variations as there
is only a single material in the domain (i.e. no change in composition in
space). Nevertheless this simple setup provides us with a complex-enough
density distribution to test the gravity postprocessor.


```{figure-md} fig:grav_mantle1
<img src="mesh.*" width="33%" />

 Mantle gravity cookbook (mesh). Coastlines are available for Paraview at https://www.earthmodels.org/date-and-tools/coastlines/los-alamos. Once opened the data must be scaled up (simply set the scale of the lower left menu in Paraview to the desired outer radius of your model). Grid lines are also available on the same site.
```

```{figure-md} fig:grav_mantle2
<img src="T.*" width="33%" />

 Mantle gravity cookbook (temperature anomaly). Coastlines are available for Paraview at https://www.earthmodels.org/date-and-tools/coastlines/los-alamos. Once opened the data must be scaled up (simply set the scale of the lower left menu in Paraview to the desired outer radius of your model). Grid lines are also available on the same site.
```

```{figure-md} fig:grav_mantle3
<img src="rho.*" width="33%" />

 Mantle gravity cookbook (density). Coastlines are available for Paraview at https://www.earthmodels.org/date-and-tools/coastlines/los-alamos. Once opened the data must be scaled up (simply set the scale of the lower left menu in Paraview to the desired outer radius of your model). Grid lines are also available on the same site.
```

The gravity postprocessor computes the gravitational potential, acceleration
vector and gradient at a given radius (here chosen to be
$6371+250=6621~\text{ km}$) on a regular $2^\circ$-latitude-longitude grid
(see also the cookbook of
{ref}`sec:benchmarks:thin-shell-gravity`) and returns the
results in the `gravity-00000` file to be found in the `output-gravity` folder
inside the regular output folder.

The python script `convert_gravity_ascii_to_vtu_map.py` converts the ascii
output to `vtu` format in order to view the results in ParaView. It is
provided in the folder of this cookbook and can be used as follows:

```{code-block} ksh
python3 convert_gravity_ascii_to_vtu_map.py gravity-00000 181 91
```

The first argument is the ascii file, while the following two arguments are
the number of longitude and latitude points as specified in the `prm` file.
The resulting `gravity-00000_map.vtu` file is then visualized with ParaView
and is shown in {numref}`fig:grav_mantle4`/{numref}`fig:grav_mantle5`. Note that on a modern laptop the calculations
resulting from running the provided `prm` file in the cookbook folder takes a
bit less than 2 hours on a single thread: about 1250&nbsp;s are spent in the
setup phase (using the spherical harmonics coefficients to compute the
temperature field on the mesh nodes) and about 4700&nbsp;s in the gravity
postprocessor itself. This time can be substantially decreased by running in
parallel on $n$ threads: the processor can then make use of the domain
decomposition and is almost $n$ times faster.

As shown in the thin shell gravity benchmark the constant component of the
density $\rho_0=3300~\text{ kg}/\text{m}^3$ generates a constant gravity
field at the measurement radius so it can be filtered out. In general, the
contribution to the gravity signal of any density distribution that solely
depends on $r$ can and should be removed as it does not contain any valuable
information.


```{figure-md} fig:grav_mantle4
<img src="grav.*" style="width:48.0%" />

 Mantle gravity: gravitational acceleration |g| computed at radius 6621&#xA0;km.
```

```{figure-md} fig:grav_mantle5
<img src="pot.*" style="width:48.0%" />

 Mantle gravity: gravitational potential computed at radius 6621&#xA0;km.
```
