library(osmdata)
library(rnaturalearth)
library(rnaturalearthdata)
library(ggplot2)
library(RANN)
library(igraph)
library(reshape2)
library(sfnetworks)
library(RcppHungarian)
library(spatstat)
library(sf)
library(tmap)
tmap_mode("view")
library(terra)
library(httr2)
library(ncdf4)
library(stars)
library(lubridate)
library(leaflet)
library(leaflet.extras2)
library(dplyr)

########################################################
#https://www.eea.europa.eu/en/datahub/datahubitem-view/6fc8ad2d-195d-40f4-bdec-576e7d1268e4
NATURA <- st_read("Natura/natura_WGS84.shp")
merged_Med <- st_read("examined_area.shp")

normalize_weights<-TRUE
remove_parts<-"NO"

# Origin shapefiles (could be a single one shapefile)
start_code<- "GR3000019"
start_area<-NATURA[NATURA[,1][[1]]==start_code,]

start_code_2<-"GR4220005"
start_area_2<-NATURA[NATURA[,1][[1]]==start_code_2,]
 
start_code_3<-"GR4210021"
start_area_3<-NATURA[NATURA[,1][[1]]==start_code_3,]

start_code_4<-"GR4210026"
start_area_4<-NATURA[NATURA[,1][[1]]==start_code_4,]

# Destination shapefile
end_code<-"GR4320006"
end_area<-NATURA[NATURA[,1][[1]]==end_code,]

points_function<-function(how_many, polygon_area){
  # Create random points inside these polygons
  polygon_area <- st_make_valid(polygon_area)
  random_points <- st_sample(polygon_area, size = how_many, type = "random")
  random_points_df <- as.data.frame(random_points)
  random_points_sf <- st_as_sf(random_points_df, crs = st_crs(polygon_area))
  return<-random_points_sf
}

# Number of origin points must be the same with number of destination points.
# random_points_1: start
# random_points_2: end
points_per_area<-20
how_many_areas_start<-4
how_many_areas_end <-1

points_start<-points_function(how_many_areas_end*points_per_area, start_area)
points_start_2<-points_function(how_many_areas_end*points_per_area, start_area_2)
points_start_3<-points_function(how_many_areas_end*points_per_area, start_area_3)
points_start_4<-points_function(how_many_areas_end*points_per_area, start_area_4)
random_points_1<-rbind(points_start, points_start_2, points_start_3, points_start_4)
random_points_1 <-random_points_1 $geometry


points_end<-points_function(how_many_areas_start*points_per_area, end_area)
random_points_2<-rbind(points_end)

random_points_2<-random_points_2$geometry

merged_Med  <- merged_Med

qtm(merged_Med)+qtm(start_area)+ qtm(random_points_1)+qtm(random_points_2)

rm(NATURA) #we delete it from memory because its very heavy


#https://data.marine.copernicus.eu/product/MEDSEA_ANALYSISFORECAST_PHY_006_013/description
nc_data <- read_stars("currents.nc")

currents_xy <- nc_data[,,,1, drop = TRUE]

cost_raster_input_x <- rast(currents_xy[1])
cost_raster_yes_x <- crop(cost_raster_input_x, vect(merged_Med), mask=TRUE)

cost_raster_input_y <- rast(currents_xy[2])
cost_raster_yes_y <- crop(cost_raster_input_y, vect(merged_Med), mask=TRUE)

rm(nc_data) #we delete it from memory because its very heavy
rm(currents_xy) #we delete it from memory because its very heavy


qtm(cost_raster_yes_x)+qtm(cost_raster_yes_y)+
  qtm(start_area)+qtm(end_area)+qtm(random_points_1)+qtm(random_points_2)

#############################################

nearest_grid_nodes<-4

spatial_resolution<-0.1

grid_points <- st_make_grid(bounding_box, cellsize = c(spatial_resolution, spatial_resolution))  # Adjust cellsize as needed
points_within_polygon <- st_intersection(grid_points, merged_Med)
points_within_polygon <- st_make_valid(points_within_polygon)
centroids <- st_centroid(points_within_polygon)
centroids_within_polygon <- st_intersection(centroids, merged_Med)

random_points_1_df <- as.data.frame(random_points_1)
distances_1 <- st_distance(random_points_1, centroids_within_polygon)
i=0
closest_data_frame_1<-data.frame(matrix(ncol=nearest_grid_nodes, nrow=length(random_points_1)))
while(i<length(random_points_1)){
  i=i+1
  closest_data_frame_1[i,]<-order(distances_1[i,])[1:nearest_grid_nodes]
}
closest_data_frame_1[,(ncol(closest_data_frame_1)+1)]<-1:nrow(closest_data_frame_1)
closest_data_frame_1<-closest_data_frame_1[,c(ncol(closest_data_frame_1),(1:ncol(closest_data_frame_1)-1))]
colnames(closest_data_frame_1)<-1:ncol(closest_data_frame_1)

melt_neighbours<-function(input_to_melt){
  nn_results_edges <- melt(input_to_melt, id = "1") 
  nn_results_edges<-nn_results_edges[,-2]
  nn_results_edges<-as.data.frame(nn_results_edges)
  nn_results_edges<-nn_results_edges[(!nn_results_edges[,1]==nn_results_edges[,2]),]
  nn_results_edges$sorted_row <- apply(nn_results_edges, 1, function(row) paste(sort(row), collapse = ','))
  nn_results_edges <- nn_results_edges[!duplicated(nn_results_edges$sorted_row), -3]
  nn_results_edges <- nn_results_edges[, -3]
  nn_results_edges[,3]<-1   #weight!!!
  colnames(nn_results_edges)<-c("from","to","weight")
  return<-nn_results_edges
}

edge_list_1<-melt_neighbours(closest_data_frame_1)
edge_list_1[,1]<-edge_list_1[,1]+length(centroids_within_polygon)

random_points_2_df <- as.data.frame(random_points_2)
distances_2 <- st_distance(random_points_2, centroids_within_polygon)
i=0
closest_data_frame_2<-data.frame(matrix(ncol=nearest_grid_nodes, nrow=length(random_points_2)))
while(i<length(random_points_2)){
  i=i+1
  closest_data_frame_2[i,]<-order(distances_2[i,])[1:nearest_grid_nodes]
}
closest_data_frame_2[,(ncol(closest_data_frame_2)+1)]<-1:nrow(closest_data_frame_2)
closest_data_frame_2<-closest_data_frame_2[,c(ncol(closest_data_frame_2),(1:ncol(closest_data_frame_2)-1))]
colnames(closest_data_frame_2)<-1:ncol(closest_data_frame_2)

edge_list_2<-melt_neighbours(closest_data_frame_2)
edge_list_2[,1]<-edge_list_2[,1]+max(edge_list_1[,1])

#####################################

k_neighbors <- 7

# Find nearest neighbors using RANN
nn_results <- nn2(st_coordinates(centroids_within_polygon), k = k_neighbors)
input_grid_graph<-nn_results[[1]]
colnames(input_grid_graph)<-1:ncol(input_grid_graph)
edge_list_0<-melt_neighbours(input_grid_graph)


#unified points object object
points_object<-centroids_within_polygon
i=0
while(i<length(random_points_1)){
  i=i+1
  points_object[length(centroids_within_polygon)+i]<-random_points_1[i] #random_points_1[i]
}

i=0
while(i<length(random_points_2)){
  i=i+1
  points_object[length(centroids_within_polygon)+length(random_points_1)+i]<-random_points_2[i]
}

#unifies edje list
edge_list_i<-rbind(edge_list_0,edge_list_1,edge_list_2)

points_cost_x<-extract(cost_raster_yes_x, vect(points_object))
points_cost_y<-extract(cost_raster_yes_y, vect(points_object))


# Function to normalize a column to the range [0.0..., 1]
normalize_dividing <- function(x) {
  #(x - min(x)) / (max(x) - min(x))
  #(x - 0) / (max(x) - 0) #we consider as the minimum value being 0
  # and all of them being positive integers
  x/max(x)
}

#sf networks test!!!
edges_list<-c()
values<-c()
i=0 
while(i<nrow(edge_list_i)){
  i=i+1
  first_point<-edge_list_i[i,1]
  second_point<-edge_list_i[i,2]
  edges_list[i] = st_sfc(st_linestring(c(points_object[[first_point]], points_object[[second_point]])))

  values[i]<-st_length(edges_list[i][[1]])
  
  #here I create the cost layer based on currents
  x_current_1<-points_cost_x[first_point,2]
  y_current_1<-points_cost_y[first_point,2]
  xy_current_vector<-as.matrix(c(x_current_1,y_current_1))

  basic_linestring<-edges_list[i][[1]]
  coords_basic_linestring <- st_coordinates(basic_linestring)
  
  # Calculate the direction vector
  direction_vector <- coords_basic_linestring[2, ] - coords_basic_linestring[1, ]
  xy_direction_vector<-as.matrix(c(direction_vector[[1]],direction_vector[[2]]))
 
  a<-xy_current_vector
  b<-xy_direction_vector

  dot_product <- sum(a * b)
  magnitude_v1 <- sqrt(sum(a^2))
  magnitude_v2 <- sqrt(sum(b^2))
  cos_angle <- dot_product / (magnitude_v1 * magnitude_v2)
  angle_rad <- acos(cos_angle)
  
  projection_length <- cos_angle * magnitude_v1

  values[i]<-projection_length * st_length(edges_list[i][[1]])
  
}

sfc_lines <- do.call(st_sfc, edges_list)
#We do these manipulations in order to add the values of the connectivity matrix in the links
values_df <- data.frame(values)

values_df$values[is.na(values_df$values)] <- 0
values_df$values[values_df$values >= 0 & values_df$values < 0.001] <- 0.001
values_df$values[values_df$values < 0 & values_df$values > -0.001] <- -0.001

if(normalize_weights==TRUE){values_df$values<-normalize_dividing(values_df$values)}
sfc_lines <- st_as_sf(sfc_lines)
sfc_lines$values <- values_df$values 

sfc_lines$positive<-sfc_lines$values>0
sfc_lines$line_ID<-1:nrow(sfc_lines)
#reverse the lines with the negative weights
new_reversed = st_reverse(sfc_lines[!sfc_lines$positive, ])
#remove the old lines
sfc_lines <-sfc_lines[sfc_lines$positive, ]
positive_weights_vector<-sfc_lines$positive
#add the new_reversed
sfc_lines = rbind(sfc_lines, new_reversed)
sfc_lines<-sfc_lines[order(sfc_lines$line_ID), ]

colnames(sfc_lines)[[1]]<-"weight"
sfc_lines$weight<-abs(sfc_lines$weight)

sfc_lines$weight<-1/sfc_lines$weight
sfc_lines$weight<-sfc_lines$weight/max(sfc_lines$weight) 


net_result = as_sfnetwork(sfc_lines, directed=TRUE)
st_crs(net_result)=crs(merged_Med)

result_edges<-st_as_sf(net_result, "edges")   
result_nodes = net_result %>% 
  activate("nodes") %>%
  st_as_sf()

starting_points_ID<-(length(centroids_within_polygon)+1):((length(centroids_within_polygon)+length(random_points_1)))
ending_points_ID<-(length(centroids_within_polygon)+length(random_points_1)+1):(length(centroids_within_polygon)+length(random_points_1)+length(random_points_2))

starting_points<-result_nodes[starting_points_ID,]
ending_points<-result_nodes[ending_points_ID,]

find_path_distances<-distances(net_result, v=starting_points_ID, to=ending_points_ID)



shortest_paths <- shortest_paths(net_result, from = starting_points_ID, to = ending_points_ID)

colnames(find_path_distances)<-ending_points_ID
rownames(find_path_distances)<-starting_points_ID

#####################################################

# Convert result_edges to sf object
#only for plotting purposes
result_edges_sf_small<-st_as_sf(result_edges, coords = c("x"))
result_edges_sf_small$weight<-1/result_edges_sf_small$weight
#https://github.com/trafficonese/leaflet.extras2/blob/master/inst/examples/arrowhead_app.R
le_map_0<-leaflet() %>%
  addTiles() %>%
  addProviderTiles("Esri.WorldImagery") %>%
  addPolylines(data = result_edges_sf_small, color = "blue", weight = 1) %>%
  addAntpath(data = result_edges_sf_small,
             group = "group",
             color = "red",
             weight = 1 + result_edges_sf_small$weight/10,
             opacity = 0.5)
#le_map_0


library(leaflet.minicharts)


coords <- st_coordinates(result_edges_sf_small)
coords_df <- as.data.frame(coords)
coords_df <- coords_df %>% group_by(L1) %>% summarize(
  lng0 = first(X),
  lat0 = first(Y),
  lng1 = last(X),
  lat1 = last(Y)
)

# Add the weight and other relevant columns
coords_df <- coords_df %>%
  mutate(
    flow = result_edges_sf_small$weight
  )

# Create the leaflet map and add flows
le_map <- leaflet() %>%
  addTiles() %>%
  addProviderTiles("Esri.WorldImagery") %>%
  addFlows(
    coords_df$lng0, coords_df$lat0, coords_df$lng1, coords_df$lat1,
    flow = coords_df$flow,
    time = NULL,# If you have time data, you can add it here
    maxFlow = max(coords_df$flow) *5,  # Adjust as necessary
    popupOptions = list(closeOnClick = FALSE, autoClose = FALSE),
    color="yellow"
  )


# Print the map
le_map

###########################################

greedy_match <- function(dist_matrix) {
  matched_pairs <- matrix(nrow = nrow(dist_matrix), ncol = 2)
  col_available <- rep(TRUE, ncol(dist_matrix))
  for (cc in 1:nrow(dist_matrix)) {
    # Find the column with the minimum distance for the current row
    min_dist_col <- which.min(ifelse(col_available, dist_matrix[cc, ], Inf))
    # Store the matched pair
    matched_pairs[cc, ] <- c(rownames(dist_matrix)[cc], colnames(dist_matrix)[min_dist_col])
    # Mark the column as unavailable
    col_available[min_dist_col] <- FALSE
  }
  return(matched_pairs)
}

hungarian_solution_translated<-greedy_match(find_path_distances)

best_paths<-list()
keep_edges<-c()
i=0
while(i<nrow(hungarian_solution_translated)){
  i=i+1
  start<-hungarian_solution_translated[,1][i]
  end<-hungarian_solution_translated[,2][i]
  find_path<-shortest_paths(net_result, from=start, to=end, output = "both")
  find_path_names<-as.numeric(find_path[["epath"]][[1]])
  
  best_paths[[i]]<-list()
  best_paths[[i]][[1]]<-c(start, end)
  best_paths[[i]][[2]]<-find_path_names
  best_paths[[i]][[3]]<-result_edges[find_path_names,]
  keep_edges<-c(keep_edges,find_path_names)
}

keep_edges_dataframe <- data.frame(variable = as.numeric(names(table(keep_edges))),
                                   frequency = as.numeric(table(keep_edges)))

get_subgraph<-subgraph.edges(net_result, keep_edges_dataframe[,1], delete.vertices = TRUE)
net_result_new = as_sfnetwork(get_subgraph, directed=FALSE)
new_weights<-keep_edges_dataframe[,2] 
net_result_new<-set.edge.attribute(net_result_new, "weight",index=E(net_result_new), value=new_weights)
result_edges_new<-st_as_sf(net_result_new, "edges") 

tm_starting_points <-   tm_shape(starting_points) +
  tm_symbols(size= 0.5,col="green")

tm_ending_points <-   tm_shape(ending_points) +
  tm_symbols(size= 0.5,col="blue")

################################################

net_result_loop<-net_result
initial_w<-get.edge.attribute(net_result, "weight")
initial_w_matrix<-data.frame(matrix(nrow=length(initial_w), ncol=2))
initial_w_matrix[,1]<-1:nrow(initial_w_matrix)
initial_w_matrix[,2]<-initial_w
colnames(initial_w_matrix)<-c("variable", "weight")

main_loop_cost<-0
many_times<-50
number_of_points<-nrow(find_path_distances)
population<-many_times*number_of_points
lamda=1
list_of_rounds<-list()
list_of_rounds_weights<-list()
keep_edges_dataframe_loop<-keep_edges_dataframe

merged <- merge(initial_w_matrix, keep_edges_dataframe_loop, by = "variable", all.x = TRUE)
merged$frequency[is.na(merged$frequency)] <- 0
merged$frequency<-merged$frequency/population
while(main_loop_cost<many_times){
  main_loop_cost<-main_loop_cost+1
  print(main_loop_cost)
  list_of_rounds[[main_loop_cost]]<-keep_edges_dataframe_loop
  
  merged$multiply<-merged[,2]/lamda+merged[,3]
  
  net_result_loop<-set.edge.attribute(net_result_loop, "weight",index=E(net_result_loop), value=merged$multiply)
  find_path_distances<-distances(net_result_loop, v=starting_points_ID, to=ending_points_ID)
  colnames(find_path_distances)<-ending_points_ID
  rownames(find_path_distances)<-starting_points_ID
  hungarian_solution_translated<-greedy_match(find_path_distances)
  
  best_paths<-list()
  keep_edges<-c()
  i=0
  while(i<nrow(hungarian_solution_translated)){
    i=i+1
    start<-hungarian_solution_translated[,1][i]
    end<-hungarian_solution_translated[,2][i]
    find_path<-shortest_paths(net_result_loop, from=start, to=end, output = "both")
    find_path_names<-as.numeric(find_path[["epath"]][[1]])
    keep_edges<-c(keep_edges,find_path_names)
  }
  
  keep_edges_dataframe_loop <- data.frame(variable = as.numeric(names(table(keep_edges))),
                                          frequency = as.numeric(table(keep_edges)))
  
  merged_new <- merge(initial_w_matrix, keep_edges_dataframe_loop, by = "variable", all.x = TRUE)
  merged_new$frequency[is.na(merged_new$frequency)] <- 0
  merged_new$frequency<-merged_new$frequency/population
  merged$frequency<-merged$frequency+merged_new$frequency
  list_of_rounds_weights[[main_loop_cost]]<-merged[,c(1,4)]
  
}

unlist_1<-c()
unlist_2<-c()

i=0
while(i<many_times){
  i<-i+1
  grab_it<-list_of_rounds[[i]]
  
  unlist_1<-c(unlist_1,grab_it[,1])
  unlist_2<-c(unlist_2,grab_it[,2])  
}

unlist_dataframe<-data.frame(matrix(ncol=2, nrow=length(unlist_1)))
unlist_dataframe[,1]<-unlist_1
unlist_dataframe[,2]<-unlist_2
colnames(unlist_dataframe)<-c("X1","X2")
unlist_dataframe[,2]<-unlist_dataframe[,2]/population

keep_edges_dataframe_after_loop <-aggregate(unlist_dataframe$X2, by = list(unlist_dataframe$X1), FUN = sum)
get_subgraph_of_final_paths<-subgraph.edges(net_result, keep_edges_dataframe_after_loop[,1], delete.vertices = TRUE)
net_result_final_paths= as_sfnetwork(get_subgraph_of_final_paths, directed=FALSE)
net_result_final_paths<-set.edge.attribute(net_result_final_paths, "weight",index=E(net_result_final_paths), value=keep_edges_dataframe_after_loop[,2])
result_edges_final_paths<-st_as_sf(net_result_final_paths, "edges") 


result_edges_final_paths<-result_edges_final_paths[,-4]
result_edges_final_paths<-result_edges_final_paths[,-4]

tm_starting_points <-   tm_shape(starting_points) +
  tm_symbols(size= 1,col="green")

tm_ending_points <-   tm_shape(ending_points) +
  tm_symbols(size= 1,col="blue")


library(viridis)

custom_palette <- colorRampPalette(c("blue", "red"))
n_colors <- 10  # Number of colors to generate
colors <- custom_palette(n_colors)

paths_colors<-tm_shape(result_edges)+
  tm_lines(col = "black",alpha = 0.05)+
  tm_shape(result_edges_final_paths) + 
  tm_lines(col = "weight",lwd="weight", scale=10, palette=colors, n=10)

################################################

root_data_F <- data.frame(matrix(nrow=(many_times-1), ncol=2))
root_data_F[,1]<-1:nrow(root_data_F)
i=1
while(i<many_times){
  i<-i+1
  freq1 <-list_of_rounds_weights[[i-1]]$multiply
  freq2 <-list_of_rounds_weights[[i]]$multiply
  rmse <- sqrt(mean((freq1 - freq2)^2))
  root_data_F[i-1,2]<-rmse
  
}

ggplot(root_data_F, aes(x = X1, y = X2)) +
  geom_point() +              # Add points
  geom_line() +               # Add line connecting points
  theme_minimal() +           # Use a minimal theme
  labs(title = "Line Plot with Points", 
       x = "X1", 
       y = "X2")              # Add labels
