# Evaluation Datasets for ChatTS

## Dataset Introduction
We offer the two evaluation datasets we gathered, as mentioned in the paper. Each dataset sample has these fields: `timeseries`, `question`, `answer` (text standard answers for reference), `attributes` (used for result evaluation), and `ability_types` (types of tasks in the question). Note that to cut evaluation costs, different questions about the same time series are combined into one `question`, and we use numbering to tell them apart. So, the actual number of questions in the evaluation dataset might be more than the number of `timeseries` entries. Also, some tasks in inductive reasoning and alignment are put in the same question because inductive reasoning tasks need to explain the physical meanings of time series attributes.

The `MCQ2` dataset is a third-party open-source dataset. We don't provide it here. Please download it directly from https://github.com/behavioral-data/TSandLanguage.

## Data Source
Dataset A contains real-world time series data from these sources:
- NAB: https://github.com/numenta/NAB. It uses the Apache License 2.0.
- Weather: https://www.bgc-jena.mpg.de/wetter/. It has the Terms of Use (as per Creative Commons CC-BY-4.0).
- Oracle: https://zenodo.org/records/6955909. [License information of Oracle dataset if known should be added here]
- AIOps: https://github.com/netmanaiops/kpi-anomaly-detection. [License information of AIOps dataset if known should be added here]

## License
Our datasets uses Creative Commons Attribution 4.0 International License (CC BY 4.0). If you use this dataset, you must:
1. **Give Attribution**: When using the dataset, clearly mention the dataset name and the sources: NAB, Weather, Oracle, AIOps and this dataset.
2. **Share Alike**: If you make something new based on this dataset, share it under the same CC BY 4.0 license.
3. **Follow Source Restrictions**: If any source dataset has special rules (like some parts of the Weather dataset under CC-BY-4.0), follow those too.

By using this dataset, you agree to follow all laws and the license terms of each source dataset and this overall license. 
