library(pheatmap)
library(dplyr)
# 加载字体
library(extrafont)

font_import()

fonts() 

red <- rgb(r=170,g=70,b=67,maxColorValue = 255)

blue <- rgb(r=69,g=114,b=167,maxColorValue = 255)

green <- rgb(r=137,g=165,b=78,maxColorValue = 255)

data <- read.table("Figure1-c-AMFs_Protein.txt",sep = ',', header = T,row.names = 1)

anno_col<- read.table("Figure1-c-annotation_col-total.txt",sep = '\t',header = T,row.names = 1)

anno_row<- read.table("Figure1-c-annotation_row-total.txt",sep = '\t',header = T,row.names = 1)

labels_row = rownames(anno_row)

# 定义一个函数，根据条件将值设置为空
replace_unwanted_values <- function(x) {
  if (x %in% c("DCAF13", "DKC1", "RPP40")) {
    return(x)
  } else {
    return("")
  }
}

# 使用sapply函数将函数应用于labels_row向量的每个元素
labels_row2 <- sapply(labels_row, replace_unwanted_values)

# 现在，labels_row 中的不满足条件的值已经被设置为空
anno_color = list(Group=c("Normal"= rgb(r=219,g=132,b=61,maxColorValue = 255),"Tumor"=rgb(r=113,g=88,b=143,maxColorValue = 255)),
                  RiBP.type=c("AMPs"=rgb(r=137,g=165,b=78,maxColorValue = 255),"RPs"=rgb(r=65,g=152,b=175,maxColorValue = 255))
)

P <- pheatmap(data,cluster_rows = F,cluster_cols = F,show_colnames = F,scale = "row", breaks = seq(-3, 3, length.out = 101),
         annotation_col = anno_col,annotation_row = anno_row,labels_row = labels_row2,
         annotation_colors = anno_color,
         color = colorRampPalette(c(blue, "white", red))(100))


pdf(file = "Figure1-c.pdf",family = "ArialMT", width = 8,height = 4)
print(P)
dev.off()