## Research compendium for 'Refitting the Context: A Reconsideration of Cultural Change among Early *Homo sapiens* at Fumane Cave through Blade Break Connections, Spatial Taphonomy, and Lithic Technology' 

### Compendium DOI:

[![DOI](https://zenodo.org/badge/785694313.svg)](https://zenodo.org/doi/10.5281/zenodo.10965413)

The content available at the above provided URL will reproduce the results as documented in the publication. Instead, the files hosted at <https://github.com/ArmandoFalcucci/Refitting-The-Context> represent the developmental versions and might have undergone modifications since the paper's publication.

### Maintainer of this repository:

[![ORCiD](https://img.shields.io/badge/ORCiD-0000--0002--3255--1005-green.svg)](https://orcid.org/0000-0002-3255-1005) Armando Falcucci (<armando.falcucci@uni-tuebingen.de>)

### Published paper:

Armando Falcucci, Domenico Giusti, Filippo Zangrossi, Matteo De Lorenzi, Letizia Ceregatti, Marco Peresani. Refitting the Context: Revisiting the Aurignacian sequence at Fumane Cave through blade fragment connections, spatial taphonomy, and lithic technology. _Journal of Paleolithic Archaeology_ (2024). DOI: [10.1007/s41982-024-00203-0](https://doi.org/10.1007/s41982-024-00203-0)

### Abstract:

High-resolution stratigraphic frameworks are crucial for unraveling the biocultural processes behind the dispersals of Homo sapiens across Europe. Detailed technological studies of lithic assemblages retrieved from multi-stratified sequences allow archaeologists to precisely model the chrono-cultural dynamics of the early Upper Paleolithic. However, it is of paramount importance to verify the integrity of these assemblages before building explanatory models of cultural change. In this study, multiple lines of evidence suggest that the stratigraphic sequence of Fumane Cave in northeastern Italy experienced minor post-depositional reworking, establishing it as a pivotal site for exploring the earliest stages of the Aurignacian. By conducting a systematic search for break connections between blade fragments and applying spatial analysis techniques, we identified three well-preserved areas of the excavation containing assemblages suitable for renewed archaeological investigations. Subsequent technological analyses, incorporating attribute analysis, reduction intensity, and multivariate statistics, have allowed us to discern the spatial organization of the site during the formation of the Protoaurignacian palimpsest A2–A1. Moreover, diachronic comparisons between three successive stratigraphic units prompted us to reject the hypothesis of techno-cultural continuity of the Protoaurignacian in northeastern Italy after the onset of the Heinrich Event 4. Based on the variability of the lithic and osseous artifacts, the most recent assemblage analyzed, D3b alpha, is now ascribed to the Early Aurignacian, aligning the evidence from Fumane with the current understanding of the development of the Aurignacian across Europe. Overall, this study demonstrates the high effectiveness of the break connection method when combined with detailed spatial analysis and lithic technology, providing a methodological tool particularly amenable to be applied to sites excavated in the past with varying degrees of recording accuracy.

### Keywords:

Protoaurignacian; Early Aurignacian; Lithics; Refittings; Assemblage integrity; Spatial analysis; Italy

### Overview of contents and how to reproduce:

Within this repository, various folders house data (`data`), code (`script`), and output files (`output`) pertinent to the paper. The data folder encompasses the blank and core datasets from the Aurignacian of Fumane Cave and the dataset of the blade fragment connection study. To replicate the results, download the entire repository and employ `Refitting-The-Context.Rproj` and open the folder `script`. For ensuring reproducibility, the `renv` package (v. 1.0.3) was utilized, following the procedures detailed in its vignette. All analyses and visualizations in the paper were conducted using R 4.3.1 on Microsoft Windows 10.0.19045 (64-bit). As the necessary packages are available in the `renv` folder, they are not explicitly listed here.

### Licenses:

Code: __MIT__ <http://opensource.org/licenses/MIT>, copyright holder: Armando Falcucci (2024).

Data and intellectual work: __Creative Commons Attribution 4.0 International License__ (http://creativecommons.org/licenses/by/4.0/), copyright holder: the authors (2024).
