# Ancillary files

## Master integrals and differential equation

For each family we provide:
*  the list of master integrals in the notation of `FiniteFlow` (FFG[family, {a1,...,a15}]);

* the matrix Ã of the differential equation (Eq. (3.5) in the paper), both in the Mandelstam variables and in the (x,y,z) variables;

* The boundary values at the physical point `{m32 = 1, s12 = 13/4, s23 = -3/4, m42 = 9/20} = {x = 3/2, y = 1/5, z = 1/2}`.

## DiffExp implementation

* One should first install [`DiffExp`](https://arxiv.org/abs/2006.05510) and modify the variable `PathToDiffExp` in `DiffExpRun.wl`.

* The allowed option for the computation are `-family`, `-vars` (either `sij` or `xyz`), `-filein` (the latter has to contain the kinematic point as a substitution rule for `vars`) and `fileout`, i.e. if one wants to compute the integrals of family `RL2` in the variables `xyz` at the point `{x = 5/3, y = 1/11, z = 1/7}`, one should run the command:
    ```
        math -script DiffExpRun.wl -family 'RL2' -vars 'xyz' -filein "point.m" -fileout "output.m"
    ```
    where the content of `point.m` should be `{x->5/3,y->1/11,z->1/7}` and the result will be saved in the file `output.m` in the notebook directory.

## Analytic solution

 We provide `.tar` files containing the analytic solution of the integrals in terms of Goncharov Polylogarithms.
