<?php

return [
    'base64logo' => 'data:image/png;base64,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',
    'sortingBasicIcon' => 'data:image/png;base64,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',
    'emailDefaultText' => "# Welcome to Mesort
Please confirm your email address and set a password by clicking on the following button.

If you don't see the button, please copy and paste this link:

",
    'maxNumberOfStudies' => env('MAX_NUMBER_STUDIES', 5),
    'blockedIps' => explode(',', env('BLOCKED_IPS', '')),
];
