// ========== Copyright Header Begin ==========================================
// 
// OpenSPARC T1 Processor File: scbuf.v
// Copyright (c) 2006 Sun Microsystems, Inc.  All Rights Reserved.
// DO NOT ALTER OR REMOVE COPYRIGHT NOTICES.
// 
// The above named program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License version 2 as published by the Free Software Foundation.
// 
// The above named program is distributed in the hope that it will be 
// useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public
// License along with this work; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.
// 
// ========== Copyright Header End ============================================
`include   "iop.h"


module scbuf (/*AUTOARG*/
   // Outputs
   scbuf_sctag_ev_uerr_r5, scbuf_sctag_ev_cerr_r5, 
   scbuf_jbi_ctag_vld, scbuf_jbi_data, scbuf_jbi_ue_err, 
   scbuf_sctag_rdma_uerr_c10, scbuf_sctag_rdma_cerr_c10, 
   scbuf_scdata_fbdecc_c4, scbuf_dram_data_mecc_r5, 
   scbuf_dram_wr_data_r5, scbuf_dram_data_vld_r5, so, 
   // Inputs
   sctag_scbuf_fbrd_en_c3, sctag_scbuf_fbrd_wl_c3, 
   sctag_scbuf_fbwr_wen_r2, sctag_scbuf_fbwr_wl_r2, 
   sctag_scbuf_fbd_stdatasel_c3, sctag_scbuf_stdecc_c3, 
   sctag_scbuf_evict_en_r0, sctag_scbuf_wbwr_wen_c6, 
   sctag_scbuf_wbwr_wl_c6, sctag_scbuf_wbrd_en_r0, 
   sctag_scbuf_wbrd_wl_r0, sctag_scbuf_ev_dword_r0, 
   sctag_scbuf_rdma_wren_s2, sctag_scbuf_rdma_wrwl_s2, jbi_sctag_req, 
   jbi_scbuf_ecc, sctag_scbuf_rdma_rden_r0, sctag_scbuf_rdma_rdwl_r0, 
   sctag_scbuf_ctag_en_c7, sctag_scbuf_ctag_c7, 
   sctag_scbuf_req_en_c7, sctag_scbuf_word_c7, 
   sctag_scbuf_word_vld_c7, scdata_scbuf_decc_out_c7, 
   dram_scbuf_data_r2, dram_scbuf_ecc_r2, cmp_gclk, arst_l, grst_l, 
   global_shift_enable, si, cluster_cken,ctu_tst_pre_grst_l, ctu_tst_scanmode, 
   ctu_tst_scan_disable, ctu_tst_macrotest, ctu_tst_short_chain
   );


//////////////////////////////////////////////////////////////////////////////
// Interface with sctag
//////////////////////////////////////////////////////////////////////////////

input           sctag_scbuf_fbrd_en_c3;   // rd en for a fill operation or fb bypass
input   [2:0]   sctag_scbuf_fbrd_wl_c3 ;  // read entry
input   [15:0]  sctag_scbuf_fbwr_wen_r2 ; // dram Fill or store in OFF mode.
input   [2:0]   sctag_scbuf_fbwr_wl_r2 ;  // dram Fill entry.
input           sctag_scbuf_fbd_stdatasel_c3; // select store data in OFF mode
input   [77:0]  sctag_scbuf_stdecc_c3;    // store data goes to scbuf and scdata

input           sctag_scbuf_evict_en_r0;
input   [3:0]   sctag_scbuf_wbwr_wen_c6;  // write en
input   [2:0]   sctag_scbuf_wbwr_wl_c6;   // from wbctl
input           sctag_scbuf_wbrd_en_r0;   // triggerred by a wr_ack from dram
input   [2:0]   sctag_scbuf_wbrd_wl_r0;

input   [2:0]   sctag_scbuf_ev_dword_r0;
output          scbuf_sctag_ev_uerr_r5;
output          scbuf_sctag_ev_cerr_r5;

input   [15:0]  sctag_scbuf_rdma_wren_s2;
input   [1:0]   sctag_scbuf_rdma_wrwl_s2;
input   [31:0]  jbi_sctag_req;
input   [6:0]   jbi_scbuf_ecc;
input           sctag_scbuf_rdma_rden_r0;
input   [1:0]   sctag_scbuf_rdma_rdwl_r0;

input           sctag_scbuf_ctag_en_c7;
input   [14:0]  sctag_scbuf_ctag_c7;
input           sctag_scbuf_req_en_c7;
input   [3:0]   sctag_scbuf_word_c7;
input           sctag_scbuf_word_vld_c7;
output          scbuf_jbi_ctag_vld;
output  [31:0]  scbuf_jbi_data;
output          scbuf_jbi_ue_err;
output          scbuf_sctag_rdma_uerr_c10;
output          scbuf_sctag_rdma_cerr_c10;


//////////////////////////////////////////////////////////////////////////////
// Interface with scdata
//////////////////////////////////////////////////////////////////////////////
output  [623:0]  scbuf_scdata_fbdecc_c4;
input   [623:0]  scdata_scbuf_decc_out_c7;


//////////////////////////////////////////////////////////////////////////////
// Interface with the DRAM
//////////////////////////////////////////////////////////////////////////////
output           scbuf_dram_data_mecc_r5;

output  [63:0]   scbuf_dram_wr_data_r5;
output           scbuf_dram_data_vld_r5;

input   [127:0]  dram_scbuf_data_r2;
input   [27:0]   dram_scbuf_ecc_r2;

//////////////////////////////////////////////////////////////////////////////
// Global Signals
//////////////////////////////////////////////////////////////////////////////
input            cmp_gclk;
input            arst_l;
input            grst_l;
input            global_shift_enable, si;
input		 cluster_cken;


output           so;
input	         ctu_tst_pre_grst_l;
input	         ctu_tst_scanmode;
input	         ctu_tst_scan_disable;
input	         ctu_tst_macrotest;
input	         ctu_tst_short_chain;




wire	         rclk;

wire             manual_scan_0;
wire             manual_scan_1;
wire             manual_scan_2;
wire             manual_scan_3;
wire             manual_scan_4;
wire             manual_scan_5;
wire             manual_scan_6;
wire             manual_scan_7;
wire             manual_scan_8;
wire             manual_scan_9;
wire             manual_scan_10;
wire             manual_scan_11;


wire             sctag_scbuf_fbrd_en_c3_v1;
wire             sctag_scbuf_fbrd_en_c3_v2;
wire             sctag_scbuf_fbrd_en_c3_v3;
wire             sctag_scbuf_fbrd_en_c3_v4;
wire   [2:0]     sctag_scbuf_fbrd_wl_c3_v1;
wire   [2:0]     sctag_scbuf_fbrd_wl_c3_v2;
wire   [2:0]     sctag_scbuf_fbrd_wl_c3_v3;
wire   [2:0]     sctag_scbuf_fbrd_wl_c3_v4;
wire   [15:0]    sctag_scbuf_fbwr_wen_r3;
wire   [2:0]     sctag_scbuf_fbwr_wl_r3_v1;
wire   [2:0]     sctag_scbuf_fbwr_wl_r3_v2;
wire   [2:0]     sctag_scbuf_fbwr_wl_r3_v3;
wire   [2:0]     sctag_scbuf_fbwr_wl_r3_v4;
wire   [623:0]   fb_array_din;
wire   [623:0]   scbuf_scdata_fbdecc_c4;
wire   [623:0]   scbuf_scdata_fbdecc_c4_pb;

wire   [63:0]    scbuf_dram_wr_data_r5_pb;

wire   [2:0]     sctag_scbuf_wbrd_wl_r1_v1;
wire   [2:0]     sctag_scbuf_wbrd_wl_r1_v2;
wire   [2:0]     sctag_scbuf_wbrd_wl_r1_v3;
wire   [2:0]     sctag_scbuf_wbrd_wl_r1_v4;
wire             sctag_scbuf_wbwr_wen_c8_v1;
wire             sctag_scbuf_wbwr_wen_c8_v2;
wire             sctag_scbuf_wbwr_wen_c8_v3;
wire             sctag_scbuf_wbwr_wen_c8_v4;
wire   [2:0]     sctag_scbuf_wbwr_wl_c8_v1;
wire   [2:0]     sctag_scbuf_wbwr_wl_c8_v2;
wire   [2:0]     sctag_scbuf_wbwr_wl_c8_v3;
wire   [2:0]     sctag_scbuf_wbwr_wl_c8_v4;
wire   [623:0]   scdata_scbuf_decc_out_c7;
wire   [623:0]   scdata_scbuf_decc_out_c7_buf;
wire   [623:0]   wb_array_dout;

wire   [15:0]    sctag_scbuf_rdma_wren_s3;
wire   [1:0]     sctag_scbuf_rdma_wrwl_s3_v1;
wire   [1:0]     sctag_scbuf_rdma_wrwl_s3_v2;
wire   [1:0]     sctag_scbuf_rdma_wrwl_s3_v3;
wire   [1:0]     sctag_scbuf_rdma_wrwl_s3_v4;
wire   [1:0]     sctag_scbuf_rdma_rdwl_r1_v1;
wire   [1:0]     sctag_scbuf_rdma_rdwl_r1_v2;
wire   [1:0]     sctag_scbuf_rdma_rdwl_r1_v3;
wire   [1:0]     sctag_scbuf_rdma_rdwl_r1_v4;
wire   [623:0]   rdma_array_din;
wire   [623:0]   rdma_array_dout;


wire   [15:0]    dummy_scbuf_scdata_fbdecc_c4 ;
wire   [15:0]    dummy_wb_array_dout ;
wire   [15:0]    dummy_rdma_array_dout ;
wire             se;


////////////////////////////////////////////////////////////////////////////////


bw_clk_cl_scbuf_cmp  header(.cluster_grst_l(scbuf_grst_l),
                       .gclk            (cmp_gclk),
                       .se              (se_buf2),
                       .si              (manual_scan_11),
                       .so              (scan_manual_1),
                       .rclk            (rclk),
                       .dbginit_l       (),
                       .cluster_cken    (cluster_cken),
                       .arst_l          (arst_l),
                       .grst_l          (grst_l),
                       .adbginit_l      (1'b1),
                       .gdbginit_l      (1'b1));

test_stub_scan tstub
  (// Outputs
   .mux_drive_disable    (),
   .mem_write_disable    (mem_write_disable),
   .sehold               (sehold),
   .se                   (se),
   .testmode_l           (),
   .mem_bypass           (),
   .so_0                 (so),
   .so_1                 (),
   .so_2                 (),

   // Inputs
   .ctu_tst_pre_grst_l   (ctu_tst_pre_grst_l),
   .arst_l               (arst_l),
   .global_shift_enable  (global_shift_enable),
   .ctu_tst_scan_disable (ctu_tst_scan_disable),
   .ctu_tst_scanmode     (ctu_tst_scanmode),
   .ctu_tst_macrotest    (ctu_tst_macrotest),
   .ctu_tst_short_chain  (ctu_tst_short_chain),
   .long_chain_so_0      (scan_manual_4),
   .short_chain_so_0     (manual_scan_11),
   .long_chain_so_1      (1'b0),
   .short_chain_so_1     (1'b0),
   .long_chain_so_2      (1'b0),
   .short_chain_so_2     (1'b0)
  );


scbuf_slowsig_buf slowsig_buf1
 (// Outputs
  .arst_l_buf            (arst_l_buf1),
  .se_buf                (se_buf1),
  .sehold_buf            (sehold_buf1),
  .mem_write_disable_buf (mem_write_disable_buf1),

  // Inputs
  .arst_l                (arst_l),
  .se                    (se),
  .sehold                (sehold),
  .mem_write_disable     (mem_write_disable)
 );

scbuf_slowsig_buf slowsig_buf2
 (// Outputs
  .arst_l_buf            (arst_l_buf2),
  .se_buf                (se_buf2),
  .sehold_buf            (sehold_buf2),
  .mem_write_disable_buf (mem_write_disable_buf2),

  // Inputs
  .arst_l                (arst_l),
  .se                    (se),
  .sehold                (sehold),
  .mem_write_disable     (mem_write_disable)
 );

scbuf_slowsig_buf slowsig_buf3
 (// Outputs
  .arst_l_buf            (arst_l_buf3),
  .se_buf                (se_buf3),
  .sehold_buf            (sehold_buf3),
  .mem_write_disable_buf (mem_write_disable_buf3),

  // Inputs
  .arst_l                (arst_l),
  .se                    (se),
  .sehold                (sehold),
  .mem_write_disable     (mem_write_disable)
 );



scbuf_sig_buf scbuf_sig_buf
 (// Outputs
  .scbuf_scdata_fbdecc_c4     (scbuf_scdata_fbdecc_c4[623:0]),
  .scbuf_dram_wr_data_r5      (scbuf_dram_wr_data_r5[63:0]),
  .scbuf_dram_data_vld_r5     (scbuf_dram_data_vld_r5),
  .scbuf_dram_data_mecc_r5    (scbuf_dram_data_mecc_r5),
  .scbuf_sctag_ev_uerr_r5     (scbuf_sctag_ev_uerr_r5),
  .scbuf_sctag_ev_cerr_r5     (scbuf_sctag_ev_cerr_r5),
  // Inputs
  .scbuf_scdata_fbdecc_c4_pb  (scbuf_scdata_fbdecc_c4_pb[623:0]),
  .scbuf_dram_wr_data_r5_pb   (scbuf_dram_wr_data_r5_pb[63:0]),
  .scbuf_dram_data_vld_r5_pb  (scbuf_dram_data_vld_r5_pb),
  .scbuf_dram_data_mecc_r5_pb (scbuf_dram_data_mecc_r5_pb),
  .scbuf_sctag_ev_uerr_r5_pb  (scbuf_sctag_ev_uerr_r5_pb),
  .scbuf_sctag_ev_cerr_r5_pb  (scbuf_sctag_ev_cerr_r5_pb)
  );





scbuf_fbd fbd
 (//Inputs
  .rclk                         (rclk),
  .se                           (se),
  .si                           (scan_manual_1),
  .sctag_scbuf_fbrd_en_c3       (sctag_scbuf_fbrd_en_c3),
  .sctag_scbuf_fbrd_wl_c3       (sctag_scbuf_fbrd_wl_c3[2:0]),
  .sctag_scbuf_fbwr_wen_r2      (sctag_scbuf_fbwr_wen_r2[15:0]),
  .sctag_scbuf_fbwr_wl_r2       (sctag_scbuf_fbwr_wl_r2[2:0]),
  .sctag_scbuf_fbd_stdatasel_c3 (sctag_scbuf_fbd_stdatasel_c3),
  .sctag_scbuf_stdecc_c3        (sctag_scbuf_stdecc_c3[77:0]),
  .dram_scbuf_data_r2           (dram_scbuf_data_r2[127:0]),
  .dram_scbuf_ecc_r2            (dram_scbuf_ecc_r2[27:0]),

  // Outputs
  .so                           (scan_manual_2),
  .sctag_scbuf_fbrd_en_c3_v1    (sctag_scbuf_fbrd_en_c3_v1),
  .sctag_scbuf_fbrd_en_c3_v2    (sctag_scbuf_fbrd_en_c3_v2),
  .sctag_scbuf_fbrd_en_c3_v3    (sctag_scbuf_fbrd_en_c3_v3),
  .sctag_scbuf_fbrd_en_c3_v4    (sctag_scbuf_fbrd_en_c3_v4),
  .sctag_scbuf_fbrd_wl_c3_v1    (sctag_scbuf_fbrd_wl_c3_v1[2:0]),
  .sctag_scbuf_fbrd_wl_c3_v2    (sctag_scbuf_fbrd_wl_c3_v2[2:0]),
  .sctag_scbuf_fbrd_wl_c3_v3    (sctag_scbuf_fbrd_wl_c3_v3[2:0]),
  .sctag_scbuf_fbrd_wl_c3_v4    (sctag_scbuf_fbrd_wl_c3_v4[2:0]),
  .sctag_scbuf_fbwr_wen_r3      (sctag_scbuf_fbwr_wen_r3[15:0]),
  .sctag_scbuf_fbwr_wren_r3_v4  (sctag_scbuf_fbwr_wren_r3_v4),
  .sctag_scbuf_fbwr_wren_r3_v3  (sctag_scbuf_fbwr_wren_r3_v3),
  .sctag_scbuf_fbwr_wren_r3_v2  (sctag_scbuf_fbwr_wren_r3_v2),
  .sctag_scbuf_fbwr_wren_r3_v1  (sctag_scbuf_fbwr_wren_r3_v1),
  .sctag_scbuf_fbwr_wl_r3_v1    (sctag_scbuf_fbwr_wl_r3_v1[2:0]),
  .sctag_scbuf_fbwr_wl_r3_v2    (sctag_scbuf_fbwr_wl_r3_v2[2:0]),
  .sctag_scbuf_fbwr_wl_r3_v3    (sctag_scbuf_fbwr_wl_r3_v3[2:0]),
  .sctag_scbuf_fbwr_wl_r3_v4    (sctag_scbuf_fbwr_wl_r3_v4[2:0]),
  .fb_array_din                 (fb_array_din[623:0])
 ) ;


bw_r_rf16x160  fb_array4
  (.dout   ({dummy_scbuf_scdata_fbdecc_c4[15:12],
             scbuf_scdata_fbdecc_c4_pb[351], scbuf_scdata_fbdecc_c4_pb[429], scbuf_scdata_fbdecc_c4_pb[507], scbuf_scdata_fbdecc_c4_pb[585],
             scbuf_scdata_fbdecc_c4_pb[352], scbuf_scdata_fbdecc_c4_pb[430], scbuf_scdata_fbdecc_c4_pb[508], scbuf_scdata_fbdecc_c4_pb[586],
             scbuf_scdata_fbdecc_c4_pb[353], scbuf_scdata_fbdecc_c4_pb[431], scbuf_scdata_fbdecc_c4_pb[509], scbuf_scdata_fbdecc_c4_pb[587],
             scbuf_scdata_fbdecc_c4_pb[354], scbuf_scdata_fbdecc_c4_pb[432], scbuf_scdata_fbdecc_c4_pb[510], scbuf_scdata_fbdecc_c4_pb[588],
             scbuf_scdata_fbdecc_c4_pb[355], scbuf_scdata_fbdecc_c4_pb[433], scbuf_scdata_fbdecc_c4_pb[511], scbuf_scdata_fbdecc_c4_pb[589],
             scbuf_scdata_fbdecc_c4_pb[356], scbuf_scdata_fbdecc_c4_pb[434], scbuf_scdata_fbdecc_c4_pb[512], scbuf_scdata_fbdecc_c4_pb[590],
             scbuf_scdata_fbdecc_c4_pb[357], scbuf_scdata_fbdecc_c4_pb[435], scbuf_scdata_fbdecc_c4_pb[513], scbuf_scdata_fbdecc_c4_pb[591],
             scbuf_scdata_fbdecc_c4_pb[358], scbuf_scdata_fbdecc_c4_pb[436], scbuf_scdata_fbdecc_c4_pb[514], scbuf_scdata_fbdecc_c4_pb[592],
             scbuf_scdata_fbdecc_c4_pb[359], scbuf_scdata_fbdecc_c4_pb[437], scbuf_scdata_fbdecc_c4_pb[515], scbuf_scdata_fbdecc_c4_pb[593],
             scbuf_scdata_fbdecc_c4_pb[360], scbuf_scdata_fbdecc_c4_pb[438], scbuf_scdata_fbdecc_c4_pb[516], scbuf_scdata_fbdecc_c4_pb[594],
             scbuf_scdata_fbdecc_c4_pb[361], scbuf_scdata_fbdecc_c4_pb[439], scbuf_scdata_fbdecc_c4_pb[517], scbuf_scdata_fbdecc_c4_pb[595],
             scbuf_scdata_fbdecc_c4_pb[362], scbuf_scdata_fbdecc_c4_pb[440], scbuf_scdata_fbdecc_c4_pb[518], scbuf_scdata_fbdecc_c4_pb[596],
             scbuf_scdata_fbdecc_c4_pb[363], scbuf_scdata_fbdecc_c4_pb[441], scbuf_scdata_fbdecc_c4_pb[519], scbuf_scdata_fbdecc_c4_pb[597],
             scbuf_scdata_fbdecc_c4_pb[364], scbuf_scdata_fbdecc_c4_pb[442], scbuf_scdata_fbdecc_c4_pb[520], scbuf_scdata_fbdecc_c4_pb[598],
             scbuf_scdata_fbdecc_c4_pb[365], scbuf_scdata_fbdecc_c4_pb[443], scbuf_scdata_fbdecc_c4_pb[521], scbuf_scdata_fbdecc_c4_pb[599],
             scbuf_scdata_fbdecc_c4_pb[366], scbuf_scdata_fbdecc_c4_pb[444], scbuf_scdata_fbdecc_c4_pb[522], scbuf_scdata_fbdecc_c4_pb[600],
             scbuf_scdata_fbdecc_c4_pb[367], scbuf_scdata_fbdecc_c4_pb[445], scbuf_scdata_fbdecc_c4_pb[523], scbuf_scdata_fbdecc_c4_pb[601],
             scbuf_scdata_fbdecc_c4_pb[368], scbuf_scdata_fbdecc_c4_pb[446], scbuf_scdata_fbdecc_c4_pb[524], scbuf_scdata_fbdecc_c4_pb[602],
             scbuf_scdata_fbdecc_c4_pb[369], scbuf_scdata_fbdecc_c4_pb[447], scbuf_scdata_fbdecc_c4_pb[525], scbuf_scdata_fbdecc_c4_pb[603],
             scbuf_scdata_fbdecc_c4_pb[370], scbuf_scdata_fbdecc_c4_pb[448], scbuf_scdata_fbdecc_c4_pb[526], scbuf_scdata_fbdecc_c4_pb[604],
             scbuf_scdata_fbdecc_c4_pb[371], scbuf_scdata_fbdecc_c4_pb[449], scbuf_scdata_fbdecc_c4_pb[527], scbuf_scdata_fbdecc_c4_pb[605],
             scbuf_scdata_fbdecc_c4_pb[372], scbuf_scdata_fbdecc_c4_pb[450], scbuf_scdata_fbdecc_c4_pb[528], scbuf_scdata_fbdecc_c4_pb[606],
             scbuf_scdata_fbdecc_c4_pb[373], scbuf_scdata_fbdecc_c4_pb[451], scbuf_scdata_fbdecc_c4_pb[529], scbuf_scdata_fbdecc_c4_pb[607],
             scbuf_scdata_fbdecc_c4_pb[374], scbuf_scdata_fbdecc_c4_pb[452], scbuf_scdata_fbdecc_c4_pb[530], scbuf_scdata_fbdecc_c4_pb[608],
             scbuf_scdata_fbdecc_c4_pb[375], scbuf_scdata_fbdecc_c4_pb[453], scbuf_scdata_fbdecc_c4_pb[531], scbuf_scdata_fbdecc_c4_pb[609],
             scbuf_scdata_fbdecc_c4_pb[376], scbuf_scdata_fbdecc_c4_pb[454], scbuf_scdata_fbdecc_c4_pb[532], scbuf_scdata_fbdecc_c4_pb[610],
             scbuf_scdata_fbdecc_c4_pb[377], scbuf_scdata_fbdecc_c4_pb[455], scbuf_scdata_fbdecc_c4_pb[533], scbuf_scdata_fbdecc_c4_pb[611],
             scbuf_scdata_fbdecc_c4_pb[378], scbuf_scdata_fbdecc_c4_pb[456], scbuf_scdata_fbdecc_c4_pb[534], scbuf_scdata_fbdecc_c4_pb[612],
             scbuf_scdata_fbdecc_c4_pb[379], scbuf_scdata_fbdecc_c4_pb[457], scbuf_scdata_fbdecc_c4_pb[535], scbuf_scdata_fbdecc_c4_pb[613],
             scbuf_scdata_fbdecc_c4_pb[380], scbuf_scdata_fbdecc_c4_pb[458], scbuf_scdata_fbdecc_c4_pb[536], scbuf_scdata_fbdecc_c4_pb[614],
             scbuf_scdata_fbdecc_c4_pb[381], scbuf_scdata_fbdecc_c4_pb[459], scbuf_scdata_fbdecc_c4_pb[537], scbuf_scdata_fbdecc_c4_pb[615],
             scbuf_scdata_fbdecc_c4_pb[382], scbuf_scdata_fbdecc_c4_pb[460], scbuf_scdata_fbdecc_c4_pb[538], scbuf_scdata_fbdecc_c4_pb[616],
             scbuf_scdata_fbdecc_c4_pb[383], scbuf_scdata_fbdecc_c4_pb[461], scbuf_scdata_fbdecc_c4_pb[539], scbuf_scdata_fbdecc_c4_pb[617],
             scbuf_scdata_fbdecc_c4_pb[384], scbuf_scdata_fbdecc_c4_pb[462], scbuf_scdata_fbdecc_c4_pb[540], scbuf_scdata_fbdecc_c4_pb[618],
             scbuf_scdata_fbdecc_c4_pb[385], scbuf_scdata_fbdecc_c4_pb[463], scbuf_scdata_fbdecc_c4_pb[541], scbuf_scdata_fbdecc_c4_pb[619],
             scbuf_scdata_fbdecc_c4_pb[386], scbuf_scdata_fbdecc_c4_pb[464], scbuf_scdata_fbdecc_c4_pb[542], scbuf_scdata_fbdecc_c4_pb[620],
             scbuf_scdata_fbdecc_c4_pb[387], scbuf_scdata_fbdecc_c4_pb[465], scbuf_scdata_fbdecc_c4_pb[543], scbuf_scdata_fbdecc_c4_pb[621],
             scbuf_scdata_fbdecc_c4_pb[388], scbuf_scdata_fbdecc_c4_pb[466], scbuf_scdata_fbdecc_c4_pb[544], scbuf_scdata_fbdecc_c4_pb[622],
             scbuf_scdata_fbdecc_c4_pb[389], scbuf_scdata_fbdecc_c4_pb[467], scbuf_scdata_fbdecc_c4_pb[545], scbuf_scdata_fbdecc_c4_pb[623]}),
   .din    ({1'b0, 1'b0, 1'b0, 1'b0,
             fb_array_din[351], fb_array_din[429], fb_array_din[507], fb_array_din[585],
             fb_array_din[352], fb_array_din[430], fb_array_din[508], fb_array_din[586],
             fb_array_din[353], fb_array_din[431], fb_array_din[509], fb_array_din[587],
             fb_array_din[354], fb_array_din[432], fb_array_din[510], fb_array_din[588],
             fb_array_din[355], fb_array_din[433], fb_array_din[511], fb_array_din[589],
             fb_array_din[356], fb_array_din[434], fb_array_din[512], fb_array_din[590],
             fb_array_din[357], fb_array_din[435], fb_array_din[513], fb_array_din[591],
             fb_array_din[358], fb_array_din[436], fb_array_din[514], fb_array_din[592],
             fb_array_din[359], fb_array_din[437], fb_array_din[515], fb_array_din[593],
             fb_array_din[360], fb_array_din[438], fb_array_din[516], fb_array_din[594],
             fb_array_din[361], fb_array_din[439], fb_array_din[517], fb_array_din[595],
             fb_array_din[362], fb_array_din[440], fb_array_din[518], fb_array_din[596],
             fb_array_din[363], fb_array_din[441], fb_array_din[519], fb_array_din[597],
             fb_array_din[364], fb_array_din[442], fb_array_din[520], fb_array_din[598],
             fb_array_din[365], fb_array_din[443], fb_array_din[521], fb_array_din[599],
             fb_array_din[366], fb_array_din[444], fb_array_din[522], fb_array_din[600],
             fb_array_din[367], fb_array_din[445], fb_array_din[523], fb_array_din[601],
             fb_array_din[368], fb_array_din[446], fb_array_din[524], fb_array_din[602],
             fb_array_din[369], fb_array_din[447], fb_array_din[525], fb_array_din[603],
             fb_array_din[370], fb_array_din[448], fb_array_din[526], fb_array_din[604],
             fb_array_din[371], fb_array_din[449], fb_array_din[527], fb_array_din[605],
             fb_array_din[372], fb_array_din[450], fb_array_din[528], fb_array_din[606],
             fb_array_din[373], fb_array_din[451], fb_array_din[529], fb_array_din[607],
             fb_array_din[374], fb_array_din[452], fb_array_din[530], fb_array_din[608],
             fb_array_din[375], fb_array_din[453], fb_array_din[531], fb_array_din[609],
             fb_array_din[376], fb_array_din[454], fb_array_din[532], fb_array_din[610],
             fb_array_din[377], fb_array_din[455], fb_array_din[533], fb_array_din[611],
             fb_array_din[378], fb_array_din[456], fb_array_din[534], fb_array_din[612],
             fb_array_din[379], fb_array_din[457], fb_array_din[535], fb_array_din[613],
             fb_array_din[380], fb_array_din[458], fb_array_din[536], fb_array_din[614],
             fb_array_din[381], fb_array_din[459], fb_array_din[537], fb_array_din[615],
             fb_array_din[382], fb_array_din[460], fb_array_din[538], fb_array_din[616],
             fb_array_din[383], fb_array_din[461], fb_array_din[539], fb_array_din[617],
             fb_array_din[384], fb_array_din[462], fb_array_din[540], fb_array_din[618],
             fb_array_din[385], fb_array_din[463], fb_array_din[541], fb_array_din[619],
             fb_array_din[386], fb_array_din[464], fb_array_din[542], fb_array_din[620],
             fb_array_din[387], fb_array_din[465], fb_array_din[543], fb_array_din[621],
             fb_array_din[388], fb_array_din[466], fb_array_din[544], fb_array_din[622],
             fb_array_din[389], fb_array_din[467], fb_array_din[545], fb_array_din[623]}),
   .rd_adr   ({1'b0, sctag_scbuf_fbrd_wl_c3_v4[2:0]}),
   .wr_adr   ({1'b0, sctag_scbuf_fbwr_wl_r3_v4[2:0]}),
   .read_en  (sctag_scbuf_fbrd_en_c3_v4),
   .wr_en    (sctag_scbuf_fbwr_wren_r3_v4),
   .word_wen ({sctag_scbuf_fbwr_wen_r3[6], sctag_scbuf_fbwr_wen_r3[4],
               sctag_scbuf_fbwr_wen_r3[2], sctag_scbuf_fbwr_wen_r3[0]}),
   .byte_wen ({1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1,
               1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1}),
   .rd_clk   (rclk),
   .wr_clk   (rclk),
   .se       (se_buf1),
   .si_r       (si),
   .si_w       (manual_scan_0a),
   .so_r       (manual_scan_0a),
   .so_w       (manual_scan_0),
   .reset_l    (arst_l_buf1),
   .rst_tri_en (mem_write_disable_buf1),
   .sehold     (sehold_buf1));


bw_r_rf16x160  fb_array3
  (.dout   ({dummy_scbuf_scdata_fbdecc_c4[11:8],
             scbuf_scdata_fbdecc_c4_pb[312], scbuf_scdata_fbdecc_c4_pb[390], scbuf_scdata_fbdecc_c4_pb[468], scbuf_scdata_fbdecc_c4_pb[546],
             scbuf_scdata_fbdecc_c4_pb[313], scbuf_scdata_fbdecc_c4_pb[391], scbuf_scdata_fbdecc_c4_pb[469], scbuf_scdata_fbdecc_c4_pb[547],
             scbuf_scdata_fbdecc_c4_pb[314], scbuf_scdata_fbdecc_c4_pb[392], scbuf_scdata_fbdecc_c4_pb[470], scbuf_scdata_fbdecc_c4_pb[548],
             scbuf_scdata_fbdecc_c4_pb[315], scbuf_scdata_fbdecc_c4_pb[393], scbuf_scdata_fbdecc_c4_pb[471], scbuf_scdata_fbdecc_c4_pb[549],
             scbuf_scdata_fbdecc_c4_pb[316], scbuf_scdata_fbdecc_c4_pb[394], scbuf_scdata_fbdecc_c4_pb[472], scbuf_scdata_fbdecc_c4_pb[550],
             scbuf_scdata_fbdecc_c4_pb[317], scbuf_scdata_fbdecc_c4_pb[395], scbuf_scdata_fbdecc_c4_pb[473], scbuf_scdata_fbdecc_c4_pb[551],
             scbuf_scdata_fbdecc_c4_pb[318], scbuf_scdata_fbdecc_c4_pb[396], scbuf_scdata_fbdecc_c4_pb[474], scbuf_scdata_fbdecc_c4_pb[552],
             scbuf_scdata_fbdecc_c4_pb[319], scbuf_scdata_fbdecc_c4_pb[397], scbuf_scdata_fbdecc_c4_pb[475], scbuf_scdata_fbdecc_c4_pb[553],
             scbuf_scdata_fbdecc_c4_pb[320], scbuf_scdata_fbdecc_c4_pb[398], scbuf_scdata_fbdecc_c4_pb[476], scbuf_scdata_fbdecc_c4_pb[554],
             scbuf_scdata_fbdecc_c4_pb[321], scbuf_scdata_fbdecc_c4_pb[399], scbuf_scdata_fbdecc_c4_pb[477], scbuf_scdata_fbdecc_c4_pb[555],
             scbuf_scdata_fbdecc_c4_pb[322], scbuf_scdata_fbdecc_c4_pb[400], scbuf_scdata_fbdecc_c4_pb[478], scbuf_scdata_fbdecc_c4_pb[556],
             scbuf_scdata_fbdecc_c4_pb[323], scbuf_scdata_fbdecc_c4_pb[401], scbuf_scdata_fbdecc_c4_pb[479], scbuf_scdata_fbdecc_c4_pb[557],
             scbuf_scdata_fbdecc_c4_pb[324], scbuf_scdata_fbdecc_c4_pb[402], scbuf_scdata_fbdecc_c4_pb[480], scbuf_scdata_fbdecc_c4_pb[558],
             scbuf_scdata_fbdecc_c4_pb[325], scbuf_scdata_fbdecc_c4_pb[403], scbuf_scdata_fbdecc_c4_pb[481], scbuf_scdata_fbdecc_c4_pb[559],
             scbuf_scdata_fbdecc_c4_pb[326], scbuf_scdata_fbdecc_c4_pb[404], scbuf_scdata_fbdecc_c4_pb[482], scbuf_scdata_fbdecc_c4_pb[560],
             scbuf_scdata_fbdecc_c4_pb[327], scbuf_scdata_fbdecc_c4_pb[405], scbuf_scdata_fbdecc_c4_pb[483], scbuf_scdata_fbdecc_c4_pb[561],
             scbuf_scdata_fbdecc_c4_pb[328], scbuf_scdata_fbdecc_c4_pb[406], scbuf_scdata_fbdecc_c4_pb[484], scbuf_scdata_fbdecc_c4_pb[562],
             scbuf_scdata_fbdecc_c4_pb[329], scbuf_scdata_fbdecc_c4_pb[407], scbuf_scdata_fbdecc_c4_pb[485], scbuf_scdata_fbdecc_c4_pb[563],
             scbuf_scdata_fbdecc_c4_pb[330], scbuf_scdata_fbdecc_c4_pb[408], scbuf_scdata_fbdecc_c4_pb[486], scbuf_scdata_fbdecc_c4_pb[564],
             scbuf_scdata_fbdecc_c4_pb[331], scbuf_scdata_fbdecc_c4_pb[409], scbuf_scdata_fbdecc_c4_pb[487], scbuf_scdata_fbdecc_c4_pb[565],
             scbuf_scdata_fbdecc_c4_pb[332], scbuf_scdata_fbdecc_c4_pb[410], scbuf_scdata_fbdecc_c4_pb[488], scbuf_scdata_fbdecc_c4_pb[566],
             scbuf_scdata_fbdecc_c4_pb[333], scbuf_scdata_fbdecc_c4_pb[411], scbuf_scdata_fbdecc_c4_pb[489], scbuf_scdata_fbdecc_c4_pb[567],
             scbuf_scdata_fbdecc_c4_pb[334], scbuf_scdata_fbdecc_c4_pb[412], scbuf_scdata_fbdecc_c4_pb[490], scbuf_scdata_fbdecc_c4_pb[568],
             scbuf_scdata_fbdecc_c4_pb[335], scbuf_scdata_fbdecc_c4_pb[413], scbuf_scdata_fbdecc_c4_pb[491], scbuf_scdata_fbdecc_c4_pb[569],
             scbuf_scdata_fbdecc_c4_pb[336], scbuf_scdata_fbdecc_c4_pb[414], scbuf_scdata_fbdecc_c4_pb[492], scbuf_scdata_fbdecc_c4_pb[570],
             scbuf_scdata_fbdecc_c4_pb[337], scbuf_scdata_fbdecc_c4_pb[415], scbuf_scdata_fbdecc_c4_pb[493], scbuf_scdata_fbdecc_c4_pb[571],
             scbuf_scdata_fbdecc_c4_pb[338], scbuf_scdata_fbdecc_c4_pb[416], scbuf_scdata_fbdecc_c4_pb[494], scbuf_scdata_fbdecc_c4_pb[572],
             scbuf_scdata_fbdecc_c4_pb[339], scbuf_scdata_fbdecc_c4_pb[417], scbuf_scdata_fbdecc_c4_pb[495], scbuf_scdata_fbdecc_c4_pb[573],
             scbuf_scdata_fbdecc_c4_pb[340], scbuf_scdata_fbdecc_c4_pb[418], scbuf_scdata_fbdecc_c4_pb[496], scbuf_scdata_fbdecc_c4_pb[574],
             scbuf_scdata_fbdecc_c4_pb[341], scbuf_scdata_fbdecc_c4_pb[419], scbuf_scdata_fbdecc_c4_pb[497], scbuf_scdata_fbdecc_c4_pb[575],
             scbuf_scdata_fbdecc_c4_pb[342], scbuf_scdata_fbdecc_c4_pb[420], scbuf_scdata_fbdecc_c4_pb[498], scbuf_scdata_fbdecc_c4_pb[576],
             scbuf_scdata_fbdecc_c4_pb[343], scbuf_scdata_fbdecc_c4_pb[421], scbuf_scdata_fbdecc_c4_pb[499], scbuf_scdata_fbdecc_c4_pb[577],
             scbuf_scdata_fbdecc_c4_pb[344], scbuf_scdata_fbdecc_c4_pb[422], scbuf_scdata_fbdecc_c4_pb[500], scbuf_scdata_fbdecc_c4_pb[578],
             scbuf_scdata_fbdecc_c4_pb[345], scbuf_scdata_fbdecc_c4_pb[423], scbuf_scdata_fbdecc_c4_pb[501], scbuf_scdata_fbdecc_c4_pb[579],
             scbuf_scdata_fbdecc_c4_pb[346], scbuf_scdata_fbdecc_c4_pb[424], scbuf_scdata_fbdecc_c4_pb[502], scbuf_scdata_fbdecc_c4_pb[580],
             scbuf_scdata_fbdecc_c4_pb[347], scbuf_scdata_fbdecc_c4_pb[425], scbuf_scdata_fbdecc_c4_pb[503], scbuf_scdata_fbdecc_c4_pb[581],
             scbuf_scdata_fbdecc_c4_pb[348], scbuf_scdata_fbdecc_c4_pb[426], scbuf_scdata_fbdecc_c4_pb[504], scbuf_scdata_fbdecc_c4_pb[582],
             scbuf_scdata_fbdecc_c4_pb[349], scbuf_scdata_fbdecc_c4_pb[427], scbuf_scdata_fbdecc_c4_pb[505], scbuf_scdata_fbdecc_c4_pb[583],
             scbuf_scdata_fbdecc_c4_pb[350], scbuf_scdata_fbdecc_c4_pb[428], scbuf_scdata_fbdecc_c4_pb[506], scbuf_scdata_fbdecc_c4_pb[584]}),
   .din    ({1'b0, 1'b0, 1'b0, 1'b0,
             fb_array_din[312], fb_array_din[390], fb_array_din[468], fb_array_din[546],
             fb_array_din[313], fb_array_din[391], fb_array_din[469], fb_array_din[547],
             fb_array_din[314], fb_array_din[392], fb_array_din[470], fb_array_din[548],
             fb_array_din[315], fb_array_din[393], fb_array_din[471], fb_array_din[549],
             fb_array_din[316], fb_array_din[394], fb_array_din[472], fb_array_din[550],
             fb_array_din[317], fb_array_din[395], fb_array_din[473], fb_array_din[551],
             fb_array_din[318], fb_array_din[396], fb_array_din[474], fb_array_din[552],
             fb_array_din[319], fb_array_din[397], fb_array_din[475], fb_array_din[553],
             fb_array_din[320], fb_array_din[398], fb_array_din[476], fb_array_din[554],
             fb_array_din[321], fb_array_din[399], fb_array_din[477], fb_array_din[555],
             fb_array_din[322], fb_array_din[400], fb_array_din[478], fb_array_din[556],
             fb_array_din[323], fb_array_din[401], fb_array_din[479], fb_array_din[557],
             fb_array_din[324], fb_array_din[402], fb_array_din[480], fb_array_din[558],
             fb_array_din[325], fb_array_din[403], fb_array_din[481], fb_array_din[559],
             fb_array_din[326], fb_array_din[404], fb_array_din[482], fb_array_din[560],
             fb_array_din[327], fb_array_din[405], fb_array_din[483], fb_array_din[561],
             fb_array_din[328], fb_array_din[406], fb_array_din[484], fb_array_din[562],
             fb_array_din[329], fb_array_din[407], fb_array_din[485], fb_array_din[563],
             fb_array_din[330], fb_array_din[408], fb_array_din[486], fb_array_din[564],
             fb_array_din[331], fb_array_din[409], fb_array_din[487], fb_array_din[565],
             fb_array_din[332], fb_array_din[410], fb_array_din[488], fb_array_din[566],
             fb_array_din[333], fb_array_din[411], fb_array_din[489], fb_array_din[567],
             fb_array_din[334], fb_array_din[412], fb_array_din[490], fb_array_din[568],
             fb_array_din[335], fb_array_din[413], fb_array_din[491], fb_array_din[569],
             fb_array_din[336], fb_array_din[414], fb_array_din[492], fb_array_din[570],
             fb_array_din[337], fb_array_din[415], fb_array_din[493], fb_array_din[571],
             fb_array_din[338], fb_array_din[416], fb_array_din[494], fb_array_din[572],
             fb_array_din[339], fb_array_din[417], fb_array_din[495], fb_array_din[573],
             fb_array_din[340], fb_array_din[418], fb_array_din[496], fb_array_din[574],
             fb_array_din[341], fb_array_din[419], fb_array_din[497], fb_array_din[575],
             fb_array_din[342], fb_array_din[420], fb_array_din[498], fb_array_din[576],
             fb_array_din[343], fb_array_din[421], fb_array_din[499], fb_array_din[577],
             fb_array_din[344], fb_array_din[422], fb_array_din[500], fb_array_din[578],
             fb_array_din[345], fb_array_din[423], fb_array_din[501], fb_array_din[579],
             fb_array_din[346], fb_array_din[424], fb_array_din[502], fb_array_din[580],
             fb_array_din[347], fb_array_din[425], fb_array_din[503], fb_array_din[581],
             fb_array_din[348], fb_array_din[426], fb_array_din[504], fb_array_din[582],
             fb_array_din[349], fb_array_din[427], fb_array_din[505], fb_array_din[583],
             fb_array_din[350], fb_array_din[428], fb_array_din[506], fb_array_din[584]}),
   .rd_adr   ({1'b0, sctag_scbuf_fbrd_wl_c3_v3[2:0]}),
   .wr_adr   ({1'b0, sctag_scbuf_fbwr_wl_r3_v3[2:0]}),
   .read_en  (sctag_scbuf_fbrd_en_c3_v3),
   .wr_en    (sctag_scbuf_fbwr_wren_r3_v3),
   .word_wen ({sctag_scbuf_fbwr_wen_r3[7], sctag_scbuf_fbwr_wen_r3[5],
               sctag_scbuf_fbwr_wen_r3[3], sctag_scbuf_fbwr_wen_r3[1]}),
   .byte_wen ({1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1,
               1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1}),
   .rd_clk   (rclk),
   .wr_clk   (rclk),
   .se       (se_buf1),
   .si_r       (manual_scan_0),
   .si_w       (manual_scan_1a),
   .so_r       (manual_scan_1a),
   .so_w       (manual_scan_1),
   .reset_l    (arst_l_buf1),
   .rst_tri_en (mem_write_disable_buf1),
   .sehold     (sehold_buf1));


bw_r_rf16x160  fb_array2
  (.dout   ({dummy_scbuf_scdata_fbdecc_c4[7:4],
             scbuf_scdata_fbdecc_c4_pb[39], scbuf_scdata_fbdecc_c4_pb[117], scbuf_scdata_fbdecc_c4_pb[195], scbuf_scdata_fbdecc_c4_pb[273],
             scbuf_scdata_fbdecc_c4_pb[40], scbuf_scdata_fbdecc_c4_pb[118], scbuf_scdata_fbdecc_c4_pb[196], scbuf_scdata_fbdecc_c4_pb[274],
             scbuf_scdata_fbdecc_c4_pb[41], scbuf_scdata_fbdecc_c4_pb[119], scbuf_scdata_fbdecc_c4_pb[197], scbuf_scdata_fbdecc_c4_pb[275],
             scbuf_scdata_fbdecc_c4_pb[42], scbuf_scdata_fbdecc_c4_pb[120], scbuf_scdata_fbdecc_c4_pb[198], scbuf_scdata_fbdecc_c4_pb[276],
             scbuf_scdata_fbdecc_c4_pb[43], scbuf_scdata_fbdecc_c4_pb[121], scbuf_scdata_fbdecc_c4_pb[199], scbuf_scdata_fbdecc_c4_pb[277],
             scbuf_scdata_fbdecc_c4_pb[44], scbuf_scdata_fbdecc_c4_pb[122], scbuf_scdata_fbdecc_c4_pb[200], scbuf_scdata_fbdecc_c4_pb[278],
             scbuf_scdata_fbdecc_c4_pb[45], scbuf_scdata_fbdecc_c4_pb[123], scbuf_scdata_fbdecc_c4_pb[201], scbuf_scdata_fbdecc_c4_pb[279],
             scbuf_scdata_fbdecc_c4_pb[46], scbuf_scdata_fbdecc_c4_pb[124], scbuf_scdata_fbdecc_c4_pb[202], scbuf_scdata_fbdecc_c4_pb[280],
             scbuf_scdata_fbdecc_c4_pb[47], scbuf_scdata_fbdecc_c4_pb[125], scbuf_scdata_fbdecc_c4_pb[203], scbuf_scdata_fbdecc_c4_pb[281],
             scbuf_scdata_fbdecc_c4_pb[48], scbuf_scdata_fbdecc_c4_pb[126], scbuf_scdata_fbdecc_c4_pb[204], scbuf_scdata_fbdecc_c4_pb[282],
             scbuf_scdata_fbdecc_c4_pb[49], scbuf_scdata_fbdecc_c4_pb[127], scbuf_scdata_fbdecc_c4_pb[205], scbuf_scdata_fbdecc_c4_pb[283],
             scbuf_scdata_fbdecc_c4_pb[50], scbuf_scdata_fbdecc_c4_pb[128], scbuf_scdata_fbdecc_c4_pb[206], scbuf_scdata_fbdecc_c4_pb[284],
             scbuf_scdata_fbdecc_c4_pb[51], scbuf_scdata_fbdecc_c4_pb[129], scbuf_scdata_fbdecc_c4_pb[207], scbuf_scdata_fbdecc_c4_pb[285],
             scbuf_scdata_fbdecc_c4_pb[52], scbuf_scdata_fbdecc_c4_pb[130], scbuf_scdata_fbdecc_c4_pb[208], scbuf_scdata_fbdecc_c4_pb[286],
             scbuf_scdata_fbdecc_c4_pb[53], scbuf_scdata_fbdecc_c4_pb[131], scbuf_scdata_fbdecc_c4_pb[209], scbuf_scdata_fbdecc_c4_pb[287],
             scbuf_scdata_fbdecc_c4_pb[54], scbuf_scdata_fbdecc_c4_pb[132], scbuf_scdata_fbdecc_c4_pb[210], scbuf_scdata_fbdecc_c4_pb[288],
             scbuf_scdata_fbdecc_c4_pb[55], scbuf_scdata_fbdecc_c4_pb[133], scbuf_scdata_fbdecc_c4_pb[211], scbuf_scdata_fbdecc_c4_pb[289],
             scbuf_scdata_fbdecc_c4_pb[56], scbuf_scdata_fbdecc_c4_pb[134], scbuf_scdata_fbdecc_c4_pb[212], scbuf_scdata_fbdecc_c4_pb[290],
             scbuf_scdata_fbdecc_c4_pb[57], scbuf_scdata_fbdecc_c4_pb[135], scbuf_scdata_fbdecc_c4_pb[213], scbuf_scdata_fbdecc_c4_pb[291],
             scbuf_scdata_fbdecc_c4_pb[58], scbuf_scdata_fbdecc_c4_pb[136], scbuf_scdata_fbdecc_c4_pb[214], scbuf_scdata_fbdecc_c4_pb[292],
             scbuf_scdata_fbdecc_c4_pb[59], scbuf_scdata_fbdecc_c4_pb[137], scbuf_scdata_fbdecc_c4_pb[215], scbuf_scdata_fbdecc_c4_pb[293],
             scbuf_scdata_fbdecc_c4_pb[60], scbuf_scdata_fbdecc_c4_pb[138], scbuf_scdata_fbdecc_c4_pb[216], scbuf_scdata_fbdecc_c4_pb[294],
             scbuf_scdata_fbdecc_c4_pb[61], scbuf_scdata_fbdecc_c4_pb[139], scbuf_scdata_fbdecc_c4_pb[217], scbuf_scdata_fbdecc_c4_pb[295],
             scbuf_scdata_fbdecc_c4_pb[62], scbuf_scdata_fbdecc_c4_pb[140], scbuf_scdata_fbdecc_c4_pb[218], scbuf_scdata_fbdecc_c4_pb[296],
             scbuf_scdata_fbdecc_c4_pb[63], scbuf_scdata_fbdecc_c4_pb[141], scbuf_scdata_fbdecc_c4_pb[219], scbuf_scdata_fbdecc_c4_pb[297],
             scbuf_scdata_fbdecc_c4_pb[64], scbuf_scdata_fbdecc_c4_pb[142], scbuf_scdata_fbdecc_c4_pb[220], scbuf_scdata_fbdecc_c4_pb[298],
             scbuf_scdata_fbdecc_c4_pb[65], scbuf_scdata_fbdecc_c4_pb[143], scbuf_scdata_fbdecc_c4_pb[221], scbuf_scdata_fbdecc_c4_pb[299],
             scbuf_scdata_fbdecc_c4_pb[66], scbuf_scdata_fbdecc_c4_pb[144], scbuf_scdata_fbdecc_c4_pb[222], scbuf_scdata_fbdecc_c4_pb[300],
             scbuf_scdata_fbdecc_c4_pb[67], scbuf_scdata_fbdecc_c4_pb[145], scbuf_scdata_fbdecc_c4_pb[223], scbuf_scdata_fbdecc_c4_pb[301],
             scbuf_scdata_fbdecc_c4_pb[68], scbuf_scdata_fbdecc_c4_pb[146], scbuf_scdata_fbdecc_c4_pb[224], scbuf_scdata_fbdecc_c4_pb[302],
             scbuf_scdata_fbdecc_c4_pb[69], scbuf_scdata_fbdecc_c4_pb[147], scbuf_scdata_fbdecc_c4_pb[225], scbuf_scdata_fbdecc_c4_pb[303],
             scbuf_scdata_fbdecc_c4_pb[70], scbuf_scdata_fbdecc_c4_pb[148], scbuf_scdata_fbdecc_c4_pb[226], scbuf_scdata_fbdecc_c4_pb[304],
             scbuf_scdata_fbdecc_c4_pb[71], scbuf_scdata_fbdecc_c4_pb[149], scbuf_scdata_fbdecc_c4_pb[227], scbuf_scdata_fbdecc_c4_pb[305],
             scbuf_scdata_fbdecc_c4_pb[72], scbuf_scdata_fbdecc_c4_pb[150], scbuf_scdata_fbdecc_c4_pb[228], scbuf_scdata_fbdecc_c4_pb[306],
             scbuf_scdata_fbdecc_c4_pb[73], scbuf_scdata_fbdecc_c4_pb[151], scbuf_scdata_fbdecc_c4_pb[229], scbuf_scdata_fbdecc_c4_pb[307],
             scbuf_scdata_fbdecc_c4_pb[74], scbuf_scdata_fbdecc_c4_pb[152], scbuf_scdata_fbdecc_c4_pb[230], scbuf_scdata_fbdecc_c4_pb[308],
             scbuf_scdata_fbdecc_c4_pb[75], scbuf_scdata_fbdecc_c4_pb[153], scbuf_scdata_fbdecc_c4_pb[231], scbuf_scdata_fbdecc_c4_pb[309],
             scbuf_scdata_fbdecc_c4_pb[76], scbuf_scdata_fbdecc_c4_pb[154], scbuf_scdata_fbdecc_c4_pb[232], scbuf_scdata_fbdecc_c4_pb[310],
             scbuf_scdata_fbdecc_c4_pb[77], scbuf_scdata_fbdecc_c4_pb[155], scbuf_scdata_fbdecc_c4_pb[233], scbuf_scdata_fbdecc_c4_pb[311]}),
   .din    ({1'b0, 1'b0, 1'b0, 1'b0,
             fb_array_din[39], fb_array_din[117], fb_array_din[195], fb_array_din[273],
             fb_array_din[40], fb_array_din[118], fb_array_din[196], fb_array_din[274],
             fb_array_din[41], fb_array_din[119], fb_array_din[197], fb_array_din[275],
             fb_array_din[42], fb_array_din[120], fb_array_din[198], fb_array_din[276],
             fb_array_din[43], fb_array_din[121], fb_array_din[199], fb_array_din[277],
             fb_array_din[44], fb_array_din[122], fb_array_din[200], fb_array_din[278],
             fb_array_din[45], fb_array_din[123], fb_array_din[201], fb_array_din[279],
             fb_array_din[46], fb_array_din[124], fb_array_din[202], fb_array_din[280],
             fb_array_din[47], fb_array_din[125], fb_array_din[203], fb_array_din[281],
             fb_array_din[48], fb_array_din[126], fb_array_din[204], fb_array_din[282],
             fb_array_din[49], fb_array_din[127], fb_array_din[205], fb_array_din[283],
             fb_array_din[50], fb_array_din[128], fb_array_din[206], fb_array_din[284],
             fb_array_din[51], fb_array_din[129], fb_array_din[207], fb_array_din[285],
             fb_array_din[52], fb_array_din[130], fb_array_din[208], fb_array_din[286],
             fb_array_din[53], fb_array_din[131], fb_array_din[209], fb_array_din[287],
             fb_array_din[54], fb_array_din[132], fb_array_din[210], fb_array_din[288],
             fb_array_din[55], fb_array_din[133], fb_array_din[211], fb_array_din[289],
             fb_array_din[56], fb_array_din[134], fb_array_din[212], fb_array_din[290],
             fb_array_din[57], fb_array_din[135], fb_array_din[213], fb_array_din[291],
             fb_array_din[58], fb_array_din[136], fb_array_din[214], fb_array_din[292],
             fb_array_din[59], fb_array_din[137], fb_array_din[215], fb_array_din[293],
             fb_array_din[60], fb_array_din[138], fb_array_din[216], fb_array_din[294],
             fb_array_din[61], fb_array_din[139], fb_array_din[217], fb_array_din[295],
             fb_array_din[62], fb_array_din[140], fb_array_din[218], fb_array_din[296],
             fb_array_din[63], fb_array_din[141], fb_array_din[219], fb_array_din[297],
             fb_array_din[64], fb_array_din[142], fb_array_din[220], fb_array_din[298],
             fb_array_din[65], fb_array_din[143], fb_array_din[221], fb_array_din[299],
             fb_array_din[66], fb_array_din[144], fb_array_din[222], fb_array_din[300],
             fb_array_din[67], fb_array_din[145], fb_array_din[223], fb_array_din[301],
             fb_array_din[68], fb_array_din[146], fb_array_din[224], fb_array_din[302],
             fb_array_din[69], fb_array_din[147], fb_array_din[225], fb_array_din[303],
             fb_array_din[70], fb_array_din[148], fb_array_din[226], fb_array_din[304],
             fb_array_din[71], fb_array_din[149], fb_array_din[227], fb_array_din[305],
             fb_array_din[72], fb_array_din[150], fb_array_din[228], fb_array_din[306],
             fb_array_din[73], fb_array_din[151], fb_array_din[229], fb_array_din[307],
             fb_array_din[74], fb_array_din[152], fb_array_din[230], fb_array_din[308],
             fb_array_din[75], fb_array_din[153], fb_array_din[231], fb_array_din[309],
             fb_array_din[76], fb_array_din[154], fb_array_din[232], fb_array_din[310],
             fb_array_din[77], fb_array_din[155], fb_array_din[233], fb_array_din[311]}),
   .rd_adr   ({1'b0, sctag_scbuf_fbrd_wl_c3_v2[2:0]}),
   .wr_adr   ({1'b0, sctag_scbuf_fbwr_wl_r3_v2[2:0]}),
   .read_en  (sctag_scbuf_fbrd_en_c3_v2),
   .wr_en    (sctag_scbuf_fbwr_wren_r3_v2),
   .word_wen ({sctag_scbuf_fbwr_wen_r3[14], sctag_scbuf_fbwr_wen_r3[12],
               sctag_scbuf_fbwr_wen_r3[10], sctag_scbuf_fbwr_wen_r3[8]}),
   .byte_wen ({1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1,
               1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1}),
   .rd_clk   (rclk),
   .wr_clk   (rclk),
   .se       (se_buf1),
   .si_r       (manual_scan_1),
   .si_w       (manual_scan_2a),
   .so_r       (manual_scan_2a),
   .so_w       (manual_scan_2),
   .reset_l    (arst_l_buf1),
   .rst_tri_en (mem_write_disable_buf1),
   .sehold     (sehold_buf1));


bw_r_rf16x160  fb_array1
  (.dout   ({dummy_scbuf_scdata_fbdecc_c4[3:0],
             scbuf_scdata_fbdecc_c4_pb[0], scbuf_scdata_fbdecc_c4_pb[78], scbuf_scdata_fbdecc_c4_pb[156], scbuf_scdata_fbdecc_c4_pb[234],
             scbuf_scdata_fbdecc_c4_pb[1], scbuf_scdata_fbdecc_c4_pb[79], scbuf_scdata_fbdecc_c4_pb[157], scbuf_scdata_fbdecc_c4_pb[235],
             scbuf_scdata_fbdecc_c4_pb[2], scbuf_scdata_fbdecc_c4_pb[80], scbuf_scdata_fbdecc_c4_pb[158], scbuf_scdata_fbdecc_c4_pb[236],
             scbuf_scdata_fbdecc_c4_pb[3], scbuf_scdata_fbdecc_c4_pb[81], scbuf_scdata_fbdecc_c4_pb[159], scbuf_scdata_fbdecc_c4_pb[237],
             scbuf_scdata_fbdecc_c4_pb[4], scbuf_scdata_fbdecc_c4_pb[82], scbuf_scdata_fbdecc_c4_pb[160], scbuf_scdata_fbdecc_c4_pb[238],
             scbuf_scdata_fbdecc_c4_pb[5], scbuf_scdata_fbdecc_c4_pb[83], scbuf_scdata_fbdecc_c4_pb[161], scbuf_scdata_fbdecc_c4_pb[239],
             scbuf_scdata_fbdecc_c4_pb[6], scbuf_scdata_fbdecc_c4_pb[84], scbuf_scdata_fbdecc_c4_pb[162], scbuf_scdata_fbdecc_c4_pb[240],
             scbuf_scdata_fbdecc_c4_pb[7], scbuf_scdata_fbdecc_c4_pb[85], scbuf_scdata_fbdecc_c4_pb[163], scbuf_scdata_fbdecc_c4_pb[241],
             scbuf_scdata_fbdecc_c4_pb[8], scbuf_scdata_fbdecc_c4_pb[86], scbuf_scdata_fbdecc_c4_pb[164], scbuf_scdata_fbdecc_c4_pb[242],
             scbuf_scdata_fbdecc_c4_pb[9], scbuf_scdata_fbdecc_c4_pb[87], scbuf_scdata_fbdecc_c4_pb[165], scbuf_scdata_fbdecc_c4_pb[243],
             scbuf_scdata_fbdecc_c4_pb[10], scbuf_scdata_fbdecc_c4_pb[88], scbuf_scdata_fbdecc_c4_pb[166], scbuf_scdata_fbdecc_c4_pb[244],
             scbuf_scdata_fbdecc_c4_pb[11], scbuf_scdata_fbdecc_c4_pb[89], scbuf_scdata_fbdecc_c4_pb[167], scbuf_scdata_fbdecc_c4_pb[245],
             scbuf_scdata_fbdecc_c4_pb[12], scbuf_scdata_fbdecc_c4_pb[90], scbuf_scdata_fbdecc_c4_pb[168], scbuf_scdata_fbdecc_c4_pb[246],
             scbuf_scdata_fbdecc_c4_pb[13], scbuf_scdata_fbdecc_c4_pb[91], scbuf_scdata_fbdecc_c4_pb[169], scbuf_scdata_fbdecc_c4_pb[247],
             scbuf_scdata_fbdecc_c4_pb[14], scbuf_scdata_fbdecc_c4_pb[92], scbuf_scdata_fbdecc_c4_pb[170], scbuf_scdata_fbdecc_c4_pb[248],
             scbuf_scdata_fbdecc_c4_pb[15], scbuf_scdata_fbdecc_c4_pb[93], scbuf_scdata_fbdecc_c4_pb[171], scbuf_scdata_fbdecc_c4_pb[249],
             scbuf_scdata_fbdecc_c4_pb[16], scbuf_scdata_fbdecc_c4_pb[94], scbuf_scdata_fbdecc_c4_pb[172], scbuf_scdata_fbdecc_c4_pb[250],
             scbuf_scdata_fbdecc_c4_pb[17], scbuf_scdata_fbdecc_c4_pb[95], scbuf_scdata_fbdecc_c4_pb[173], scbuf_scdata_fbdecc_c4_pb[251],
             scbuf_scdata_fbdecc_c4_pb[18], scbuf_scdata_fbdecc_c4_pb[96], scbuf_scdata_fbdecc_c4_pb[174], scbuf_scdata_fbdecc_c4_pb[252],
             scbuf_scdata_fbdecc_c4_pb[19], scbuf_scdata_fbdecc_c4_pb[97], scbuf_scdata_fbdecc_c4_pb[175], scbuf_scdata_fbdecc_c4_pb[253],
             scbuf_scdata_fbdecc_c4_pb[20], scbuf_scdata_fbdecc_c4_pb[98], scbuf_scdata_fbdecc_c4_pb[176], scbuf_scdata_fbdecc_c4_pb[254],
             scbuf_scdata_fbdecc_c4_pb[21], scbuf_scdata_fbdecc_c4_pb[99], scbuf_scdata_fbdecc_c4_pb[177], scbuf_scdata_fbdecc_c4_pb[255],
             scbuf_scdata_fbdecc_c4_pb[22], scbuf_scdata_fbdecc_c4_pb[100], scbuf_scdata_fbdecc_c4_pb[178], scbuf_scdata_fbdecc_c4_pb[256],
             scbuf_scdata_fbdecc_c4_pb[23], scbuf_scdata_fbdecc_c4_pb[101], scbuf_scdata_fbdecc_c4_pb[179], scbuf_scdata_fbdecc_c4_pb[257],
             scbuf_scdata_fbdecc_c4_pb[24], scbuf_scdata_fbdecc_c4_pb[102], scbuf_scdata_fbdecc_c4_pb[180], scbuf_scdata_fbdecc_c4_pb[258],
             scbuf_scdata_fbdecc_c4_pb[25], scbuf_scdata_fbdecc_c4_pb[103], scbuf_scdata_fbdecc_c4_pb[181], scbuf_scdata_fbdecc_c4_pb[259],
             scbuf_scdata_fbdecc_c4_pb[26], scbuf_scdata_fbdecc_c4_pb[104], scbuf_scdata_fbdecc_c4_pb[182], scbuf_scdata_fbdecc_c4_pb[260],
             scbuf_scdata_fbdecc_c4_pb[27], scbuf_scdata_fbdecc_c4_pb[105], scbuf_scdata_fbdecc_c4_pb[183], scbuf_scdata_fbdecc_c4_pb[261],
             scbuf_scdata_fbdecc_c4_pb[28], scbuf_scdata_fbdecc_c4_pb[106], scbuf_scdata_fbdecc_c4_pb[184], scbuf_scdata_fbdecc_c4_pb[262],
             scbuf_scdata_fbdecc_c4_pb[29], scbuf_scdata_fbdecc_c4_pb[107], scbuf_scdata_fbdecc_c4_pb[185], scbuf_scdata_fbdecc_c4_pb[263],
             scbuf_scdata_fbdecc_c4_pb[30], scbuf_scdata_fbdecc_c4_pb[108], scbuf_scdata_fbdecc_c4_pb[186], scbuf_scdata_fbdecc_c4_pb[264],
             scbuf_scdata_fbdecc_c4_pb[31], scbuf_scdata_fbdecc_c4_pb[109], scbuf_scdata_fbdecc_c4_pb[187], scbuf_scdata_fbdecc_c4_pb[265],
             scbuf_scdata_fbdecc_c4_pb[32], scbuf_scdata_fbdecc_c4_pb[110], scbuf_scdata_fbdecc_c4_pb[188], scbuf_scdata_fbdecc_c4_pb[266],
             scbuf_scdata_fbdecc_c4_pb[33], scbuf_scdata_fbdecc_c4_pb[111], scbuf_scdata_fbdecc_c4_pb[189], scbuf_scdata_fbdecc_c4_pb[267],
             scbuf_scdata_fbdecc_c4_pb[34], scbuf_scdata_fbdecc_c4_pb[112], scbuf_scdata_fbdecc_c4_pb[190], scbuf_scdata_fbdecc_c4_pb[268],
             scbuf_scdata_fbdecc_c4_pb[35], scbuf_scdata_fbdecc_c4_pb[113], scbuf_scdata_fbdecc_c4_pb[191], scbuf_scdata_fbdecc_c4_pb[269],
             scbuf_scdata_fbdecc_c4_pb[36], scbuf_scdata_fbdecc_c4_pb[114], scbuf_scdata_fbdecc_c4_pb[192], scbuf_scdata_fbdecc_c4_pb[270],
             scbuf_scdata_fbdecc_c4_pb[37], scbuf_scdata_fbdecc_c4_pb[115], scbuf_scdata_fbdecc_c4_pb[193], scbuf_scdata_fbdecc_c4_pb[271],
             scbuf_scdata_fbdecc_c4_pb[38], scbuf_scdata_fbdecc_c4_pb[116], scbuf_scdata_fbdecc_c4_pb[194], scbuf_scdata_fbdecc_c4_pb[272]}),
   .din    ({1'b0, 1'b0, 1'b0, 1'b0,
             fb_array_din[0], fb_array_din[78], fb_array_din[156], fb_array_din[234],
             fb_array_din[1], fb_array_din[79], fb_array_din[157], fb_array_din[235],
             fb_array_din[2], fb_array_din[80], fb_array_din[158], fb_array_din[236],
             fb_array_din[3], fb_array_din[81], fb_array_din[159], fb_array_din[237],
             fb_array_din[4], fb_array_din[82], fb_array_din[160], fb_array_din[238],
             fb_array_din[5], fb_array_din[83], fb_array_din[161], fb_array_din[239],
             fb_array_din[6], fb_array_din[84], fb_array_din[162], fb_array_din[240],
             fb_array_din[7], fb_array_din[85], fb_array_din[163], fb_array_din[241],
             fb_array_din[8], fb_array_din[86], fb_array_din[164], fb_array_din[242],
             fb_array_din[9], fb_array_din[87], fb_array_din[165], fb_array_din[243],
             fb_array_din[10], fb_array_din[88], fb_array_din[166], fb_array_din[244],
             fb_array_din[11], fb_array_din[89], fb_array_din[167], fb_array_din[245],
             fb_array_din[12], fb_array_din[90], fb_array_din[168], fb_array_din[246],
             fb_array_din[13], fb_array_din[91], fb_array_din[169], fb_array_din[247],
             fb_array_din[14], fb_array_din[92], fb_array_din[170], fb_array_din[248],
             fb_array_din[15], fb_array_din[93], fb_array_din[171], fb_array_din[249],
             fb_array_din[16], fb_array_din[94], fb_array_din[172], fb_array_din[250],
             fb_array_din[17], fb_array_din[95], fb_array_din[173], fb_array_din[251],
             fb_array_din[18], fb_array_din[96], fb_array_din[174], fb_array_din[252],
             fb_array_din[19], fb_array_din[97], fb_array_din[175], fb_array_din[253],
             fb_array_din[20], fb_array_din[98], fb_array_din[176], fb_array_din[254],
             fb_array_din[21], fb_array_din[99], fb_array_din[177], fb_array_din[255],
             fb_array_din[22], fb_array_din[100], fb_array_din[178], fb_array_din[256],
             fb_array_din[23], fb_array_din[101], fb_array_din[179], fb_array_din[257],
             fb_array_din[24], fb_array_din[102], fb_array_din[180], fb_array_din[258],
             fb_array_din[25], fb_array_din[103], fb_array_din[181], fb_array_din[259],
             fb_array_din[26], fb_array_din[104], fb_array_din[182], fb_array_din[260],
             fb_array_din[27], fb_array_din[105], fb_array_din[183], fb_array_din[261],
             fb_array_din[28], fb_array_din[106], fb_array_din[184], fb_array_din[262],
             fb_array_din[29], fb_array_din[107], fb_array_din[185], fb_array_din[263],
             fb_array_din[30], fb_array_din[108], fb_array_din[186], fb_array_din[264],
             fb_array_din[31], fb_array_din[109], fb_array_din[187], fb_array_din[265],
             fb_array_din[32], fb_array_din[110], fb_array_din[188], fb_array_din[266],
             fb_array_din[33], fb_array_din[111], fb_array_din[189], fb_array_din[267],
             fb_array_din[34], fb_array_din[112], fb_array_din[190], fb_array_din[268],
             fb_array_din[35], fb_array_din[113], fb_array_din[191], fb_array_din[269],
             fb_array_din[36], fb_array_din[114], fb_array_din[192], fb_array_din[270],
             fb_array_din[37], fb_array_din[115], fb_array_din[193], fb_array_din[271],
             fb_array_din[38], fb_array_din[116], fb_array_din[194], fb_array_din[272]}),
   .rd_adr   ({1'b0, sctag_scbuf_fbrd_wl_c3_v1[2:0]}),
   .wr_adr   ({1'b0, sctag_scbuf_fbwr_wl_r3_v1[2:0]}),
   .read_en  (sctag_scbuf_fbrd_en_c3_v1),
   .wr_en    (sctag_scbuf_fbwr_wren_r3_v1),
   .word_wen ({sctag_scbuf_fbwr_wen_r3[15], sctag_scbuf_fbwr_wen_r3[13],
               sctag_scbuf_fbwr_wen_r3[11], sctag_scbuf_fbwr_wen_r3[9]}),
   .byte_wen ({1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1,
               1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1}),
   .rd_clk   (rclk),
   .wr_clk   (rclk),
   .se       (se_buf1),
   .si_r       (manual_scan_2),
   .si_w       (manual_scan_3a),
   .so_r       (manual_scan_3a),
   .so_w       (manual_scan_3),
   .reset_l    (arst_l_buf1),
   .rst_tri_en (mem_write_disable_buf1),
   .sehold     (sehold_buf1));


////////////////////////////////////////////////////////////////////////////////

scbuf_rdmard rdmard
  ( // Outputs
   .so                                  (scan_manual_3),
   .scdata_scbuf_decc_out_c7_buf        (scdata_scbuf_decc_out_c7_buf[623:0]),
   .scbuf_jbi_ctag_vld                  (scbuf_jbi_ctag_vld),
   .scbuf_jbi_data                      (scbuf_jbi_data[31:0]),
   .scbuf_jbi_ue_err                    (scbuf_jbi_ue_err),
   .scbuf_sctag_rdma_uerr_c10           (scbuf_sctag_rdma_uerr_c10),
   .scbuf_sctag_rdma_cerr_c10           (scbuf_sctag_rdma_cerr_c10),
   // Inputs
   .rclk                                (rclk),
   .se                                  (se),
   .si                                  (scan_manual_2),
   .sctag_scbuf_ctag_en_c7              (sctag_scbuf_ctag_en_c7),
   .sctag_scbuf_ctag_c7                 (sctag_scbuf_ctag_c7[14:0]),
   .sctag_scbuf_req_en_c7               (sctag_scbuf_req_en_c7),
   .scdata_scbuf_decc_out_c7            (scdata_scbuf_decc_out_c7[623:0]),
   .sctag_scbuf_word_c7                 (sctag_scbuf_word_c7[3:0]),
   .sctag_scbuf_word_vld_c7             (sctag_scbuf_word_vld_c7)); 


////////////////////////////////////////////////////////////////////////////////
bw_r_rf16x160  wb_array4
  (.dout   ({dummy_wb_array_dout[15:12],
             wb_array_dout[351], wb_array_dout[429], wb_array_dout[507], wb_array_dout[585],
             wb_array_dout[352], wb_array_dout[430], wb_array_dout[508], wb_array_dout[586],
             wb_array_dout[353], wb_array_dout[431], wb_array_dout[509], wb_array_dout[587],
             wb_array_dout[354], wb_array_dout[432], wb_array_dout[510], wb_array_dout[588],
             wb_array_dout[355], wb_array_dout[433], wb_array_dout[511], wb_array_dout[589],
             wb_array_dout[356], wb_array_dout[434], wb_array_dout[512], wb_array_dout[590],
             wb_array_dout[357], wb_array_dout[435], wb_array_dout[513], wb_array_dout[591],
             wb_array_dout[358], wb_array_dout[436], wb_array_dout[514], wb_array_dout[592],
             wb_array_dout[359], wb_array_dout[437], wb_array_dout[515], wb_array_dout[593],
             wb_array_dout[360], wb_array_dout[438], wb_array_dout[516], wb_array_dout[594],
             wb_array_dout[361], wb_array_dout[439], wb_array_dout[517], wb_array_dout[595],
             wb_array_dout[362], wb_array_dout[440], wb_array_dout[518], wb_array_dout[596],
             wb_array_dout[363], wb_array_dout[441], wb_array_dout[519], wb_array_dout[597],
             wb_array_dout[364], wb_array_dout[442], wb_array_dout[520], wb_array_dout[598],
             wb_array_dout[365], wb_array_dout[443], wb_array_dout[521], wb_array_dout[599],
             wb_array_dout[366], wb_array_dout[444], wb_array_dout[522], wb_array_dout[600],
             wb_array_dout[367], wb_array_dout[445], wb_array_dout[523], wb_array_dout[601],
             wb_array_dout[368], wb_array_dout[446], wb_array_dout[524], wb_array_dout[602],
             wb_array_dout[369], wb_array_dout[447], wb_array_dout[525], wb_array_dout[603],
             wb_array_dout[370], wb_array_dout[448], wb_array_dout[526], wb_array_dout[604],
             wb_array_dout[371], wb_array_dout[449], wb_array_dout[527], wb_array_dout[605],
             wb_array_dout[372], wb_array_dout[450], wb_array_dout[528], wb_array_dout[606],
             wb_array_dout[373], wb_array_dout[451], wb_array_dout[529], wb_array_dout[607],
             wb_array_dout[374], wb_array_dout[452], wb_array_dout[530], wb_array_dout[608],
             wb_array_dout[375], wb_array_dout[453], wb_array_dout[531], wb_array_dout[609],
             wb_array_dout[376], wb_array_dout[454], wb_array_dout[532], wb_array_dout[610],
             wb_array_dout[377], wb_array_dout[455], wb_array_dout[533], wb_array_dout[611],
             wb_array_dout[378], wb_array_dout[456], wb_array_dout[534], wb_array_dout[612],
             wb_array_dout[379], wb_array_dout[457], wb_array_dout[535], wb_array_dout[613],
             wb_array_dout[380], wb_array_dout[458], wb_array_dout[536], wb_array_dout[614],
             wb_array_dout[381], wb_array_dout[459], wb_array_dout[537], wb_array_dout[615],
             wb_array_dout[382], wb_array_dout[460], wb_array_dout[538], wb_array_dout[616],
             wb_array_dout[383], wb_array_dout[461], wb_array_dout[539], wb_array_dout[617],
             wb_array_dout[384], wb_array_dout[462], wb_array_dout[540], wb_array_dout[618],
             wb_array_dout[385], wb_array_dout[463], wb_array_dout[541], wb_array_dout[619],
             wb_array_dout[386], wb_array_dout[464], wb_array_dout[542], wb_array_dout[620],
             wb_array_dout[387], wb_array_dout[465], wb_array_dout[543], wb_array_dout[621],
             wb_array_dout[388], wb_array_dout[466], wb_array_dout[544], wb_array_dout[622],
             wb_array_dout[389], wb_array_dout[467], wb_array_dout[545], wb_array_dout[623]}),
   .din    ({1'b0, 1'b0, 1'b0, 1'b0,
             scdata_scbuf_decc_out_c7_buf[351], scdata_scbuf_decc_out_c7_buf[429], scdata_scbuf_decc_out_c7_buf[507], scdata_scbuf_decc_out_c7_buf[585],
             scdata_scbuf_decc_out_c7_buf[352], scdata_scbuf_decc_out_c7_buf[430], scdata_scbuf_decc_out_c7_buf[508], scdata_scbuf_decc_out_c7_buf[586],
             scdata_scbuf_decc_out_c7_buf[353], scdata_scbuf_decc_out_c7_buf[431], scdata_scbuf_decc_out_c7_buf[509], scdata_scbuf_decc_out_c7_buf[587],
             scdata_scbuf_decc_out_c7_buf[354], scdata_scbuf_decc_out_c7_buf[432], scdata_scbuf_decc_out_c7_buf[510], scdata_scbuf_decc_out_c7_buf[588],
             scdata_scbuf_decc_out_c7_buf[355], scdata_scbuf_decc_out_c7_buf[433], scdata_scbuf_decc_out_c7_buf[511], scdata_scbuf_decc_out_c7_buf[589],
             scdata_scbuf_decc_out_c7_buf[356], scdata_scbuf_decc_out_c7_buf[434], scdata_scbuf_decc_out_c7_buf[512], scdata_scbuf_decc_out_c7_buf[590],
             scdata_scbuf_decc_out_c7_buf[357], scdata_scbuf_decc_out_c7_buf[435], scdata_scbuf_decc_out_c7_buf[513], scdata_scbuf_decc_out_c7_buf[591],
             scdata_scbuf_decc_out_c7_buf[358], scdata_scbuf_decc_out_c7_buf[436], scdata_scbuf_decc_out_c7_buf[514], scdata_scbuf_decc_out_c7_buf[592],
             scdata_scbuf_decc_out_c7_buf[359], scdata_scbuf_decc_out_c7_buf[437], scdata_scbuf_decc_out_c7_buf[515], scdata_scbuf_decc_out_c7_buf[593],
             scdata_scbuf_decc_out_c7_buf[360], scdata_scbuf_decc_out_c7_buf[438], scdata_scbuf_decc_out_c7_buf[516], scdata_scbuf_decc_out_c7_buf[594],
             scdata_scbuf_decc_out_c7_buf[361], scdata_scbuf_decc_out_c7_buf[439], scdata_scbuf_decc_out_c7_buf[517], scdata_scbuf_decc_out_c7_buf[595],
             scdata_scbuf_decc_out_c7_buf[362], scdata_scbuf_decc_out_c7_buf[440], scdata_scbuf_decc_out_c7_buf[518], scdata_scbuf_decc_out_c7_buf[596],
             scdata_scbuf_decc_out_c7_buf[363], scdata_scbuf_decc_out_c7_buf[441], scdata_scbuf_decc_out_c7_buf[519], scdata_scbuf_decc_out_c7_buf[597],
             scdata_scbuf_decc_out_c7_buf[364], scdata_scbuf_decc_out_c7_buf[442], scdata_scbuf_decc_out_c7_buf[520], scdata_scbuf_decc_out_c7_buf[598],
             scdata_scbuf_decc_out_c7_buf[365], scdata_scbuf_decc_out_c7_buf[443], scdata_scbuf_decc_out_c7_buf[521], scdata_scbuf_decc_out_c7_buf[599],
             scdata_scbuf_decc_out_c7_buf[366], scdata_scbuf_decc_out_c7_buf[444], scdata_scbuf_decc_out_c7_buf[522], scdata_scbuf_decc_out_c7_buf[600],
             scdata_scbuf_decc_out_c7_buf[367], scdata_scbuf_decc_out_c7_buf[445], scdata_scbuf_decc_out_c7_buf[523], scdata_scbuf_decc_out_c7_buf[601],
             scdata_scbuf_decc_out_c7_buf[368], scdata_scbuf_decc_out_c7_buf[446], scdata_scbuf_decc_out_c7_buf[524], scdata_scbuf_decc_out_c7_buf[602],
             scdata_scbuf_decc_out_c7_buf[369], scdata_scbuf_decc_out_c7_buf[447], scdata_scbuf_decc_out_c7_buf[525], scdata_scbuf_decc_out_c7_buf[603],
             scdata_scbuf_decc_out_c7_buf[370], scdata_scbuf_decc_out_c7_buf[448], scdata_scbuf_decc_out_c7_buf[526], scdata_scbuf_decc_out_c7_buf[604],
             scdata_scbuf_decc_out_c7_buf[371], scdata_scbuf_decc_out_c7_buf[449], scdata_scbuf_decc_out_c7_buf[527], scdata_scbuf_decc_out_c7_buf[605],
             scdata_scbuf_decc_out_c7_buf[372], scdata_scbuf_decc_out_c7_buf[450], scdata_scbuf_decc_out_c7_buf[528], scdata_scbuf_decc_out_c7_buf[606],
             scdata_scbuf_decc_out_c7_buf[373], scdata_scbuf_decc_out_c7_buf[451], scdata_scbuf_decc_out_c7_buf[529], scdata_scbuf_decc_out_c7_buf[607],
             scdata_scbuf_decc_out_c7_buf[374], scdata_scbuf_decc_out_c7_buf[452], scdata_scbuf_decc_out_c7_buf[530], scdata_scbuf_decc_out_c7_buf[608],
             scdata_scbuf_decc_out_c7_buf[375], scdata_scbuf_decc_out_c7_buf[453], scdata_scbuf_decc_out_c7_buf[531], scdata_scbuf_decc_out_c7_buf[609],
             scdata_scbuf_decc_out_c7_buf[376], scdata_scbuf_decc_out_c7_buf[454], scdata_scbuf_decc_out_c7_buf[532], scdata_scbuf_decc_out_c7_buf[610],
             scdata_scbuf_decc_out_c7_buf[377], scdata_scbuf_decc_out_c7_buf[455], scdata_scbuf_decc_out_c7_buf[533], scdata_scbuf_decc_out_c7_buf[611],
             scdata_scbuf_decc_out_c7_buf[378], scdata_scbuf_decc_out_c7_buf[456], scdata_scbuf_decc_out_c7_buf[534], scdata_scbuf_decc_out_c7_buf[612],
             scdata_scbuf_decc_out_c7_buf[379], scdata_scbuf_decc_out_c7_buf[457], scdata_scbuf_decc_out_c7_buf[535], scdata_scbuf_decc_out_c7_buf[613],
             scdata_scbuf_decc_out_c7_buf[380], scdata_scbuf_decc_out_c7_buf[458], scdata_scbuf_decc_out_c7_buf[536], scdata_scbuf_decc_out_c7_buf[614],
             scdata_scbuf_decc_out_c7_buf[381], scdata_scbuf_decc_out_c7_buf[459], scdata_scbuf_decc_out_c7_buf[537], scdata_scbuf_decc_out_c7_buf[615],
             scdata_scbuf_decc_out_c7_buf[382], scdata_scbuf_decc_out_c7_buf[460], scdata_scbuf_decc_out_c7_buf[538], scdata_scbuf_decc_out_c7_buf[616],
             scdata_scbuf_decc_out_c7_buf[383], scdata_scbuf_decc_out_c7_buf[461], scdata_scbuf_decc_out_c7_buf[539], scdata_scbuf_decc_out_c7_buf[617],
             scdata_scbuf_decc_out_c7_buf[384], scdata_scbuf_decc_out_c7_buf[462], scdata_scbuf_decc_out_c7_buf[540], scdata_scbuf_decc_out_c7_buf[618],
             scdata_scbuf_decc_out_c7_buf[385], scdata_scbuf_decc_out_c7_buf[463], scdata_scbuf_decc_out_c7_buf[541], scdata_scbuf_decc_out_c7_buf[619],
             scdata_scbuf_decc_out_c7_buf[386], scdata_scbuf_decc_out_c7_buf[464], scdata_scbuf_decc_out_c7_buf[542], scdata_scbuf_decc_out_c7_buf[620],
             scdata_scbuf_decc_out_c7_buf[387], scdata_scbuf_decc_out_c7_buf[465], scdata_scbuf_decc_out_c7_buf[543], scdata_scbuf_decc_out_c7_buf[621],
             scdata_scbuf_decc_out_c7_buf[388], scdata_scbuf_decc_out_c7_buf[466], scdata_scbuf_decc_out_c7_buf[544], scdata_scbuf_decc_out_c7_buf[622],
             scdata_scbuf_decc_out_c7_buf[389], scdata_scbuf_decc_out_c7_buf[467], scdata_scbuf_decc_out_c7_buf[545], scdata_scbuf_decc_out_c7_buf[623]}),
   .rd_adr   ({1'b0, sctag_scbuf_wbrd_wl_r1_v4[2:0]}),
   .wr_adr   ({1'b0, sctag_scbuf_wbwr_wl_c8_v4[2:0]}),
   .read_en  (sctag_scbuf_wbrd_en_r1_v4),
   .wr_en    (sctag_scbuf_wbwr_wen_c8_v4),
   .word_wen ({4{sctag_scbuf_wbwr_wen_c8_v4}}),
   .byte_wen ({1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1,
               1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1}),
   .rd_clk   (rclk),
   .wr_clk   (rclk),
   .se       (se_buf2),
   .si_r       (manual_scan_3),
   .si_w       (manual_scan_4a),
   .so_r       (manual_scan_4a),
   .so_w       (manual_scan_4),
   .reset_l    (arst_l_buf2),
   .rst_tri_en (mem_write_disable_buf2),
   .sehold     (sehold_buf2));


bw_r_rf16x160  wb_array3
  (.dout   ({dummy_wb_array_dout[11:8],
             wb_array_dout[312], wb_array_dout[390], wb_array_dout[468], wb_array_dout[546],
             wb_array_dout[313], wb_array_dout[391], wb_array_dout[469], wb_array_dout[547],
             wb_array_dout[314], wb_array_dout[392], wb_array_dout[470], wb_array_dout[548],
             wb_array_dout[315], wb_array_dout[393], wb_array_dout[471], wb_array_dout[549],
             wb_array_dout[316], wb_array_dout[394], wb_array_dout[472], wb_array_dout[550],
             wb_array_dout[317], wb_array_dout[395], wb_array_dout[473], wb_array_dout[551],
             wb_array_dout[318], wb_array_dout[396], wb_array_dout[474], wb_array_dout[552],
             wb_array_dout[319], wb_array_dout[397], wb_array_dout[475], wb_array_dout[553],
             wb_array_dout[320], wb_array_dout[398], wb_array_dout[476], wb_array_dout[554],
             wb_array_dout[321], wb_array_dout[399], wb_array_dout[477], wb_array_dout[555],
             wb_array_dout[322], wb_array_dout[400], wb_array_dout[478], wb_array_dout[556],
             wb_array_dout[323], wb_array_dout[401], wb_array_dout[479], wb_array_dout[557],
             wb_array_dout[324], wb_array_dout[402], wb_array_dout[480], wb_array_dout[558],
             wb_array_dout[325], wb_array_dout[403], wb_array_dout[481], wb_array_dout[559],
             wb_array_dout[326], wb_array_dout[404], wb_array_dout[482], wb_array_dout[560],
             wb_array_dout[327], wb_array_dout[405], wb_array_dout[483], wb_array_dout[561],
             wb_array_dout[328], wb_array_dout[406], wb_array_dout[484], wb_array_dout[562],
             wb_array_dout[329], wb_array_dout[407], wb_array_dout[485], wb_array_dout[563],
             wb_array_dout[330], wb_array_dout[408], wb_array_dout[486], wb_array_dout[564],
             wb_array_dout[331], wb_array_dout[409], wb_array_dout[487], wb_array_dout[565],
             wb_array_dout[332], wb_array_dout[410], wb_array_dout[488], wb_array_dout[566],
             wb_array_dout[333], wb_array_dout[411], wb_array_dout[489], wb_array_dout[567],
             wb_array_dout[334], wb_array_dout[412], wb_array_dout[490], wb_array_dout[568],
             wb_array_dout[335], wb_array_dout[413], wb_array_dout[491], wb_array_dout[569],
             wb_array_dout[336], wb_array_dout[414], wb_array_dout[492], wb_array_dout[570],
             wb_array_dout[337], wb_array_dout[415], wb_array_dout[493], wb_array_dout[571],
             wb_array_dout[338], wb_array_dout[416], wb_array_dout[494], wb_array_dout[572],
             wb_array_dout[339], wb_array_dout[417], wb_array_dout[495], wb_array_dout[573],
             wb_array_dout[340], wb_array_dout[418], wb_array_dout[496], wb_array_dout[574],
             wb_array_dout[341], wb_array_dout[419], wb_array_dout[497], wb_array_dout[575],
             wb_array_dout[342], wb_array_dout[420], wb_array_dout[498], wb_array_dout[576],
             wb_array_dout[343], wb_array_dout[421], wb_array_dout[499], wb_array_dout[577],
             wb_array_dout[344], wb_array_dout[422], wb_array_dout[500], wb_array_dout[578],
             wb_array_dout[345], wb_array_dout[423], wb_array_dout[501], wb_array_dout[579],
             wb_array_dout[346], wb_array_dout[424], wb_array_dout[502], wb_array_dout[580],
             wb_array_dout[347], wb_array_dout[425], wb_array_dout[503], wb_array_dout[581],
             wb_array_dout[348], wb_array_dout[426], wb_array_dout[504], wb_array_dout[582],
             wb_array_dout[349], wb_array_dout[427], wb_array_dout[505], wb_array_dout[583],
             wb_array_dout[350], wb_array_dout[428], wb_array_dout[506], wb_array_dout[584]}),
   .din    ({1'b0, 1'b0, 1'b0, 1'b0,
             scdata_scbuf_decc_out_c7_buf[312], scdata_scbuf_decc_out_c7_buf[390], scdata_scbuf_decc_out_c7_buf[468], scdata_scbuf_decc_out_c7_buf[546],
             scdata_scbuf_decc_out_c7_buf[313], scdata_scbuf_decc_out_c7_buf[391], scdata_scbuf_decc_out_c7_buf[469], scdata_scbuf_decc_out_c7_buf[547],
             scdata_scbuf_decc_out_c7_buf[314], scdata_scbuf_decc_out_c7_buf[392], scdata_scbuf_decc_out_c7_buf[470], scdata_scbuf_decc_out_c7_buf[548],
             scdata_scbuf_decc_out_c7_buf[315], scdata_scbuf_decc_out_c7_buf[393], scdata_scbuf_decc_out_c7_buf[471], scdata_scbuf_decc_out_c7_buf[549],
             scdata_scbuf_decc_out_c7_buf[316], scdata_scbuf_decc_out_c7_buf[394], scdata_scbuf_decc_out_c7_buf[472], scdata_scbuf_decc_out_c7_buf[550],
             scdata_scbuf_decc_out_c7_buf[317], scdata_scbuf_decc_out_c7_buf[395], scdata_scbuf_decc_out_c7_buf[473], scdata_scbuf_decc_out_c7_buf[551],
             scdata_scbuf_decc_out_c7_buf[318], scdata_scbuf_decc_out_c7_buf[396], scdata_scbuf_decc_out_c7_buf[474], scdata_scbuf_decc_out_c7_buf[552],
             scdata_scbuf_decc_out_c7_buf[319], scdata_scbuf_decc_out_c7_buf[397], scdata_scbuf_decc_out_c7_buf[475], scdata_scbuf_decc_out_c7_buf[553],
             scdata_scbuf_decc_out_c7_buf[320], scdata_scbuf_decc_out_c7_buf[398], scdata_scbuf_decc_out_c7_buf[476], scdata_scbuf_decc_out_c7_buf[554],
             scdata_scbuf_decc_out_c7_buf[321], scdata_scbuf_decc_out_c7_buf[399], scdata_scbuf_decc_out_c7_buf[477], scdata_scbuf_decc_out_c7_buf[555],
             scdata_scbuf_decc_out_c7_buf[322], scdata_scbuf_decc_out_c7_buf[400], scdata_scbuf_decc_out_c7_buf[478], scdata_scbuf_decc_out_c7_buf[556],
             scdata_scbuf_decc_out_c7_buf[323], scdata_scbuf_decc_out_c7_buf[401], scdata_scbuf_decc_out_c7_buf[479], scdata_scbuf_decc_out_c7_buf[557],
             scdata_scbuf_decc_out_c7_buf[324], scdata_scbuf_decc_out_c7_buf[402], scdata_scbuf_decc_out_c7_buf[480], scdata_scbuf_decc_out_c7_buf[558],
             scdata_scbuf_decc_out_c7_buf[325], scdata_scbuf_decc_out_c7_buf[403], scdata_scbuf_decc_out_c7_buf[481], scdata_scbuf_decc_out_c7_buf[559],
             scdata_scbuf_decc_out_c7_buf[326], scdata_scbuf_decc_out_c7_buf[404], scdata_scbuf_decc_out_c7_buf[482], scdata_scbuf_decc_out_c7_buf[560],
             scdata_scbuf_decc_out_c7_buf[327], scdata_scbuf_decc_out_c7_buf[405], scdata_scbuf_decc_out_c7_buf[483], scdata_scbuf_decc_out_c7_buf[561],
             scdata_scbuf_decc_out_c7_buf[328], scdata_scbuf_decc_out_c7_buf[406], scdata_scbuf_decc_out_c7_buf[484], scdata_scbuf_decc_out_c7_buf[562],
             scdata_scbuf_decc_out_c7_buf[329], scdata_scbuf_decc_out_c7_buf[407], scdata_scbuf_decc_out_c7_buf[485], scdata_scbuf_decc_out_c7_buf[563],
             scdata_scbuf_decc_out_c7_buf[330], scdata_scbuf_decc_out_c7_buf[408], scdata_scbuf_decc_out_c7_buf[486], scdata_scbuf_decc_out_c7_buf[564],
             scdata_scbuf_decc_out_c7_buf[331], scdata_scbuf_decc_out_c7_buf[409], scdata_scbuf_decc_out_c7_buf[487], scdata_scbuf_decc_out_c7_buf[565],
             scdata_scbuf_decc_out_c7_buf[332], scdata_scbuf_decc_out_c7_buf[410], scdata_scbuf_decc_out_c7_buf[488], scdata_scbuf_decc_out_c7_buf[566],
             scdata_scbuf_decc_out_c7_buf[333], scdata_scbuf_decc_out_c7_buf[411], scdata_scbuf_decc_out_c7_buf[489], scdata_scbuf_decc_out_c7_buf[567],
             scdata_scbuf_decc_out_c7_buf[334], scdata_scbuf_decc_out_c7_buf[412], scdata_scbuf_decc_out_c7_buf[490], scdata_scbuf_decc_out_c7_buf[568],
             scdata_scbuf_decc_out_c7_buf[335], scdata_scbuf_decc_out_c7_buf[413], scdata_scbuf_decc_out_c7_buf[491], scdata_scbuf_decc_out_c7_buf[569],
             scdata_scbuf_decc_out_c7_buf[336], scdata_scbuf_decc_out_c7_buf[414], scdata_scbuf_decc_out_c7_buf[492], scdata_scbuf_decc_out_c7_buf[570],
             scdata_scbuf_decc_out_c7_buf[337], scdata_scbuf_decc_out_c7_buf[415], scdata_scbuf_decc_out_c7_buf[493], scdata_scbuf_decc_out_c7_buf[571],
             scdata_scbuf_decc_out_c7_buf[338], scdata_scbuf_decc_out_c7_buf[416], scdata_scbuf_decc_out_c7_buf[494], scdata_scbuf_decc_out_c7_buf[572],
             scdata_scbuf_decc_out_c7_buf[339], scdata_scbuf_decc_out_c7_buf[417], scdata_scbuf_decc_out_c7_buf[495], scdata_scbuf_decc_out_c7_buf[573],
             scdata_scbuf_decc_out_c7_buf[340], scdata_scbuf_decc_out_c7_buf[418], scdata_scbuf_decc_out_c7_buf[496], scdata_scbuf_decc_out_c7_buf[574],
             scdata_scbuf_decc_out_c7_buf[341], scdata_scbuf_decc_out_c7_buf[419], scdata_scbuf_decc_out_c7_buf[497], scdata_scbuf_decc_out_c7_buf[575],
             scdata_scbuf_decc_out_c7_buf[342], scdata_scbuf_decc_out_c7_buf[420], scdata_scbuf_decc_out_c7_buf[498], scdata_scbuf_decc_out_c7_buf[576],
             scdata_scbuf_decc_out_c7_buf[343], scdata_scbuf_decc_out_c7_buf[421], scdata_scbuf_decc_out_c7_buf[499], scdata_scbuf_decc_out_c7_buf[577],
             scdata_scbuf_decc_out_c7_buf[344], scdata_scbuf_decc_out_c7_buf[422], scdata_scbuf_decc_out_c7_buf[500], scdata_scbuf_decc_out_c7_buf[578],
             scdata_scbuf_decc_out_c7_buf[345], scdata_scbuf_decc_out_c7_buf[423], scdata_scbuf_decc_out_c7_buf[501], scdata_scbuf_decc_out_c7_buf[579],
             scdata_scbuf_decc_out_c7_buf[346], scdata_scbuf_decc_out_c7_buf[424], scdata_scbuf_decc_out_c7_buf[502], scdata_scbuf_decc_out_c7_buf[580],
             scdata_scbuf_decc_out_c7_buf[347], scdata_scbuf_decc_out_c7_buf[425], scdata_scbuf_decc_out_c7_buf[503], scdata_scbuf_decc_out_c7_buf[581],
             scdata_scbuf_decc_out_c7_buf[348], scdata_scbuf_decc_out_c7_buf[426], scdata_scbuf_decc_out_c7_buf[504], scdata_scbuf_decc_out_c7_buf[582],
             scdata_scbuf_decc_out_c7_buf[349], scdata_scbuf_decc_out_c7_buf[427], scdata_scbuf_decc_out_c7_buf[505], scdata_scbuf_decc_out_c7_buf[583],
             scdata_scbuf_decc_out_c7_buf[350], scdata_scbuf_decc_out_c7_buf[428], scdata_scbuf_decc_out_c7_buf[506], scdata_scbuf_decc_out_c7_buf[584]}),
   .rd_adr   ({1'b0, sctag_scbuf_wbrd_wl_r1_v3[2:0]}),
   .wr_adr   ({1'b0, sctag_scbuf_wbwr_wl_c8_v3[2:0]}),
   .read_en  (sctag_scbuf_wbrd_en_r1_v3),
   .wr_en    (sctag_scbuf_wbwr_wen_c8_v3),
   .word_wen ({4{sctag_scbuf_wbwr_wen_c8_v3}}),
   .byte_wen ({1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1,
               1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1}),
   .rd_clk   (rclk),
   .wr_clk   (rclk),
   .se       (se_buf2),
   .si_r       (manual_scan_4),
   .si_w       (manual_scan_5a),
   .so_r       (manual_scan_5a),
   .so_w       (manual_scan_5),
   .reset_l  (arst_l_buf2),
   .rst_tri_en (mem_write_disable_buf2),
   .sehold   (sehold_buf2));


bw_r_rf16x160  wb_array2
  (.dout   ({dummy_wb_array_dout[7:4],
             wb_array_dout[39], wb_array_dout[117], wb_array_dout[195], wb_array_dout[273],
             wb_array_dout[40], wb_array_dout[118], wb_array_dout[196], wb_array_dout[274],
             wb_array_dout[41], wb_array_dout[119], wb_array_dout[197], wb_array_dout[275],
             wb_array_dout[42], wb_array_dout[120], wb_array_dout[198], wb_array_dout[276],
             wb_array_dout[43], wb_array_dout[121], wb_array_dout[199], wb_array_dout[277],
             wb_array_dout[44], wb_array_dout[122], wb_array_dout[200], wb_array_dout[278],
             wb_array_dout[45], wb_array_dout[123], wb_array_dout[201], wb_array_dout[279],
             wb_array_dout[46], wb_array_dout[124], wb_array_dout[202], wb_array_dout[280],
             wb_array_dout[47], wb_array_dout[125], wb_array_dout[203], wb_array_dout[281],
             wb_array_dout[48], wb_array_dout[126], wb_array_dout[204], wb_array_dout[282],
             wb_array_dout[49], wb_array_dout[127], wb_array_dout[205], wb_array_dout[283],
             wb_array_dout[50], wb_array_dout[128], wb_array_dout[206], wb_array_dout[284],
             wb_array_dout[51], wb_array_dout[129], wb_array_dout[207], wb_array_dout[285],
             wb_array_dout[52], wb_array_dout[130], wb_array_dout[208], wb_array_dout[286],
             wb_array_dout[53], wb_array_dout[131], wb_array_dout[209], wb_array_dout[287],
             wb_array_dout[54], wb_array_dout[132], wb_array_dout[210], wb_array_dout[288],
             wb_array_dout[55], wb_array_dout[133], wb_array_dout[211], wb_array_dout[289],
             wb_array_dout[56], wb_array_dout[134], wb_array_dout[212], wb_array_dout[290],
             wb_array_dout[57], wb_array_dout[135], wb_array_dout[213], wb_array_dout[291],
             wb_array_dout[58], wb_array_dout[136], wb_array_dout[214], wb_array_dout[292],
             wb_array_dout[59], wb_array_dout[137], wb_array_dout[215], wb_array_dout[293],
             wb_array_dout[60], wb_array_dout[138], wb_array_dout[216], wb_array_dout[294],
             wb_array_dout[61], wb_array_dout[139], wb_array_dout[217], wb_array_dout[295],
             wb_array_dout[62], wb_array_dout[140], wb_array_dout[218], wb_array_dout[296],
             wb_array_dout[63], wb_array_dout[141], wb_array_dout[219], wb_array_dout[297],
             wb_array_dout[64], wb_array_dout[142], wb_array_dout[220], wb_array_dout[298],
             wb_array_dout[65], wb_array_dout[143], wb_array_dout[221], wb_array_dout[299],
             wb_array_dout[66], wb_array_dout[144], wb_array_dout[222], wb_array_dout[300],
             wb_array_dout[67], wb_array_dout[145], wb_array_dout[223], wb_array_dout[301],
             wb_array_dout[68], wb_array_dout[146], wb_array_dout[224], wb_array_dout[302],
             wb_array_dout[69], wb_array_dout[147], wb_array_dout[225], wb_array_dout[303],
             wb_array_dout[70], wb_array_dout[148], wb_array_dout[226], wb_array_dout[304],
             wb_array_dout[71], wb_array_dout[149], wb_array_dout[227], wb_array_dout[305],
             wb_array_dout[72], wb_array_dout[150], wb_array_dout[228], wb_array_dout[306],
             wb_array_dout[73], wb_array_dout[151], wb_array_dout[229], wb_array_dout[307],
             wb_array_dout[74], wb_array_dout[152], wb_array_dout[230], wb_array_dout[308],
             wb_array_dout[75], wb_array_dout[153], wb_array_dout[231], wb_array_dout[309],
             wb_array_dout[76], wb_array_dout[154], wb_array_dout[232], wb_array_dout[310],
             wb_array_dout[77], wb_array_dout[155], wb_array_dout[233], wb_array_dout[311]}),
   .din    ({1'b0, 1'b0, 1'b0, 1'b0,
             scdata_scbuf_decc_out_c7_buf[39], scdata_scbuf_decc_out_c7_buf[117], scdata_scbuf_decc_out_c7_buf[195], scdata_scbuf_decc_out_c7_buf[273],
             scdata_scbuf_decc_out_c7_buf[40], scdata_scbuf_decc_out_c7_buf[118], scdata_scbuf_decc_out_c7_buf[196], scdata_scbuf_decc_out_c7_buf[274],
             scdata_scbuf_decc_out_c7_buf[41], scdata_scbuf_decc_out_c7_buf[119], scdata_scbuf_decc_out_c7_buf[197], scdata_scbuf_decc_out_c7_buf[275],
             scdata_scbuf_decc_out_c7_buf[42], scdata_scbuf_decc_out_c7_buf[120], scdata_scbuf_decc_out_c7_buf[198], scdata_scbuf_decc_out_c7_buf[276],
             scdata_scbuf_decc_out_c7_buf[43], scdata_scbuf_decc_out_c7_buf[121], scdata_scbuf_decc_out_c7_buf[199], scdata_scbuf_decc_out_c7_buf[277],
             scdata_scbuf_decc_out_c7_buf[44], scdata_scbuf_decc_out_c7_buf[122], scdata_scbuf_decc_out_c7_buf[200], scdata_scbuf_decc_out_c7_buf[278],
             scdata_scbuf_decc_out_c7_buf[45], scdata_scbuf_decc_out_c7_buf[123], scdata_scbuf_decc_out_c7_buf[201], scdata_scbuf_decc_out_c7_buf[279],
             scdata_scbuf_decc_out_c7_buf[46], scdata_scbuf_decc_out_c7_buf[124], scdata_scbuf_decc_out_c7_buf[202], scdata_scbuf_decc_out_c7_buf[280],
             scdata_scbuf_decc_out_c7_buf[47], scdata_scbuf_decc_out_c7_buf[125], scdata_scbuf_decc_out_c7_buf[203], scdata_scbuf_decc_out_c7_buf[281],
             scdata_scbuf_decc_out_c7_buf[48], scdata_scbuf_decc_out_c7_buf[126], scdata_scbuf_decc_out_c7_buf[204], scdata_scbuf_decc_out_c7_buf[282],
             scdata_scbuf_decc_out_c7_buf[49], scdata_scbuf_decc_out_c7_buf[127], scdata_scbuf_decc_out_c7_buf[205], scdata_scbuf_decc_out_c7_buf[283],
             scdata_scbuf_decc_out_c7_buf[50], scdata_scbuf_decc_out_c7_buf[128], scdata_scbuf_decc_out_c7_buf[206], scdata_scbuf_decc_out_c7_buf[284],
             scdata_scbuf_decc_out_c7_buf[51], scdata_scbuf_decc_out_c7_buf[129], scdata_scbuf_decc_out_c7_buf[207], scdata_scbuf_decc_out_c7_buf[285],
             scdata_scbuf_decc_out_c7_buf[52], scdata_scbuf_decc_out_c7_buf[130], scdata_scbuf_decc_out_c7_buf[208], scdata_scbuf_decc_out_c7_buf[286],
             scdata_scbuf_decc_out_c7_buf[53], scdata_scbuf_decc_out_c7_buf[131], scdata_scbuf_decc_out_c7_buf[209], scdata_scbuf_decc_out_c7_buf[287],
             scdata_scbuf_decc_out_c7_buf[54], scdata_scbuf_decc_out_c7_buf[132], scdata_scbuf_decc_out_c7_buf[210], scdata_scbuf_decc_out_c7_buf[288],
             scdata_scbuf_decc_out_c7_buf[55], scdata_scbuf_decc_out_c7_buf[133], scdata_scbuf_decc_out_c7_buf[211], scdata_scbuf_decc_out_c7_buf[289],
             scdata_scbuf_decc_out_c7_buf[56], scdata_scbuf_decc_out_c7_buf[134], scdata_scbuf_decc_out_c7_buf[212], scdata_scbuf_decc_out_c7_buf[290],
             scdata_scbuf_decc_out_c7_buf[57], scdata_scbuf_decc_out_c7_buf[135], scdata_scbuf_decc_out_c7_buf[213], scdata_scbuf_decc_out_c7_buf[291],
             scdata_scbuf_decc_out_c7_buf[58], scdata_scbuf_decc_out_c7_buf[136], scdata_scbuf_decc_out_c7_buf[214], scdata_scbuf_decc_out_c7_buf[292],
             scdata_scbuf_decc_out_c7_buf[59], scdata_scbuf_decc_out_c7_buf[137], scdata_scbuf_decc_out_c7_buf[215], scdata_scbuf_decc_out_c7_buf[293],
             scdata_scbuf_decc_out_c7_buf[60], scdata_scbuf_decc_out_c7_buf[138], scdata_scbuf_decc_out_c7_buf[216], scdata_scbuf_decc_out_c7_buf[294],
             scdata_scbuf_decc_out_c7_buf[61], scdata_scbuf_decc_out_c7_buf[139], scdata_scbuf_decc_out_c7_buf[217], scdata_scbuf_decc_out_c7_buf[295],
             scdata_scbuf_decc_out_c7_buf[62], scdata_scbuf_decc_out_c7_buf[140], scdata_scbuf_decc_out_c7_buf[218], scdata_scbuf_decc_out_c7_buf[296],
             scdata_scbuf_decc_out_c7_buf[63], scdata_scbuf_decc_out_c7_buf[141], scdata_scbuf_decc_out_c7_buf[219], scdata_scbuf_decc_out_c7_buf[297],
             scdata_scbuf_decc_out_c7_buf[64], scdata_scbuf_decc_out_c7_buf[142], scdata_scbuf_decc_out_c7_buf[220], scdata_scbuf_decc_out_c7_buf[298],
             scdata_scbuf_decc_out_c7_buf[65], scdata_scbuf_decc_out_c7_buf[143], scdata_scbuf_decc_out_c7_buf[221], scdata_scbuf_decc_out_c7_buf[299],
             scdata_scbuf_decc_out_c7_buf[66], scdata_scbuf_decc_out_c7_buf[144], scdata_scbuf_decc_out_c7_buf[222], scdata_scbuf_decc_out_c7_buf[300],
             scdata_scbuf_decc_out_c7_buf[67], scdata_scbuf_decc_out_c7_buf[145], scdata_scbuf_decc_out_c7_buf[223], scdata_scbuf_decc_out_c7_buf[301],
             scdata_scbuf_decc_out_c7_buf[68], scdata_scbuf_decc_out_c7_buf[146], scdata_scbuf_decc_out_c7_buf[224], scdata_scbuf_decc_out_c7_buf[302],
             scdata_scbuf_decc_out_c7_buf[69], scdata_scbuf_decc_out_c7_buf[147], scdata_scbuf_decc_out_c7_buf[225], scdata_scbuf_decc_out_c7_buf[303],
             scdata_scbuf_decc_out_c7_buf[70], scdata_scbuf_decc_out_c7_buf[148], scdata_scbuf_decc_out_c7_buf[226], scdata_scbuf_decc_out_c7_buf[304],
             scdata_scbuf_decc_out_c7_buf[71], scdata_scbuf_decc_out_c7_buf[149], scdata_scbuf_decc_out_c7_buf[227], scdata_scbuf_decc_out_c7_buf[305],
             scdata_scbuf_decc_out_c7_buf[72], scdata_scbuf_decc_out_c7_buf[150], scdata_scbuf_decc_out_c7_buf[228], scdata_scbuf_decc_out_c7_buf[306],
             scdata_scbuf_decc_out_c7_buf[73], scdata_scbuf_decc_out_c7_buf[151], scdata_scbuf_decc_out_c7_buf[229], scdata_scbuf_decc_out_c7_buf[307],
             scdata_scbuf_decc_out_c7_buf[74], scdata_scbuf_decc_out_c7_buf[152], scdata_scbuf_decc_out_c7_buf[230], scdata_scbuf_decc_out_c7_buf[308],
             scdata_scbuf_decc_out_c7_buf[75], scdata_scbuf_decc_out_c7_buf[153], scdata_scbuf_decc_out_c7_buf[231], scdata_scbuf_decc_out_c7_buf[309],
             scdata_scbuf_decc_out_c7_buf[76], scdata_scbuf_decc_out_c7_buf[154], scdata_scbuf_decc_out_c7_buf[232], scdata_scbuf_decc_out_c7_buf[310],
             scdata_scbuf_decc_out_c7_buf[77], scdata_scbuf_decc_out_c7_buf[155], scdata_scbuf_decc_out_c7_buf[233], scdata_scbuf_decc_out_c7_buf[311]}),
   .rd_adr   ({1'b0, sctag_scbuf_wbrd_wl_r1_v2[2:0]}),
   .wr_adr   ({1'b0, sctag_scbuf_wbwr_wl_c8_v2[2:0]}),
   .read_en  (sctag_scbuf_wbrd_en_r1_v2),
   .wr_en    (sctag_scbuf_wbwr_wen_c8_v2),
   .word_wen ({4{sctag_scbuf_wbwr_wen_c8_v2}}),
   .byte_wen ({1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1,
               1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1}),
   .rd_clk   (rclk),
   .wr_clk   (rclk),
   .se       (se_buf2),
   .si_r       (manual_scan_5),
   .si_w       (manual_scan_6a),
   .so_r       (manual_scan_6a),
   .so_w       (manual_scan_6),
   .reset_l    (arst_l_buf2),
   .rst_tri_en (mem_write_disable_buf2),
   .sehold     (sehold_buf2));


bw_r_rf16x160  wb_array1
  (.dout   ({dummy_wb_array_dout[3:0],
             wb_array_dout[0], wb_array_dout[78], wb_array_dout[156], wb_array_dout[234],
             wb_array_dout[1], wb_array_dout[79], wb_array_dout[157], wb_array_dout[235],
             wb_array_dout[2], wb_array_dout[80], wb_array_dout[158], wb_array_dout[236],
             wb_array_dout[3], wb_array_dout[81], wb_array_dout[159], wb_array_dout[237],
             wb_array_dout[4], wb_array_dout[82], wb_array_dout[160], wb_array_dout[238],
             wb_array_dout[5], wb_array_dout[83], wb_array_dout[161], wb_array_dout[239],
             wb_array_dout[6], wb_array_dout[84], wb_array_dout[162], wb_array_dout[240],
             wb_array_dout[7], wb_array_dout[85], wb_array_dout[163], wb_array_dout[241],
             wb_array_dout[8], wb_array_dout[86], wb_array_dout[164], wb_array_dout[242],
             wb_array_dout[9], wb_array_dout[87], wb_array_dout[165], wb_array_dout[243],
             wb_array_dout[10], wb_array_dout[88], wb_array_dout[166], wb_array_dout[244],
             wb_array_dout[11], wb_array_dout[89], wb_array_dout[167], wb_array_dout[245],
             wb_array_dout[12], wb_array_dout[90], wb_array_dout[168], wb_array_dout[246],
             wb_array_dout[13], wb_array_dout[91], wb_array_dout[169], wb_array_dout[247],
             wb_array_dout[14], wb_array_dout[92], wb_array_dout[170], wb_array_dout[248],
             wb_array_dout[15], wb_array_dout[93], wb_array_dout[171], wb_array_dout[249],
             wb_array_dout[16], wb_array_dout[94], wb_array_dout[172], wb_array_dout[250],
             wb_array_dout[17], wb_array_dout[95], wb_array_dout[173], wb_array_dout[251],
             wb_array_dout[18], wb_array_dout[96], wb_array_dout[174], wb_array_dout[252],
             wb_array_dout[19], wb_array_dout[97], wb_array_dout[175], wb_array_dout[253],
             wb_array_dout[20], wb_array_dout[98], wb_array_dout[176], wb_array_dout[254],
             wb_array_dout[21], wb_array_dout[99], wb_array_dout[177], wb_array_dout[255],
             wb_array_dout[22], wb_array_dout[100], wb_array_dout[178], wb_array_dout[256],
             wb_array_dout[23], wb_array_dout[101], wb_array_dout[179], wb_array_dout[257],
             wb_array_dout[24], wb_array_dout[102], wb_array_dout[180], wb_array_dout[258],
             wb_array_dout[25], wb_array_dout[103], wb_array_dout[181], wb_array_dout[259],
             wb_array_dout[26], wb_array_dout[104], wb_array_dout[182], wb_array_dout[260],
             wb_array_dout[27], wb_array_dout[105], wb_array_dout[183], wb_array_dout[261],
             wb_array_dout[28], wb_array_dout[106], wb_array_dout[184], wb_array_dout[262],
             wb_array_dout[29], wb_array_dout[107], wb_array_dout[185], wb_array_dout[263],
             wb_array_dout[30], wb_array_dout[108], wb_array_dout[186], wb_array_dout[264],
             wb_array_dout[31], wb_array_dout[109], wb_array_dout[187], wb_array_dout[265],
             wb_array_dout[32], wb_array_dout[110], wb_array_dout[188], wb_array_dout[266],
             wb_array_dout[33], wb_array_dout[111], wb_array_dout[189], wb_array_dout[267],
             wb_array_dout[34], wb_array_dout[112], wb_array_dout[190], wb_array_dout[268],
             wb_array_dout[35], wb_array_dout[113], wb_array_dout[191], wb_array_dout[269],
             wb_array_dout[36], wb_array_dout[114], wb_array_dout[192], wb_array_dout[270],
             wb_array_dout[37], wb_array_dout[115], wb_array_dout[193], wb_array_dout[271],
             wb_array_dout[38], wb_array_dout[116], wb_array_dout[194], wb_array_dout[272]}),
   .din    ({1'b0, 1'b0, 1'b0, 1'b0,
             scdata_scbuf_decc_out_c7_buf[0], scdata_scbuf_decc_out_c7_buf[78], scdata_scbuf_decc_out_c7_buf[156], scdata_scbuf_decc_out_c7_buf[234],
             scdata_scbuf_decc_out_c7_buf[1], scdata_scbuf_decc_out_c7_buf[79], scdata_scbuf_decc_out_c7_buf[157], scdata_scbuf_decc_out_c7_buf[235],
             scdata_scbuf_decc_out_c7_buf[2], scdata_scbuf_decc_out_c7_buf[80], scdata_scbuf_decc_out_c7_buf[158], scdata_scbuf_decc_out_c7_buf[236],
             scdata_scbuf_decc_out_c7_buf[3], scdata_scbuf_decc_out_c7_buf[81], scdata_scbuf_decc_out_c7_buf[159], scdata_scbuf_decc_out_c7_buf[237],
             scdata_scbuf_decc_out_c7_buf[4], scdata_scbuf_decc_out_c7_buf[82], scdata_scbuf_decc_out_c7_buf[160], scdata_scbuf_decc_out_c7_buf[238],
             scdata_scbuf_decc_out_c7_buf[5], scdata_scbuf_decc_out_c7_buf[83], scdata_scbuf_decc_out_c7_buf[161], scdata_scbuf_decc_out_c7_buf[239],
             scdata_scbuf_decc_out_c7_buf[6], scdata_scbuf_decc_out_c7_buf[84], scdata_scbuf_decc_out_c7_buf[162], scdata_scbuf_decc_out_c7_buf[240],
             scdata_scbuf_decc_out_c7_buf[7], scdata_scbuf_decc_out_c7_buf[85], scdata_scbuf_decc_out_c7_buf[163], scdata_scbuf_decc_out_c7_buf[241],
             scdata_scbuf_decc_out_c7_buf[8], scdata_scbuf_decc_out_c7_buf[86], scdata_scbuf_decc_out_c7_buf[164], scdata_scbuf_decc_out_c7_buf[242],
             scdata_scbuf_decc_out_c7_buf[9], scdata_scbuf_decc_out_c7_buf[87], scdata_scbuf_decc_out_c7_buf[165], scdata_scbuf_decc_out_c7_buf[243],
             scdata_scbuf_decc_out_c7_buf[10], scdata_scbuf_decc_out_c7_buf[88], scdata_scbuf_decc_out_c7_buf[166], scdata_scbuf_decc_out_c7_buf[244],
             scdata_scbuf_decc_out_c7_buf[11], scdata_scbuf_decc_out_c7_buf[89], scdata_scbuf_decc_out_c7_buf[167], scdata_scbuf_decc_out_c7_buf[245],
             scdata_scbuf_decc_out_c7_buf[12], scdata_scbuf_decc_out_c7_buf[90], scdata_scbuf_decc_out_c7_buf[168], scdata_scbuf_decc_out_c7_buf[246],
             scdata_scbuf_decc_out_c7_buf[13], scdata_scbuf_decc_out_c7_buf[91], scdata_scbuf_decc_out_c7_buf[169], scdata_scbuf_decc_out_c7_buf[247],
             scdata_scbuf_decc_out_c7_buf[14], scdata_scbuf_decc_out_c7_buf[92], scdata_scbuf_decc_out_c7_buf[170], scdata_scbuf_decc_out_c7_buf[248],
             scdata_scbuf_decc_out_c7_buf[15], scdata_scbuf_decc_out_c7_buf[93], scdata_scbuf_decc_out_c7_buf[171], scdata_scbuf_decc_out_c7_buf[249],
             scdata_scbuf_decc_out_c7_buf[16], scdata_scbuf_decc_out_c7_buf[94], scdata_scbuf_decc_out_c7_buf[172], scdata_scbuf_decc_out_c7_buf[250],
             scdata_scbuf_decc_out_c7_buf[17], scdata_scbuf_decc_out_c7_buf[95], scdata_scbuf_decc_out_c7_buf[173], scdata_scbuf_decc_out_c7_buf[251],
             scdata_scbuf_decc_out_c7_buf[18], scdata_scbuf_decc_out_c7_buf[96], scdata_scbuf_decc_out_c7_buf[174], scdata_scbuf_decc_out_c7_buf[252],
             scdata_scbuf_decc_out_c7_buf[19], scdata_scbuf_decc_out_c7_buf[97], scdata_scbuf_decc_out_c7_buf[175], scdata_scbuf_decc_out_c7_buf[253],
             scdata_scbuf_decc_out_c7_buf[20], scdata_scbuf_decc_out_c7_buf[98], scdata_scbuf_decc_out_c7_buf[176], scdata_scbuf_decc_out_c7_buf[254],
             scdata_scbuf_decc_out_c7_buf[21], scdata_scbuf_decc_out_c7_buf[99], scdata_scbuf_decc_out_c7_buf[177], scdata_scbuf_decc_out_c7_buf[255],
             scdata_scbuf_decc_out_c7_buf[22], scdata_scbuf_decc_out_c7_buf[100], scdata_scbuf_decc_out_c7_buf[178], scdata_scbuf_decc_out_c7_buf[256],
             scdata_scbuf_decc_out_c7_buf[23], scdata_scbuf_decc_out_c7_buf[101], scdata_scbuf_decc_out_c7_buf[179], scdata_scbuf_decc_out_c7_buf[257],
             scdata_scbuf_decc_out_c7_buf[24], scdata_scbuf_decc_out_c7_buf[102], scdata_scbuf_decc_out_c7_buf[180], scdata_scbuf_decc_out_c7_buf[258],
             scdata_scbuf_decc_out_c7_buf[25], scdata_scbuf_decc_out_c7_buf[103], scdata_scbuf_decc_out_c7_buf[181], scdata_scbuf_decc_out_c7_buf[259],
             scdata_scbuf_decc_out_c7_buf[26], scdata_scbuf_decc_out_c7_buf[104], scdata_scbuf_decc_out_c7_buf[182], scdata_scbuf_decc_out_c7_buf[260],
             scdata_scbuf_decc_out_c7_buf[27], scdata_scbuf_decc_out_c7_buf[105], scdata_scbuf_decc_out_c7_buf[183], scdata_scbuf_decc_out_c7_buf[261],
             scdata_scbuf_decc_out_c7_buf[28], scdata_scbuf_decc_out_c7_buf[106], scdata_scbuf_decc_out_c7_buf[184], scdata_scbuf_decc_out_c7_buf[262],
             scdata_scbuf_decc_out_c7_buf[29], scdata_scbuf_decc_out_c7_buf[107], scdata_scbuf_decc_out_c7_buf[185], scdata_scbuf_decc_out_c7_buf[263],
             scdata_scbuf_decc_out_c7_buf[30], scdata_scbuf_decc_out_c7_buf[108], scdata_scbuf_decc_out_c7_buf[186], scdata_scbuf_decc_out_c7_buf[264],
             scdata_scbuf_decc_out_c7_buf[31], scdata_scbuf_decc_out_c7_buf[109], scdata_scbuf_decc_out_c7_buf[187], scdata_scbuf_decc_out_c7_buf[265],
             scdata_scbuf_decc_out_c7_buf[32], scdata_scbuf_decc_out_c7_buf[110], scdata_scbuf_decc_out_c7_buf[188], scdata_scbuf_decc_out_c7_buf[266],
             scdata_scbuf_decc_out_c7_buf[33], scdata_scbuf_decc_out_c7_buf[111], scdata_scbuf_decc_out_c7_buf[189], scdata_scbuf_decc_out_c7_buf[267],
             scdata_scbuf_decc_out_c7_buf[34], scdata_scbuf_decc_out_c7_buf[112], scdata_scbuf_decc_out_c7_buf[190], scdata_scbuf_decc_out_c7_buf[268],
             scdata_scbuf_decc_out_c7_buf[35], scdata_scbuf_decc_out_c7_buf[113], scdata_scbuf_decc_out_c7_buf[191], scdata_scbuf_decc_out_c7_buf[269],
             scdata_scbuf_decc_out_c7_buf[36], scdata_scbuf_decc_out_c7_buf[114], scdata_scbuf_decc_out_c7_buf[192], scdata_scbuf_decc_out_c7_buf[270],
             scdata_scbuf_decc_out_c7_buf[37], scdata_scbuf_decc_out_c7_buf[115], scdata_scbuf_decc_out_c7_buf[193], scdata_scbuf_decc_out_c7_buf[271],
             scdata_scbuf_decc_out_c7_buf[38], scdata_scbuf_decc_out_c7_buf[116], scdata_scbuf_decc_out_c7_buf[194], scdata_scbuf_decc_out_c7_buf[272]}),
   .rd_adr   ({1'b0, sctag_scbuf_wbrd_wl_r1_v1[2:0]}),
   .wr_adr   ({1'b0, sctag_scbuf_wbwr_wl_c8_v1[2:0]}),
   .read_en  (sctag_scbuf_wbrd_en_r1_v1),
   .wr_en    (sctag_scbuf_wbwr_wen_c8_v1),
   .word_wen ({4{sctag_scbuf_wbwr_wen_c8_v1}}),
   .byte_wen ({1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1,
               1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1}),
   .rd_clk   (rclk),
   .wr_clk   (rclk),
   .se       (se_buf2),
   .si_r       (manual_scan_6),
   .si_w       (manual_scan_7a),
   .so_r       (manual_scan_7a),
   .so_w       (manual_scan_7),
   .reset_l    (arst_l_buf2),
   .rst_tri_en (mem_write_disable_buf2),
   .sehold     (sehold_buf2));


////////////////////////////////////////////////////////////////////////////////

scbuf_evict evict
 (
  // Outputs
  .so                                   (scan_manual_4),
  .scbuf_dram_wr_data_r5_pb             (scbuf_dram_wr_data_r5_pb[63:0]),
  .scbuf_dram_data_vld_r5_pb            (scbuf_dram_data_vld_r5_pb),
  .scbuf_dram_data_mecc_r5_pb           (scbuf_dram_data_mecc_r5_pb),
  .scbuf_sctag_ev_uerr_r5_pb            (scbuf_sctag_ev_uerr_r5_pb),
  .scbuf_sctag_ev_cerr_r5_pb            (scbuf_sctag_ev_cerr_r5_pb),
  .sctag_scbuf_wbrd_en_r1_v1            (sctag_scbuf_wbrd_en_r1_v1),
  .sctag_scbuf_wbrd_en_r1_v2            (sctag_scbuf_wbrd_en_r1_v2),
  .sctag_scbuf_wbrd_en_r1_v3            (sctag_scbuf_wbrd_en_r1_v3),
  .sctag_scbuf_wbrd_en_r1_v4            (sctag_scbuf_wbrd_en_r1_v4),
  .sctag_scbuf_wbrd_wl_r1_v1            (sctag_scbuf_wbrd_wl_r1_v1[2:0]),
  .sctag_scbuf_wbrd_wl_r1_v2            (sctag_scbuf_wbrd_wl_r1_v2[2:0]),
  .sctag_scbuf_wbrd_wl_r1_v3            (sctag_scbuf_wbrd_wl_r1_v3[2:0]),
  .sctag_scbuf_wbrd_wl_r1_v4            (sctag_scbuf_wbrd_wl_r1_v4[2:0]),
  .sctag_scbuf_wbwr_wen_c8_v1           (sctag_scbuf_wbwr_wen_c8_v1),
  .sctag_scbuf_wbwr_wen_c8_v2           (sctag_scbuf_wbwr_wen_c8_v2),
  .sctag_scbuf_wbwr_wen_c8_v3           (sctag_scbuf_wbwr_wen_c8_v3),
  .sctag_scbuf_wbwr_wen_c8_v4           (sctag_scbuf_wbwr_wen_c8_v4),
  .sctag_scbuf_wbwr_wl_c8_v1            (sctag_scbuf_wbwr_wl_c8_v1[2:0]),
  .sctag_scbuf_wbwr_wl_c8_v2            (sctag_scbuf_wbwr_wl_c8_v2[2:0]),
  .sctag_scbuf_wbwr_wl_c8_v3            (sctag_scbuf_wbwr_wl_c8_v3[2:0]),
  .sctag_scbuf_wbwr_wl_c8_v4            (sctag_scbuf_wbwr_wl_c8_v4[2:0]),
  .sctag_scbuf_rdma_rden_r1_v1          (sctag_scbuf_rdma_rden_r1_v1),
  .sctag_scbuf_rdma_rden_r1_v2          (sctag_scbuf_rdma_rden_r1_v2),
  .sctag_scbuf_rdma_rden_r1_v3          (sctag_scbuf_rdma_rden_r1_v3),
  .sctag_scbuf_rdma_rden_r1_v4          (sctag_scbuf_rdma_rden_r1_v4),
  .sctag_scbuf_rdma_rdwl_r1_v1          (sctag_scbuf_rdma_rdwl_r1_v1[1:0]),
  .sctag_scbuf_rdma_rdwl_r1_v2          (sctag_scbuf_rdma_rdwl_r1_v2[1:0]),
  .sctag_scbuf_rdma_rdwl_r1_v3          (sctag_scbuf_rdma_rdwl_r1_v3[1:0]),
  .sctag_scbuf_rdma_rdwl_r1_v4          (sctag_scbuf_rdma_rdwl_r1_v4[1:0]),
  .sctag_scbuf_rdma_wren_s3             (sctag_scbuf_rdma_wren_s3[15:0]),
  .sctag_scbuf_rdma_wren_s3_v4          (sctag_scbuf_rdma_wren_s3_v4),
  .sctag_scbuf_rdma_wren_s3_v3          (sctag_scbuf_rdma_wren_s3_v3),
  .sctag_scbuf_rdma_wren_s3_v2          (sctag_scbuf_rdma_wren_s3_v2),
  .sctag_scbuf_rdma_wren_s3_v1          (sctag_scbuf_rdma_wren_s3_v1),
  .sctag_scbuf_rdma_wrwl_s3_v1          (sctag_scbuf_rdma_wrwl_s3_v1[1:0]),
  .sctag_scbuf_rdma_wrwl_s3_v2          (sctag_scbuf_rdma_wrwl_s3_v2[1:0]),
  .sctag_scbuf_rdma_wrwl_s3_v3          (sctag_scbuf_rdma_wrwl_s3_v3[1:0]),
  .sctag_scbuf_rdma_wrwl_s3_v4          (sctag_scbuf_rdma_wrwl_s3_v4[1:0]),
  .rdma_array_din                       (rdma_array_din[623:0]),
  // Inputs
  .rclk                                 (rclk),
  .grst_l                               (scbuf_grst_l),
  .arst_l                               (arst_l_buf3),
  .se                                   (se),
  .sehold                               (sehold),
  .si                                   (scan_manual_3),
  .sctag_scbuf_wbrd_en_r0               (sctag_scbuf_wbrd_en_r0),
  .wb_array_dout                        (wb_array_dout[623:0]),
  .sctag_scbuf_evict_en_r0              (sctag_scbuf_evict_en_r0),
  .sctag_scbuf_ev_dword_r0              (sctag_scbuf_ev_dword_r0[2:0]),
  .sctag_scbuf_rdma_rden_r0             (sctag_scbuf_rdma_rden_r0),
  .rdma_array_dout                      (rdma_array_dout[623:0]),
  .sctag_scbuf_wbrd_wl_r0               (sctag_scbuf_wbrd_wl_r0[2:0]),
  .sctag_scbuf_wbwr_wen_c6              (sctag_scbuf_wbwr_wen_c6[0]),
  .sctag_scbuf_wbwr_wl_c6               (sctag_scbuf_wbwr_wl_c6[2:0]),
  .sctag_scbuf_rdma_rdwl_r0             (sctag_scbuf_rdma_rdwl_r0[1:0]),
  .sctag_scbuf_rdma_wren_s2             (sctag_scbuf_rdma_wren_s2[15:0]),
  .sctag_scbuf_rdma_wrwl_s2             (sctag_scbuf_rdma_wrwl_s2[1:0]),
  .jbi_sctag_req                        (jbi_sctag_req[31:0]),
  .jbi_scbuf_ecc                        (jbi_scbuf_ecc[6:0])); 


////////////////////////////////////////////////////////////////////////////////


bw_r_rf16x160  rdma_array4
  (.dout   ({dummy_rdma_array_dout[15:12],
             rdma_array_dout[351], rdma_array_dout[429], rdma_array_dout[507], rdma_array_dout[585],
             rdma_array_dout[352], rdma_array_dout[430], rdma_array_dout[508], rdma_array_dout[586],
             rdma_array_dout[353], rdma_array_dout[431], rdma_array_dout[509], rdma_array_dout[587],
             rdma_array_dout[354], rdma_array_dout[432], rdma_array_dout[510], rdma_array_dout[588],
             rdma_array_dout[355], rdma_array_dout[433], rdma_array_dout[511], rdma_array_dout[589],
             rdma_array_dout[356], rdma_array_dout[434], rdma_array_dout[512], rdma_array_dout[590],
             rdma_array_dout[357], rdma_array_dout[435], rdma_array_dout[513], rdma_array_dout[591],
             rdma_array_dout[358], rdma_array_dout[436], rdma_array_dout[514], rdma_array_dout[592],
             rdma_array_dout[359], rdma_array_dout[437], rdma_array_dout[515], rdma_array_dout[593],
             rdma_array_dout[360], rdma_array_dout[438], rdma_array_dout[516], rdma_array_dout[594],
             rdma_array_dout[361], rdma_array_dout[439], rdma_array_dout[517], rdma_array_dout[595],
             rdma_array_dout[362], rdma_array_dout[440], rdma_array_dout[518], rdma_array_dout[596],
             rdma_array_dout[363], rdma_array_dout[441], rdma_array_dout[519], rdma_array_dout[597],
             rdma_array_dout[364], rdma_array_dout[442], rdma_array_dout[520], rdma_array_dout[598],
             rdma_array_dout[365], rdma_array_dout[443], rdma_array_dout[521], rdma_array_dout[599],
             rdma_array_dout[366], rdma_array_dout[444], rdma_array_dout[522], rdma_array_dout[600],
             rdma_array_dout[367], rdma_array_dout[445], rdma_array_dout[523], rdma_array_dout[601],
             rdma_array_dout[368], rdma_array_dout[446], rdma_array_dout[524], rdma_array_dout[602],
             rdma_array_dout[369], rdma_array_dout[447], rdma_array_dout[525], rdma_array_dout[603],
             rdma_array_dout[370], rdma_array_dout[448], rdma_array_dout[526], rdma_array_dout[604],
             rdma_array_dout[371], rdma_array_dout[449], rdma_array_dout[527], rdma_array_dout[605],
             rdma_array_dout[372], rdma_array_dout[450], rdma_array_dout[528], rdma_array_dout[606],
             rdma_array_dout[373], rdma_array_dout[451], rdma_array_dout[529], rdma_array_dout[607],
             rdma_array_dout[374], rdma_array_dout[452], rdma_array_dout[530], rdma_array_dout[608],
             rdma_array_dout[375], rdma_array_dout[453], rdma_array_dout[531], rdma_array_dout[609],
             rdma_array_dout[376], rdma_array_dout[454], rdma_array_dout[532], rdma_array_dout[610],
             rdma_array_dout[377], rdma_array_dout[455], rdma_array_dout[533], rdma_array_dout[611],
             rdma_array_dout[378], rdma_array_dout[456], rdma_array_dout[534], rdma_array_dout[612],
             rdma_array_dout[379], rdma_array_dout[457], rdma_array_dout[535], rdma_array_dout[613],
             rdma_array_dout[380], rdma_array_dout[458], rdma_array_dout[536], rdma_array_dout[614],
             rdma_array_dout[381], rdma_array_dout[459], rdma_array_dout[537], rdma_array_dout[615],
             rdma_array_dout[382], rdma_array_dout[460], rdma_array_dout[538], rdma_array_dout[616],
             rdma_array_dout[383], rdma_array_dout[461], rdma_array_dout[539], rdma_array_dout[617],
             rdma_array_dout[384], rdma_array_dout[462], rdma_array_dout[540], rdma_array_dout[618],
             rdma_array_dout[385], rdma_array_dout[463], rdma_array_dout[541], rdma_array_dout[619],
             rdma_array_dout[386], rdma_array_dout[464], rdma_array_dout[542], rdma_array_dout[620],
             rdma_array_dout[387], rdma_array_dout[465], rdma_array_dout[543], rdma_array_dout[621],
             rdma_array_dout[388], rdma_array_dout[466], rdma_array_dout[544], rdma_array_dout[622],
             rdma_array_dout[389], rdma_array_dout[467], rdma_array_dout[545], rdma_array_dout[623]}),
   .din    ({1'b0, 1'b0, 1'b0, 1'b0,
             rdma_array_din[351], rdma_array_din[429], rdma_array_din[507], rdma_array_din[585],
             rdma_array_din[352], rdma_array_din[430], rdma_array_din[508], rdma_array_din[586],
             rdma_array_din[353], rdma_array_din[431], rdma_array_din[509], rdma_array_din[587],
             rdma_array_din[354], rdma_array_din[432], rdma_array_din[510], rdma_array_din[588],
             rdma_array_din[355], rdma_array_din[433], rdma_array_din[511], rdma_array_din[589],
             rdma_array_din[356], rdma_array_din[434], rdma_array_din[512], rdma_array_din[590],
             rdma_array_din[357], rdma_array_din[435], rdma_array_din[513], rdma_array_din[591],
             rdma_array_din[358], rdma_array_din[436], rdma_array_din[514], rdma_array_din[592],
             rdma_array_din[359], rdma_array_din[437], rdma_array_din[515], rdma_array_din[593],
             rdma_array_din[360], rdma_array_din[438], rdma_array_din[516], rdma_array_din[594],
             rdma_array_din[361], rdma_array_din[439], rdma_array_din[517], rdma_array_din[595],
             rdma_array_din[362], rdma_array_din[440], rdma_array_din[518], rdma_array_din[596],
             rdma_array_din[363], rdma_array_din[441], rdma_array_din[519], rdma_array_din[597],
             rdma_array_din[364], rdma_array_din[442], rdma_array_din[520], rdma_array_din[598],
             rdma_array_din[365], rdma_array_din[443], rdma_array_din[521], rdma_array_din[599],
             rdma_array_din[366], rdma_array_din[444], rdma_array_din[522], rdma_array_din[600],
             rdma_array_din[367], rdma_array_din[445], rdma_array_din[523], rdma_array_din[601],
             rdma_array_din[368], rdma_array_din[446], rdma_array_din[524], rdma_array_din[602],
             rdma_array_din[369], rdma_array_din[447], rdma_array_din[525], rdma_array_din[603],
             rdma_array_din[370], rdma_array_din[448], rdma_array_din[526], rdma_array_din[604],
             rdma_array_din[371], rdma_array_din[449], rdma_array_din[527], rdma_array_din[605],
             rdma_array_din[372], rdma_array_din[450], rdma_array_din[528], rdma_array_din[606],
             rdma_array_din[373], rdma_array_din[451], rdma_array_din[529], rdma_array_din[607],
             rdma_array_din[374], rdma_array_din[452], rdma_array_din[530], rdma_array_din[608],
             rdma_array_din[375], rdma_array_din[453], rdma_array_din[531], rdma_array_din[609],
             rdma_array_din[376], rdma_array_din[454], rdma_array_din[532], rdma_array_din[610],
             rdma_array_din[377], rdma_array_din[455], rdma_array_din[533], rdma_array_din[611],
             rdma_array_din[378], rdma_array_din[456], rdma_array_din[534], rdma_array_din[612],
             rdma_array_din[379], rdma_array_din[457], rdma_array_din[535], rdma_array_din[613],
             rdma_array_din[380], rdma_array_din[458], rdma_array_din[536], rdma_array_din[614],
             rdma_array_din[381], rdma_array_din[459], rdma_array_din[537], rdma_array_din[615],
             rdma_array_din[382], rdma_array_din[460], rdma_array_din[538], rdma_array_din[616],
             rdma_array_din[383], rdma_array_din[461], rdma_array_din[539], rdma_array_din[617],
             rdma_array_din[384], rdma_array_din[462], rdma_array_din[540], rdma_array_din[618],
             rdma_array_din[385], rdma_array_din[463], rdma_array_din[541], rdma_array_din[619],
             rdma_array_din[386], rdma_array_din[464], rdma_array_din[542], rdma_array_din[620],
             rdma_array_din[387], rdma_array_din[465], rdma_array_din[543], rdma_array_din[621],
             rdma_array_din[388], rdma_array_din[466], rdma_array_din[544], rdma_array_din[622],
             rdma_array_din[389], rdma_array_din[467], rdma_array_din[545], rdma_array_din[623]}),
   .rd_adr   ({1'b0, 1'b0, sctag_scbuf_rdma_rdwl_r1_v4[1:0]}),
   .wr_adr   ({1'b0, 1'b0, sctag_scbuf_rdma_wrwl_s3_v4[1:0]}),
   .read_en  (sctag_scbuf_rdma_rden_r1_v4),
   .wr_en    (sctag_scbuf_rdma_wren_s3_v4),
   .word_wen ({sctag_scbuf_rdma_wren_s3[6], sctag_scbuf_rdma_wren_s3[4],
               sctag_scbuf_rdma_wren_s3[2], sctag_scbuf_rdma_wren_s3[0]}),
   .byte_wen ({1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1,
               1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1}),
   .rd_clk   (rclk),
   .wr_clk   (rclk),
   .se       (se_buf3),
   .si_r       (manual_scan_7),
   .si_w       (manual_scan_8a),
   .so_r       (manual_scan_8a),
   .so_w       (manual_scan_8),
   .reset_l    (arst_l_buf3),
   .rst_tri_en (mem_write_disable_buf3),
   .sehold     (sehold_buf3));


bw_r_rf16x160  rdma_array3
  (.dout   ({dummy_rdma_array_dout[11:8],
             rdma_array_dout[312], rdma_array_dout[390], rdma_array_dout[468], rdma_array_dout[546],
             rdma_array_dout[313], rdma_array_dout[391], rdma_array_dout[469], rdma_array_dout[547],
             rdma_array_dout[314], rdma_array_dout[392], rdma_array_dout[470], rdma_array_dout[548],
             rdma_array_dout[315], rdma_array_dout[393], rdma_array_dout[471], rdma_array_dout[549],
             rdma_array_dout[316], rdma_array_dout[394], rdma_array_dout[472], rdma_array_dout[550],
             rdma_array_dout[317], rdma_array_dout[395], rdma_array_dout[473], rdma_array_dout[551],
             rdma_array_dout[318], rdma_array_dout[396], rdma_array_dout[474], rdma_array_dout[552],
             rdma_array_dout[319], rdma_array_dout[397], rdma_array_dout[475], rdma_array_dout[553],
             rdma_array_dout[320], rdma_array_dout[398], rdma_array_dout[476], rdma_array_dout[554],
             rdma_array_dout[321], rdma_array_dout[399], rdma_array_dout[477], rdma_array_dout[555],
             rdma_array_dout[322], rdma_array_dout[400], rdma_array_dout[478], rdma_array_dout[556],
             rdma_array_dout[323], rdma_array_dout[401], rdma_array_dout[479], rdma_array_dout[557],
             rdma_array_dout[324], rdma_array_dout[402], rdma_array_dout[480], rdma_array_dout[558],
             rdma_array_dout[325], rdma_array_dout[403], rdma_array_dout[481], rdma_array_dout[559],
             rdma_array_dout[326], rdma_array_dout[404], rdma_array_dout[482], rdma_array_dout[560],
             rdma_array_dout[327], rdma_array_dout[405], rdma_array_dout[483], rdma_array_dout[561],
             rdma_array_dout[328], rdma_array_dout[406], rdma_array_dout[484], rdma_array_dout[562],
             rdma_array_dout[329], rdma_array_dout[407], rdma_array_dout[485], rdma_array_dout[563],
             rdma_array_dout[330], rdma_array_dout[408], rdma_array_dout[486], rdma_array_dout[564],
             rdma_array_dout[331], rdma_array_dout[409], rdma_array_dout[487], rdma_array_dout[565],
             rdma_array_dout[332], rdma_array_dout[410], rdma_array_dout[488], rdma_array_dout[566],
             rdma_array_dout[333], rdma_array_dout[411], rdma_array_dout[489], rdma_array_dout[567],
             rdma_array_dout[334], rdma_array_dout[412], rdma_array_dout[490], rdma_array_dout[568],
             rdma_array_dout[335], rdma_array_dout[413], rdma_array_dout[491], rdma_array_dout[569],
             rdma_array_dout[336], rdma_array_dout[414], rdma_array_dout[492], rdma_array_dout[570],
             rdma_array_dout[337], rdma_array_dout[415], rdma_array_dout[493], rdma_array_dout[571],
             rdma_array_dout[338], rdma_array_dout[416], rdma_array_dout[494], rdma_array_dout[572],
             rdma_array_dout[339], rdma_array_dout[417], rdma_array_dout[495], rdma_array_dout[573],
             rdma_array_dout[340], rdma_array_dout[418], rdma_array_dout[496], rdma_array_dout[574],
             rdma_array_dout[341], rdma_array_dout[419], rdma_array_dout[497], rdma_array_dout[575],
             rdma_array_dout[342], rdma_array_dout[420], rdma_array_dout[498], rdma_array_dout[576],
             rdma_array_dout[343], rdma_array_dout[421], rdma_array_dout[499], rdma_array_dout[577],
             rdma_array_dout[344], rdma_array_dout[422], rdma_array_dout[500], rdma_array_dout[578],
             rdma_array_dout[345], rdma_array_dout[423], rdma_array_dout[501], rdma_array_dout[579],
             rdma_array_dout[346], rdma_array_dout[424], rdma_array_dout[502], rdma_array_dout[580],
             rdma_array_dout[347], rdma_array_dout[425], rdma_array_dout[503], rdma_array_dout[581],
             rdma_array_dout[348], rdma_array_dout[426], rdma_array_dout[504], rdma_array_dout[582],
             rdma_array_dout[349], rdma_array_dout[427], rdma_array_dout[505], rdma_array_dout[583],
             rdma_array_dout[350], rdma_array_dout[428], rdma_array_dout[506], rdma_array_dout[584]}),
   .din    ({1'b0, 1'b0, 1'b0, 1'b0,
             rdma_array_din[312], rdma_array_din[390], rdma_array_din[468], rdma_array_din[546],
             rdma_array_din[313], rdma_array_din[391], rdma_array_din[469], rdma_array_din[547],
             rdma_array_din[314], rdma_array_din[392], rdma_array_din[470], rdma_array_din[548],
             rdma_array_din[315], rdma_array_din[393], rdma_array_din[471], rdma_array_din[549],
             rdma_array_din[316], rdma_array_din[394], rdma_array_din[472], rdma_array_din[550],
             rdma_array_din[317], rdma_array_din[395], rdma_array_din[473], rdma_array_din[551],
             rdma_array_din[318], rdma_array_din[396], rdma_array_din[474], rdma_array_din[552],
             rdma_array_din[319], rdma_array_din[397], rdma_array_din[475], rdma_array_din[553],
             rdma_array_din[320], rdma_array_din[398], rdma_array_din[476], rdma_array_din[554],
             rdma_array_din[321], rdma_array_din[399], rdma_array_din[477], rdma_array_din[555],
             rdma_array_din[322], rdma_array_din[400], rdma_array_din[478], rdma_array_din[556],
             rdma_array_din[323], rdma_array_din[401], rdma_array_din[479], rdma_array_din[557],
             rdma_array_din[324], rdma_array_din[402], rdma_array_din[480], rdma_array_din[558],
             rdma_array_din[325], rdma_array_din[403], rdma_array_din[481], rdma_array_din[559],
             rdma_array_din[326], rdma_array_din[404], rdma_array_din[482], rdma_array_din[560],
             rdma_array_din[327], rdma_array_din[405], rdma_array_din[483], rdma_array_din[561],
             rdma_array_din[328], rdma_array_din[406], rdma_array_din[484], rdma_array_din[562],
             rdma_array_din[329], rdma_array_din[407], rdma_array_din[485], rdma_array_din[563],
             rdma_array_din[330], rdma_array_din[408], rdma_array_din[486], rdma_array_din[564],
             rdma_array_din[331], rdma_array_din[409], rdma_array_din[487], rdma_array_din[565],
             rdma_array_din[332], rdma_array_din[410], rdma_array_din[488], rdma_array_din[566],
             rdma_array_din[333], rdma_array_din[411], rdma_array_din[489], rdma_array_din[567],
             rdma_array_din[334], rdma_array_din[412], rdma_array_din[490], rdma_array_din[568],
             rdma_array_din[335], rdma_array_din[413], rdma_array_din[491], rdma_array_din[569],
             rdma_array_din[336], rdma_array_din[414], rdma_array_din[492], rdma_array_din[570],
             rdma_array_din[337], rdma_array_din[415], rdma_array_din[493], rdma_array_din[571],
             rdma_array_din[338], rdma_array_din[416], rdma_array_din[494], rdma_array_din[572],
             rdma_array_din[339], rdma_array_din[417], rdma_array_din[495], rdma_array_din[573],
             rdma_array_din[340], rdma_array_din[418], rdma_array_din[496], rdma_array_din[574],
             rdma_array_din[341], rdma_array_din[419], rdma_array_din[497], rdma_array_din[575],
             rdma_array_din[342], rdma_array_din[420], rdma_array_din[498], rdma_array_din[576],
             rdma_array_din[343], rdma_array_din[421], rdma_array_din[499], rdma_array_din[577],
             rdma_array_din[344], rdma_array_din[422], rdma_array_din[500], rdma_array_din[578],
             rdma_array_din[345], rdma_array_din[423], rdma_array_din[501], rdma_array_din[579],
             rdma_array_din[346], rdma_array_din[424], rdma_array_din[502], rdma_array_din[580],
             rdma_array_din[347], rdma_array_din[425], rdma_array_din[503], rdma_array_din[581],
             rdma_array_din[348], rdma_array_din[426], rdma_array_din[504], rdma_array_din[582],
             rdma_array_din[349], rdma_array_din[427], rdma_array_din[505], rdma_array_din[583],
             rdma_array_din[350], rdma_array_din[428], rdma_array_din[506], rdma_array_din[584]}),
   .rd_adr   ({1'b0, 1'b0, sctag_scbuf_rdma_rdwl_r1_v3[1:0]}),
   .wr_adr   ({1'b0, 1'b0, sctag_scbuf_rdma_wrwl_s3_v3[1:0]}),
   .read_en  (sctag_scbuf_rdma_rden_r1_v3),
   .wr_en    (sctag_scbuf_rdma_wren_s3_v3),
   .word_wen ({sctag_scbuf_rdma_wren_s3[7], sctag_scbuf_rdma_wren_s3[5],
               sctag_scbuf_rdma_wren_s3[3], sctag_scbuf_rdma_wren_s3[1]}),
   .byte_wen ({1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1,
               1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1}),
   .rd_clk   (rclk),
   .wr_clk   (rclk),
   .se       (se_buf3),
   .si_r       (manual_scan_8),
   .si_w       (manual_scan_9a),
   .so_r       (manual_scan_9a),
   .so_w       (manual_scan_9),
   .reset_l    (arst_l_buf3),
   .rst_tri_en (mem_write_disable_buf3),
   .sehold     (sehold_buf3));


bw_r_rf16x160  rdma_array2
  (.dout   ({dummy_rdma_array_dout[7:4],
             rdma_array_dout[39], rdma_array_dout[117], rdma_array_dout[195], rdma_array_dout[273],
             rdma_array_dout[40], rdma_array_dout[118], rdma_array_dout[196], rdma_array_dout[274],
             rdma_array_dout[41], rdma_array_dout[119], rdma_array_dout[197], rdma_array_dout[275],
             rdma_array_dout[42], rdma_array_dout[120], rdma_array_dout[198], rdma_array_dout[276],
             rdma_array_dout[43], rdma_array_dout[121], rdma_array_dout[199], rdma_array_dout[277],
             rdma_array_dout[44], rdma_array_dout[122], rdma_array_dout[200], rdma_array_dout[278],
             rdma_array_dout[45], rdma_array_dout[123], rdma_array_dout[201], rdma_array_dout[279],
             rdma_array_dout[46], rdma_array_dout[124], rdma_array_dout[202], rdma_array_dout[280],
             rdma_array_dout[47], rdma_array_dout[125], rdma_array_dout[203], rdma_array_dout[281],
             rdma_array_dout[48], rdma_array_dout[126], rdma_array_dout[204], rdma_array_dout[282],
             rdma_array_dout[49], rdma_array_dout[127], rdma_array_dout[205], rdma_array_dout[283],
             rdma_array_dout[50], rdma_array_dout[128], rdma_array_dout[206], rdma_array_dout[284],
             rdma_array_dout[51], rdma_array_dout[129], rdma_array_dout[207], rdma_array_dout[285],
             rdma_array_dout[52], rdma_array_dout[130], rdma_array_dout[208], rdma_array_dout[286],
             rdma_array_dout[53], rdma_array_dout[131], rdma_array_dout[209], rdma_array_dout[287],
             rdma_array_dout[54], rdma_array_dout[132], rdma_array_dout[210], rdma_array_dout[288],
             rdma_array_dout[55], rdma_array_dout[133], rdma_array_dout[211], rdma_array_dout[289],
             rdma_array_dout[56], rdma_array_dout[134], rdma_array_dout[212], rdma_array_dout[290],
             rdma_array_dout[57], rdma_array_dout[135], rdma_array_dout[213], rdma_array_dout[291],
             rdma_array_dout[58], rdma_array_dout[136], rdma_array_dout[214], rdma_array_dout[292],
             rdma_array_dout[59], rdma_array_dout[137], rdma_array_dout[215], rdma_array_dout[293],
             rdma_array_dout[60], rdma_array_dout[138], rdma_array_dout[216], rdma_array_dout[294],
             rdma_array_dout[61], rdma_array_dout[139], rdma_array_dout[217], rdma_array_dout[295],
             rdma_array_dout[62], rdma_array_dout[140], rdma_array_dout[218], rdma_array_dout[296],
             rdma_array_dout[63], rdma_array_dout[141], rdma_array_dout[219], rdma_array_dout[297],
             rdma_array_dout[64], rdma_array_dout[142], rdma_array_dout[220], rdma_array_dout[298],
             rdma_array_dout[65], rdma_array_dout[143], rdma_array_dout[221], rdma_array_dout[299],
             rdma_array_dout[66], rdma_array_dout[144], rdma_array_dout[222], rdma_array_dout[300],
             rdma_array_dout[67], rdma_array_dout[145], rdma_array_dout[223], rdma_array_dout[301],
             rdma_array_dout[68], rdma_array_dout[146], rdma_array_dout[224], rdma_array_dout[302],
             rdma_array_dout[69], rdma_array_dout[147], rdma_array_dout[225], rdma_array_dout[303],
             rdma_array_dout[70], rdma_array_dout[148], rdma_array_dout[226], rdma_array_dout[304],
             rdma_array_dout[71], rdma_array_dout[149], rdma_array_dout[227], rdma_array_dout[305],
             rdma_array_dout[72], rdma_array_dout[150], rdma_array_dout[228], rdma_array_dout[306],
             rdma_array_dout[73], rdma_array_dout[151], rdma_array_dout[229], rdma_array_dout[307],
             rdma_array_dout[74], rdma_array_dout[152], rdma_array_dout[230], rdma_array_dout[308],
             rdma_array_dout[75], rdma_array_dout[153], rdma_array_dout[231], rdma_array_dout[309],
             rdma_array_dout[76], rdma_array_dout[154], rdma_array_dout[232], rdma_array_dout[310],
             rdma_array_dout[77], rdma_array_dout[155], rdma_array_dout[233], rdma_array_dout[311]}),
   .din    ({1'b0, 1'b0, 1'b0, 1'b0,
             rdma_array_din[39], rdma_array_din[117], rdma_array_din[195], rdma_array_din[273],
             rdma_array_din[40], rdma_array_din[118], rdma_array_din[196], rdma_array_din[274],
             rdma_array_din[41], rdma_array_din[119], rdma_array_din[197], rdma_array_din[275],
             rdma_array_din[42], rdma_array_din[120], rdma_array_din[198], rdma_array_din[276],
             rdma_array_din[43], rdma_array_din[121], rdma_array_din[199], rdma_array_din[277],
             rdma_array_din[44], rdma_array_din[122], rdma_array_din[200], rdma_array_din[278],
             rdma_array_din[45], rdma_array_din[123], rdma_array_din[201], rdma_array_din[279],
             rdma_array_din[46], rdma_array_din[124], rdma_array_din[202], rdma_array_din[280],
             rdma_array_din[47], rdma_array_din[125], rdma_array_din[203], rdma_array_din[281],
             rdma_array_din[48], rdma_array_din[126], rdma_array_din[204], rdma_array_din[282],
             rdma_array_din[49], rdma_array_din[127], rdma_array_din[205], rdma_array_din[283],
             rdma_array_din[50], rdma_array_din[128], rdma_array_din[206], rdma_array_din[284],
             rdma_array_din[51], rdma_array_din[129], rdma_array_din[207], rdma_array_din[285],
             rdma_array_din[52], rdma_array_din[130], rdma_array_din[208], rdma_array_din[286],
             rdma_array_din[53], rdma_array_din[131], rdma_array_din[209], rdma_array_din[287],
             rdma_array_din[54], rdma_array_din[132], rdma_array_din[210], rdma_array_din[288],
             rdma_array_din[55], rdma_array_din[133], rdma_array_din[211], rdma_array_din[289],
             rdma_array_din[56], rdma_array_din[134], rdma_array_din[212], rdma_array_din[290],
             rdma_array_din[57], rdma_array_din[135], rdma_array_din[213], rdma_array_din[291],
             rdma_array_din[58], rdma_array_din[136], rdma_array_din[214], rdma_array_din[292],
             rdma_array_din[59], rdma_array_din[137], rdma_array_din[215], rdma_array_din[293],
             rdma_array_din[60], rdma_array_din[138], rdma_array_din[216], rdma_array_din[294],
             rdma_array_din[61], rdma_array_din[139], rdma_array_din[217], rdma_array_din[295],
             rdma_array_din[62], rdma_array_din[140], rdma_array_din[218], rdma_array_din[296],
             rdma_array_din[63], rdma_array_din[141], rdma_array_din[219], rdma_array_din[297],
             rdma_array_din[64], rdma_array_din[142], rdma_array_din[220], rdma_array_din[298],
             rdma_array_din[65], rdma_array_din[143], rdma_array_din[221], rdma_array_din[299],
             rdma_array_din[66], rdma_array_din[144], rdma_array_din[222], rdma_array_din[300],
             rdma_array_din[67], rdma_array_din[145], rdma_array_din[223], rdma_array_din[301],
             rdma_array_din[68], rdma_array_din[146], rdma_array_din[224], rdma_array_din[302],
             rdma_array_din[69], rdma_array_din[147], rdma_array_din[225], rdma_array_din[303],
             rdma_array_din[70], rdma_array_din[148], rdma_array_din[226], rdma_array_din[304],
             rdma_array_din[71], rdma_array_din[149], rdma_array_din[227], rdma_array_din[305],
             rdma_array_din[72], rdma_array_din[150], rdma_array_din[228], rdma_array_din[306],
             rdma_array_din[73], rdma_array_din[151], rdma_array_din[229], rdma_array_din[307],
             rdma_array_din[74], rdma_array_din[152], rdma_array_din[230], rdma_array_din[308],
             rdma_array_din[75], rdma_array_din[153], rdma_array_din[231], rdma_array_din[309],
             rdma_array_din[76], rdma_array_din[154], rdma_array_din[232], rdma_array_din[310],
             rdma_array_din[77], rdma_array_din[155], rdma_array_din[233], rdma_array_din[311]}),
   .rd_adr   ({1'b0, 1'b0, sctag_scbuf_rdma_rdwl_r1_v2[1:0]}),
   .wr_adr   ({1'b0, 1'b0, sctag_scbuf_rdma_wrwl_s3_v2[1:0]}),
   .read_en  (sctag_scbuf_rdma_rden_r1_v2),
   .wr_en    (sctag_scbuf_rdma_wren_s3_v2),
   .word_wen ({sctag_scbuf_rdma_wren_s3[14], sctag_scbuf_rdma_wren_s3[12],
               sctag_scbuf_rdma_wren_s3[10], sctag_scbuf_rdma_wren_s3[8]}),
   .byte_wen ({1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1,
               1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1}),
   .rd_clk   (rclk),
   .wr_clk   (rclk),
   .se       (se_buf3),
   .si_r       (manual_scan_9),
   .si_w       (manual_scan_10a),
   .so_r       (manual_scan_10a),
   .so_w       (manual_scan_10),
   .reset_l    (arst_l_buf3),
   .rst_tri_en (mem_write_disable_buf3),
   .sehold     (sehold_buf3));


bw_r_rf16x160  rdma_array1
  (.dout   ({dummy_rdma_array_dout[3:0],
             rdma_array_dout[0], rdma_array_dout[78], rdma_array_dout[156], rdma_array_dout[234],
             rdma_array_dout[1], rdma_array_dout[79], rdma_array_dout[157], rdma_array_dout[235],
             rdma_array_dout[2], rdma_array_dout[80], rdma_array_dout[158], rdma_array_dout[236],
             rdma_array_dout[3], rdma_array_dout[81], rdma_array_dout[159], rdma_array_dout[237],
             rdma_array_dout[4], rdma_array_dout[82], rdma_array_dout[160], rdma_array_dout[238],
             rdma_array_dout[5], rdma_array_dout[83], rdma_array_dout[161], rdma_array_dout[239],
             rdma_array_dout[6], rdma_array_dout[84], rdma_array_dout[162], rdma_array_dout[240],
             rdma_array_dout[7], rdma_array_dout[85], rdma_array_dout[163], rdma_array_dout[241],
             rdma_array_dout[8], rdma_array_dout[86], rdma_array_dout[164], rdma_array_dout[242],
             rdma_array_dout[9], rdma_array_dout[87], rdma_array_dout[165], rdma_array_dout[243],
             rdma_array_dout[10], rdma_array_dout[88], rdma_array_dout[166], rdma_array_dout[244],
             rdma_array_dout[11], rdma_array_dout[89], rdma_array_dout[167], rdma_array_dout[245],
             rdma_array_dout[12], rdma_array_dout[90], rdma_array_dout[168], rdma_array_dout[246],
             rdma_array_dout[13], rdma_array_dout[91], rdma_array_dout[169], rdma_array_dout[247],
             rdma_array_dout[14], rdma_array_dout[92], rdma_array_dout[170], rdma_array_dout[248],
             rdma_array_dout[15], rdma_array_dout[93], rdma_array_dout[171], rdma_array_dout[249],
             rdma_array_dout[16], rdma_array_dout[94], rdma_array_dout[172], rdma_array_dout[250],
             rdma_array_dout[17], rdma_array_dout[95], rdma_array_dout[173], rdma_array_dout[251],
             rdma_array_dout[18], rdma_array_dout[96], rdma_array_dout[174], rdma_array_dout[252],
             rdma_array_dout[19], rdma_array_dout[97], rdma_array_dout[175], rdma_array_dout[253],
             rdma_array_dout[20], rdma_array_dout[98], rdma_array_dout[176], rdma_array_dout[254],
             rdma_array_dout[21], rdma_array_dout[99], rdma_array_dout[177], rdma_array_dout[255],
             rdma_array_dout[22], rdma_array_dout[100], rdma_array_dout[178], rdma_array_dout[256],
             rdma_array_dout[23], rdma_array_dout[101], rdma_array_dout[179], rdma_array_dout[257],
             rdma_array_dout[24], rdma_array_dout[102], rdma_array_dout[180], rdma_array_dout[258],
             rdma_array_dout[25], rdma_array_dout[103], rdma_array_dout[181], rdma_array_dout[259],
             rdma_array_dout[26], rdma_array_dout[104], rdma_array_dout[182], rdma_array_dout[260],
             rdma_array_dout[27], rdma_array_dout[105], rdma_array_dout[183], rdma_array_dout[261],
             rdma_array_dout[28], rdma_array_dout[106], rdma_array_dout[184], rdma_array_dout[262],
             rdma_array_dout[29], rdma_array_dout[107], rdma_array_dout[185], rdma_array_dout[263],
             rdma_array_dout[30], rdma_array_dout[108], rdma_array_dout[186], rdma_array_dout[264],
             rdma_array_dout[31], rdma_array_dout[109], rdma_array_dout[187], rdma_array_dout[265],
             rdma_array_dout[32], rdma_array_dout[110], rdma_array_dout[188], rdma_array_dout[266],
             rdma_array_dout[33], rdma_array_dout[111], rdma_array_dout[189], rdma_array_dout[267],
             rdma_array_dout[34], rdma_array_dout[112], rdma_array_dout[190], rdma_array_dout[268],
             rdma_array_dout[35], rdma_array_dout[113], rdma_array_dout[191], rdma_array_dout[269],
             rdma_array_dout[36], rdma_array_dout[114], rdma_array_dout[192], rdma_array_dout[270],
             rdma_array_dout[37], rdma_array_dout[115], rdma_array_dout[193], rdma_array_dout[271],
             rdma_array_dout[38], rdma_array_dout[116], rdma_array_dout[194], rdma_array_dout[272]}),
   .din    ({1'b0, 1'b0, 1'b0, 1'b0,
             rdma_array_din[0], rdma_array_din[78], rdma_array_din[156], rdma_array_din[234],
             rdma_array_din[1], rdma_array_din[79], rdma_array_din[157], rdma_array_din[235],
             rdma_array_din[2], rdma_array_din[80], rdma_array_din[158], rdma_array_din[236],
             rdma_array_din[3], rdma_array_din[81], rdma_array_din[159], rdma_array_din[237],
             rdma_array_din[4], rdma_array_din[82], rdma_array_din[160], rdma_array_din[238],
             rdma_array_din[5], rdma_array_din[83], rdma_array_din[161], rdma_array_din[239],
             rdma_array_din[6], rdma_array_din[84], rdma_array_din[162], rdma_array_din[240],
             rdma_array_din[7], rdma_array_din[85], rdma_array_din[163], rdma_array_din[241],
             rdma_array_din[8], rdma_array_din[86], rdma_array_din[164], rdma_array_din[242],
             rdma_array_din[9], rdma_array_din[87], rdma_array_din[165], rdma_array_din[243],
             rdma_array_din[10], rdma_array_din[88], rdma_array_din[166], rdma_array_din[244],
             rdma_array_din[11], rdma_array_din[89], rdma_array_din[167], rdma_array_din[245],
             rdma_array_din[12], rdma_array_din[90], rdma_array_din[168], rdma_array_din[246],
             rdma_array_din[13], rdma_array_din[91], rdma_array_din[169], rdma_array_din[247],
             rdma_array_din[14], rdma_array_din[92], rdma_array_din[170], rdma_array_din[248],
             rdma_array_din[15], rdma_array_din[93], rdma_array_din[171], rdma_array_din[249],
             rdma_array_din[16], rdma_array_din[94], rdma_array_din[172], rdma_array_din[250],
             rdma_array_din[17], rdma_array_din[95], rdma_array_din[173], rdma_array_din[251],
             rdma_array_din[18], rdma_array_din[96], rdma_array_din[174], rdma_array_din[252],
             rdma_array_din[19], rdma_array_din[97], rdma_array_din[175], rdma_array_din[253],
             rdma_array_din[20], rdma_array_din[98], rdma_array_din[176], rdma_array_din[254],
             rdma_array_din[21], rdma_array_din[99], rdma_array_din[177], rdma_array_din[255],
             rdma_array_din[22], rdma_array_din[100], rdma_array_din[178], rdma_array_din[256],
             rdma_array_din[23], rdma_array_din[101], rdma_array_din[179], rdma_array_din[257],
             rdma_array_din[24], rdma_array_din[102], rdma_array_din[180], rdma_array_din[258],
             rdma_array_din[25], rdma_array_din[103], rdma_array_din[181], rdma_array_din[259],
             rdma_array_din[26], rdma_array_din[104], rdma_array_din[182], rdma_array_din[260],
             rdma_array_din[27], rdma_array_din[105], rdma_array_din[183], rdma_array_din[261],
             rdma_array_din[28], rdma_array_din[106], rdma_array_din[184], rdma_array_din[262],
             rdma_array_din[29], rdma_array_din[107], rdma_array_din[185], rdma_array_din[263],
             rdma_array_din[30], rdma_array_din[108], rdma_array_din[186], rdma_array_din[264],
             rdma_array_din[31], rdma_array_din[109], rdma_array_din[187], rdma_array_din[265],
             rdma_array_din[32], rdma_array_din[110], rdma_array_din[188], rdma_array_din[266],
             rdma_array_din[33], rdma_array_din[111], rdma_array_din[189], rdma_array_din[267],
             rdma_array_din[34], rdma_array_din[112], rdma_array_din[190], rdma_array_din[268],
             rdma_array_din[35], rdma_array_din[113], rdma_array_din[191], rdma_array_din[269],
             rdma_array_din[36], rdma_array_din[114], rdma_array_din[192], rdma_array_din[270],
             rdma_array_din[37], rdma_array_din[115], rdma_array_din[193], rdma_array_din[271],
             rdma_array_din[38], rdma_array_din[116], rdma_array_din[194], rdma_array_din[272]}),
   .rd_adr   ({1'b0, 1'b0, sctag_scbuf_rdma_rdwl_r1_v1[1:0]}),
   .wr_adr   ({1'b0, 1'b0, sctag_scbuf_rdma_wrwl_s3_v1[1:0]}),
   .read_en  (sctag_scbuf_rdma_rden_r1_v1),
   .wr_en    (sctag_scbuf_rdma_wren_s3_v1),
   .word_wen ({sctag_scbuf_rdma_wren_s3[15], sctag_scbuf_rdma_wren_s3[13],
               sctag_scbuf_rdma_wren_s3[11], sctag_scbuf_rdma_wren_s3[9]}),
   .byte_wen ({1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1,
               1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1, 1'b1}),
   .rd_clk   (rclk),
   .wr_clk   (rclk),
   .se       (se_buf3),
   .si_r       (manual_scan_10),
   .si_w       (manual_scan_11a),
   .so_r       (manual_scan_11a),
   .so_w       (manual_scan_11),
   .reset_l    (arst_l_buf3),
   .rst_tri_en (mem_write_disable_buf3),
   .sehold     (sehold_buf3));


////////////////////////////////////////////////////////////////////////////////

endmodule
