/**
 * Copyright 2020 The SkyWater PDK Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 */

`ifndef SKY130_FD_SC_HD__UDP_DFF_PS_V
`define SKY130_FD_SC_HD__UDP_DFF_PS_V

/**
 * udp_dff$PS: Positive edge triggered D flip-flop with active high
 *
 * Verilog primitive definition.
 *
 * WARNING: This file is autogenerated, do not modify directly!
 */

`timescale 1ns / 1ps
`default_nettype none

`ifdef NO_PRIMITIVES
`include "./sky130_fd_sc_hd__udp_dff_ps.blackbox.v"
`else
primitive sky130_fd_sc_hd__udp_dff$PS (
    Q  ,
    D  ,
    CLK,
    SET
);

    output Q  ;
    input  D  ;
    input  CLK;
    input  SET;

    reg Q;

    table
     //  D  CLK  SET  :  Qt : Qt+1
         *   b    0   :  ?  :  -    ; // data event, hold unless CP==x
         ?  (?0)  0   :  ?  :  -    ; // CP => 0, hold
         ?   b   (?0) :  ?  :  -    ; // S => 0, hold unless CP==x
         ?   ?    1   :  ?  :  1    ; // async set
         0   r    0   :  ?  :  0    ; // clock data on CP
         1   r    ?   :  ?  :  1    ; // clock data on CP
         0  (x1)  0   :  0  :  0    ; // possible CP, hold when D==Q==0
         1  (x1)  ?   :  1  :  1    ; // possible CP, hold when D==Q==1
         0   x    0   :  0  :  0    ; // unkown CP, hold when D==Q==0
         1   x    ?   :  1  :  1    ; // unkown CP, hold when D==Q==1
         ?   b   (?x) :  1  :  1    ; // S=>x, hold when Q==1 unless CP==x
    endtable
endprimitive
`endif // NO_PRIMITIVES

`default_nettype wire
`endif  // SKY130_FD_SC_HD__UDP_DFF_PS_V
