/**
 * Copyright 2020 The SkyWater PDK Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 */

`ifndef SKY130_FD_SC_HD__UDP_DFF_NSR_PP_PG_N_V
`define SKY130_FD_SC_HD__UDP_DFF_NSR_PP_PG_N_V

/**
 * udp_dff$NSR_pp$PG$N: Negative edge triggered D flip-flop
 *                      (Q output UDP) with both active high reset and
 *                      set (set dominate). Includes VPWR and VGND
 *                      power pins and notifier pin.
 *
 * Verilog primitive definition.
 *
 * WARNING: This file is autogenerated, do not modify directly!
 */

`timescale 1ns / 1ps
`default_nettype none

`ifdef NO_PRIMITIVES
`include "./sky130_fd_sc_hd__udp_dff_nsr_pp_pg_n.blackbox.v"
`else
primitive sky130_fd_sc_hd__udp_dff$NSR_pp$PG$N (
    Q       ,
    SET     ,
    RESET   ,
    CLK_N   ,
    D       ,
    NOTIFIER,
    VPWR    ,
    VGND
);

    output Q       ;
    input  SET     ;
    input  RESET   ;
    input  CLK_N   ;
    input  D       ;
    input  NOTIFIER;
    input  VPWR    ;
    input  VGND    ;

    reg Q;

    table
     //         SET          RESET CLK_N  D  NOTIFIER VPWR VGND :  Qt : Qt+1
                 0             1     b    ?     ?      1    0   :  ?  :  0    ; // Asserting reset
                 0             *     ?    ?     ?      1    0   :  0  :  0    ; // Changing reset
                 1             ?     b    ?     ?      1    0   :  ?  :  1    ; // Asserting set  (dominates reset)
                 *             0     ?    ?     ?      1    0   :  1  :  1    ; // Changing set
                 1             ?     n    ?     ?      1    0   :  1  :  1    ;
                 ?             1     n    ?     ?      1    0   :  0  :  0    ;
                 x             ?     n    ?     ?      1    0   :  1  :  1    ;
                 ?             x     n    ?     ?      1    0   :  0  :  0    ;
                 0             ?    (01)  0     ?      1    0   :  ?  :  0    ; // rising clock
                 ?             0    (01)  1     ?      1    0   :  ?  :  1    ; // rising clock
                 0             ?     p    0     ?      1    0   :  0  :  0    ; // potential rising clock
                 ?             0     p    1     ?      1    0   :  1  :  1    ; // potential rising clock
                 0             ?     x    0     ?      1    0   :  1  :  x    ;
                 ?             0     x    1     ?      1    0   :  0  :  x    ;
                 0             0     n    ?     ?      1    0   :  ?  :  -    ; // Clock falling register output does not change
                 0             0     ?    *     ?      1    0   :  ?  :  -    ; // Changing Data
        // ['IfDef(functional)', '']                 ?             ?     ?    ?     *      1    0   :  ?  :  -    ; // go to - on notify
        // ['Else', '']                 ?             ?     ?    ?     *      1    0   :  ?  :  X    ; // go to X on notify
        // ['EndIfDef(functional)', '']                 ?             ?     ?    ?     ?      *    0   :  ?  :  X    ; // any change on vpwr
                 ?             ?     ?    ?     ?      ?    *   :  ?  :  X    ; // any change on vgnd
    endtable
endprimitive
`endif // NO_PRIMITIVES

`default_nettype wire
`endif  // SKY130_FD_SC_HD__UDP_DFF_NSR_PP_PG_N_V
