// Auto-generated by Perses AST.
// DO NOT MODIFY.
grammar Solidity;

options {
    tokenVocab=SolidityLexer;
}
sourceUnit
    : (pragmaDirective | importDirective | contractDefinition | interfaceDefinition | libraryDefinition | functionDefinition | constantVariableDeclaration | structDefinition | enumDefinition)* EOF
    ;

pragmaDirective
    : Pragma PragmaToken+ PragmaSemicolon
    ;

importDirective
    : Import (path (As identifier)? | symbolAliases From path | Mul As identifier From path) Semicolon
    ;

contractDefinition
    : Abstract? Contract identifier inheritanceSpecifierList? LBrace contractBodyElement* RBrace
    ;

interfaceDefinition
    : Interface identifier inheritanceSpecifierList? LBrace contractBodyElement* RBrace
    ;

libraryDefinition
    : Library identifier LBrace contractBodyElement* RBrace
    ;

functionDefinition
    : Function (identifier | Fallback | Receive) LParen parameterList? RParen (visibility | stateMutability | modifierInvocation | Virtual | overrideSpecifier)* (Returns LParen parameterList RParen)? (Semicolon | block)
    ;

constantVariableDeclaration
    : typeName Constant identifier Assign expression Semicolon
    ;

structDefinition
    : Struct identifier LBrace structMember+ RBrace
    ;

enumDefinition
    : Enum identifier LBrace identifier (Comma identifier)* RBrace
    ;

path
    : NonEmptyStringLiteral
    ;

identifier
    : Identifier
    | From
    ;

symbolAliases
    : LBrace importAliases (Comma importAliases)* RBrace
    ;

importAliases
    : identifier (As identifier)?
    ;

inheritanceSpecifierList
    : Is inheritanceSpecifier (Comma inheritanceSpecifier)*?
    ;

contractBodyElement
    : constructorDefinition
    | functionDefinition
    | modifierDefinition
    | fallbackFunctionDefinition
    | receiveFunctionDefinition
    | structDefinition
    | enumDefinition
    | stateVariableDeclaration
    | eventDefinition
    | usingDirective
    ;

inheritanceSpecifier
    : identifierPath callArgumentList?
    ;

identifierPath
    : identifier (Period identifier)*
    ;

callArgumentList
    : LParen ((expression (Comma expression)*)? | LBrace (namedArgument (Comma namedArgument)*)? RBrace) RParen
    ;

constructorDefinition
    : Constructor LParen parameterList? RParen (modifierInvocation | Payable | Internal | Public)* block
    ;

modifierDefinition
    : Modifier identifier (LParen parameterList? RParen)? (Virtual | overrideSpecifier)* (Semicolon | block)
    ;

fallbackFunctionDefinition
    : Fallback LParen parameterList? RParen (External | stateMutability | modifierInvocation | Virtual | overrideSpecifier)* (Returns LParen parameterList RParen | /* Epsilon. */) (Semicolon | block)
    ;

receiveFunctionDefinition
    : Receive LParen RParen (External | Payable | modifierInvocation | Virtual | overrideSpecifier)* (Semicolon | block)
    ;

stateVariableDeclaration
    : typeName (Public | Private | Internal | Constant | overrideSpecifier | Immutable)* identifier (Assign expression)? Semicolon
    ;

eventDefinition
    : Event identifier LParen (eventParameter (Comma eventParameter)*)? RParen Anonymous? Semicolon
    ;

usingDirective
    : Using identifierPath For (Mul | typeName) Semicolon
    ;

namedArgument
    : identifier Colon expression
    ;

expression
    : expression LBrack expression? RBrack
    | expression LBrack expression? Colon expression? RBrack
    | expression Period (identifier | Address)
    | expression LBrace (namedArgument (Comma namedArgument)*)? RBrace
    | expression callArgumentList
    | Payable callArgumentList
    | Type LParen typeName RParen
    | (Inc | Dec | Not | BitNot | Delete | Sub) expression
    | expression (Inc | Dec)
    | <assoc=right> expression Exp expression
    | expression (Mul | Div | Mod) expression
    | expression (Add | Sub) expression
    | expression (Shl | Sar | Shr) expression
    | expression BitAnd expression
    | expression BitXor expression
    | expression BitOr expression
    | expression (LessThan | GreaterThan | LessThanOrEqual | GreaterThanOrEqual) expression
    | expression (Equal | NotEqual) expression
    | expression And expression
    | expression Or expression
    | <assoc=right> expression Conditional expression Colon expression
    | <assoc=right> expression assignOp expression
    | New typeName
    | tupleExpression
    | inlineArrayExpression
    | identifier
    | literal
    | elementaryTypeName
    ;

modifierInvocation
    : identifierPath callArgumentList?
    ;

visibility
    : Internal
    | External
    | Private
    | Public
    ;

parameterList
    : parameterDeclaration (Comma parameterDeclaration)*
    ;

parameterDeclaration
    : typeName dataLocation? identifier?
    ;

typeName
    : elementaryTypeName
    | functionTypeName
    | mappingType
    | identifierPath
    | typeName LBrack expression? RBrack
    ;

dataLocation
    : Memory
    | Storage
    | Calldata
    ;

block
    : LBrace (statement | uncheckedBlock)* RBrace
    ;

stateMutability
    : Pure
    | View
    | Payable
    ;

overrideSpecifier
    : Override (LParen identifierPath (Comma identifierPath)* RParen)?
    ;

structMember
    : typeName identifier Semicolon
    ;

eventParameter
    : typeName Indexed? identifier?
    ;

elementaryTypeName
    : Address
    | Address Payable
    | Bool
    | String
    | Bytes
    | SignedIntegerType
    | UnsignedIntegerType
    | FixedBytes
    | Fixed
    | Ufixed
    ;

functionTypeName
    : Function LParen parameterList? RParen (visibility | stateMutability)* (Returns LParen parameterList RParen)?
    ;

mappingType
    : Mapping LParen mappingKeyType DoubleArrow typeName RParen
    ;

variableDeclaration
    : typeName dataLocation? identifier
    ;

assignOp
    : Assign
    | AssignBitOr
    | AssignBitXor
    | AssignBitAnd
    | AssignShl
    | AssignSar
    | AssignShr
    | AssignAdd
    | AssignSub
    | AssignMul
    | AssignDiv
    | AssignMod
    ;

tupleExpression
    : LParen expression? (Comma expression?)* RParen
    ;

inlineArrayExpression
    : LBrack expression (Comma expression)* RBrack
    ;

literal
    : stringLiteral
    | numberLiteral
    | booleanLiteral
    | hexStringLiteral
    | unicodeStringLiteral
    ;

stringLiteral
    : StringLiteral+
    ;

numberLiteral
    : (DecimalNumber | HexNumber) NumberUnit?
    ;

booleanLiteral
    : True
    | False
    ;

hexStringLiteral
    : HexString+
    ;

unicodeStringLiteral
    : UnicodeStringLiteral+
    ;

statement
    : block
    | simpleStatement
    | ifStatement
    | forStatement
    | whileStatement
    | doWhileStatement
    | continueStatement
    | breakStatement
    | tryStatement
    | returnStatement
    | emitStatement
    | assemblyStatement
    ;

uncheckedBlock
    : Unchecked block
    ;

simpleStatement
    : variableDeclarationStatement
    | expressionStatement
    ;

ifStatement
    : If LParen expression RParen statement (Else statement)?
    ;

forStatement
    : For LParen (simpleStatement | Semicolon) (expressionStatement | Semicolon) expression? RParen statement
    ;

whileStatement
    : While LParen expression RParen statement
    ;

doWhileStatement
    : Do statement While LParen expression RParen Semicolon
    ;

continueStatement
    : Continue Semicolon
    ;

breakStatement
    : Break Semicolon
    ;

tryStatement
    : Try expression (Returns LParen parameterList RParen)? block catchClause+
    ;

returnStatement
    : Return expression? Semicolon
    ;

emitStatement
    : Emit expression callArgumentList Semicolon
    ;

assemblyStatement
    : Assembly AssemblyDialect? AssemblyLBrace yulStatement* YulRBrace
    ;

variableDeclarationStatement
    : (variableDeclaration (Assign expression)? | variableDeclarationTuple Assign expression) Semicolon
    ;

expressionStatement
    : expression Semicolon
    ;

catchClause
    : Catch (identifier? LParen parameterList RParen)? block
    ;

yulStatement
    : yulBlock
    | yulVariableDeclaration
    | yulAssignment
    | yulFunctionCall
    | yulIfStatement
    | yulForStatement
    | yulSwitchStatement
    | YulLeave
    | YulBreak
    | YulContinue
    | yulFunctionDefinition
    ;

variableDeclarationList
    : variableDeclaration (Comma variableDeclaration)*
    ;

variableDeclarationTuple
    : LParen Comma* variableDeclaration (Comma variableDeclaration?)* RParen
    ;

mappingKeyType
    : elementaryTypeName
    | identifierPath
    ;

yulBlock
    : YulLBrace yulStatement* YulRBrace
    ;

yulVariableDeclaration
    : YulLet YulIdentifier (YulAssign yulExpression)?
    | YulLet YulIdentifier (YulComma YulIdentifier)* (YulAssign yulFunctionCall)?
    ;

yulAssignment
    : yulPath YulAssign yulExpression
    | yulPath (YulComma yulPath)+ YulAssign yulFunctionCall
    ;

yulFunctionCall
    : (YulIdentifier | YulEVMBuiltin) YulLParen (yulExpression (YulComma yulExpression)*)? YulRParen
    ;

yulIfStatement
    : YulIf yulExpression yulBlock
    ;

yulForStatement
    : YulFor yulBlock yulExpression yulBlock yulBlock
    ;

yulSwitchStatement
    : YulSwitch yulExpression (yulSwitchCase+ (YulDefault yulBlock)? | YulDefault yulBlock)
    ;

yulFunctionDefinition
    : YulFunction YulIdentifier YulLParen (YulIdentifier (YulComma YulIdentifier)*)? YulRParen (YulArrow YulIdentifier (YulComma YulIdentifier)*)? yulBlock
    ;

yulExpression
    : yulPath
    | yulFunctionCall
    | yulLiteral
    ;

yulPath
    : YulIdentifier (YulPeriod YulIdentifier)*
    ;

yulSwitchCase
    : YulCase yulLiteral yulBlock
    ;

yulLiteral
    : YulDecimalNumber
    | YulStringLiteral
    | YulHexNumber
    | yulBoolean
    ;

yulBoolean
    : YulTrue
    | YulFalse
    ;

