# Gis
Sample code for processing GIS data using fiona for I/O.

## What is it?
1. `geopandas.ipynb`: Jupyter notebook illustrating the capabilities of
    GeoPandas data structures and algorithms.
1. `gis.ipynb`: Jupyter notebook with sample code that processes various
    GIS data formats: shape files using Fiona, GeoJSON files, and
    GeoTIFF files using `GDAL`.
1. `make_your_own_world.ipynb`: Jupyter notebook illustrating how to use
    Shapely for geometric computations to create geographial information.
1. `maps.ipynb`: Jupyter notebook illustrating some more use cases of
    Folium.
1. `shapely.ipynb`: Jupyter notebook illustrating how to work with
    Shapely objects and algorithms.
1. `world_happiness.ipynb`: jupyter notebook illustrating how to create
    a chloropleth map using `Folium` and GeoJSON information.
1, `city_center.ipynb`: GeoPoandas application to approximate the
   center of Belgian municipalities by the centroid of their shape.
1. `Data`: shape, GeoJSON and GeoTIFF files, as well as the World
    Happiness data for 2016.
