# Contributing

You are very welcome to contribute to this repository.


## How to contribute?

This can be done in several ways, depending on how familiar you are with
the GitHub workflow:

  * simply send an [email](geertjan.bex@uhasselt.be),
  * [create an issue](https://help.github.com/articles/creating-an-issue/)
    on GitHub, or
  * [fork the repository](https://help.github.com/articles/fork-a-repo/)
    on GitHub, create a branch based on the development
    branch, make your contribution, and submit a
    [pull request](https://help.github.com/articles/about-pull-requests/).

For pull requests, a few things should be noted:

  * you may be asked to modify your contribution to fit better into
    the context,
  * please base them on the development branch,
  * please ensure your branch is in sync with the upstream development
    branch before submitting the pull request,
  * please try to use [informative commit messages](https://chris.beams.io/posts/git-commit/)
    (I'm not claiming that mine are shining examples, but well...), and
  * if you want to suggest modifications to PowerPoint presentations,
    please make a copy of the original presentation, modify it, and add it.

Since from `git`'s perspective, PowerPoint files are just binary files,
a merge can only be done using Microsoft's PowerPoint application by
comparing two PowerPoint files.

Of course, although all contributions are very much appreciated, some of
them might not be integrated into the material.  If that should happen,
 I'll try to justify that decision, and it can be discussed.


## Citation and licensing

For contributions in general,

  * if you make a contribution, this will be mentioned in the
    [README](README.md), unless requested otherwise;
  * contributions will be under the same [license as this repository](LICENSE).


## What can you contribute?
  
Basically, anything you like, e.g.,

  * corrections of typos,
  * bug fixes in sample code,
  * additional sample code,
  * extra or alternative slides in presentations,
  * a section in a presentation,
  * a new subject, or aspect of an existing subject.
