---
layout: page
title: Code of conduct
permalink: /code_of_conduct.html
---

# Code of conduct

This workshop is dedicated to providing a welcoming and supportive environment for all people, regardless of background or identity. By participating in this workshop, participants accept to abide by this Code of Conduct and accept the procedures by which any Code of Conduct incidents are resolved. We do not tolerate behavior that is disrespectful or that excludes, intimidates, or causes discomfort to others. We do not tolerate discrimination or harassment based on characteristics that include, but are not limited to, gender identity and expression, sexual orientation, disability, physical appearance, body size, citizenship, nationality, ethnic or social origin, pregnancy, familial status, veteran status, genetic information, religion or belief (or lack thereof), membership of a national minority, property, age, education, socio-economic status, technical choices, and experience level.

Everyone who participates in workshop activities is required to conform to this Code of Conduct. It applies to all spaces managed by or affiliated with the workshop, including, but not limited to, workshops, email lists, and online forums such as GitHub, Slack and Twitter. Workshop hosts are expected to assist with the enforcement of the Code of Conduct. By participating, participants indicate their acceptance of the procedures by which the workshop resolves any Code of Conduct incidents, which may include storage and processing of their personal information.


## Expected behavior

All participants in our events and communications are expected to show respect and courtesy to others. All interactions should be professional regardless of platform: either online or in-person. In order to foster a positive and professional learning environment we encourage the following kinds of behaviors in all workshop events and platforms:

* Use welcoming and inclusive language
* Be respectful of different viewpoints and experiences
* Gracefully accept constructive criticism
* Focus on what is best for the community
* Show courtesy and respect towards other community members


## Unacceptable behavior

Examples of unacceptable behavior by participants at any workshop event/platform include:

* written or verbal comments which have the effect of excluding people on the basis of membership of any specific group
* causing someone to fear for their safety, such as through stalking, following, or intimidation
* violent threats or language directed against another person
* the display of sexual or violent images
* unwelcome sexual attention
* nonconsensual or unwelcome physical contact
* sustained disruption of talks, events or communications
* insults or put downs
* sexist, racist, homophobic, transphobic, ableist, or exclusionary jokes
* excessive swearing
* incitement to violence, suicide, or self-harm
* continuing to initiate interaction (including photography or recording) with someone after being asked to stop
* publication of private communication without consent
* sharing recordings of training sessions with non-participants


## Consequences of Unacceptable behavior

If you believe someone is violating the Code of Conduct, we ask that you report it to any of the workshop organizers. This is a community-led workshop, and we value the involvement of everyone in the community. We are committed to creating a friendly and respectful place for learning, teaching and contributing. All participants in our events and communications are expected to show respect and courtesy to others.

To make clear what is expected, everyone participating in this conference and its activities is required to conform to the Code of Conduct. This Code of Conduct applies to all spaces affiliated with the conference, but not limited to, workshops, email lists, and online forums such as GitHub, Slack and Twitter. Workshop organizers are expected to assist with the enforcement of the Code of Conduct.

Participants who are asked to stop any inappropriate behavior are expected to comply immediately. This applies to any workshop events and platforms, either online or in-person. If a participant engages in behavior that violates this code of conduct, the organizers may warn the offender, ask them to leave the event or platform, or investigate the Code of Conduct violation and impose appropriate sanctions.


## Attribution

This code of conduct is largely mirrored from the one used by [ML4Science](https://www.ml4science.org/code-of-conduct) that in turn modelled it on the [Software Carpentry's code of conduct](https://www.google.com/url?q=https%3A%2F%2Fdocs.carpentries.org%2Ftopic_folders%2Fpolicies%2Fcode-of-conduct.html&sa=D&sntz=1&usg=AOvVaw3u6XY-Uib9k9m6Y7uxovay).
