# ICSE 2025 - Replication Package

This replication package contains the supplementary material for our paper "An Exploratory Study on the Engineering of Security Features", published in the proceedings of the International Conference on Software Engineering (ICSE) 2025.

This study has been designed, conducted, and reported by the following investigators:

- [Kevin Hermann](https://se.ruhr-uni-bochum.de/kevin-hermann/) (Ruhr University Bochum)
- [Sven Peldszus](https://sven.peldszus.com/) (Ruhr University Bochum)
- [Jan-Philipp Steghöfer](https://jpsteghofer.net/) (XITASO GmbH) 
- [Thorsten Berger](https://se.ruhr-uni-bochum.de/thorsten-berger/) (Ruhr University Bochum, University of Gothgenburg, and Chalmers University of Technology)

Interested researchers can contact any of the investigators listed above for more information. 

The dataset containing coded interview and survey data and the analysis scripts produced for evaluating this data are available below.

## How to cite this work
---
If this work or the dataset is helping your research, consider to cite it is as follows, thanks!

```
@article{ICSE2025_SecurityFeatures,
  title = {{An Exploratory Study on the Engineering of Security Features}},
  journal = {International Conference on Software Engineering (ICSE)},
  year = {2025},
  author = {Kevin Hermann and Sven Peldszus and Jan-Philipp Steghöfer and Thorsten Berger}
}
```

## Overview of the replication package
---
This replication package is structured as follows:
```
    /
    .
    |--- assumption_selection.xlsx                      Data related to assumptions gathered from researchers
    |--- interview_themes_and_assumption_mapping.xlsx   Data related to the themes identified in the interviews with practitioners and their mapping to the assumptions of researchers
    |--- mentioned_security_features.xlsx               Data related to security features mentioned by practitioners in the interviews
    |--- interview_guide.pdf                            The interview guide for semi-structured interviews with practitioners
    |--- ICSE_2025.pdf                                  A copy of the preliminary paper published at ICSE 2025
```

Please find detailed information about the individual files below.

### assumption_selection.xlsx

The file "assumption_selection.xlsx" contains the assumptions gathered from 22 researchers, from which we selected the four most frequently mentioned ones, which are listed and described in Section 4 of our paper.
In addition, we list other assumptions that were mentioned, not related to the four selected assumptions.
Each line corresponds to one received response.

### interview_themes_and_assumption_mapping.xlsx

The file "interview_themes_and_assumption_mapping.xlsx" contains 3 sheets. (Sheet "themes") comprises the demographic data of each participant (used in Section 3.B, Table 1, and Figure 1of our paper), and a mapping of each interview to the corresponding themes (provided in Section 5-8 of our paper). (Sheet "assumptions") contains the agreement of each interview with each assumption, based on the mapping to the themes, as shown in Table 3 of our paper. In this process, we used (Sheet "helper") to convert the agreement from sheet "themes" to numerical values, to facilitate the calculation process. We calculated the agreement based on a 2/3-majority, only taking into account the themes towards the participants were not neutral.

### mentioned_security_features.xlsx

The file "mentioned_security_features.xlsx" contains the order of the security features that were mentioned during the interviews. We also provide a comparison of the most frequently mentioned security features authentication, authorization, and cryptography to other mentioned security features, which we used for evaluating theme "SSF3: Only few security features are of immediate concern" in Section 5 of our paper.

### interview_guide.pdf

The file "interview_guide.pdf" contains the interview guide used to conduct the interviews.
