# Combine and plot growth rate data from Daydacna
# Project "Saiwan_data_processing"
# Author: Niels J. de Winter
# Study: "Living on the edge: Response of rudist bivalves (Hippuritida) to hot and highly seasonal climate in the low-latitude Saiwan site, Oman"

# Load growth rate data from ShellChron
Age_model_results <- read.csv("2_Results_dating/Age_model_results.csv")

# Load Daydacna ages and rename columns
B10_MgCa_BP_Daydacna <- read.csv("Daydacna_results/B10_LA_bandpass_MgCa_GR_parameters.csv")
B10_MgCa_BP_Daydacna <- mutate(B10_MgCa_BP_Daydacna,
    D = time..s.,
    mean.day = Cumulative.days.percentile.50,
    CL95.day = Cumulative.days.percentile.97.5 - Cumulative.days.percentile.2.5
)
B10_MgLi_BP_Daydacna <- read.csv("Daydacna_results/B10_LA_bandpass_MgLi_GR_parameters.csv")
B10_MgLi_BP_Daydacna <- mutate(B10_MgLi_BP_Daydacna,
    D = time..s.,
    mean.day = Cumulative.days.percentile.50,
    CL95.day = Cumulative.days.percentile.97.5 - Cumulative.days.percentile.2.5
)
B10_SrLi_BP_Daydacna <- read.csv("Daydacna_results/B10_LA_bandpass_SrLi_GR_parameters.csv")
B10_SrLi_BP_Daydacna <- mutate(B10_SrLi_BP_Daydacna,
    D = time..s.,
    mean.day = Cumulative.days.percentile.50,
    CL95.day = Cumulative.days.percentile.97.5 - Cumulative.days.percentile.2.5
)
B10_SrCa_BP_Daydacna <- read.csv("Daydacna_results/B10_LA_bandpass_SrCa_GR_parameters.csv")
B10_SrCa_BP_Daydacna <- mutate(B10_SrCa_BP_Daydacna,
    D = time..s.,
    mean.day = Cumulative.days.percentile.50,
    CL95.day = Cumulative.days.percentile.97.5 - Cumulative.days.percentile.2.5
)
B10_MgLi_Daydacna <- read.csv("Daydacna_results/B10_LAICPMS_MgLi_GR_parameters.csv")
B10_MgLi_Daydacna <- mutate(B10_MgLi_Daydacna,
    D = time..s.,
    mean.day = Cumulative.days.percentile.50,
    CL95.day = Cumulative.days.percentile.97.5 - Cumulative.days.percentile.2.5
)
B10_SrLi_Daydacna <- read.csv("Daydacna_results/B10_LAICPMS_SrLi_GR_parameters.csv")
B10_SrLi_Daydacna <- mutate(B10_SrLi_Daydacna,
    D = time..s.,
    mean.day = Cumulative.days.percentile.50,
    CL95.day = Cumulative.days.percentile.97.5 - Cumulative.days.percentile.2.5
)

# Combine dating results per species and pivot to longer format
# B10
B10_dated_DD <- full_join( # Add MgCa & MgLi BP Daydacna result
    select(
        B10_MgCa_BP_Daydacna,
        mean.day,
        CL95.day,
        D
    ), select(
        B10_MgLi_BP_Daydacna,
        mean.day,
        CL95.day,
        D
    ),
    by = "D",
    suffix = c(
        ".DD.MgCaBP",
        ".DD.MgLiBP"
        )
) %>%
full_join( # Add SrCa BP Daydacna result
    ., select(
    B10_SrCa_BP_Daydacna,
    mean.day,
    CL95.day,
    D
),
by = "D"
) %>%
full_join( # Add SrLi BP Daydacna result
    ., select(
    B10_SrLi_BP_Daydacna,
    mean.day,
    CL95.day,
    D
),
by = "D",
suffix = c(
    ".DD.SrCaBP",
    ".DD.SrLiBP"
    )
) %>%
full_join( # Add MgLi Daydacna result
    ., select(
    B10_MgLi_Daydacna,
    mean.day,
    CL95.day,
    D
),
by = "D"
) %>%
full_join( # Add SrLi Daydacna result
    ., select(
    B10_SrLi_Daydacna,
    mean.day,
    CL95.day,
    D
),
by = "D",
suffix = c(
    ".DD.MgLi",
    ".DD.SrLi"
    )
) %>%
mutate(
    specimen_name = "B10",
    species = "Torreites sanchezi"
)

# Pivot to long format
B10_dated_DD_long <- pivot_longer(
    B10_dated_DD,
    !c(D, specimen_name, species),
    names_to = "variable",
    values_to = "day"
)

# Separate day values from uncertainties
B10_dated_DD_long <- separate_wider_delim(
    B10_dated_DD_long,
    variable,
    delim = ".",
    names = c("statistic",
        "unit",
        "method",
        "proxy"
    )
)

# Pivot to wider format by statistic
B10_dated_DD_long <- pivot_wider(B10_dated_DD_long,
    names_from = statistic,
    values_from = day,
    values_fn = function(x) mean(x, na.rm = TRUE)
) %>% # start each curve with D = 0
    group_by(specimen_name) %>%
    mutate(
        D_zero = D - min(D)
    )

# Export growth rate data
write.csv(B10_dated_DD_long, "Age_model_results_DD.csv", row.names = FALSE)