#include "random.h"

double Urnd::rnd() {
	static std::random_device rd;
	static std::mt19937_64 gen(rd()); // Mersenne twister (64 bit)
	static std::uniform_real_distribution<double> urd(0., 1.);
	return urd(gen);
}
int32_t Irnd::rnd(int32_t low, int32_t high) {
	static std::random_device rd;
	static std::mt19937_64 gen(rd()); // Mersenne twister (64 bit)
	using Dist = std::uniform_int_distribution<int32_t>;
	static Dist uid{};
	return uid(gen, Dist::param_type{ low, high });
}
int32_t Grnd::rnd(double p) {
	Urnd urnd;
	double U = urnd.rnd();
	int32_t G = static_cast<int32_t>(floor(log(1 - U) / log(p)));
	return G;
};
int32_t Lrnd::rnd(double p) {
	Grnd grnd;
	return (grnd.rnd(p) - grnd.rnd(p));
};